/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.pse;

import com.odi.DatabaseRootNotFoundException;
import com.odi.ObjectStoreException;
import com.odi.util.DuplicateKeyException;
import com.sonicsw.mf.common.util.LockFile;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.db.DBVersionInfo;
import progress.message.db.Db;
import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.db.EDatabaseNotExists;
import progress.message.db.prAccessor;
import progress.message.db.pse.PSEDbContext;
import progress.message.db.pse.PSEUtil;
import progress.message.dbsc.ISchemaDef;
import progress.message.dbsc.pse.DbSchemaPSE;
import progress.message.util.DebugState;

public class PSEBrokerDb
extends Db {
    public static final int RETAIN_MODE_COMMIT = 3;
    public static final int RETAIN_MODE_ROLLBACK = 2;
    public static final int RETAIN_MODE_EVICT = 3;
    private static final String PSE_STORE_NAME = "SonicMQStore";
    static final String PSE_DBFILE_EXTENSION = ".odb";
    static final String PSE_DBLOCKFILE_EXTENSION = ".lck";
    public static final String REG_DIR = "reg";
    public static final String REG_FILENAME = "reg";
    public static final int REG_CTX_IDENT = 1;
    public static final String GR_DIR = "gr";
    public static final String GR_FILENAME = "gr";
    public static final int GR_CTX_IDENT = 2;
    public static final String PUBSUB_DIR = "pubsub";
    public static final String PUBSUB_FILENAME = "pubsub";
    public static final int PUBSUB_CTX_IDENT = 3;
    public static final String PTP_DIR = "ptp";
    public static final String PTP_FILENAME = "ptp";
    public static final int PTP_CTX_IDENT = 4;
    public static final String DD_DIR = "dd";
    public static final String DD_FILENAME = "dd";
    public static final int DD_CTX_IDENT = 5;
    public static final String LOCK_FILENAME = "db.lck";
    Hashtable m_DbCtx = new Hashtable();
    boolean m_started = false;
    private String m_dbDir;
    private LockFile m_dbLockFile;
    DbSchemaPSE m_schemaHelper;
    String m_ddName;
    private volatile boolean m_closed = false;
    public static long PSE_NULL_DATE = 0L;
    boolean DEBUG1 = false;

    public PSEBrokerDb(String dir, String brokerInstance, String ddName) throws EDatabaseException {
        super(brokerInstance);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("PSEBrokerDb " + dir);
        }
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.m_dbDir = dir;
        if (this.m_dbDir == null) {
            this.m_dbDir = "." + File.separator + PSE_STORE_NAME;
        }
        this.m_ddName = ddName;
        this.m_schemaHelper = new DbSchemaPSE(this);
        if (this.DEBUG) {
            this.debug("Constructed");
        }
    }

    @Override
    public String rootName(String baseName) {
        return baseName;
    }

    @Override
    public void onShutdown() {
    }

    public String getDbDir() {
        return this.m_dbDir;
    }

    @Override
    public String getDDName() {
        return this.m_ddName;
    }

    @Override
    public ISchemaDef getSchemaDef() {
        return this.m_schemaHelper;
    }

    public PSEDbContext getCtx(int ident) throws EDatabaseException {
        PSEDbContext ctx = (PSEDbContext)this.m_DbCtx.get(new Integer(ident));
        if (ctx == null) {
            switch (ident) {
                case 1: {
                    ctx = this.m_schemaHelper.openReg();
                    break;
                }
                case 5: {
                    ctx = this.m_schemaHelper.openDD();
                    break;
                }
                case 2: {
                    ctx = this.m_schemaHelper.openGR();
                    break;
                }
                case 3: {
                    ctx = this.m_schemaHelper.openPubSub();
                    break;
                }
                case 4: {
                    ctx = this.m_schemaHelper.openPtp();
                }
            }
        }
        return ctx;
    }

    @Override
    public boolean seemsConfigured() throws EDatabaseException {
        boolean result = false;
        if (PSEUtil.existsPSEDbFile(this.m_dbDir, "reg", "reg")) {
            if (this.DEBUG) {
                this.debug("seemsConfigured: returning true");
            }
            return true;
        }
        if (this.DEBUG) {
            this.debug("seemsConfigured: Completed Result= " + result);
        }
        return result;
    }

    @Override
    public boolean seemsConfiguredDD() throws EDatabaseException {
        boolean result = false;
        if (PSEUtil.existsPSEDbFile(this.m_dbDir, "dd", "dd")) {
            if (this.DEBUG) {
                this.debug("seemsConfiguredDD: returning true");
            }
            return true;
        }
        if (this.DEBUG) {
            this.debug("seemsConfiguredDD: Completed Result= " + result);
        }
        return result;
    }

    @Override
    public void start() throws EDatabaseException, EDatabaseNotExists {
        if (this.DEBUG1) {
            this.debug("start: m_started= " + this.m_started);
        }
        if (!this.m_started) {
            File f = new File(this.m_dbDir);
            if (this.DEBUG) {
                this.debug("start ");
            }
            if (!f.exists()) {
                throw new EDatabaseNotExists("Directory does not exist " + this.m_dbDir);
            }
            this.lockDb();
            this.m_started = true;
        }
    }

    @Override
    public void createNewDb() throws EDatabaseException {
        this.createNewDbDir(this.m_dbDir);
        if (this.DEBUG) {
            this.debug("createNewDbDir ");
        }
    }

    @Override
    public void pingDatabase() {
    }

    void createNewDbDir(String name) throws EDatabaseException {
        try {
            boolean created = false;
            File f = new File(name);
            if (!f.exists() && !(created = f.mkdirs())) {
                throw new EDatabaseException("Can't create directory " + name);
            }
        }
        catch (SecurityException ex) {
            throw new EDatabaseException("Can't create directory " + name + " " + ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws EDatabaseException {
        if (this.DEBUG1) {
            this.debug("Close starting: m_started= " + this.m_started);
        }
        this.m_closed = true;
        try {
            Enumeration entries = this.m_DbCtx.elements();
            while (entries.hasMoreElements()) {
                PSEDbContext ctx = (PSEDbContext)entries.nextElement();
                try {
                    ctx.close();
                    if (!this.DEBUG) continue;
                    this.debug("Closed " + ctx);
                }
                catch (Throwable throwable) {}
            }
            this.m_DbCtx.clear();
        }
        finally {
            if (this.m_started) {
                this.unlockDb();
            }
            this.m_started = false;
        }
        if (this.DEBUG1) {
            this.debug("Close completed");
        }
    }

    public void close(int ident) {
        PSEDbContext ctx = (PSEDbContext)this.m_DbCtx.get(new Integer(ident));
        if (ctx != null) {
            ctx.close();
            this.m_DbCtx.remove(new Integer(ident));
        }
        if (this.DEBUG) {
            this.debug("Closed " + ctx);
        }
    }

    public void destroy(int ident) {
        PSEDbContext ctx = (PSEDbContext)this.m_DbCtx.get(new Integer(ident));
        if (ctx != null) {
            ctx.destroy();
            this.m_DbCtx.remove(new Integer(ident));
        }
        if (this.DEBUG) {
            this.debug("Destroyed " + ctx);
        }
    }

    public void validateDb() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("validateDb: Starting... brokerName= " + this.getBrokerName());
        }
        if (this.seemsConfigured()) {
            PSEDbContext ctx = (PSEDbContext)this.m_DbCtx.get(new Integer(1));
            boolean opened = false;
            if (ctx == null) {
                ctx = this.getCtx(1);
                opened = true;
            }
            String nameInDb = PSEUtil.getStringRoot(ctx, this.rootName("BrokerName"));
            if (opened) {
                if (this.DEBUG) {
                    this.debug("validateDb: closing reg");
                }
                this.close(1);
            }
            if (nameInDb != null && !nameInDb.equals(this.getBrokerName())) {
                Object[] parms = new Object[]{nameInDb, this.getBrokerName()};
                String msg = MessageFormat.format(prAccessor.getString("WRONG_DB"), parms);
                throw new EDatabaseException(msg);
            }
        }
    }

    @Override
    public DBVersionInfo getDBVersionInfo() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("getDBVersionInfo: Starting... rootname= " + this.rootName("BrokerDBVer"));
        }
        PSEDbContext ctx = this.getCtx(1);
        this.validateDb();
        DBVersionInfo versObj = PSEUtil.getDBVersionInfo(ctx, this.rootName("BrokerDBVer"));
        if (this.DEBUG) {
            this.debug("getDBVersionInfo: Completed...");
        }
        return versObj;
    }

    @Override
    public void setDBVersionInfo(DBVersionInfo vers) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("setDBVersionInfo rootname= " + this.rootName("BrokerDBVer"));
        }
        PSEDbContext ctx = this.getCtx(1);
        PSEUtil.setDBVersionInfo(ctx, this.rootName("BrokerDBVer"), vers);
        if (this.DEBUG) {
            this.debug("setDBVersionInfo completed");
        }
    }

    @Override
    public boolean isRemoteDb() {
        return false;
    }

    public boolean isUniqueConstraintException(RuntimeException e) {
        return e instanceof DuplicateKeyException;
    }

    public boolean isTableNotFoundException(ObjectStoreException e) {
        return e instanceof DatabaseRootNotFoundException;
    }

    public void createRootTreeSet(PSEDbContext ctx, String name, Class classname, String primarykeyAccessor) throws EDatabaseException, EBrokerNameTooLong {
        PSEUtil.createRootTreeSet(ctx, this.rootName(name), classname, primarykeyAccessor);
    }

    public PSEDbContext createNewContext(int ident, String dir, String dbfilename, boolean create) throws EDatabaseException, EDatabaseNotExists {
        if (this.DEBUG1) {
            this.debug("createNewContext ident= " + ident + " dir= " + dir + " f= " + dbfilename + " create= " + create + " numDbsCtx= " + this.m_DbCtx.size());
        }
        PSEDbContext pdb = null;
        try {
            String dbdir = null;
            dbdir = dir == null ? "." : dir;
            File f = new File(dbdir);
            if (!f.exists()) {
                throw new EDatabaseNotExists("Directory does not exist " + dbdir);
            }
            File lockf = new File(f, dbfilename + PSE_DBLOCKFILE_EXTENSION);
            if (lockf.exists()) {
                lockf.delete();
                if (this.DEBUG1) {
                    this.debug("createNewContext: deleted " + lockf.getCanonicalPath());
                }
            }
            f = new File(f, dbfilename + PSE_DBFILE_EXTENSION);
            String fulldbname = f.getCanonicalPath();
            pdb = new PSEDbContext(ident, fulldbname);
            if (create) {
                pdb.create();
            } else {
                pdb.open();
            }
            this.m_DbCtx.put(new Integer(ident), pdb);
        }
        catch (IOException ioe) {
            if (this.DEBUG1) {
                ioe.printStackTrace();
            }
            throw new EDatabaseException(ioe.toString());
        }
        return pdb;
    }

    public void createRoot(PSEDbContext ctx, String name, Object obj) throws EDatabaseException, EBrokerNameTooLong {
        if (this.DEBUG) {
            this.debug("Creating Root " + this.rootName(name));
        }
        PSEUtil.createRoot(ctx, this.rootName(name), obj);
    }

    public void createIndex(PSEDbContext ctx, String name, Class classname, String accessor, boolean ordered, boolean allowdups) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("Creating index on " + this.rootName(name));
        }
        PSEUtil.createIndex(ctx, this.rootName(name), classname, accessor, ordered, allowdups);
    }

    @Override
    public String toString() {
        return "PSEBrokerDb for " + this.m_dbDir;
    }

    private void lockDb() throws EDatabaseException {
        File lockFile = new File(this.m_dbDir, LOCK_FILENAME);
        this.m_dbLockFile = new LockFile(lockFile.getAbsolutePath());
        if (!this.m_dbLockFile.lock()) {
            String fname = LOCK_FILENAME;
            try {
                fname = lockFile.getCanonicalPath();
            }
            catch (IOException ex) {
                // empty catch block
            }
            Object[] parms = new Object[]{this.m_dbDir, fname};
            String msg = MessageFormat.format(prAccessor.getString("LOCKFILE_EXISTS"), parms);
            throw new EDatabaseException(msg);
        }
    }

    private void unlockDb() {
        if (this.m_dbLockFile != null) {
            this.m_dbLockFile.unlock();
            this.m_dbLockFile = null;
        }
    }
}

