/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.util.DuplicateKeyException;
import com.odi.util.OSTreeSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.util.OpContext;
import progress.message.dbq.IDupDetectDBQ;
import progress.message.dbq.pse.DBQPSEBase;
import progress.message.dbsc.data.IDbDupDetectData;
import progress.message.dbsc.data.impl.DbDupDetectData;
import progress.message.dbsc.pse.pc.dd.PSEDupDetectInfo;

public class DupDetectDBQImplPSE
extends DBQPSEBase
implements IDupDetectDBQ {
    private PSEBrokerDb m_pseDb;
    private String m_ddName;
    private int CLEANER_BATCH_SIZE = 1000;
    private OSTreeSet m_rootDD;

    public DupDetectDBQImplPSE(PSEBrokerDb db, String ddName) {
        super("DupDetectDBQImplPSE ");
        this.m_pseDb = db;
        this.m_ddName = ddName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws EDatabaseException {
        if (this.m_dbCtx == null) {
            this.m_dbCtx = this.m_pseDb.getCtx(5);
        }
        this.m_opCtxUpdate = new OpContext(2, this.m_dbCtx);
        this.m_opCtxRead = new OpContext(1, 2, this.m_dbCtx);
        this.acquireLock(this.m_opCtxRead);
        try {
            OSTreeSet rootDD = this.getRootDD();
            if (this.isDebugLevel1()) {
                int ct = rootDD.size();
                long dbSize = this.m_dbCtx.getDatabase().getSizeInBytes();
                this.debug("count of DupDetectInfo= " + rootDD.size() + " dbsize= " + dbSize);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(String commitId, long timestamp) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("delete starting; commitId= " + commitId + " date= " + new Date(timestamp));
        }
        int ct = 0;
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEDupDetectInfo ddinfo = this.getDDInfo(commitId);
            if (ddinfo != null && ddinfo.getCreationTime() == timestamp) {
                this.getRootDD().remove((Object)ddinfo);
                ObjectStore.destroy((Object)ddinfo);
                ++ct;
                this.commit();
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("delete completed; deleted " + ct);
        }
        return ct;
    }

    private PSEDupDetectInfo getDDInfo(String commitId) {
        PSEDupDetectInfo ddinfo = (PSEDupDetectInfo)this.getRootDD().getFromPrimaryIndex((Object)commitId);
        return ddinfo;
    }

    private Iterator getIterator(String commitId) {
        if (commitId != null) {
            return this.getRootDD().primaryIndexIterator((Object)commitId);
        }
        return this.getRootDD().primaryIndexIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteOld(long time) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("deleteOld starting; date= " + new Date(time));
        }
        int ct = 0;
        String startingCommitId = null;
        boolean done = false;
        while (!done) {
            this.acquireLock(this.m_opCtxUpdate);
            int ctBatch = 0;
            int ctBatchDeleted = 0;
            try {
                Iterator it = this.getIterator(startingCommitId);
                while (it.hasNext()) {
                    PSEDupDetectInfo ddinfo = (PSEDupDetectInfo)it.next();
                    startingCommitId = ddinfo.getCommitID();
                    ++ctBatch;
                    if (ddinfo.getEndOfLife() < time) {
                        it.remove();
                        ObjectStore.destroy((Object)ddinfo);
                        ++ctBatchDeleted;
                    }
                    if (ctBatch != this.CLEANER_BATCH_SIZE) continue;
                    break;
                }
                if (ctBatchDeleted > 0) {
                    this.commit();
                    ct += ctBatchDeleted;
                }
                if (ctBatch >= this.CLEANER_BATCH_SIZE) continue;
                done = true;
            }
            catch (ObjectStoreException e) {
                this.m_dbCtx.handlePSEException(e);
            }
            finally {
                this.releaseLock(this.m_opCtxUpdate);
            }
        }
        if (DEBUG) {
            this.debug("deleteOld completed; deleted " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAll() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("deleteAll: starting ");
        }
        int ct = 0;
        this.acquireLock(this.m_opCtxUpdate);
        try {
            Iterator it = this.getIterator(null);
            while (it.hasNext()) {
                PSEDupDetectInfo ddinfo = (PSEDupDetectInfo)it.next();
                it.remove();
                ObjectStore.destroy((Object)ddinfo);
                ++ct;
            }
            if (ct > 0) {
                this.commit();
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("deleteAll completed; deleted " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteChannelRecord(String commitId, String channelID) throws EDatabaseException, IllegalArgumentException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("deleteChannelRecord starting; commitId= " + commitId + " channelID = " + channelID);
        }
        int ct = 0;
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEDupDetectInfo ddinfo = this.getDDInfo(commitId);
            if (ddinfo != null && ddinfo.getChannelID().equals(channelID)) {
                this.getRootDD().remove((Object)ddinfo);
                ObjectStore.destroy((Object)ddinfo);
                ++ct;
                this.commit();
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("deleteChannelRecord completed; deleted " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateChannelRecord(String commitId, long endOfLife, int channelStatus, String channelID) throws EDatabaseException, IllegalArgumentException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("updateChannelrecord starting; commitId= " + commitId + " channelID = " + channelID);
        }
        int ct = 0;
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEDupDetectInfo ddinfo = this.getDDInfo(commitId);
            if (ddinfo != null && ddinfo.getChannelID().equals(channelID)) {
                ddinfo.setEndOfLife(endOfLife);
                ddinfo.setStatus(channelStatus);
                ++ct;
                this.commit();
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("updateChannelrecord completed; commitId= " + commitId + " channelID = " + channelID + " numUpdated= " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String commitId, long endOfLife, long timestamp, int status, String channelID) throws EDatabaseException, IllegalArgumentException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("write  starting; commitId= " + commitId + " channelID= " + channelID + " timeStamp= " + new Date(timestamp) + " endOfLife= " + new Date(endOfLife));
        }
        int result = 0;
        this.acquireLock(this.m_opCtxUpdate);
        try {
            result = this.writeInternal(commitId, endOfLife, timestamp, status, channelID, true);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("write  completed; commitId= " + commitId + " channelID = " + channelID + " result= " + result);
        }
        return result;
    }

    @Override
    public int writeTx(String commitId, long endOfLife, long timestamp, int status, String channelID) throws EDatabaseException, IllegalArgumentException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("writeTx  starting; commitId= " + commitId + " channelID = " + channelID);
        }
        int result = 0;
        this.checkUpdateLock();
        result = this.writeInternal(commitId, endOfLife, timestamp, status, channelID, false);
        if (DEBUG) {
            this.debug("writeTx  completed; commitId= " + commitId + " channelID = " + channelID + " result= " + result);
        }
        return result;
    }

    @Override
    public void updateAllRecordInfoTx(String commitId, long endOfLife, int channelStatus, String channelID) throws EDatabaseException, IllegalArgumentException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("updateAllRecordInfoTx starting; commitId= " + commitId + " channelID = " + channelID);
        }
        this.checkUpdateLock();
        try {
            PSEDupDetectInfo ddinfo = this.getDDInfo(commitId);
            if (ddinfo != null) {
                ddinfo.setEndOfLife(endOfLife);
                ddinfo.setStatus(channelStatus);
                ddinfo.setChannelId(channelID);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        if (DEBUG) {
            this.debug("updateAllRecordInfoTx completed; commitId= " + commitId + " channelID = " + channelID);
        }
    }

    @Override
    public IDbDupDetectData getRecordInfoTx(String commitId) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("getRecordInfoTx starting; commitId= " + commitId);
        }
        DbDupDetectData result = null;
        this.checkUpdateLock();
        try {
            PSEDupDetectInfo ddinfo = this.getDDInfo(commitId);
            if (ddinfo != null) {
                result = new DbDupDetectData(ddinfo.getCommitID(), ddinfo.getEndOfLife(), ddinfo.getCreationTime(), ddinfo.getStatus(), ddinfo.getChannelID());
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        return result;
    }

    private int writeInternal(String commitId, long endOfLife, long timestamp, int status, String channelID, boolean doCommit) throws EDatabaseException, IllegalArgumentException {
        int res = 0;
        try {
            PSEDupDetectInfo ddinfo = new PSEDupDetectInfo(commitId, endOfLife, timestamp, status, channelID);
            boolean added = this.getRootDD().add((Object)ddinfo);
            if (added) {
                res = 1;
            }
            if (doCommit) {
                this.commit();
            }
        }
        catch (DuplicateKeyException dke) {
            res = -1;
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getRecords(String minCommitId, String maxCommitId, int count, boolean inclusive) throws EDatabaseException {
        ArrayList<DbDupDetectData> result = new ArrayList<DbDupDetectData>();
        this.acquireLock(this.m_opCtxRead);
        try {
            Iterator it = this.getIterator(minCommitId);
            int resultCount = 0;
            boolean firstPass = true;
            while (it.hasNext()) {
                PSEDupDetectInfo ddinfo = (PSEDupDetectInfo)it.next();
                String commitId = ddinfo.getCommitID();
                if (commitId.compareTo(maxCommitId) <= 0) {
                    if (firstPass) {
                        firstPass = false;
                        if (!inclusive && commitId.equals(minCommitId)) continue;
                    }
                    DbDupDetectData info = new DbDupDetectData(ddinfo.getCommitID(), ddinfo.getEndOfLife(), ddinfo.getCreationTime(), ddinfo.getStatus(), ddinfo.getChannelID());
                    result.add(info);
                    if (++resultCount < count) continue;
                    ArrayList<DbDupDetectData> arrayList = result;
                    return arrayList;
                }
                ArrayList<DbDupDetectData> arrayList = result;
                return arrayList;
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLimits() throws EDatabaseException {
        String[] result = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            Iterator it = this.getIterator(null);
            Object lastCommitId = null;
            boolean firstPass = true;
            while (it.hasNext()) {
                if (firstPass) {
                    String commitId = ((PSEDupDetectInfo)it.next()).getCommitID();
                    result = new String[]{commitId, commitId};
                    firstPass = false;
                    continue;
                }
                result[1] = ((PSEDupDetectInfo)it.next()).getCommitID();
            }
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return result;
    }

    private OSTreeSet getRootDD() {
        if (this.m_rootDD != null) {
            return this.m_rootDD;
        }
        return (OSTreeSet)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName(this.m_ddName));
    }
}

