/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.Database;
import com.odi.DatabaseRootNotFoundException;
import com.odi.IPersistent;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.Placement;
import com.odi.Session;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeSet;
import java.util.Date;
import java.util.Iterator;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.PSEDbContext;
import progress.message.dbsc.IStatusListener;
import progress.message.dbsc.pse.DbSchemaPSE;
import progress.message.dbsc.pse.pc.pubsub.IPSEClientUndelMsgs;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessage;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessages;
import progress.message.dbsc.pse.pc.pubsub.IPSEUndelMsg;
import progress.message.dbsc.pse.pc.pubsub.PSEClientUndelMsgs;
import progress.message.dbsc.pse.pc.pubsub.PSEMessages;
import progress.message.dbsc.pse.pc.pubsub.v2.PSEClientUndelMsgs2;
import progress.message.dbsc.pse.pc.pubsub.v2.PSEMessages2;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class UpgradeHelperV7ToV702
extends DebugObject {
    private static int COMMIT_SIZE = 20000;
    private PSEBrokerDb m_pseDb;
    private DbSchemaPSE m_schemadef;
    private PSEDbContext m_dbctx;

    UpgradeHelperV7ToV702(PSEBrokerDb pdb, DbSchemaPSE schemadef) {
        super(DebugState.GLOBAL_DEBUG_ON ? "UpgradeHelperV7ToV702 " + pdb : null);
        this.m_pseDb = pdb;
        this.m_schemadef = schemadef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpgrade() throws EDatabaseException {
        IStatusListener listener = this.m_schemadef.getStatusListener();
        if (this.DEBUG) {
            this.debug("Starting Db Upgrade...");
        }
        if (listener != null) {
            listener.upgradingSchema("Starting Db Upgrade...");
        }
        Object dbctx = null;
        try {
            this.m_dbctx = this.m_pseDb.getCtx(3);
            this.m_dbctx.getSession().join();
            this.upgradeMessages();
            this.upgradeUndelMsgs();
            if (this.DEBUG) {
                this.debug("Db Upgrade Complete ");
            }
            if (listener != null) {
                listener.upgradingSchema("Db Upgrade Complete");
            }
        }
        catch (ObjectStoreException ex) {
            ex.printStackTrace();
            this.m_dbctx.handlePSEException(ex);
        }
        finally {
            this.m_dbctx.getSession();
            Session.leave();
        }
    }

    private void upgradeMessages() throws EDatabaseException {
        boolean restart;
        IStatusListener listener = this.m_schemadef.getStatusListener();
        Database db = this.m_dbctx.getDatabase();
        if (this.DEBUG) {
            this.debug("upgradeMessages: starting ");
        }
        IPSEMessages oldMsgsRoot = null;
        try {
            oldMsgsRoot = (IPSEMessages)db.getRoot("OldMessages");
        }
        catch (DatabaseRootNotFoundException ex) {
            // empty catch block
        }
        IPSEMessages newMsgsRoot = null;
        try {
            newMsgsRoot = (IPSEMessages)db.getRoot("Messages");
        }
        catch (DatabaseRootNotFoundException ex) {
            throw new EDatabaseException("Invalid pubsub db; Messages root not found");
        }
        if (newMsgsRoot instanceof PSEMessages) {
            if (oldMsgsRoot != null) {
                throw new EAssertFailure("OldMessagesRoot not null; possibly corrupt schema");
            }
            oldMsgsRoot = newMsgsRoot;
            db.createRoot("OldMessages", (Object)oldMsgsRoot);
            db.setRoot("Messages", (Object)new PSEMessages2(db));
        }
        this.m_dbctx.commit();
        if (oldMsgsRoot == null) {
            return;
        }
        newMsgsRoot = (IPSEMessages)db.getRoot("Messages");
        oldMsgsRoot = (IPSEMessages)db.getRoot("OldMessages");
        int totmsgs = oldMsgsRoot.getCount();
        if (this.DEBUG) {
            this.debug("upgradeMessages: upgrading Messages; totCount= " + totmsgs);
        }
        int ct = 0;
        block4: do {
            newMsgsRoot = (IPSEMessages)db.getRoot("Messages");
            oldMsgsRoot = (IPSEMessages)db.getRoot("OldMessages");
            IndexIterator it = oldMsgsRoot.getIterator();
            restart = false;
            while (it.hasNext()) {
                IPSEMessage oldMsg = (IPSEMessage)it.next();
                newMsgsRoot.addMessage(oldMsg.getMessageId(), oldMsg.getSequenceNumber(), oldMsg.getMessageSize(), oldMsg.getExpiration(), new Date(System.currentTimeMillis()), new String(oldMsg.getJMSMessageId()), oldMsg.getMessageBody());
                IPSEMessage newMsg = newMsgsRoot.get(oldMsg.getMessageId());
                oldMsg.setMessageBodyNullNoDestroy();
                long[] recips = oldMsg.getRecipsArray();
                if (recips != null) {
                    for (int i = 0; i < recips.length; ++i) {
                        newMsg.addRecipient(recips[i]);
                    }
                }
                oldMsgsRoot.removingMsg(oldMsg);
                oldMsg.removeAllRecipients();
                it.remove();
                ObjectStore.destroy((Object)oldMsg);
                if (++ct % COMMIT_SIZE != 0) continue;
                this.m_dbctx.commit();
                if (this.DEBUG) {
                    this.debug("UpgradeMessages: NumProcessed= " + ct + "; totmsgs= " + totmsgs);
                }
                if (listener != null) {
                    listener.upgradingSchema("UpgradeMessages: NumProcessed= " + ct + "; totmsgs= " + totmsgs);
                }
                restart = true;
                continue block4;
            }
        } while (restart);
        if (oldMsgsRoot.getCount() > 0) {
            throw new EAssertFailure("***Error: Not all Messages transformed");
        }
        db.destroyRoot("OldMessages");
        ObjectStore.destroy((Object)oldMsgsRoot);
        this.m_dbctx.commit();
        if (this.DEBUG) {
            this.debug("UpgradeMessages complete: NumProcessed= " + ct);
        }
        if (listener != null) {
            listener.upgradingSchema("UpgradeMessages complete: NumProcessed= " + ct);
        }
    }

    private void upgradeUndelMsgs() throws EDatabaseException {
        boolean restart;
        IStatusListener listener = this.m_schemadef.getStatusListener();
        Database db = this.m_dbctx.getDatabase();
        OSTreeSet oldClRoot = null;
        try {
            oldClRoot = (OSTreeSet)db.getRoot("OldClientUndelMsgs");
        }
        catch (DatabaseRootNotFoundException ex) {
            // empty catch block
        }
        OSTreeSet newClRoot = null;
        try {
            newClRoot = (OSTreeSet)db.getRoot("ClientUndelMsgs");
        }
        catch (DatabaseRootNotFoundException ex) {
            throw new EDatabaseException("Invalid pubsub db; ClientUndelMsgs root not found");
        }
        if (newClRoot.isEmpty()) {
            if (oldClRoot == null) {
                OSTreeSet ts = new OSTreeSet((Placement)db, IPSEClientUndelMsgs.class, "getClientId()");
                db.setRoot("ClientUndelMsgs", (Object)ts);
                ObjectStore.destroy((IPersistent)newClRoot);
            }
        } else {
            Iterator it = newClRoot.iterator();
            IPSEClientUndelMsgs clUndel = (IPSEClientUndelMsgs)it.next();
            if (clUndel instanceof PSEClientUndelMsgs) {
                if (oldClRoot != null) {
                    throw new EAssertFailure("OldClientUndelMsgs root not null; possibly corrupt schema");
                }
                oldClRoot = newClRoot;
                db.createRoot("OldClientUndelMsgs", (Object)oldClRoot);
                OSTreeSet ts = new OSTreeSet((Placement)db, IPSEClientUndelMsgs.class, "getClientId()");
                db.setRoot("ClientUndelMsgs", (Object)ts);
            }
        }
        this.m_dbctx.commit();
        if (oldClRoot == null) {
            return;
        }
        oldClRoot = (OSTreeSet)db.getRoot("OldClientUndelMsgs");
        newClRoot = (OSTreeSet)db.getRoot("ClientUndelMsgs");
        if (this.DEBUG) {
            this.debug("upgradeUndelMsgs: upgradingUndel; numClients= " + oldClRoot.size());
        }
        int ct = 0;
        long currentCid = -1L;
        block4: do {
            oldClRoot = (OSTreeSet)db.getRoot("OldClientUndelMsgs");
            newClRoot = (OSTreeSet)db.getRoot("ClientUndelMsgs");
            IPSEMessages newMsgsRoot = (IPSEMessages)db.getRoot("Messages");
            Iterator it = oldClRoot.iterator();
            restart = false;
            while (it.hasNext()) {
                IPSEClientUndelMsgs oldCl = (IPSEClientUndelMsgs)it.next();
                IPSEClientUndelMsgs newCl = (IPSEClientUndelMsgs)newClRoot.getFromPrimaryIndex((Object)new Long(oldCl.getClientId()));
                if (newCl == null) {
                    newCl = new PSEClientUndelMsgs2(db, oldCl.getClientId());
                    newClRoot.add((Object)newCl);
                }
                if (this.DEBUG && currentCid != oldCl.getClientId()) {
                    this.debug("Starting client= " + oldCl.getClientId() + "; ct= " + oldCl.getUndelCount() + "; size= " + oldCl.getUndelSize());
                }
                currentCid = oldCl.getClientId();
                IndexIterator itu = oldCl.getUndelIterator();
                while (itu.hasNext()) {
                    IPSEUndelMsg oldUndel = (IPSEUndelMsg)itu.next();
                    Object newUndel = null;
                    IPSEMessage msg = newMsgsRoot.get(oldUndel.getMessageId());
                    if (msg == null) {
                        throw new EAssertFailure("Message with id " + oldUndel.getMessageId() + " not found");
                    }
                    int size = msg.getMessageSize();
                    newCl.addUndel(oldUndel.getMessageId(), oldUndel.getSequenceNumber(), msg.getMessageSize(), oldUndel.getRedelivery(), msg.getExpiration(), oldUndel.getFromRemoteBroker(), oldUndel.getPersistent(), oldUndel.getUndelSubjectIds(), msg);
                    itu.remove();
                    oldCl.updateTotalSize(-size);
                    ObjectStore.destroy((Object)oldUndel);
                    if (++ct % COMMIT_SIZE != 0) continue;
                    this.m_dbctx.commit();
                    if (ct % 100000 == 0) {
                        if (this.DEBUG) {
                            this.debug("UpgradeUndelMsgs: NumProcessed= " + ct);
                        }
                        if (listener != null) {
                            listener.upgradingSchema("UpgradeUndelMsgs: NumProcessed= " + ct);
                        }
                    }
                    restart = true;
                    break;
                }
                if (restart) continue block4;
                it.remove();
                ObjectStore.destroy((Object)oldCl);
                if (!this.DEBUG) continue;
                this.debug("Completed client= " + newCl.getClientId() + "; ct= " + newCl.getUndelCount() + "; size= " + newCl.getUndelSize());
            }
        } while (restart);
        if (!oldClRoot.isEmpty()) {
            throw new EAssertFailure("***Error: Not all Clients transformed");
        }
        db.destroyRoot("OldClientUndelMsgs");
        ObjectStore.destroy((IPersistent)oldClRoot);
        this.m_dbctx.commit();
        if (this.DEBUG) {
            this.debug("UpgradeUndelMsgs complete: NumProcessed= " + ct);
        }
        if (listener != null) {
            listener.upgradingSchema("UpgradeUndelMsgs complete: NumProcessed= " + ct);
        }
    }
}

