/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.gr;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.util.OSVector;
import java.util.Iterator;
import progress.message.dbsc.pse.pc.gr.PSERouteInfo;

public class PSERouteHolder
implements IPersistent,
IPersistentHooks {
    private String _RoutingNodeName;
    private String _GlobalName;
    private OSVector _routes;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = PSERouteHolder.getClassInfoInstance();

    public PSERouteHolder(String routingNodeName, String globalName) {
        this._RoutingNodeName = new String(routingNodeName);
        this._GlobalName = new String(globalName);
        this._routes = new OSVector();
    }

    public String getRoutingNodeName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._RoutingNodeName;
    }

    public String getGlobalName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._GlobalName;
    }

    public void preDestroyPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        this.removeAllRoutes();
        ObjectStore.destroy((IPersistent)this._routes);
        ObjectStore.destroy((Object)this._GlobalName);
        ObjectStore.destroy((Object)this._RoutingNodeName);
    }

    public void removeAllRoutes() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (!this._routes.isEmpty()) {
            Iterator it = this._routes.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                it.remove();
                ObjectStore.destroy(obj);
            }
        }
    }

    public int getCountRoutes() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._routes.size();
    }

    public Iterator getRoutes() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._routes.iterator();
    }

    public boolean addRoute(PSERouteInfo newri) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String broker = newri.getBrokerName();
        int removed = this.removeRoute(broker);
        this._routes.addElement((Object)newri);
        return true;
    }

    public int removeRoute(String broker) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        int ct = 0;
        if (!this._routes.isEmpty()) {
            Iterator it = this._routes.iterator();
            while (it.hasNext()) {
                PSERouteInfo ri = (PSERouteInfo)it.next();
                if (ri.getBrokerName() == null && broker == null) {
                    it.remove();
                    ObjectStore.destroy((Object)ri);
                    ++ct;
                    continue;
                }
                if (ri.getBrokerName() == null || !ri.getBrokerName().equals(broker)) continue;
                it.remove();
                ObjectStore.destroy((Object)ri);
                ++ct;
            }
        }
        return ct;
    }

    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSERouteHolder: ");
        buf.append("\tRoutingNodeName: " + this.getRoutingNodeName());
        buf.append("\tGlobalName: " + this.getGlobalName());
        buf.append("\tCountRoutes: " + this.getCountRoutes());
        return buf.toString();
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSERouteHolder)super.clone()).ODIref = null;
        ((PSERouteHolder)super.clone()).ODIObjectState = 0;
        return (PSERouteHolder)super.clone();
    }

    public void postInitializeContents() {
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._RoutingNodeName = genericObject.getStringField(1, classInfo);
        this._GlobalName = genericObject.getStringField(2, classInfo);
        this._routes = (OSVector)genericObject.getClassField(3, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setStringField(1, this._RoutingNodeName, classInfo);
        genericObject.setStringField(2, this._GlobalName, classInfo);
        genericObject.setClassField(3, (Object)this._routes, classInfo);
    }

    public void clearContents() {
        this._RoutingNodeName = null;
        this._GlobalName = null;
        this._routes = null;
    }

    public PSERouteHolder(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        try {
            return ClassInfo.get(Class.forName("progress.message.dbsc.pse.pc.gr.PSERouteHolder"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

