/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import progress.message.broker.AgentRegistrar;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.RemoteBrokerDescriptor;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;

public class RBRegistrySyncOp {
    public static final byte VERSION = 0;
    private ArrayList m_rbds = new ArrayList();
    private boolean m_lastChunk = false;
    private long m_guarTrackingNum = -1L;

    RBRegistrySyncOp() {
    }

    boolean isLastChunk() {
        return this.m_lastChunk;
    }

    void setGuarTrackingNum(long guarTrkNum) {
        this.m_guarTrackingNum = guarTrkNum;
    }

    long getGuarTrackingNum() {
        return this.m_guarTrackingNum;
    }

    RBRegistrySyncOp(DataInput input) throws IOException {
        input.readByte();
        this.m_lastChunk = input.readBoolean();
        int size = input.readInt();
        this.m_rbds = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            RemoteBrokerDescriptor rbd = new RemoteBrokerDescriptor();
            rbd.readFromStream(input, (short)-1);
            this.m_rbds.add(rbd);
        }
    }

    public static IMgram createRBRegistrySyncOpMgram(ArrayList rbds, boolean lastChunk) throws IOException {
        IMgram mgram = MgramFactory.getMgramFactory().buildOperationMgram(23);
        ObjectOutput output = mgram.getPayloadOutputStreamHandle();
        FTMgramFactory.addFTOpHeader(output, (byte)8);
        output.writeByte(0);
        output.writeBoolean(lastChunk);
        int size = rbds.size();
        output.writeInt(size);
        RemoteBrokerDescriptor rbd = null;
        for (int i = 0; i < size; ++i) {
            rbd = (RemoteBrokerDescriptor)rbds.get(i);
            rbd.writeToStream(output, (short)-1);
        }
        return mgram;
    }

    public void execute() throws IOException {
        int size = this.m_rbds.size();
        RemoteBrokerDescriptor rbd = null;
        AgentRegistrar agentReg = AgentRegistrar.getAgentRegistrar();
        for (int i = 0; i < size; ++i) {
            rbd = (RemoteBrokerDescriptor)this.m_rbds.get(i);
            agentReg.getBrokerDatabase().getIRoutingDBQ().addRemoteBroker(rbd.getClientId(), rbd.getUrl(), rbd.getFtPeerUrl(), rbd.getNode(), rbd.getBroker(), rbd.getUser(), rbd.getPassword());
        }
    }
}

