/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerStatus;
import progress.message.broker.Config;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EStartupFailure;
import progress.message.broker.IAcceptor;
import progress.message.broker.IClientContext;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.broker.IStateController;
import progress.message.broker.IStateListener;
import progress.message.broker.LogManager;
import progress.message.broker.TransactionMgr;
import progress.message.broker.prAccessor;
import progress.message.client.EConnectFailure;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.dd.NoDupDetectDb;
import progress.message.ft.ActionManager;
import progress.message.ft.CannotActivateException;
import progress.message.ft.ConnectionManager;
import progress.message.ft.DynamicSyncManager;
import progress.message.ft.FTReflectionOperation;
import progress.message.ft.FailoverConfig;
import progress.message.ft.FailoverStateSolicitator;
import progress.message.ft.IReplicationConnection;
import progress.message.ft.IRequestHandler;
import progress.message.ft.RBRegistrySyncOp;
import progress.message.ft.ReplicationChannel;
import progress.message.ft.ReplicationConnection;
import progress.message.ft.ReplicationDemultiplexer;
import progress.message.ft.ReplicationState;
import progress.message.ft.TransactionSyncOp;
import progress.message.ft.TxnFileReplicationMgr;
import progress.message.ft.UserIDMappingSyncOp;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.net.ISocket;
import progress.message.net.ISocketHandler;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.Envelope;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Publication;
import progress.message.zclient.Solicitation;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectUtil;

public final class ReplicationManager
extends DebugObject
implements ISocketHandler,
IReplicationConnection,
IStateController,
IStateListener {
    private static final int STARTUP = 0;
    private static final int WAITING = 1;
    private static final int STANDALONE = 2;
    private static final int ACTIVE = 3;
    private static final int STANDBY = 4;
    private static final int ACTIVE_SYNC = 5;
    private static final int STANDBY_SYNC = 6;
    private static final String[] State = ReplicationState.s_replicationStateStrings;
    private static final int s_delAllTxnSize = 10000;
    private static Object _syncObj = new Object();
    private Object m_replicationStateSyncObj = new Object();
    private static ReplicationManager s_instance = null;
    private Object m_replTrackSyncObject = new Object();
    private ConnectionManager m_connMgr = null;
    private FailoverStateSolicitator m_remoteStateSolicitator = null;
    private DynamicSyncManager m_dynamicSyncMgr = null;
    private int m_replicationChunkSize = 0;
    private long m_localID = -1L;
    private long m_remoteID = -1L;
    private long m_failureDetectTimeout = -1L;
    private boolean m_ackOnSync = true;
    private int m_recoveredState = 0;
    private ActionManager m_actionMgr;
    private ReplicationDemultiplexer m_demux;
    private TxnFileReplicationMgr m_txnFileReplicationMgr;
    private LongHashTable<ReplicationJob> m_jobs = null;
    private boolean m_trackReceivedConnections = false;
    private boolean m_hasReceivedConnections = false;
    private volatile boolean m_stoppingReplication = false;
    private long m_replCount = 0L;
    private boolean activating = false;
    private volatile int m_replicationState = 7;
    private Object m_stateChangeMutex = new Object();
    private boolean m_inStateTransition = false;
    private volatile int m_brokerState;
    private volatile boolean m_shutdown = false;
    private HashMap<String, IRequestHandler> m_requestHandlers = new HashMap();
    private Object m_syncObj = new Object();
    private Thread m_lockHolder = null;
    private int m_lockCount = 0;

    static AgentRegistrar getAR() {
        return AgentRegistrarLazyHolder.REG_OBJ;
    }

    static LogManager getLM() {
        return LogManagerLazyHolder.LOG_MGR;
    }

    static TransactionMgr getTM() {
        return TransactionMgrLazyHolder.TXN_MGR;
    }

    public ActionManager getActionManager() {
        return this.m_actionMgr;
    }

    public ReplicationDemultiplexer getReplicationDemultiplexer() {
        return this.m_demux;
    }

    public TxnFileReplicationMgr getTxnFileReplicationMgr() {
        return this.m_txnFileReplicationMgr;
    }

    long getLocalID() {
        return this.m_localID;
    }

    long getRemoteID() {
        return this.m_remoteID;
    }

    void setRemoteID(long id) {
        this.m_remoteID = id;
    }

    public ConnectionManager getConnectionMgr() {
        return this.m_connMgr;
    }

    FailoverStateSolicitator getRemoteStateSolicitator() {
        return this.m_remoteStateSolicitator;
    }

    int getRecoveredState() {
        return this.m_recoveredState;
    }

    private boolean isRecoverable() {
        return this.m_recoveredState != 5;
    }

    public synchronized boolean isAssertingActive() {
        return Config.FT_START_ACTIVE || this.activating;
    }

    int getReplicationChunkSize() {
        return this.m_replicationChunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manuallyActivateBroker() throws CannotActivateException {
        try {
            this.lock();
            this.waitForStateTransitionToComplete();
            if (this.DEBUG) {
                this.debug("activating broker, state = " + State[this.m_replicationState]);
            }
            if (this.m_replicationState != 0 && this.m_replicationState != 1) {
                throw new CannotActivateException(1);
            }
            if (Config.FT_START_ACTIVE) {
                return;
            }
            if (!this.startActive()) {
                if (this.DEBUG) {
                    this.debug("failed to activate broker, saved state = " + BrokerStatus.State.get(this.getRecoveredState()));
                }
                throw new CannotActivateException(3);
            }
        }
        finally {
            this.unlock();
        }
    }

    void setDynamicSyncStatus(int status) {
        this.m_dynamicSyncMgr.setStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReplicationState(int replicationState) throws InterruptedException {
        Object object = this.m_replicationStateSyncObj;
        synchronized (object) {
            while (this.m_replicationState != replicationState) {
                this.m_replicationStateSyncObj.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStandbyDynamicSyncDone() throws InterruptedException {
        try {
            this.lock();
            this.waitForStateTransitionToComplete();
            if (this.m_replicationState == 6) {
                this.setBrokerState(6);
                return;
            }
        }
        finally {
            this.unlock();
        }
    }

    void triggerDynamicSyncOnActive() throws InterruptedException {
        if (this.DEBUG) {
            this.debug("triggering active sync, broker state = " + State[this.m_replicationState]);
        }
        this.waitForReplicationState(2);
        this.setBrokerState(3);
    }

    public synchronized int getReplicationState() {
        return this.m_replicationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReplicationState(int state) {
        int oldState;
        Object object = this.m_replicationStateSyncObj;
        synchronized (object) {
            oldState = this.m_replicationState;
            this.m_replicationState = state;
            this.m_replicationStateSyncObj.notifyAll();
        }
        BrokerManagementNotificationsHelper.sendReplicationStateChangeNotification(Config.PRIMARY ? "PRIMARY" : "BACKUP", ReplicationState.getReplicationStateString(oldState), ReplicationState.getReplicationStateString(this.m_replicationState));
        if (this.DEBUG) {
            this.debug("Notified ReplicationStateChange from " + ReplicationState.getReplicationStateString(oldState) + " to " + ReplicationState.getReplicationStateString(this.m_replicationState));
        }
        BrokerComponent.getComponentContext().logMessage("Replication State is " + ReplicationState.getReplicationStateString(this.m_replicationState), 3);
    }

    public synchronized String getReplicationStateString() {
        return ReplicationState.getReplicationStateString(this.getReplicationState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBrokerState() {
        Object object = this.m_stateChangeMutex;
        synchronized (object) {
            return this.m_brokerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBrokerState(int state) {
        block30: {
            boolean failover;
            if (this.DEBUG) {
                this.debug("changing state to " + BrokerStatus.State.get(state) + " by " + Thread.currentThread());
            }
            Object object = this.m_stateChangeMutex;
            synchronized (object) {
                while (this.m_inStateTransition) {
                    try {
                        if (this.DEBUG) {
                            this.debug("waiting for the last state transition to finish...");
                        }
                        this.m_stateChangeMutex.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        return;
                    }
                }
                if (this.isShuttingDown()) {
                    return;
                }
                if (this.CALLBACK) {
                    this.callback(BrokerStatus.State.get(state), 3, null);
                }
                this.m_inStateTransition = true;
                this.m_brokerState = state;
                if (this.DEBUG) {
                    this.debug("transitioning to " + BrokerStatus.State.get(state));
                }
            }
            boolean bl = failover = this.m_replicationState == 4 && state == 1;
            if (failover) {
                if (this.DEBUG) {
                    this.debug("FAILOVER");
                }
                this.m_trackReceivedConnections = true;
                this.m_hasReceivedConnections = false;
            }
            boolean ret = false;
            try {
                ret = BrokerStateManagerLazyHolder.STATE_MGR.setState(state, this);
            }
            catch (EAssertFailure ea) {
                if (Broker.exiting) break block30;
                try {
                    BrokerComponent.getBrokerComponent().abort("Failed to transition broker to " + BrokerStatus.State.get(state), ea, 1);
                }
                catch (EBrokerAborted eba) {
                    throw ea;
                }
            }
            finally {
                if (!ret) {
                    Object object2 = this.m_stateChangeMutex;
                    synchronized (object2) {
                        this.m_inStateTransition = false;
                        this.m_stateChangeMutex.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForStateTransitionToComplete() {
        boolean interrupted = false;
        Object object = this.m_stateChangeMutex;
        synchronized (object) {
            while (!interrupted && this.m_inStateTransition) {
                try {
                    if (this.DEBUG) {
                        this.debug("Waiting for the state transition to " + BrokerStatus.State.get(this.m_brokerState) + " to completes...");
                    }
                    this.m_stateChangeMutex.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void saveReplicationState(int state) {
        block8: {
            if (state == 2 || state == 3 || state == 1 || state == 6 || state == 5) {
                try {
                    if (this.DEBUG) {
                        this.debug("saving broker state " + BrokerStatus.State.get(state) + " to db...");
                    }
                    this.m_recoveredState = state;
                    AgentRegistrarLazyHolder.REG_OBJ.getBrokerDatabase().setBrokerLastKnownState(state);
                    if (this.DEBUG) {
                        this.debug("broker state saved.");
                    }
                    if (this.CALLBACK) {
                        Object[] params = new Object[]{new Integer(this.m_brokerState)};
                        this.callback("Broker State Written", 0, params);
                    }
                }
                catch (EDatabaseException e) {
                    if (Broker.exiting) break block8;
                    e.printStackTrace();
                    try {
                        String msg = MessageFormat.format(prAccessor.getString("BROKER_STATE_SAVE_ERROR"), BrokerStatus.State.get(state));
                        BrokerComponent.getBrokerComponent().abort(msg, e, 1);
                    }
                    catch (EBrokerAborted eba) {
                        return;
                    }
                }
            }
        }
    }

    DynamicSyncManager.DynamicSyncClientInfo getAllInMemoryClientContexts() {
        return AgentRegistrarLazyHolder.REG_OBJ.getAllInMemoryClientContexts();
    }

    Object getRBRegistrySyncObj() {
        return AgentRegistrarLazyHolder.REG_OBJ.getRouterManager().getRBRegistrySyncObj();
    }

    Enumeration getRBRegistry() {
        return AgentRegistrarLazyHolder.REG_OBJ.getRouterManager().getAllRemoteBrokers();
    }

    public ArrayList snapshotFileBasedTxns() {
        return AgentRegistrarLazyHolder.REG_OBJ.getTransactionMgr().snapshotFileBasedTxns();
    }

    void replicateFileBasedTxn(int tid) {
        AgentRegistrarLazyHolder.REG_OBJ.getTransactionMgr().replicateFileBasedTxn(tid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplicationManager getReplicationManager() throws EStartupFailure {
        if (s_instance != null) {
            return s_instance;
        }
        Object object = _syncObj;
        synchronized (object) {
            if (s_instance == null) {
                s_instance = new ReplicationManager();
            }
        }
        return s_instance;
    }

    public ReplicationConnection getReplicationConnection() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getConnection();
        }
        return null;
    }

    private ReplicationManager() throws EStartupFailure {
        super(DebugState.GLOBAL_DEBUG_ON ? "ReplicationManager" : null);
        try {
            this.m_localID = AddrUtil.stringToClientId(Config.BROKER_NAME, FailoverConfig.RM_APPID);
            this.m_ackOnSync = Config.FT_REPLICATE_PERSISTENT;
            this.m_failureDetectTimeout = Config.FT_FAILURE_DETECT_TIMEOUT;
            this.m_replicationChunkSize = Config.REPLICATION_CHUNK_SIZE;
            if (this.DEBUG) {
                this.debug("Config.FT_START_ACTIVE: " + Config.FT_START_ACTIVE + " m_ackOnSync: " + this.m_ackOnSync + " m_failureDetectTimeout: " + this.m_failureDetectTimeout + " m_replicationChunkSize: " + this.m_replicationChunkSize);
            }
            this.m_connMgr = new ConnectionManager(this);
            this.m_actionMgr = new ActionManager();
            this.m_txnFileReplicationMgr = new TxnFileReplicationMgr();
            this.m_demux = new ReplicationDemultiplexer(this);
            this.m_jobs = new LongHashTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EStartupFailure("Error starting ReplicationManager: " + e, e);
        }
    }

    @Override
    public void stateChanging(int state) {
        this.saveReplicationState(state);
        if (this.CALLBACK) {
            this.callback(BrokerStatus.State.get(state), 1, null);
        }
    }

    @Override
    public void stateChanged(int state) throws Exception {
        if (this.DEBUG) {
            this.debug("received state change notification, state = " + BrokerStatus.State.get(state));
        }
        if (this.CALLBACK) {
            this.callback(BrokerStatus.State.get(state), 2, null);
        }
        switch (state) {
            case 5: {
                this.m_dynamicSyncMgr.beginStandbySync();
                break;
            }
            case 3: {
                try {
                    BrokerStateManager.getBrokerStateManager().waitForStatusChange(this.getActionManager());
                }
                catch (Throwable t) {
                    if (!Broker.exiting) {
                        BrokerComponent.getComponentContext().logMessage(t, 2);
                    }
                    return;
                }
                this.m_dynamicSyncMgr.beginActiveSync();
                if (this.DEBUG) {
                    this.debug("Kicking off syncpoint for dynamic sync");
                }
                try {
                    AgentRegistrarLazyHolder.REG_OBJ.forceSyncpoint(true, false);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            case 4: {
                this.m_dynamicSyncMgr.stopDynamicSync();
                if (this.DEBUG) {
                    this.debug("starting the conversion thread to establish replication connection.");
                }
                this.m_connMgr.start();
                break;
            }
            case 1: {
                this.m_dynamicSyncMgr.stopDynamicSync();
                break;
            }
            case 2: 
            case 6: {
                this.m_dynamicSyncMgr.onDynamicSyncComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChangeFailed(Throwable t, int state) {
        Object object = this.m_stateChangeMutex;
        synchronized (object) {
            if (state == this.m_brokerState && this.m_inStateTransition) {
                if (this.DEBUG) {
                    this.debug("State change failed " + BrokerStatus.State.get(this.m_brokerState));
                }
                this.m_inStateTransition = false;
                this.m_stateChangeMutex.notifyAll();
            }
        }
        if (!Broker.exiting) {
            try {
                BrokerComponent.getBrokerComponent().abort("Failed to transition broker to " + BrokerStatus.State.get(state), t, 1);
            }
            catch (EBrokerAborted eba) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChangeComplete(int state) {
        if (ReplicationState.isReplicationState(state)) {
            int replState = ReplicationState.getReplicationStateFromBrokerState(state);
            if (this.DEBUG) {
                this.debug("BSTATE = " + BrokerStatus.State.get(state) + " RSTATE = " + State[replState]);
            }
            this.setReplicationState(replState);
        }
        boolean stoppingReplication = this.m_stoppingReplication;
        Object object = this.m_stateChangeMutex;
        synchronized (object) {
            if (state == this.m_brokerState) {
                if (this.DEBUG) {
                    this.debug("Done state transition to " + BrokerStatus.State.get(this.m_brokerState));
                }
                this.m_inStateTransition = false;
            }
            this.m_stateChangeMutex.notifyAll();
        }
        if (state == 5 || state == 6) {
            if (stoppingReplication || this.m_brokerState == 4) {
                if (this.DEBUG) {
                    this.debug("suppressing sendStandbyBrokerState: in transition to:" + BrokerStatus.State.get(this.m_brokerState) + " state, stoppingReplication:" + stoppingReplication);
                }
            } else {
                if (this.DEBUG) {
                    this.debug("sending local state to the peer, state = " + BrokerStatus.State.get(state));
                }
                this.m_remoteStateSolicitator.sendStandbyBrokerState(state);
            }
        }
    }

    public void start() throws Exception {
        this.m_recoveredState = AgentRegistrarLazyHolder.REG_OBJ.getBrokerDatabase().getBrokerLastKnownState();
        if (this.DEBUG) {
            this.debug("broker's last known state is " + State[this.m_recoveredState]);
        }
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 4, 8);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 1, 3);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 3, 2);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 3, 1);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 2, 1);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 4, 5);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 5, 6);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 5, 4);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 6, 1);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 6, 4);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 1, 5);
        BrokerStateManagerLazyHolder.STATE_MGR.registerController(this, 6, 5);
        BrokerStateManagerLazyHolder.STATE_MGR.registerListener(this);
        this.m_remoteStateSolicitator = new FailoverStateSolicitator(this);
        this.m_dynamicSyncMgr = new DynamicSyncManager(this);
        ReplicationChannel.startAcceptors(this.m_connMgr);
    }

    public boolean isShuttingDown() {
        return this.m_shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean fatal) {
        BrokerComponent.getComponentContext().logMessage("Closing down all replication connection(s)", 3);
        this.m_remoteStateSolicitator.sendRemoteShutdownNotification();
        Object object = this.m_stateChangeMutex;
        synchronized (object) {
            while (this.m_inStateTransition) {
                try {
                    if (this.DEBUG) {
                        this.debug("waiting for the last state transition to finish...");
                    }
                    this.m_stateChangeMutex.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            this.m_shutdown = true;
        }
        this.m_connMgr.shutdown();
        this.terminateReplicationJobs();
        if (this.m_actionMgr != null) {
            this.m_actionMgr.shutdown();
        }
        try {
            this.m_dynamicSyncMgr.stopDynamicSync();
            this.m_demux.stopThread(4, fatal);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_txnFileReplicationMgr.closeAllReplicatedFiles();
        if (this.m_remoteStateSolicitator != null) {
            this.m_remoteStateSolicitator.cleanup();
        }
    }

    public static boolean isReplicationConnection(IClientContext cc) {
        String appid = cc.getAppid();
        int scode = SubjectUtil.computeSCode(appid, 0, appid.length());
        if (scode == FailoverConfig.RM_APPID_SCODE) {
            return true;
        }
        if (scode == FailoverConfig.RM_BACKUP_APPID_SCODE) {
            return true;
        }
        return scode == FailoverConfig.RM_PRIMARY_APPID_SCODE;
    }

    public boolean startActive() {
        if (this.isRecoverable()) {
            this.activating = true;
            if (this.DEBUG) {
                this.debug("Direct activation initiated.");
            }
            this.setBrokerState(8);
            this.activating = false;
            return true;
        }
        BrokerComponent.getComponentContext().logMessage("Direct activation failed, waiting to sync up with peer FT broker.", 3);
        return false;
    }

    @Override
    public void handleSocket(ISocket socket, IAcceptor acceptor) throws IOException {
        if (this.isShuttingDown()) {
            return;
        }
        this.m_connMgr.handleSocket(socket, acceptor.getAcceptorName());
    }

    public void onConnect(long id, AgentConnection conn) throws EConnectFailure {
        if (this.m_connMgr.getConnectID() == id) {
            if (this.DEBUG) {
                this.debug("paired FT broker connecting");
            }
            byte negotiatedSessionVer = conn.getAgentListener().getClientSessionVer();
            if (this.checkDebugFlags(64)) {
                this.debug("onConnect: Validating CAA SessionVer (passive side): " + negotiatedSessionVer);
            }
            this.m_connMgr.validateSessionVer(negotiatedSessionVer);
            if (this.checkDebugFlags(64)) {
                this.debug("onConnect: Validated CAA SessionVer (passive side): " + negotiatedSessionVer);
            }
            this.m_connMgr.passiveConnect();
        }
    }

    public void onDisconnect(long id) {
        if (this.m_connMgr.getConnectID() == id) {
            this.m_connMgr.abortConnect();
        }
    }

    public synchronized void connectionReceived() {
        if (this.m_trackReceivedConnections && !this.m_hasReceivedConnections) {
            if (this.DEBUG) {
                this.debug("client connection received after failover.");
            }
            this.m_hasReceivedConnections = true;
        }
    }

    public synchronized boolean hasReceivedConnections() {
        return this.m_hasReceivedConnections;
    }

    public synchronized boolean isFailoverBroker() {
        return this.m_trackReceivedConnections;
    }

    public synchronized void resetFailoverStatus() {
        if (this.m_trackReceivedConnections) {
            this.m_trackReceivedConnections = false;
        }
    }

    public void onConvert(AgentConnection conn, IMgram m) throws EUnexpectedMgram, EGeneralException, IOException {
        if (this.DEBUG) {
            this.debug("received FT_CONVERT mgram");
        }
        this.m_connMgr.convertEvent(conn, m);
    }

    public void onDisconnect(ReplicationChannel channel) {
        boolean replicating = this.m_connMgr.disconnect(channel);
        if (!replicating) {
            this.onReplicationStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onReplicationStop() {
        try {
            this.lock();
            this.m_stoppingReplication = true;
            if (this.DEBUG) {
                this.debug("Stopping replication - all channels of weight > 0 disconnected.");
            }
            this.terminateReplicationJobs();
            this.m_remoteStateSolicitator.cleanup();
            this.waitForStateTransitionToComplete();
            switch (this.m_replicationState) {
                case 3: 
                case 5: {
                    this.setBrokerState(1);
                    return;
                }
                case 4: {
                    if (this.m_connMgr.isRemoteAdminShutdown()) {
                        this.setBrokerState(1);
                        return;
                    }
                    if (!this.m_connMgr.isRemoteAdminDisconnected()) return;
                    this.setBrokerState(4);
                    return;
                }
                case 6: {
                    this.setBrokerState(4);
                    return;
                }
                case 1: {
                    return;
                }
            }
            return;
        }
        finally {
            this.m_stoppingReplication = false;
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onReplicationResume() {
        if (this.DEBUG) {
            this.debug("Resuming replication - channel of weight > 0 connected.");
        }
        try {
            this.lock();
            this.waitForStateTransitionToComplete();
            switch (this.m_replicationState) {
                case 2: {
                    this.m_remoteStateSolicitator.doSolicit();
                    return;
                }
                case 1: 
                case 4: {
                    this.m_remoteStateSolicitator.resume();
                    this.setBrokerState(5);
                    return;
                }
                default: {
                    throw new EAssertFailure("Unable to resume replication - invalid broker state, state = " + State[this.m_replicationState]);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void onSyncpointStart() {
        if (this.DEBUG) {
            this.debug("onSyncpointStart(): m_brokerState = " + BrokerStatus.State.get(this.m_brokerState) + " and m_replicationState = " + State[this.m_replicationState]);
        }
        if (this.m_brokerState == 3 || this.m_replicationState == 5) {
            this.m_dynamicSyncMgr.startActiveSyncBrokerThreads();
        }
    }

    public boolean onSyncpointComplete() {
        boolean replicateEndSyncpointOp = this.m_dynamicSyncMgr.onSyncpointComplete();
        return replicateEndSyncpointOp;
    }

    void setRemoteBrokerState(boolean isPeerActive, int peerRecoveredState, boolean peerHasClientConnected) {
        if (this.DEBUG) {
            this.debug("setRemoteBrokerState(): peer active = " + isPeerActive + ", peer saved state = " + peerRecoveredState + ", has client failed over = " + peerHasClientConnected);
        }
        this.m_remoteStateSolicitator.setRemoteBrokerState(isPeerActive, peerRecoveredState, peerHasClientConnected);
    }

    void setLocalBrokerRole(boolean active) {
        this.m_remoteStateSolicitator.setLocalBrokerRole(active);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postConnect(ReplicationConnection conn) throws EGeneralException {
        try {
            this.lock();
            this.waitForStateTransitionToComplete();
            if (this.m_remoteStateSolicitator.resolveBrokerRole()) {
                conn.startChannelSwitchHandler();
                this.m_remoteStateSolicitator.doSolicit();
            }
        }
        finally {
            this.unlock();
        }
    }

    void handleUserIDMappingSyncOp(UserIDMappingSyncOp uIdSyncOp) {
        this.m_dynamicSyncMgr.handleUserIDMappingSyncOp(uIdSyncOp);
    }

    void handleRBRegistrySyncOp(RBRegistrySyncOp rbRegistrySyncOp) {
        this.m_dynamicSyncMgr.handleRBRegistrySyncOp(rbRegistrySyncOp);
    }

    void handleTxnSyncCompleteOp() {
        TransactionSyncOp txnSyncOp = new TransactionSyncOp();
        txnSyncOp.setTxnSyncComplete(true);
        this.m_dynamicSyncMgr.handleTransactionSyncOp(txnSyncOp);
    }

    void handleReplicateTxnMgram(int tid, short flags, IMgram m) {
        boolean live;
        boolean bl = live = (flags & 1) == 0;
        if (live) {
            if (!Config.FT_REPLICATE_PERSISTENT) {
                this.acknowledge(m.getGuarenteedTrackingNum());
                if (this.DEBUG) {
                    this.debug("onReplicatedMgram acknowledged: " + m.getGuarenteedTrackingNum());
                }
                this.m_txnFileReplicationMgr.onReplicatedMgram(tid, flags, m.getOperationHandle(), -1L);
            } else {
                this.m_txnFileReplicationMgr.onReplicatedMgram(tid, flags, m.getOperationHandle(), m.getGuarenteedTrackingNum());
            }
        } else {
            TransactionSyncOp txnSyncOp = new TransactionSyncOp(tid, flags, m, this.m_txnFileReplicationMgr);
            this.m_dynamicSyncMgr.handleTransactionSyncOp(txnSyncOp);
        }
    }

    public void completeQDynamicSync(long lastTracking) {
        this.m_dynamicSyncMgr.completeQDynamicSync(lastTracking);
    }

    private boolean okToReplicate(IStateEvent evt) {
        return evt != null && this.okToReplicate();
    }

    private boolean okToReplicate(IReplicateableSaverOp op) {
        boolean ret = false;
        if (op != null && !this.isShuttingDown()) {
            if (this.m_brokerState == 2) {
                ret = true;
            } else if (this.m_brokerState == 3) {
                ret = this.m_dynamicSyncMgr.okToReplicate(op);
            }
        }
        return ret;
    }

    public boolean okToReplicate() {
        return !this.isShuttingDown() && (this.m_brokerState == 2 || this.m_brokerState == 3);
    }

    @Override
    public boolean replicateMgram(IMgram m) {
        boolean ret = false;
        if (this.okToReplicate()) {
            m.setGuarenteed(this.allocTracking());
            ret = this.m_connMgr.sendReplicationMgram(m);
        }
        return ret;
    }

    public boolean replicateMgramSynchronously(IMgram m) throws InterruptedException {
        ReplicationJob job = this.replicateMgramSynchronouslyNoWait(m);
        if (job != null) {
            return job.join();
        }
        return false;
    }

    public ReplicationJob replicateMgramSynchronouslyNoWait(IMgram m) throws InterruptedException {
        ReplicationJob job = null;
        if (this.okToReplicate()) {
            try {
                if (this.DEBUG) {
                    this.debug("replicateMgramSynchronously replicating m.getType(): " + m.getType());
                }
                job = this.sendMgram(m, true);
            }
            catch (EClientNotRegistered e) {
                if (this.DEBUG) {
                    this.debug(e.toString(), e);
                }
                return null;
            }
        } else {
            return null;
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateReplicationJobs() {
        LongHashTable<ReplicationJob> longHashTable = this.m_jobs;
        synchronized (longHashTable) {
            Enumeration<ReplicationJob> entries = this.m_jobs.elements();
            while (entries.hasMoreElements()) {
                ReplicationJob job = entries.nextElement();
                job.setStatus(2);
            }
            this.m_jobs.clear();
        }
    }

    private ReplicationJob createJob(long tracking) {
        ReplicationJob job = new ReplicationJob();
        this.m_jobs.put(tracking, job);
        if (this.isShuttingDown()) {
            job.setStatus(2);
        }
        return job;
    }

    private void removeJob(long tracking) {
        this.m_jobs.remove(tracking);
    }

    private ReplicationRequest createRequest(long tracking) {
        ReplicationRequest req = new ReplicationRequest();
        this.m_jobs.put(tracking, (ReplicationJob)req);
        if (this.isShuttingDown()) {
            req.setStatus(2);
        }
        return req;
    }

    private ReplicationJob sendMgram(IMgram m, boolean createJob) throws EClientNotRegistered {
        long tracking = this.allocTracking();
        if (this.DEBUG) {
            this.debug("sendMgram tracking: " + tracking);
        }
        m.setGuarenteed(tracking);
        ReplicationJob job = null;
        if (createJob) {
            job = this.createJob(tracking);
        }
        if (!this.m_connMgr.sendReplicationMgram(m) && createJob) {
            this.removeJob(tracking);
            job.setStatus(2);
        }
        return job;
    }

    private IMgram buildReplicationRequest(String subject, long replyTracking, byte[] data) {
        IMgram request = MgramFactory.getMgramFactory().createMgram(true);
        request.setType((byte)34);
        request.setRequestReplySend();
        request.setSubject(new Subject(subject), 5);
        byte[] body = new byte[8 + (data == null ? 0 : data.length)];
        ArrayUtil.writeLong(body, 0, replyTracking);
        if (data != null) {
            System.arraycopy(data, 0, body, 8, data.length);
        }
        request.setBody(body);
        return request;
    }

    private IMgram buildReplicationReply(long replyTracking, byte[] data) {
        IMgram reply = MgramFactory.getMgramFactory().createMgram(true);
        reply.setType((byte)34);
        reply.setRequestReplyReply();
        reply.setGuarenteed(replyTracking);
        reply.setBody(data);
        return reply;
    }

    public ReplicationRequest sendRequest(String subject, byte[] data) throws InterruptedException {
        return this.sendRequest(subject, data, false);
    }

    public ReplicationRequest sendRequest(String subject, byte[] data, boolean nonStop) throws InterruptedException {
        if (!nonStop && !this.okToReplicate()) {
            return null;
        }
        long requestTracking = this.allocTracking();
        ReplicationJob requestJob = this.createJob(requestTracking);
        long replyTracking = this.allocTracking();
        ReplicationRequest replyJob = this.createRequest(replyTracking);
        if (this.DEBUG) {
            this.debug("sending replication request " + subject + ", request tracking = " + requestTracking + ", reply tracking = " + replyTracking);
        }
        IMgram request = this.buildReplicationRequest(subject, replyTracking, data);
        request.setGuarenteed(requestTracking);
        if (!this.m_connMgr.sendReplicationRequest(request)) {
            this.removeJob(requestTracking);
            this.removeJob(replyTracking);
            requestJob.setStatus(2);
            replyJob.setStatus(2);
            return null;
        }
        if (requestJob.join()) {
            if (this.DEBUG) {
                this.debug("request sent successfully, reply tracking = " + replyTracking);
            }
            return replyJob;
        }
        if (this.DEBUG) {
            this.debug("failed to send replication request, status = " + requestJob.m_status);
        }
        this.removeJob(replyTracking);
        replyJob.setStatus(2);
        return null;
    }

    public void sendReply(long replyTracking, byte[] data) {
        IMgram reply = this.buildReplicationReply(replyTracking, data);
        this.m_connMgr.sendReplicationReply(reply);
    }

    IRequestHandler registerRequestHandler(String subject, IRequestHandler handler) {
        IRequestHandler old = this.m_requestHandlers.get(subject);
        this.m_requestHandlers.put(subject, handler);
        return old;
    }

    IRequestHandler getRequestHandler(String subject) {
        return this.m_requestHandlers.get(subject);
    }

    Vector<Long> getPendingRequests() {
        Vector<Long> requests = new Vector<Long>();
        Enumeration<Long> keys = ((LongHashTable)this.m_jobs.clone()).keys();
        while (keys.hasMoreElements()) {
            Long key = keys.nextElement();
            if (!(this.m_jobs.get(key) instanceof ReplicationRequest)) continue;
            requests.add(key);
        }
        return requests;
    }

    public boolean replicateSaverOp(IReplicateableSaverOp op) {
        boolean ret = false;
        try {
            ret = this.replicateSaverOp(op, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ret;
    }

    public boolean replicateSaverOp(IReplicateableSaverOp op, boolean sync) throws InterruptedException {
        ReplicationJob job;
        block6: {
            job = null;
            if (this.okToReplicate(op)) {
                IMgram m = MgramFactory.getMgramFactory().buildDatabaseMgram(op);
                try {
                    if (this.DEBUG) {
                        this.debug("replicating " + op);
                    }
                    if ((job = this.sendMgram(m, sync)) == null) {
                        return true;
                    }
                    break block6;
                }
                catch (EClientNotRegistered e) {
                    if (this.DEBUG) {
                        this.debug(e.toString(), e);
                    }
                    return false;
                }
            }
            return false;
        }
        return job.join();
    }

    public boolean replicateFTRelectionOp(FTReflectionOperation op) {
        ReplicationJob job;
        block12: {
            job = null;
            if (this.okToReplicate()) {
                try {
                    IMgram m = op.createFTReflectionMgram();
                    try {
                        if (this.DEBUG) {
                            this.debug("replicating " + op);
                        }
                        job = this.sendMgram(m, true);
                        break block12;
                    }
                    catch (EClientNotRegistered e) {
                        if (this.DEBUG) {
                            this.debug(e.toString(), e);
                        }
                        return false;
                    }
                }
                catch (IOException e) {
                    if (this.DEBUG) {
                        this.debug(e.toString(), e);
                    }
                    return false;
                }
                catch (ClassNotFoundException e) {
                    if (this.DEBUG) {
                        this.debug(e.toString(), e);
                    }
                    return false;
                }
            }
            return false;
        }
        try {
            return job.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean replicateEvent(IStateEvent evt) {
        boolean ret;
        block4: {
            ret = false;
            if (this.okToReplicate(evt)) {
                IMgram m = MgramFactory.getMgramFactory().buildStateEventMgram(evt, true);
                try {
                    if (this.DEBUG) {
                        this.debug("replicating " + evt + ", seq # = " + evt.getSeqNo());
                    }
                    long tracking = evt.getActionTrackingNum();
                    m.setGuarenteed(tracking);
                    ret = this.m_connMgr.sendReplicationMgram(m);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (!this.DEBUG) break block4;
                    this.debug("failed to send an replication event to the backup broker", ex);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocTracking() {
        Object object = this.m_replTrackSyncObject;
        synchronized (object) {
            return this.m_replCount++;
        }
    }

    boolean replicateDynamicSyncData(IMgram m, boolean synchronously) {
        ReplicationJob job = null;
        if (this.okToReplicate()) {
            try {
                if (this.DEBUG) {
                    this.debug("replicating dynamic sync data synchronously: " + synchronously + " m.getGuarenteedTrackingNum: " + m.getGuarenteedTrackingNum());
                }
                job = this.sendMgram(m, synchronously);
            }
            catch (EClientNotRegistered e) {
                if (this.DEBUG) {
                    this.debug(e.toString(), e);
                }
                return false;
            }
        } else {
            return false;
        }
        try {
            if (synchronously) {
                return job.join();
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void replicateRoutes(Vector routes) {
        this.m_dynamicSyncMgr.replicateRoutes(routes);
        this.m_dynamicSyncMgr.setStatus(64);
    }

    @Override
    public boolean acknowledge(long tracking) {
        block3: {
            IMgram ack = MgramFactory.getMgramFactory().buildAck(tracking, (short)0, 0);
            try {
                if (this.DEBUG) {
                    this.debug("acknowledging replication event, tracking # = " + tracking);
                }
                this.m_connMgr.sendReplicationAck(ack);
            }
            catch (Exception ex) {
                if (!this.DEBUG) break block3;
                this.debug("failed to send an replication ack back to the active broker", ex);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUndelMsgs() {
        block8: {
            BrokerDatabase db = AgentRegistrarLazyHolder.REG_OBJ.getBrokerDatabase();
            boolean needRelease = false;
            try {
                db.beginPubSubDBTran();
                needRelease = true;
                db.delAllUndelMsgs(10000);
                db.commitPubSubTran(true);
            }
            catch (EDatabaseException e) {
                if (Broker.exiting) break block8;
                try {
                    BrokerComponent.getBrokerComponent().abort("Failed to delete all un-delivered message info prior to dynamic sync on the standby.", e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
            finally {
                if (needRelease) {
                    db.releasePubSubDBTran();
                }
            }
        }
    }

    void clearStandbyDataPreDynSync() {
        block4: {
            this.deleteClientRegistryDbData();
            this.m_txnFileReplicationMgr.deleteAllDiskResidentTxnFiles();
            this.deleteUndelMsgs();
            if (NoDupDetectDb.isEnabled() && !NoDupDetectDb.isFTShared()) {
                try {
                    NoDupDetectDb.getConnection().deleteAll();
                }
                catch (EDatabaseException e) {
                }
                catch (EGeneralException e) {
                    e.printStackTrace();
                    if (!this.DEBUG) break block4;
                    this.debug(e.toString(), e);
                }
            }
        }
        this.deleteRouteInfoDbData();
    }

    void deleteClientRegistryDbData() {
        block5: {
            try {
                if (this.DEBUG) {
                    this.debug("Deleting all clients on the standby");
                }
                AgentRegistrarLazyHolder.REG_OBJ.getBrokerDatabase().deleteClientRegistryDbData();
            }
            catch (EDatabaseException e) {
                if (Broker.exiting) break block5;
                try {
                    BrokerComponent.getBrokerComponent().abort("Failed to delete all clients pre-dynamic sync on the standby", e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
        }
    }

    void deleteRBRegistryDbData() {
        block5: {
            try {
                if (this.DEBUG) {
                    this.debug("Deleting all RemoteBrokers on the standby");
                }
                AgentRegistrarLazyHolder.REG_OBJ.getBrokerDatabase().deleteRBRegistryDbData();
            }
            catch (EDatabaseException e) {
                if (Broker.exiting) break block5;
                try {
                    BrokerComponent.getBrokerComponent().abort("Failed to delete all RemoteBrokers pre-dynamic sync on the standby", e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
        }
    }

    void deleteRouteInfoDbData() {
        block5: {
            try {
                if (this.DEBUG) {
                    this.debug("Deleting all Routes on the standby");
                }
                AgentRegistrarLazyHolder.REG_OBJ.getBrokerDatabase().deleteRouteInfoDbData();
            }
            catch (EDatabaseException e) {
                if (Broker.exiting) break block5;
                try {
                    BrokerComponent.getBrokerComponent().abort("Failed to delete all Routes pre-dynamic sync on the standby", e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
        }
    }

    void onReplicationAck(long tracking) {
        if (this.DEBUG) {
            this.debug("replication mgram acknowledged, tracking # = " + tracking);
        }
        if (this.getActionManager().onReplicationAck(tracking)) {
            return;
        }
        ReplicationJob job = this.m_jobs.remove(tracking);
        if (job != null) {
            job.setStatus(1);
        }
    }

    boolean onReplicationReply(IMgram reply) {
        long tracking = reply.getGuarenteedTrackingNum();
        if (this.DEBUG) {
            this.debug("received reply, tracking # = " + tracking);
        }
        boolean handled = false;
        ReplicationJob job = this.m_jobs.get(tracking);
        if (job instanceof ReplicationRequest) {
            this.m_jobs.remove(tracking);
            ((ReplicationRequest)job).setReplyMgram(reply);
            handled = true;
        }
        return handled;
    }

    void onReplicatedMgram(IMgram m) {
        this.getReplicationDemultiplexer().enqueueInboundQueue(m, m.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lock() {
        Object object = this.m_syncObj;
        synchronized (object) {
            Thread t = Thread.currentThread();
            if (this.m_lockHolder == t) {
                ++this.m_lockCount;
                return;
            }
            boolean interrupted = false;
            while (this.m_lockHolder != null) {
                try {
                    this.m_syncObj.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.m_lockHolder = t;
            this.m_lockCount = 1;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() throws IllegalMonitorStateException {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_lockHolder == Thread.currentThread()) {
                if (--this.m_lockCount == 0) {
                    this.m_lockHolder = null;
                    this.m_syncObj.notifyAll();
                }
            } else {
                throw new IllegalMonitorStateException("unlock() without lock().");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryLock() {
        Object object = this.m_syncObj;
        synchronized (object) {
            Thread t = Thread.currentThread();
            if (this.m_lockHolder == t) {
                ++this.m_lockCount;
                return true;
            }
            if (this.m_lockHolder != null) {
                return false;
            }
            this.m_lockHolder = t;
            this.m_lockCount = 1;
            return true;
        }
    }

    public static class ReplicationRequest
    extends ReplicationJob {
        private IMgram m_replyMgram = null;

        public IMgram getReplyMgram() {
            return this.m_replyMgram;
        }

        void setReplyMgram(IMgram reply) {
            this.m_replyMgram = reply;
            this.setStatus(1);
        }
    }

    public static class ReplicationJob {
        private int m_status = 0;
        static final int PENDING = 0;
        static final int SUCCESS = 1;
        static final int FAILED = 2;

        synchronized void setStatus(int status) {
            this.m_status = status;
            this.notifyAll();
        }

        public synchronized boolean join() throws InterruptedException {
            while (this.m_status == 0) {
                this.wait();
            }
            return this.m_status == 1;
        }
    }

    class ReplicationSession
    extends AgentAdminSession {
        ReplicationSession(Connection conn) throws EGeneralException {
            super(conn);
        }

        Publication publish(Message msg, int timeout, boolean ret) throws EGeneralException {
            Envelope env = this.buildDefaultEnvelope(msg);
            msg.setSubject(msg.getSubject().direct(AddrUtil.getSwizzleString(ReplicationManager.this.m_remoteID)));
            return this.publishInternal(env, timeout, ret, false);
        }

        Message request(Message msg, int timeout) throws EGeneralException {
            Envelope env = this.buildDefaultEnvelope(msg);
            msg.setSubject(msg.getSubject().direct(AddrUtil.getSwizzleString(ReplicationManager.this.m_remoteID)));
            return super.request(env, timeout);
        }

        Solicitation solicit(Message msg, MessageHandler mh, int timeout) throws EGeneralException {
            Envelope env = this.buildDefaultEnvelope(msg);
            msg.setSubject(msg.getSubject().direct(AddrUtil.getSwizzleString(ReplicationManager.this.m_remoteID)));
            return this.solicitInternal(env, mh, timeout);
        }
    }

    private static class BrokerStateManagerLazyHolder {
        private static BrokerStateManager STATE_MGR = BrokerStateManager.getBrokerStateManager();

        private BrokerStateManagerLazyHolder() {
        }
    }

    private static class LogManagerLazyHolder {
        private static LogManager LOG_MGR = AgentRegistrarLazyHolder.access$000().getLogManager();

        private LogManagerLazyHolder() {
        }
    }

    private static class TransactionMgrLazyHolder {
        private static TransactionMgr TXN_MGR = AgentRegistrarLazyHolder.access$000().getTransactionMgr();

        private TransactionMgrLazyHolder() {
        }
    }

    private static class AgentRegistrarLazyHolder {
        private static AgentRegistrar REG_OBJ = AgentRegistrar.getAgentRegistrar();

        private AgentRegistrarLazyHolder() {
        }
    }
}

