/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.LinkedList;
import progress.message.broker.Broker;
import progress.message.ft.DynamicSyncManager;
import progress.message.ft.UserIDMappingSyncOp;
import progress.message.zclient.DebugThread;

public class UserIDMappingDynSyncer
extends DebugThread {
    private DynamicSyncManager m_dsm;
    private int m_role = -1;
    private LinkedList m_todoList = null;

    public UserIDMappingDynSyncer(DynamicSyncManager dsm, int role) {
        super("UserIDMappingDynSyncer");
        this.m_dsm = dsm;
        this.m_role = role;
        if (this.m_role == 2) {
            this.m_todoList = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkItem(UserIDMappingSyncOp uIdSyncOp) {
        LinkedList linkedList = this.m_todoList;
        synchronized (linkedList) {
            this.m_todoList.add(uIdSyncOp);
            this.m_todoList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() {
        try {
            if (this.DEBUG) {
                this.debug("UserIDMappingDynSyncer running... m_role: " + this.m_role);
            }
            if (this.m_role == 1) {
                if (this.DEBUG) {
                    this.debug("get and send clientcontext registry info to be replicated on the standby");
                }
                this.doActiveSync();
            } else if (this.m_role == 2) {
                if (this.DEBUG) {
                    this.debug("receive and process database info replicated from active");
                }
                this.doStandbySync();
            }
            if (this.DEBUG) {
                this.debug("UserIDMappingDynSyncer exiting...");
            }
            this.m_dsm.setStatus(32);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.DEBUG) {
                this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
            }
        }
    }

    private void doActiveSync() {
        this.m_dsm.replicateAllInMemoryClientContexts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStandbySync() throws InterruptedException {
        while (!this.isShuttingDown()) {
            UserIDMappingSyncOp uIdOp = null;
            LinkedList linkedList = this.m_todoList;
            synchronized (linkedList) {
                while (this.m_todoList.isEmpty()) {
                    this.m_todoList.wait();
                }
                uIdOp = (UserIDMappingSyncOp)this.m_todoList.removeFirst();
            }
            uIdOp.execute();
            this.m_dsm.acknowledge(uIdOp.getGuarTrackingNum());
            if (!uIdOp.isLastChunk()) continue;
            if (!this.DEBUG) break;
            this.debug("Received last replication chunk UserIdMappingSyncOp");
            break;
        }
    }
}

