/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EGeneralException;
import progress.message.crypto.DES;
import progress.message.crypto.SHA;
import progress.message.gr.EAlreadyConnecting;
import progress.message.gr.RemoteBroker;
import progress.message.gr.RouterManager;
import progress.message.gr.prAccessor;
import progress.message.util.DebugState;
import progress.message.util.Hex;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.SecurityConfig;
import progress.message.zclient.Session;

class ConvertToRouter
extends DebugObject
implements IMessageHandler {
    public static final byte BEGIN = 1;
    public static final byte DONE = 2;
    public static final byte CHALLENGE = 3;
    static final int PADDED_HASH_LENGTH = 20 + DES.computePad(20);
    private RouterManager m_rtmgr = null;
    private AgentRegistrar m_reg = null;
    private static volatile ConvertToRouter s_instance = null;
    public static final String GR_CONVERT_SUBJECT = "$SYS.GR.CONVERT";

    ConvertToRouter(AgentRegistrar reg, RouterManager rtmgr) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ConvertToRouter" : null);
        this.m_rtmgr = rtmgr;
        this.m_reg = reg;
        s_instance = this;
    }

    public static ConvertToRouter getInstance() {
        return s_instance;
    }

    public String getFtPeerReverseUrl(String node) {
        String backupReverseUrl = null;
        if (Config.REPLICATED) {
            String acceptorConfigID;
            Broker broker = Broker.getBroker();
            AcceptorHolder backupAccHolder = broker.getFTPeerAcceptorHolder();
            if (backupAccHolder == null) {
                return null;
            }
            RoutingConnectionInfo routeInfo = this.m_reg.getRoutingConfig().getRoutingConnection(node);
            if (routeInfo != null && (acceptorConfigID = routeInfo.getRoutingAcceptor()) != null && acceptorConfigID.trim().length() > 0) {
                if (this.DEBUG) {
                    this.debug("getFtPeerReverseUrl: checking RoutingConnectionInfo for Routing Acceptor property: " + acceptorConfigID);
                }
                Acceptor acceptor = null;
                Enumeration entries = backupAccHolder.getAcceptors();
                block0: while (acceptor == null && entries.hasMoreElements()) {
                    Hashtable next = (Hashtable)entries.nextElement();
                    Enumeration acceptors = next.elements();
                    while (acceptors.hasMoreElements()) {
                        String acceptorname;
                        Acceptor nextacceptor = (Acceptor)acceptors.nextElement();
                        if (this.DEBUG) {
                            this.debug("getFtPeerReverseUrl: checking acceptor " + nextacceptor.getAcceptorName() + " external url = " + nextacceptor.getExternalURL() + " internal url = " + nextacceptor.getURL());
                        }
                        if (!(acceptorname = nextacceptor.getAcceptorName()).equals(acceptorConfigID)) continue;
                        acceptor = nextacceptor;
                        continue block0;
                    }
                }
                if (acceptor != null) {
                    String externalUrl = acceptor.getExternalURL();
                    if (externalUrl != null && externalUrl.trim().length() > 0) {
                        backupReverseUrl = externalUrl;
                        if (this.DEBUG) {
                            this.debug("getFtPeerReverseUrl: Using acceptor " + acceptorConfigID + "'s " + " external URL " + backupReverseUrl);
                        }
                    } else {
                        String internalUrl = acceptor.getURL();
                        if (internalUrl != null && internalUrl.trim().length() > 0) {
                            backupReverseUrl = internalUrl;
                            if (this.DEBUG) {
                                this.debug("getFtPeerReverseUrl: Using acceptor " + acceptorConfigID + "'s " + " default URL " + backupReverseUrl);
                            }
                        }
                    }
                }
            }
            if (backupReverseUrl == null) {
                backupReverseUrl = backupAccHolder.getPrimaryAcceptor().getExternalURL();
                if (this.DEBUG) {
                    this.debug("getFtPeerReverseUrl: FT peer primary acceptor external URL " + backupReverseUrl);
                }
            }
            if (backupReverseUrl == null) {
                backupReverseUrl = backupAccHolder.getDefaultRoutingURL();
                if (this.DEBUG) {
                    this.debug("getFtPeerReverseUrl: FT peer DRU " + backupReverseUrl);
                }
            }
            if (backupReverseUrl == null) {
                backupReverseUrl = backupAccHolder.getPrimaryAcceptor().getURL();
                if (this.DEBUG) {
                    this.debug("getFtPeerReverseUrl: FT peer primary acceptor URL " + backupReverseUrl);
                }
            }
        }
        return backupReverseUrl;
    }

    @Override
    public void handleMessage(Session session, Envelope envelope) {
        block42: {
            Message req = envelope.getMessage();
            Message reply = null;
            try {
                byte i = req.readByte();
                switch (i) {
                    case 1: {
                        RemoteBroker remote;
                        if (!envelope.isRequest()) break;
                        String node = req.readUTF();
                        String broker = req.readUTF();
                        String backUrl = req.readUTF();
                        String targetNodeName = req.readUTF();
                        String myCN = req.readUTF();
                        if (this.DEBUG) {
                            this.debug("BEGIN request - NODE:" + node + ", BROKER:" + broker + ", URL:" + backUrl + ", MY_CN: " + myCN);
                        }
                        if (!targetNodeName.equals(Config.ROUTING_NODE_NAME)) {
                            reply = new Message();
                            reply.writeBoolean(false);
                            reply.writeInt(-6);
                            session.reply(reply, envelope);
                            return;
                        }
                        long rcid = 0L;
                        try {
                            rcid = AddrUtil.getIdFromDirectedSubject(envelope.getReplySubject());
                        }
                        catch (Exception e) {
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                            return;
                        }
                        String user = null;
                        try {
                            ClientSecurityContext secctx = this.m_reg.getClient(rcid).getConnection().getSecurityContextFromId(rcid);
                            user = secctx.getUid();
                            if (Config.ENABLE_SECURITY && !this.m_rtmgr.checkNodePermission(user, node)) {
                                reply = new Message();
                                reply.writeBoolean(false);
                                reply.writeInt(-6);
                                session.reply(reply, envelope);
                                return;
                            }
                            if (!Config.ENABLE_SECURITY && !Config.ENABLE_ROUTING) {
                                String warning = MessageFormat.format(prAccessor.getString("DRA_NOT_SUPPORTED2"), Config.PRODUCT_NAME, node, broker);
                                BrokerComponent.getComponentContext().logMessage(warning, 2);
                                reply = new Message();
                                reply.writeBoolean(false);
                                reply.writeInt(-6);
                                session.reply(reply, envelope);
                                return;
                            }
                        }
                        catch (EClientNotRegistered e) {
                            return;
                        }
                        IClientContext cc = null;
                        try {
                            cc = this.m_reg.getClient(rcid);
                        }
                        catch (EClientNotRegistered ex) {
                            return;
                        }
                        AgentConnection con = cc.getConnection();
                        if (con == null) {
                            return;
                        }
                        con.setRemoteBroker(rcid);
                        try {
                            this.m_rtmgr.addConnectingBroker(rcid);
                        }
                        catch (EAlreadyConnecting ace) {
                            con.close();
                            return;
                        }
                        String remoteFtPeerUrl = null;
                        if (cc.getClientSessionVer() >= 27) {
                            if (req.readBoolean()) {
                                remoteFtPeerUrl = req.readUTF();
                            }
                            if (this.DEBUG) {
                                this.debug(node + "::" + broker + " has FT peer URL " + remoteFtPeerUrl);
                            }
                        }
                        if ((remote = (RemoteBroker)this.m_rtmgr.getRemoteBroker(rcid)) == null) {
                            remote = this.m_rtmgr.register(rcid, backUrl, remoteFtPeerUrl, node, broker, this.m_rtmgr.getUserIDForNode(node), this.m_rtmgr.getPasswordForNode(node));
                        }
                        if (this.DEBUG) {
                            this.debug("Preparing " + remote + " to respond to ack exchange");
                        }
                        long token = remote.brokerAckExchange(myCN);
                        if (this.DEBUG) {
                            this.debug(remote.toString() + " ready for ack exchange");
                        }
                        reply = new Message();
                        reply.writeBoolean(true);
                        reply.writeUTF(Config.ROUTING_NODE_NAME);
                        reply.writeUTF(Config.BROKER_NAME);
                        reply.writeUTF(this.m_rtmgr.getUserIDForNode(node, myCN));
                        reply.writeLong(token);
                        if (this.DEBUG) {
                            this.debug(Config.ROUTING_NODE_NAME + " " + Config.BROKER_NAME + " " + user);
                        }
                        if (cc.getClientSessionVer() >= 27) {
                            String peerURL = this.getFtPeerReverseUrl(node);
                            if (this.DEBUG) {
                                this.debug(remote.toString() + " setting FT Peer ReverseURL as " + peerURL);
                            }
                            if (peerURL != null) {
                                reply.writeBoolean(true);
                                reply.writeUTF(peerURL);
                            } else {
                                reply.writeBoolean(false);
                            }
                        }
                        session.reply(reply, envelope);
                        break;
                    }
                    case 2: {
                        throw new RuntimeException();
                    }
                    case 3: {
                        if (this.DEBUG) {
                            this.debug("preparing RESPONSE to CHALLENGE from the remote");
                        }
                        Message msg = new Message();
                        try {
                            byte[] resp;
                            long rcid = 0L;
                            rcid = AddrUtil.getIdFromDirectedSubject(envelope.getReplySubject());
                            RemoteBroker remote = (RemoteBroker)this.m_rtmgr.getRemoteBroker(rcid);
                            if (remote == null) {
                                throw new Exception();
                            }
                            long token = req.readLong();
                            if (token != remote.getToken()) {
                                if (this.DEBUG) {
                                    this.debug("Challenge: token mismatch; token in msg= " + token + "remoteBroker token= " + remote.getToken());
                                }
                                throw new Exception();
                            }
                            byte[] cipher = new byte[req.readInt()];
                            int len = req.read(cipher);
                            if (this.DEBUG) {
                                this.debug("the length of encrypted challenge = " + len);
                            }
                            if ((resp = this.prepareResponse(cipher, this.m_rtmgr.getPasswordForNode(remote.getNodeName()))) != null && resp.length != 0) {
                                msg.writeBoolean(true);
                                msg.writeInt(resp.length);
                                msg.write(resp);
                            } else {
                                msg.writeBoolean(false);
                            }
                        }
                        catch (Exception ex) {
                            msg.writeBoolean(false);
                        }
                        session.reply(msg, envelope);
                        if (!this.DEBUG) break;
                        this.debug("Responded to the challenge");
                        break;
                    }
                }
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block42;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    private byte[] prepareResponse(byte[] challenge, String pwd) {
        if (this.DEBUG) {
            this.debug("encrypting the response using password: " + pwd);
        }
        byte[] passiveNonce = new byte[16];
        byte[] pwdKey = new byte[8];
        System.arraycopy(new ProgressPasswordUser("", pwd).getTestPattern(), 6, pwdKey, 0, 8);
        try {
            DES des = new DES();
            des.init(2, pwdKey);
            des.doFinal(challenge, 0, 16, passiveNonce, 0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (this.DEBUG) {
            this.debug("decrypted nonce is " + Hex.toString(passiveNonce));
        }
        byte[] response = new byte[PADDED_HASH_LENGTH];
        SHA sha = new SHA();
        sha.add(passiveNonce);
        sha.add(SecurityConfig.KNOWN_SECRET);
        byte[] hash = sha.digest();
        System.arraycopy(hash, 0, response, 0, hash.length);
        if (this.DEBUG) {
            this.debug("SHA hash of the response is " + Hex.toString(response));
        }
        byte[] payload = new byte[response.length];
        DES des = new DES();
        des.init(1, pwdKey);
        des.doFinal(response, 0, response.length, payload, 0);
        if (this.DEBUG) {
            this.debug("done preparing the reponse, length = " + payload.length);
        }
        return payload;
    }
}

