/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import java.util.ArrayList;
import java.util.LinkedList;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.gr.IDRATask;
import progress.message.gr.ITaskCompletionListener;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;

public class DRAThreadPool
extends DebugObject {
    private int m_configMaxPoolSize = Config.ROUTING_THREADS;
    private int m_initialPoolSize = Math.min(this.m_initialPoolSize, this.m_configMaxPoolSize);
    private int m_currentPoolSize;
    private long m_numPoolWaits;
    private long m_numTasks;
    private long m_maxWaitingTasks;
    private int m_workerId;
    private ArrayList m_busyThreads;
    private ArrayList m_availableThreads;
    private boolean m_started;
    private LinkedList m_workQueue = new LinkedList();
    private ITaskCompletionListener m_taskCompletionListener;
    private boolean DEBUG1;
    private int m_mod = 100;

    public DRAThreadPool() {
        super("DRAThreadPool");
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.DEBUG1) {
            this.debug("constructed; m_configMaxPoolSize= " + this.m_configMaxPoolSize);
        }
    }

    synchronized void start() {
        if (this.m_started) {
            return;
        }
        this.m_busyThreads = new ArrayList();
        this.m_availableThreads = new ArrayList();
        if (this.m_workQueue.isEmpty()) {
            for (int i = 0; i < this.m_initialPoolSize; ++i) {
                this.createNewWorkerThread();
            }
            if (this.DEBUG1) {
                this.debug("Starting worker threads; initialPoolSize= " + this.m_initialPoolSize);
            }
        } else {
            int workQSize = this.m_workQueue.size();
            this.increaseThreadPool();
            if (this.DEBUG1) {
                this.debug("Starting worker threads; workQSize= " + workQSize + " initialPoolSize= " + this.m_currentPoolSize);
            }
        }
        this.m_started = true;
    }

    public void setTaskCompletionListener(ITaskCompletionListener obj) {
        this.m_taskCompletionListener = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopThreads() {
        if (this.DEBUG1) {
            this.debug("Stopping All Worker Threads; Broker.exiting= " + Broker.exiting);
        }
        DRAThreadPool dRAThreadPool = this;
        synchronized (dRAThreadPool) {
            this.notifyAll();
        }
        ArrayList availableThreads = null;
        ArrayList busyThreads = null;
        DRAThreadPool dRAThreadPool2 = this;
        synchronized (dRAThreadPool2) {
            availableThreads = (ArrayList)this.m_availableThreads.clone();
            busyThreads = (ArrayList)this.m_busyThreads.clone();
        }
        if (this.DEBUG1) {
            this.debug("Stopping busy threads " + busyThreads.size());
        }
        for (DRAWorkerThread worker : busyThreads) {
            if (worker == null || !worker.isAlive()) continue;
            if (this.DEBUG1) {
                this.debug("Shutting down (busy): " + worker);
            }
            worker.shutdown();
        }
        if (this.DEBUG1) {
            this.debug("Stopping available threads " + availableThreads.size());
        }
        for (DRAWorkerThread worker : availableThreads) {
            if (worker == null || !worker.isAlive()) continue;
            if (this.DEBUG1) {
                this.debug("Shutting down (available): " + worker);
            }
            worker.shutdown();
        }
        if (this.DEBUG1) {
            this.debug("Waiting for available threads to exit ");
        }
        for (DRAWorkerThread worker : availableThreads) {
            if (worker == null || !worker.isAlive()) continue;
            try {
                worker.join();
            }
            catch (InterruptedException ex) {}
        }
        if (this.DEBUG1) {
            this.debug("Waiting for busy threads to exit ");
        }
        for (DRAWorkerThread worker : busyThreads) {
            if (worker == null || !worker.isAlive()) continue;
            try {
                worker.join();
            }
            catch (InterruptedException ex) {}
        }
        if (this.DEBUG1) {
            this.debug("All Threads exited");
        }
        this.m_started = false;
    }

    synchronized void setConfigMaxPoolSize(int size) {
        if (size == this.m_configMaxPoolSize) {
            return;
        }
        if (size < 0) {
            throw new EAssertFailure("setConfigMaxPoolSize: pool size < 0 " + size);
        }
        int oldMaxSize = this.m_configMaxPoolSize;
        this.m_configMaxPoolSize = size;
        if (this.DEBUG1) {
            this.debug(" setConfigMaxPoolSize: oldMaxSize= " + oldMaxSize + " newMaxSize= " + this.m_configMaxPoolSize + " currentSize= " + this.m_currentPoolSize + " numBusy= " + this.m_busyThreads.size() + " numAvailable= " + this.m_availableThreads.size() + " taskQueueSize= " + this.m_workQueue.size());
        }
        if (this.m_configMaxPoolSize > oldMaxSize) {
            this.increaseThreadPool();
        } else {
            this.decreaseThreadPool();
        }
    }

    synchronized void addDRATask(IDRATask task) {
        this.m_workQueue.add(task);
        ++this.m_numTasks;
        if (!this.m_started) {
            return;
        }
        if (this.m_availableThreads.size() >= this.m_workQueue.size()) {
            this.notifyAll();
        } else {
            boolean increasedPool = false;
            if (this.m_availableThreads.size() < this.m_workQueue.size()) {
                increasedPool = this.increaseThreadPool();
            }
            if (!increasedPool) {
                ++this.m_numPoolWaits;
                if (this.DEBUG1 && this.m_numPoolWaits % (long)this.m_mod == 0L) {
                    this.debug("addDRATask: task wait stats: totTasks= " + this.m_numTasks + " numPoolWaits " + this.m_numPoolWaits + " taskQueueSize= " + this.m_workQueue.size() + " poolSize " + this.m_currentPoolSize);
                }
            }
        }
        if (this.DEBUG) {
            this.debug("addDRATask: added " + task + " ident= " + task.getTargetObjectIdent() + " taskQueueSize= " + this.m_workQueue.size() + " availableThreads= " + this.m_availableThreads.size());
        }
        if ((long)this.m_workQueue.size() > this.m_maxWaitingTasks) {
            this.m_maxWaitingTasks = this.m_workQueue.size();
            if (this.DEBUG1) {
                this.debug("MaxWorkQueueSize= " + this.m_maxWaitingTasks);
            }
        }
    }

    synchronized void workerThreadExiting(DRAWorkerThread worker) {
        boolean removed = false;
        if (this.m_availableThreads.contains(worker)) {
            this.m_availableThreads.remove(worker);
            removed = true;
        }
        if (this.m_busyThreads.contains(worker)) {
            this.m_busyThreads.remove(worker);
            removed = true;
        }
        if (removed) {
            --this.m_currentPoolSize;
            if (this.DEBUG1) {
                this.debug("workerThreadExiting: " + worker + " m_currentPoolSize= " + this.m_currentPoolSize);
            }
        }
    }

    synchronized IDRATask getNextDRATask() throws InterruptedException {
        IDRATask task = null;
        DRAWorkerThread worker = (DRAWorkerThread)Thread.currentThread();
        while (!Broker.exiting && this.m_workQueue.size() == 0 && this.m_currentPoolSize <= this.m_configMaxPoolSize) {
            this.setWorkerAvailable(worker);
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                this.workerThreadExiting(worker);
                this.notifyAll();
                throw ex;
            }
        }
        if (Broker.exiting || this.m_currentPoolSize > this.m_configMaxPoolSize) {
            this.workerThreadExiting(worker);
            if (this.DEBUG1) {
                this.debug("getNextDRATask: threadExiting; " + worker + " numBusy= " + this.m_busyThreads.size() + " numAvailable= " + this.m_availableThreads.size());
            }
            this.notifyAll();
            return null;
        }
        task = (IDRATask)this.m_workQueue.removeFirst();
        this.setWorkerBusy(worker);
        return task;
    }

    void taskCompleted(IDRATask task) {
        if (this.m_taskCompletionListener != null) {
            this.m_taskCompletionListener.taskCompleted(task);
        }
    }

    private void createNewWorkerThread() {
        DRAWorkerThread newWorker = new DRAWorkerThread(++this.m_workerId);
        ++this.m_currentPoolSize;
        newWorker.setDaemon(true);
        this.m_availableThreads.add(newWorker);
        newWorker.start();
    }

    private boolean increaseThreadPool() {
        boolean increased = false;
        while (this.m_workQueue.size() > 0 && this.m_availableThreads.size() < this.m_workQueue.size() && this.m_currentPoolSize < this.m_configMaxPoolSize) {
            this.createNewWorkerThread();
            increased = true;
        }
        return increased;
    }

    private synchronized void decreaseThreadPool() {
        if (this.m_configMaxPoolSize < this.m_currentPoolSize) {
            int decrement = this.m_currentPoolSize - this.m_configMaxPoolSize;
            decrement = Math.min(decrement, this.m_availableThreads.size());
            for (int i = 0; i < decrement; ++i) {
                this.notifyAll();
            }
        }
    }

    private void setWorkerBusy(DRAWorkerThread worker) {
        if (this.m_availableThreads.contains(worker)) {
            this.m_availableThreads.remove(worker);
            this.m_busyThreads.add(worker);
        }
    }

    private void setWorkerAvailable(DRAWorkerThread worker) {
        if (this.m_busyThreads.contains(worker)) {
            this.m_busyThreads.remove(worker);
            this.m_availableThreads.add(worker);
        }
    }

    class DRAWorkerThread
    extends DebugThread {
        private int m_id;
        private boolean DEBUG1;

        DRAWorkerThread(int id) {
            super("DRAWorkerThread " + id);
            this.m_id = id;
            this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            long tasks = 0L;
            if (this.DEBUG1) {
                this.debug("Starting");
            }
            try {
                while (!Broker.exiting && !this.isInterrupted()) {
                    IDRATask task = DRAThreadPool.this.getNextDRATask();
                    if (task == null) {
                        break;
                    }
                    try {
                        if (this.DEBUG) {
                            this.debug("About to execute " + task.toString());
                        }
                        task.execute();
                        ++tasks;
                        if (this.DEBUG) {
                            this.debug("Completed " + task.toString() + "; totTasks= " + tasks);
                        }
                        if (!this.DEBUG1 || tasks % (long)DRAThreadPool.this.m_mod != 0L) continue;
                        this.debug("totTasks= " + tasks);
                    }
                    finally {
                        DRAThreadPool.this.taskCompleted(task);
                    }
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            finally {
                DRAThreadPool.this.workerThreadExiting(this);
                if (this.DEBUG1) {
                    this.debug("Exiting, broker exiting = " + Broker.exiting + "; numTasksCompleted= " + tasks);
                }
            }
        }
    }
}

