/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.GuarAckDoneEvt;
import progress.message.broker.GuarAckXchgEvt;
import progress.message.broker.GuarQAckDoneEvt;
import progress.message.broker.GuarQAckXchgEvt;
import progress.message.broker.IClientContext;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.IRoutingConfigListener;
import progress.message.broker.InDoubtQMsgReenqueueEvt;
import progress.message.broker.LogEvent;
import progress.message.broker.LogManager;
import progress.message.broker.PublishLimiterNotify;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EBrokerRedirected;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.gr.GRFlowControlTracker;
import progress.message.gr.GuarAckExchanger;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.gr.RouterConnect;
import progress.message.gr.RouterManager;
import progress.message.gr.TokenGen;
import progress.message.gr.prAccessor;
import progress.message.msg.IMgram;
import progress.message.net.http.client.tunnel.HttpProxyConfig;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.util.LongHashTable;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Label;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.xonce.IMsgTracker;

public class RemoteBroker
extends DebugObject
implements IRemoteBroker,
IRoutingConfigListener {
    private String m_userid = null;
    private String m_password = null;
    private String m_appid = null;
    private long m_cid;
    private String m_node = null;
    private String m_directUrl = null;
    private String m_standbyUrl = null;
    private String m_brokerName = null;
    RoutingConnectionInfo m_connectInfo = null;
    private RouterManager m_rtmgr = null;
    private LogManager m_logMgr = null;
    private IClientContext m_cc = null;
    private boolean m_registered = false;
    private boolean m_connected = false;
    private boolean m_connecting = false;
    private int m_disconnectReason = -1;
    private Object m_flagMutex = new Object();
    private long m_inDoubtTime;
    private LongHashTable m_guarQAcks = new LongHashTable();
    private LongHashTable m_rcvdXOnceQTrackNums = new LongHashTable();
    private IndexedList m_inDoubtQTrackNums = new IndexedList();
    private Object m_tableSyncObj = new Object();
    private GuarAckExchanger m_guarAckXchanger;
    private int m_routingConfigIndex = -1;
    private static Label s_label = new Label();
    private long m_convertToken;
    private boolean m_passiveGAXIsRunning;
    private boolean m_routeDeleted = false;
    private boolean DEBUG1;

    boolean isRouteDeleted() {
        return this.m_routeDeleted;
    }

    RemoteBroker(RouterManager rtmgr, RoutingConnectionInfo connectInfo) {
        this.debugNameHelper("RemoteBroker @" + Integer.toHexString(this.hashCodeHelper()) + " [" + connectInfo.getRoutingNodeName() + "]" + " (" + connectInfo.getUserName() + ")");
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.m_connectInfo = connectInfo;
        this.m_node = this.m_connectInfo.getRoutingNodeName();
        this.m_rtmgr = rtmgr;
        this.m_logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        this.m_registered = false;
        if (this.DEBUG) {
            this.debug("Constructing unbound: " + connectInfo);
        }
    }

    private void debugNameHelper(String string) {
        this.debugName(string);
    }

    private int hashCodeHelper() {
        return this.hashCode();
    }

    RemoteBroker(RouterManager rtmgr, long cid, String node, String broker, String url, String standbyUrl, String user, String password) {
        this.debugName("RemoteBroker @" + Integer.toHexString(this.hashCodeHelper()) + " [" + node + "]" + broker + " CID:" + cid);
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.m_node = node;
        this.m_directUrl = url;
        this.m_standbyUrl = standbyUrl;
        this.m_rtmgr = rtmgr;
        this.m_logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        this.m_cid = cid;
        this.m_brokerName = broker;
        this.m_userid = user;
        this.m_password = password;
        this.m_appid = RouterManager.getRouterAppID(node, broker);
        this.m_registered = true;
        this.m_inDoubtTime = 0L;
        if (this.DEBUG) {
            this.debug("Constructing bound: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteBroker connect(AgentRegistrar reg) throws EGeneralException {
        RemoteBroker registered = null;
        Connection connect = null;
        String userid = null;
        String password = null;
        String[] urls = null;
        RemoteBrokerHelper.ConnectThreadMonitor monitorThread = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper().getConnectThreadMonitor();
        if (this.DEBUG) {
            this.debug("Request for connect() with registered=" + this.m_registered + ", connected=" + this.m_connected + ", connecting=" + this.m_connecting);
        }
        AgentRegistrar.getAgentRegistrar().getRoutingConfig().removeRoutingConfigListener(this);
        Object object = this.m_flagMutex;
        synchronized (object) {
            if (this.m_registered) {
                throw new EAssertFailure("Already registered, unexpected connect()");
            }
            this.m_connected = false;
            this.m_connecting = true;
        }
        RoutingConnectionInfo currentRCI = AgentRegistrar.getAgentRegistrar().getRoutingConfig().getRoutingConnection(this.m_node);
        if (currentRCI != null) {
            if (this.m_connectInfo != null && this.m_connectInfo.isAdvertised() && !currentRCI.isStaticRouting()) {
                this.m_rtmgr.getRouteForwarder().overrideAdvertisedConnectionInfo(this.m_connectInfo, currentRCI);
            } else {
                this.m_connectInfo = currentRCI;
            }
        }
        try {
            Object brokerWideProxyHost;
            userid = this.m_connectInfo.getUserName();
            password = this.m_connectInfo.getPassword();
            urls = this.m_connectInfo.getArrayOfURLs();
            connect = new RouterConnect(reg, this.m_rtmgr, this, userid, password);
            IHttpProxyConfig pConfig = this.m_connectInfo.getProxyConfig();
            if (pConfig == null || pConfig.getHost() == null || pConfig.getHost().trim().length() == 0) {
                pConfig = null;
                brokerWideProxyHost = Config.PROXY_HOST;
                if (brokerWideProxyHost == null || ((String)brokerWideProxyHost).trim().length() == 0) {
                    pConfig = null;
                } else {
                    String brokerWideProxyProtocol = Config.PROXY_PROTOCOL;
                    pConfig = new HttpProxyConfig(brokerWideProxyProtocol, (String)brokerWideProxyHost, Integer.parseInt(Config.PROXY_PORT), Config.PROXY_USER_NAME, Config.PROXY_PASSWORD);
                }
            }
            connect.connect(urls, this.m_connectInfo.isLoadBalance(), false, null, null, pConfig);
            if (monitorThread != null) {
                monitorThread.setOkToInterrupt(true);
            }
            registered = ((RouterConnect)connect).convert(60);
            brokerWideProxyHost = this.m_flagMutex;
            synchronized (brokerWideProxyHost) {
                this.m_connecting = false;
            }
            brokerWideProxyHost = registered;
            return brokerWideProxyHost;
        }
        catch (EBrokerRedirected e) {
            if (connect != null) {
                connect.cleanUp();
            }
            try {
                connect = new RouterConnect(reg, this.m_rtmgr, this, userid, password);
                connect.connect(e.getNewBrokerURL(), false);
                if (monitorThread != null) {
                    monitorThread.setOkToInterrupt(true);
                }
                registered = ((RouterConnect)connect).convert(60);
            }
            catch (EGeneralException ege) {
                this.m_connecting = false;
                if (connect != null) {
                    connect.cleanUp();
                }
                if (this.DEBUG) {
                    this.debug("RemoteBroker.connect: redirected connect to " + this + " failed; url= " + e.getNewBrokerURL() + " " + ege.toString());
                }
                throw ege;
            }
            catch (Exception ex) {
                this.m_connecting = false;
                if (connect != null) {
                    connect.cleanUp();
                }
                BrokerComponent.getComponentContext().logMessage("RemoteBroker.connect: redirected connect to " + this + " failed; url= " + e.getNewBrokerURL(), (Throwable)ex, 2);
            }
            Object object2 = this.m_flagMutex;
            synchronized (object2) {
                this.m_connecting = false;
            }
            object2 = registered;
            return object2;
        }
        catch (EGeneralException e) {
            this.m_connecting = false;
            if (connect != null) {
                connect.cleanUp();
            }
            if (this.DEBUG) {
                this.debug("RemoteBroker.connect: connect to " + this + " failed;" + e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            this.m_connecting = false;
            if (connect != null) {
                connect.cleanUp();
            }
            BrokerComponent.getComponentContext().logMessage("RemoteBroker.connect: connect to " + this + " failed;", (Throwable)e, 2);
        }
        finally {
            if (monitorThread != null) {
                monitorThread.setOkToInterrupt(false);
                Thread.interrupted();
            }
        }
        return registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterConnect reconnect(AgentRegistrar reg, RouterManager rtmgr, RemoteBroker rb, String user, String password, String directUrl, String ftPeerUrl) throws ENetworkFailure, EGeneralException {
        Connection connect;
        block13: {
            connect = null;
            boolean connected = false;
            try {
                connect = new RouterConnect(reg, rtmgr, rb, user, password);
                connect.connect(directUrl, false);
                if (this.DEBUG) {
                    this.debug("Created client connection to " + directUrl);
                }
                connected = true;
            }
            catch (ENetworkFailure e) {
                if (this.DEBUG) {
                    this.debug("Connection to " + directUrl + " failed: " + e.getMessage());
                }
                if (ftPeerUrl != null) {
                    connect.cleanUp();
                    connect = null;
                    try {
                        connect = new RouterConnect(reg, rtmgr, rb, user, password);
                        connect.connect(ftPeerUrl, false);
                        if (this.DEBUG) {
                            this.debug("Created client connection to " + ftPeerUrl);
                        }
                        connected = true;
                        break block13;
                    }
                    catch (ENetworkFailure ee) {
                        String newMessage = MessageFormat.format(prAccessor.getString("NETWORK_FAILURE_FT_PAIR"), e.getMessage(), ee.getMessage());
                        if (this.DEBUG) {
                            this.debug("Connection to " + ftPeerUrl + " failed: " + ee.getMessage());
                        }
                        throw new ENetworkFailure(ee.getErrorId(), newMessage);
                    }
                }
                throw e;
            }
            finally {
                if (connect != null && !connected) {
                    connect.cleanUp();
                }
            }
        }
        return connect;
    }

    public RemoteBroker reconnect(AgentRegistrar reg) throws EGeneralException {
        return this.reconnect(reg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteBroker reconnect(AgentRegistrar reg, boolean useFtPeer) throws EGeneralException {
        RemoteBroker registered;
        if (this.CALLBACK) {
            this.callback("Invoking CALLBACK upon re-connecting to node " + this.getNodeName(), 9, null);
        }
        RemoteBroker remoteBroker = this;
        synchronized (remoteBroker) {
            if (this.DEBUG) {
                this.debug("Request for reconnect() with registered=" + this.m_registered + ", connected=" + this.m_connected + ", connecting=" + this.m_connecting);
            }
            RemoteBrokerHelper.ConnectThreadMonitor monitorThread = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper().getConnectThreadMonitor();
            AgentRegistrar.getAgentRegistrar().getRoutingConfig().removeRoutingConfigListener(this);
            if (!this.m_registered) {
                throw new EAssertFailure("Not yet registered, cannot reconnect()");
            }
            Object object = this.m_flagMutex;
            synchronized (object) {
                if (this.m_connected) {
                    return this;
                }
                this.m_connected = false;
                this.m_connecting = true;
            }
            Connection connect = null;
            registered = null;
            try {
                if (this.DEBUG) {
                    this.debug("RemoteBroker.reconnect connecting to " + this.getNodeName() + "::" + this.getBrokerName() + " connect url = " + this.m_directUrl + " info =  " + this.getConnectInfo());
                }
                connect = this.reconnect(reg, this.m_rtmgr, this, this.m_userid, this.m_password, this.m_directUrl, useFtPeer ? this.m_standbyUrl : null);
                if (monitorThread != null) {
                    monitorThread.setOkToInterrupt(true);
                }
                registered = ((RouterConnect)connect).convert(60);
            }
            catch (EGeneralException e) {
                Object object2 = this.m_flagMutex;
                synchronized (object2) {
                    this.m_connecting = false;
                }
                if (connect != null) {
                    connect.cleanUp();
                }
                if (this.DEBUG) {
                    this.debug("RemoteBroker.reconnect failed; rb= " + this.toString() + "; " + e.toString());
                }
                throw e;
            }
            catch (Exception e) {
                Object object3 = this.m_flagMutex;
                synchronized (object3) {
                    this.m_connecting = false;
                }
                if (connect != null) {
                    connect.cleanUp();
                }
                BrokerComponent.getComponentContext().logMessage("RemoteBroker.reconnect failed; rb= " + this.toString(), (Throwable)e, 2);
            }
            finally {
                if (monitorThread != null) {
                    monitorThread.setOkToInterrupt(false);
                    Thread.interrupted();
                }
            }
            Object object4 = this.m_flagMutex;
            synchronized (object4) {
                this.m_connecting = false;
            }
        }
        String node = null;
        String broker = null;
        if (registered == null) {
            throw new NullPointerException("'registered' is null at " + RemoteBroker.class + ".reconnect( AgentRegistrar reg, boolean useFtPeer )");
        }
        node = registered.getNodeName();
        broker = registered.getBrokerName();
        if (registered.getConnectURL() != null) {
            broker = broker + " (" + registered.getConnectURL() + ")";
        }
        Object[] obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node == null ? "<unknown node>" : node, broker == null ? "<unknown broker>" : broker};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_SUCCESS"), obj), 3);
        return registered;
    }

    void update(String url, String userid, String password) {
        this.m_directUrl = url;
        this.m_userid = userid;
        this.m_password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(int reason) {
        AgentRegistrar.getAgentRegistrar().getRoutingConfig().removeRoutingConfigListener(this);
        Object object = this.m_flagMutex;
        synchronized (object) {
            this.m_disconnectReason = reason;
            this.m_connected = false;
            this.m_connecting = false;
            if (this.m_passiveGAXIsRunning) {
                if (this.m_guarAckXchanger != null) {
                    this.m_guarAckXchanger.abort();
                }
                this.m_passiveGAXIsRunning = false;
            }
        }
        RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
        rbh.wakeUpConnectThread();
        if (this.DEBUG) {
            this.debug("In-doubt received messages = " + this.m_rcvdXOnceQTrackNums.size());
            Enumeration enumeration = this.m_inDoubtQTrackNums.elements();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            this.debug("In-doubt sent messages = " + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConnectionTimedOut() {
        Object object = this.m_flagMutex;
        synchronized (object) {
            return this.isRegistered() && !this.isConnected() && (this.m_disconnectReason == 3 || this.m_disconnectReason == 2);
        }
    }

    @Override
    public boolean isNeighbor() {
        return false;
    }

    @Override
    public boolean isHttp() {
        return false;
    }

    @Override
    public void sendThrough(IMgram m) {
        if (this.DEBUG) {
            this.debug("in sendThrough(IMgram m)");
        }
        this.m_cc.sendThrough(m);
    }

    @Override
    public boolean send(IMgram m) throws InterruptedException {
        if (m.isPubSub()) {
            if (this.m_cc.getClientSessionVer() < 25) {
                AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, 18, true);
                return false;
            }
            if (m.getSubject().isMultiSubject() && this.m_cc.getClientSessionVer() < 28) {
                AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, 27, true);
                return false;
            }
        }
        IMgram correctedMgram = this.removeJMSXUserID(m);
        int status = this.m_cc.xOnceQSend(correctedMgram, s_label, false);
        boolean successfulSend = false;
        if (m.isJMSPersistent()) {
            switch (status) {
                case 0: 
                case 2: {
                    successfulSend = true;
                    break;
                }
                default: {
                    RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
                    rbh.rerouteUnacknowledged(m);
                    break;
                }
            }
        }
        return successfulSend;
    }

    private IMgram removeJMSXUserID(IMgram m) {
        RoutingConnectionInfo routingInfo = AgentRegistrar.getAgentRegistrar().getRoutingConfig().getRoutingConnection(this.m_node);
        if (routingInfo == null || routingInfo.getPropagateJMSXUserID()) {
            return m;
        }
        if (m.isSecure() && (SecurityLogic.isMKeyEncryption(m.getSecurity()) || SecurityLogic.isMKeyDigest(m.getSecurity()))) {
            throw new EAssertFailure("Unexpected SA_ENCRYPT_MESSAGE_MESSAGE_KEY or SA_MAC_MESSAGE_MESSAGE_KEY in removeJMSXUserID");
        }
        Hashtable table = m.getSidebandDataReadOnly().getProperties();
        if (table.get("JMSXUserID") == null) {
            return m;
        }
        IMgram modifiedMgram = null;
        try {
            modifiedMgram = (IMgram)m.clone();
        }
        catch (CloneNotSupportedException ex) {
            modifiedMgram = m;
        }
        table = modifiedMgram.getSidebandData().getProperties();
        table.remove("JMSXUserID");
        modifiedMgram.getSidebandData().setProperties(table);
        return modifiedMgram;
    }

    String getUserID() {
        return this.m_userid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClientContext(IClientContext cc) {
        if (this.DEBUG) {
            this.debug(" setclientContext " + cc);
        }
        this.m_cc = cc;
        this.m_cc.setRemoteBroker();
        if (this.m_cc.getCCFlowControlTracker() == null) {
            this.m_cc.setCCFlowControlTracker(new GRFlowControlTracker(this.m_cc));
        }
        Object object = this.m_flagMutex;
        synchronized (object) {
            this.m_connected = true;
            this.m_connecting = false;
        }
        if (this.DEBUG) {
            this.debug("setClientContext() registering for routing config changes.");
        }
        AgentRegistrar.getAgentRegistrar().getRoutingConfig().addRoutingConfigListener(this);
    }

    String getAppID() {
        return this.m_appid;
    }

    @Override
    public long getClientID() {
        return this.m_cid;
    }

    @Override
    public String getNodeName() {
        if (this.m_registered) {
            return this.m_node;
        }
        return this.m_connectInfo.getRoutingNodeName();
    }

    @Override
    public String getPendingQueueName() {
        return this.getNodeName();
    }

    public RoutingConnectionInfo getConnectInfo() {
        return this.m_connectInfo;
    }

    @Override
    public String getBrokerName() {
        return this.m_brokerName;
    }

    @Override
    public String getConnectURL() {
        return this.m_directUrl;
    }

    public String getStandbyConnectURL() {
        return this.m_standbyUrl;
    }

    public String getUser() {
        return this.m_userid;
    }

    public String getPassword() {
        return this.m_password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.m_flagMutex;
        synchronized (object) {
            return this.m_connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.m_flagMutex;
        synchronized (object) {
            return this.m_connecting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered() {
        Object object = this.m_flagMutex;
        synchronized (object) {
            return this.m_registered;
        }
    }

    @Override
    public boolean isOkToDispatch(IMinEnqueuePriorityListener iMinEnqPrioListener) {
        if (!this.isConnected()) {
            return false;
        }
        if (this.m_cc == null) {
            return false;
        }
        return this.m_cc.okToDispatch(iMinEnqPrioListener);
    }

    @Override
    public boolean isOkToSend(PublishLimiterNotify notifyLimiter) {
        if (this.m_cc != null && !this.m_cc.okToDispatchRemote()) {
            return false;
        }
        int prio = this.getMinSendPriority(notifyLimiter);
        return prio <= 9 && this.isConnected();
    }

    @Override
    public int getMinSendPriority(PublishLimiterNotify notifyLimiter) {
        if (!this.isConnected()) {
            return 10;
        }
        if (this.m_cc == null) {
            return 10;
        }
        return this.m_cc.getMinSendPriority(notifyLimiter);
    }

    @Override
    public void expireSent() throws InterruptedException {
        if (!this.m_connected) {
            return;
        }
        if (this.m_cc == null) {
            return;
        }
        this.m_cc.clearExpiredMsgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getToken() {
        Object object = this.m_flagMutex;
        synchronized (object) {
            return this.m_convertToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setToken(long token) {
        Object object = this.m_flagMutex;
        synchronized (object) {
            this.m_convertToken = token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long brokerAckExchange(String myCertificateCommonName) throws EGeneralException {
        if (Config.DISABLE_ACKEXCHANGE) {
            if (this.DEBUG) {
                this.debug("AckExchange disabled ");
            }
            return 0L;
        }
        Object object = this.m_flagMutex;
        synchronized (object) {
            this.m_passiveGAXIsRunning = false;
        }
        long token = 0L;
        while ((token = TokenGen.generateToken()) == 0L) {
        }
        this.setToken(token);
        String userIdToRemote = this.m_rtmgr.getUserIDForNode(this.m_node, myCertificateCommonName);
        String thisBroker = RouterManager.getLocalRouterAppID();
        long remoteClientId = AddrUtil.stringToClientId(userIdToRemote, thisBroker);
        if (this.DEBUG) {
            this.debug("Constructing AckExchanger: this Broker= " + thisBroker);
            this.debug(" thisB's Usrid= <" + userIdToRemote + ">");
            this.debug(" thisB's ClientId on remote Broker= " + remoteClientId);
            this.debug(" RemoteBroker's ClientId= " + this.m_cid);
            this.debug("token= " + token);
            this.debug("In-doubt received messages = " + this.m_rcvdXOnceQTrackNums.size());
            Enumeration enumeration = this.m_inDoubtQTrackNums.elements();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            this.debug("In-doubt sent messages = " + count);
        }
        this.m_guarAckXchanger = new GuarAckExchanger(this.m_rtmgr.getRouterSession(), remoteClientId, this.m_cid, token, false, this);
        Object object2 = this.m_flagMutex;
        synchronized (object2) {
            this.m_passiveGAXIsRunning = true;
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean okToConvert(long token) {
        if (Config.DISABLE_ACKEXCHANGE) {
            if (this.DEBUG) {
                this.debug("AckExchange disabled ");
            }
            return true;
        }
        if (token == this.m_convertToken && this.m_passiveGAXIsRunning) {
            try {
                if (this.DEBUG) {
                    this.debug("blocking for completion of GAX");
                }
                this.m_guarAckXchanger.doExchange();
                if (this.DEBUG) {
                    this.debug("GAX complete");
                }
            }
            catch (EGeneralException e) {
                if (this.DEBUG) {
                    this.debug("okToConvert() returning false due to exception in guar ack exchange, thread " + Thread.currentThread());
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                Object object = this.m_flagMutex;
                synchronized (object) {
                    this.m_passiveGAXIsRunning = false;
                }
                return false;
            }
            Object object = this.m_flagMutex;
            synchronized (object) {
                this.m_passiveGAXIsRunning = false;
            }
            return true;
        }
        if (this.DEBUG) {
            this.debug("okToConvert() returning false for thread " + Thread.currentThread() + ", token= " + token + ", m_convertToken= " + this.m_convertToken);
        }
        return false;
    }

    @Override
    public void IRoutingConfigChanged(RoutingConnectionInfo newRouting, RoutingConnectionInfo oldRouting) {
        IClientContext clientContext = null;
        AgentConnection connection = null;
        if (newRouting == null) {
            if (this.isRegistered() && this.isConnected() && this.getNodeName().equals(oldRouting.getRoutingNodeName())) {
                if (this.DEBUG) {
                    this.debug("default route deleted, old route = " + oldRouting);
                }
                this.m_routeDeleted = true;
                try {
                    this.getCC().getConnection().getSocket().close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return;
        }
        if (this.isRegistered() && this.isConnected() && this.getNodeName().equals(newRouting.getRoutingNodeName())) {
            try {
                clientContext = AgentRegistrar.getAgentRegistrar().getClient(this.getClientID());
            }
            catch (EClientNotRegistered ex) {
                return;
            }
            connection = clientContext.getConnection();
            if (connection != null) {
                connection.setIdleTimeout(newRouting.getTimeout());
            }
        }
    }

    @Override
    public void setRoutingConfigIndex(int index) {
        this.m_routingConfigIndex = index;
    }

    @Override
    public int getRoutingConfigIndex() {
        return this.m_routingConfigIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getInDoubtTime() {
        Object object = this.m_flagMutex;
        synchronized (object) {
            return this.m_inDoubtTime;
        }
    }

    @Override
    public int getInDoubtQMsgsCount() {
        return this.m_inDoubtQTrackNums.count();
    }

    @Override
    public int getPendingQMsgsCount() {
        IClientContext cc = this.m_cc;
        if (cc != null) {
            return cc.getPendingQCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInDoubtTime(long time) {
        Object object = this.m_flagMutex;
        synchronized (object) {
            this.m_inDoubtTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasInDoubtState() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (!this.m_rcvdXOnceQTrackNums.isEmpty()) {
                if (this.DEBUG) {
                    this.debug("Has pending state; expecting " + this.m_rcvdXOnceQTrackNums.size() + " responses to guaranteed acks");
                }
                return true;
            }
            Enumeration enumeration = this.m_inDoubtQTrackNums.elements();
            if (enumeration.hasMoreElements()) {
                if (this.DEBUG) {
                    int count = 0;
                    while (enumeration.hasMoreElements()) {
                        enumeration.nextElement();
                        ++count;
                    }
                    this.debug("Has pending state; expects " + count + " acks to resolve in-doubt messages");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void xOnceQMsgReceived(long tracking, IMsgTracker tracker) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_rcvdXOnceQTrackNums.put(tracking, tracker);
        }
        if (this.isConnected() && this.CALLBACK) {
            this.callback("Invoking CALLBACK upon receipt of an xonce msg from node " + this.getNodeName(), 7, this.getCC().getConnection().getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGuarQAck(long ackTracking, long msgTracking) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_guarQAcks.put(ackTracking, new Long(msgTracking));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQMsgInDoubt(long tracking) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (this.DEBUG) {
                this.debug("Added to in-doubt list " + tracking);
            }
            this.m_inDoubtQTrackNums.appendNoDup(tracking, new Long(tracking));
        }
        if (this.CALLBACK) {
            this.callback("Invoking CALLBACK upon restoring of an in-doubt msg against node " + this.getNodeName(), 8, new Integer(this.m_inDoubtQTrackNums.count()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleQAckAck(IMgram ack) {
        long acktrk = ack.getAckHandle().getTrackingNumber();
        if (this.DEBUG) {
            this.debug("In handleQAckAck for " + acktrk);
        }
        boolean needEvent = false;
        boolean isQueueTracker = false;
        long ourTrackNum = 0L;
        IMsgTracker msgTracker = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Long msgTracking = (Long)this.m_guarQAcks.remove(acktrk);
            if (msgTracking == null) {
                return false;
            }
            if (this.DEBUG) {
                this.debug("In handleQAckAck for " + acktrk + " remote's TrackingNum= " + msgTracking);
            }
            msgTracker = (IMsgTracker)this.m_rcvdXOnceQTrackNums.remove(msgTracking);
        }
        if (msgTracker != null) {
            AgentQueueMsgTracker queueTracker = null;
            AgentGuarMsgTracker guarTracker = null;
            switch (msgTracker.getType()) {
                case 0: {
                    isQueueTracker = true;
                    queueTracker = (AgentQueueMsgTracker)msgTracker;
                    ourTrackNum = queueTracker.getTracking();
                    needEvent = queueTracker.guarAckDone();
                    break;
                }
                case 1: {
                    isQueueTracker = false;
                    guarTracker = (AgentGuarMsgTracker)msgTracker;
                    ourTrackNum = guarTracker.getTracking();
                    needEvent = guarTracker.guarAckDone();
                    break;
                }
                case 2: {
                    isQueueTracker = false;
                    needEvent = msgTracker.guarAckDone();
                    ourTrackNum = msgTracker.getTracking();
                }
            }
        } else {
            return true;
        }
        if (needEvent) {
            LogEvent evt = isQueueTracker ? new GuarQAckDoneEvt(ourTrackNum) : new GuarAckDoneEvt(ourTrackNum);
            evt.setReplicateOnly(msgTracker.isReplicateOnly());
            this.m_logMgr.addEvent(evt, true);
        }
        if (this.DEBUG) {
            this.debug("In handleQAckAck for " + acktrk + " returning true ");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireInDoubt() throws InterruptedException {
        IndexedList inDoubtList = null;
        int count = 0;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration enu = this.m_inDoubtQTrackNums.elements();
            while (enu.hasMoreElements()) {
                ++count;
                long tracking = (Long)enu.nextElement();
                AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().removeInDoubtMsg(tracking);
            }
            if (count == 0) {
                if ((this.debugFlags & 0x40) > 0) {
                    this.debug("Expiring " + count + " in-doubt messages to routing queue");
                }
                return;
            }
            inDoubtList = this.m_inDoubtQTrackNums;
            this.m_inDoubtQTrackNums = new IndexedList();
            IndexedList mgrams = new IndexedList();
        }
        Enumeration enu = inDoubtList.elements();
        while (enu.hasMoreElements()) {
            long tracking = (Long)enu.nextElement();
            IMgram m = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver().retrieveMgram(tracking);
            if (m == null) {
                if (!this.DEBUG) continue;
                this.debug("Restoring inDoubt messages to queue: No mgram in db for tracking " + tracking);
                continue;
            }
            AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, 6, true);
        }
        if (this.DEBUG) {
            this.debug("Moved " + count + " in-doubt messages to dead message queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inDoubtQMsgAcknowledged(long tracking) {
        AgentQueueMsgTracker tracker;
        ListNode obj;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (this.DEBUG) {
                this.debug("Received ack for " + tracking);
            }
            if ((obj = this.m_inDoubtQTrackNums.remove(tracking)) != null) {
                if (this.DEBUG) {
                    this.debug("Message " + tracking + " foung in in-doubt list");
                }
                AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().removeInDoubtMsg(tracking);
            }
        }
        if (obj != null && (tracker = AgentQueueMsgTracker.getTracker(tracking)) != null) {
            tracker.acknowledged(null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumXOnceQMsgs() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            return this.m_rcvdXOnceQTrackNums.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getXOnceQMsgTrackNums() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            return this.m_rcvdXOnceQTrackNums.keys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allXOnceQAcksDone() {
        GuarQAckXchgEvt queueXchgEvt = new GuarQAckXchgEvt();
        GuarAckXchgEvt pubsubXchgEvt = new GuarAckXchgEvt();
        GuarQAckXchgEvt replOnlyQueueXchgEvt = new GuarQAckXchgEvt();
        GuarAckXchgEvt replOnlyPubsubXchgEvt = new GuarAckXchgEvt();
        int queueCt = 0;
        int pubsubCt = 0;
        int replOnlyQueueCt = 0;
        int replOnlyPubsubCt = 0;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration enu = this.m_rcvdXOnceQTrackNums.elements();
            while (enu.hasMoreElements()) {
                IMsgTracker msgTracker = (IMsgTracker)enu.nextElement();
                switch (msgTracker.getType()) {
                    case 0: {
                        if (msgTracker.isReplicateOnly()) {
                            ++replOnlyQueueCt;
                            replOnlyQueueXchgEvt.addTracking(msgTracker.getTracking());
                            break;
                        }
                        ++queueCt;
                        queueXchgEvt.addTracking(msgTracker.getTracking());
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (msgTracker.isReplicateOnly()) {
                            ++replOnlyPubsubCt;
                            replOnlyPubsubXchgEvt.addTracking(msgTracker.getTracking());
                            break;
                        }
                        ++pubsubCt;
                        pubsubXchgEvt.addTracking(msgTracker.getTracking());
                    }
                }
                msgTracker.guarAckDone();
            }
            this.m_rcvdXOnceQTrackNums.clear();
            this.m_guarQAcks.clear();
        }
        if (queueCt > 0) {
            queueXchgEvt.setReplicateOnly(false);
            this.m_logMgr.addEvent(queueXchgEvt, false);
        }
        if (replOnlyQueueCt > 0) {
            replOnlyQueueXchgEvt.setReplicateOnly(true);
            this.m_logMgr.addEvent(replOnlyQueueXchgEvt, false);
        }
        if (pubsubCt > 0) {
            pubsubXchgEvt.setReplicateOnly(false);
            this.m_logMgr.addEvent(pubsubXchgEvt, false);
        }
        if (replOnlyPubsubCt > 0) {
            replOnlyPubsubXchgEvt.setReplicateOnly(true);
            this.m_logMgr.addEvent(replOnlyPubsubXchgEvt, false);
        }
        if ((this.debugFlags & 0x40) > 0) {
            this.debug("Acks confirmed for " + (queueCt + pubsubCt + replOnlyQueueCt + replOnlyPubsubCt) + " messages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allInDoubtQAcksReceived() throws InterruptedException {
        long tracking;
        Enumeration enu;
        IndexedList inDoubtList = null;
        int count = 0;
        InDoubtQMsgReenqueueEvt evt = new InDoubtQMsgReenqueueEvt();
        InDoubtQMsgReenqueueEvt replOnlyEvt = new InDoubtQMsgReenqueueEvt();
        replOnlyEvt.setReplicateOnly(true);
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            enu = this.m_inDoubtQTrackNums.elements();
            while (enu.hasMoreElements()) {
                ++count;
                tracking = (Long)enu.nextElement();
                AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().removeInDoubtMsg(tracking);
                AgentQueueMsgTracker tracker = null;
                tracker = AgentQueueMsgTracker.getTracker(tracking);
                if (tracker != null && tracker.isReplicateOnly()) {
                    replOnlyEvt.addTracking(tracking);
                } else {
                    evt.addTracking(tracking);
                }
                if (tracker != null) {
                    tracker.setReceiverId(0L);
                    continue;
                }
                if (!this.DEBUG) continue;
                this.debug("Tracker for " + tracking + " not found");
            }
            if (count == 0) {
                if ((this.debugFlags & 0x40) > 0) {
                    this.debug("Restored " + count + " recovered in-doubt messages to routing queue");
                }
                AgentRegistrar.getAgentRegistrar().getLogManager().flush();
                return;
            }
            inDoubtList = this.m_inDoubtQTrackNums;
            this.m_inDoubtQTrackNums = new IndexedList();
        }
        this.m_logMgr.addEvent(replOnlyEvt, false);
        this.m_logMgr.addEvent(evt, true);
        this.m_logMgr.waitForFlush(evt);
        IndexedList<IMgram> mgrams = new IndexedList<IMgram>();
        enu = inDoubtList.elements();
        while (enu.hasMoreElements()) {
            tracking = (Long)enu.nextElement();
            IMgram m = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver().retrieveMgram(tracking);
            if (m == null) {
                if (!this.DEBUG) continue;
                this.debug("Restoring inDoubt messages to queue: No mgram in db for tracking " + tracking);
                continue;
            }
            mgrams.appendNoDup(tracking, m);
        }
        RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
        if (this.DEBUG) {
            this.debug(this + "Restoring: " + mgrams.count() + " to pending queue.");
        }
        rbh.rerouteUnacknowledged(mgrams.elements(), false);
        if ((this.debugFlags & 0x40) > 0) {
            this.debug("Restored " + count + " recovered in-doubt messages to routing queue");
        }
    }

    IClientContext getCC() {
        return this.m_cc;
    }

    @Override
    public String toString() {
        return "RemoteBroker(NODE:" + this.m_node + ",BROKER:" + this.m_brokerName + ",URL:" + this.m_directUrl + ",CID:" + this.m_cid;
    }
}

