/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.Config;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.broker.StatsManager;
import progress.message.db.EDatabaseException;
import progress.message.dbq.IRoutingDBQ;
import progress.message.ft.DynamicSyncRoutesReplicationOp;
import progress.message.ft.DynamicSyncRoutesSaveOp;
import progress.message.ft.ReplicationManager;
import progress.message.gr.RouteInfo;
import progress.message.gr.RouteSaverOp;
import progress.message.util.StreamUtil;
import progress.message.zclient.DebugThread;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.FastVector;
import progress.message.zclient.QueueLimiter;

public class RouteSaver
extends DebugThread {
    public static final int BYNODE = 1;
    public static final int BYBROKER = 2;
    private BrokerDatabase m_db;
    private IRoutingDBQ m_dbq;
    private ReplicationManager m_replMgr;
    private StatsManager m_statsMgr;
    private FastVector m_todolist;
    private FastVector m_prevTodolist;
    private QueueLimiter m_limiter;
    private int m_queueSize;
    private int m_flushState;
    private static int FLUSHEND = 0;
    private static int FLUSHPROCESS = 1;
    private static int FLUSHSTART = 2;

    RouteSaver(AgentRegistrar reg) {
        super("RouteSaver");
        this.m_db = reg.getBrokerDatabase();
        this.m_dbq = this.m_db.getIRoutingDBQ();
        this.m_statsMgr = reg.getStatsManager();
        this.m_todolist = new FastVector();
        this.m_prevTodolist = new FastVector();
        this.m_limiter = new QueueLimiter(Config.PS_DB_QUEUE_SIZE);
    }

    public RouteSaverOp buildRouteSaverOp(int type, InputStream is) throws IOException, EMgramFormatError {
        RouteSaverOp result = null;
        switch (type) {
            case 10: {
                result = new RouteDeleteOp();
                break;
            }
            case 9: {
                result = new RouteSaveOp();
            }
        }
        if (result != null) {
            result.readFromStream(is);
        }
        return result;
    }

    public synchronized Vector getRoutes() {
        try {
            return this.m_dbq.getRoutes();
        }
        catch (EDatabaseException e) {
            BrokerComponent.getComponentContext().logMessage("Error reading routes from dynamic routing table: " + e.getMessage(), (Throwable)e, 2);
            return null;
        }
    }

    private void initReplication() {
        if (this.m_replMgr == null) {
            this.m_replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        }
    }

    synchronized void save(RouteInfo ri) {
        int size = ri.length();
        this.waitForQueueSpace(size);
        this.m_todolist.addElement(new RouteSaveOp(ri));
        this.m_limiter.add(size);
        ++this.m_queueSize;
        if (this.CALLBACK) {
            this.callback("Save route called", 0, ri.getGlobalName());
        }
        this.notifyAll();
    }

    public synchronized void enqueue(RouteSaverOp op) {
        int size = op.memsize();
        this.waitForQueueSpace(size);
        this.m_todolist.addElement(op);
        this.m_limiter.add(size);
        ++this.m_queueSize;
        this.notifyAll();
    }

    public synchronized void enqueueNoLimiterWait(RouteSaverOp op) {
        this.m_todolist.addElement(op);
        this.m_limiter.add(op.memsize());
        ++this.m_queueSize;
        if (this.CALLBACK) {
            this.callback("EnqueueNoLimiterWait called", 2, op);
        }
        this.notifyAll();
    }

    public synchronized void deleteRouteNode(RouteInfo ri) {
        this.m_todolist.addElement(new RouteDeleteOp(ri, 1));
        ++this.m_queueSize;
        if (this.CALLBACK) {
            this.callback("Delete route node", 1, ri.getGlobalName());
        }
        this.notifyAll();
    }

    public synchronized void deleteRouteBroker(RouteInfo ri) {
        this.m_todolist.addElement(new RouteDeleteOp(ri, 2));
        ++this.m_queueSize;
        if (this.CALLBACK) {
            this.callback("Delete route broker (specific global dest.)", 1, ri.getGlobalName());
        }
        this.notifyAll();
    }

    public synchronized void flush() throws InterruptedException {
        this.m_flushState = FLUSHSTART;
        this.notifyAll();
        while (this.m_flushState != FLUSHEND) {
            this.wait();
        }
    }

    private synchronized FastVector getTodolist() throws InterruptedException {
        while (this.m_todolist.m_count == 0) {
            if (this.m_flushState != FLUSHEND) {
                this.m_flushState = FLUSHEND;
                this.notifyAll();
            }
            do {
                this.wait();
            } while (this.m_todolist.m_count == 0 && this.m_flushState == FLUSHEND);
        }
        FastVector ret = this.m_todolist;
        this.m_todolist = this.m_prevTodolist;
        this.m_prevTodolist = ret;
        this.m_limiter.reset();
        this.m_queueSize = 0;
        if (this.m_flushState == FLUSHSTART) {
            this.m_flushState = FLUSHPROCESS;
        }
        this.notifyAll();
        return ret;
    }

    private void waitForQueueSpace(int size) {
        try {
            while (!this.m_limiter.hasRoom(size)) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() throws InterruptedException {
        try {
            if (this.checkDebugFlags(64)) {
                this.debug("starting");
            }
            while (!Broker.exiting && !Thread.currentThread().isInterrupted()) {
                FastVector todolist = null;
                try {
                    todolist = this.getTodolist();
                }
                catch (InterruptedException e) {
                    if (!Broker.exiting) {
                        throw e;
                    }
                    if (this.checkDebugFlags(64)) {
                        this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
                    }
                    return;
                }
                if (this.DEBUG) {
                    this.debug("beginning route information saves/deletes");
                }
                long start = System.currentTimeMillis();
                long count = 0L;
                this.m_db.beginRoutingDBTran();
                boolean inTx = true;
                try {
                    for (int i = 0; i < todolist.m_count && !Broker.exiting; ++i) {
                        RouteSaverOp op = (RouteSaverOp)todolist.m_data[i];
                        ++count;
                        if (op.executeOutsideRoutingDBTx()) {
                            if (this.checkDebugFlags(64)) {
                                this.debug("Switching out of RouteSaver tx for " + op);
                            }
                            this.m_db.commitRoutingTran();
                            this.m_db.releaseRoutingDBTran();
                            inTx = false;
                        } else if (!inTx) {
                            if (this.checkDebugFlags(64)) {
                                this.debug("Switching back to RouteSaver tx.");
                            }
                            this.m_db.beginRoutingDBTran();
                            inTx = true;
                        }
                        if (Config.REPLICATED && op.okToReplicate()) {
                            this.initReplication();
                            if (this.m_replMgr.okToReplicate()) {
                                this.m_replMgr.replicateSaverOp((IReplicateableSaverOp)((Object)op));
                            }
                        }
                        if (this.CALLBACK) {
                            if (op instanceof RouteSaveOp) {
                                this.callback("Pre execute route save op", 3, op);
                            } else if (op instanceof RouteDeleteOp) {
                                this.callback("Pre to execute route save op", 5, op);
                            }
                        }
                        try {
                            if (this.checkDebugFlags(64)) {
                                if (op instanceof DynamicSyncRoutesReplicationOp) {
                                    this.debug("Starting DynamicSyncRoutesReplicationOp ");
                                }
                                if (op instanceof DynamicSyncRoutesSaveOp) {
                                    this.debug("Starting DynamicSyncRoutesSaveOp ");
                                }
                            }
                            op.doit(this.m_dbq);
                            if (this.checkDebugFlags(64)) {
                                if (op instanceof DynamicSyncRoutesReplicationOp) {
                                    this.debug("Completed DynamicSyncRoutesReplicationOp ");
                                }
                                if (op instanceof DynamicSyncRoutesSaveOp) {
                                    this.debug("Completed DynamicSyncRoutesSaveOp ");
                                }
                            }
                            if (this.CALLBACK) {
                                if (op instanceof RouteSaveOp) {
                                    this.callback("Post execute route save op", 4, op);
                                } else if (op instanceof RouteDeleteOp) {
                                    this.callback("Post execute route save op", 6, op);
                                }
                            }
                        }
                        catch (IOException e) {
                            this.m_db.rollbackRoutingTran();
                            if (Broker.exiting) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                            if (inTx) {
                                this.m_db.releaseRoutingDBTran();
                            }
                            if (this.checkDebugFlags(64)) {
                                this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
                            }
                            return;
                        }
                        todolist.m_data[i] = null;
                    }
                    if (inTx) {
                        this.m_db.commitRoutingTran();
                    }
                    if (this.checkDebugFlags(64)) {
                        this.debug("Commited " + count + " RouteOps in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    todolist.m_count = 0;
                }
                finally {
                    if (!inTx) continue;
                    this.m_db.releaseRoutingDBTran();
                }
            }
        }
        catch (EDatabaseException e) {
            if (Broker.exiting) {
                Thread.currentThread().interrupt();
                return;
            }
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        finally {
            if (this.checkDebugFlags(64)) {
                this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
            }
        }
    }

    final class RouteDeleteOp
    implements RouteSaverOp,
    IReplicateableSaverOp {
        private RouteInfo m_ri;
        private int m_deleteType;

        RouteDeleteOp(RouteInfo ri, int deleteType) {
            this.m_ri = ri;
            this.m_deleteType = deleteType;
        }

        RouteDeleteOp() {
        }

        @Override
        public boolean executeOutsideRoutingDBTx() {
            return false;
        }

        @Override
        public void doit(IRoutingDBQ dbq) throws IOException {
            if (RouteSaver.this.DEBUG) {
                RouteSaver.this.debug("deleting route " + this.m_ri.getNodeName() + "::" + this.m_ri.getGlobalName());
            }
            if (this.m_deleteType == 1) {
                dbq.deleteRoutesByNodeGlobalTx(this.m_ri.getNodeName(), this.m_ri.getGlobalName());
            } else {
                dbq.deleteRoutesByNodeGlobalBrokerTx(this.m_ri.getNodeName(), this.m_ri.getGlobalName(), this.m_ri.getBrokerName());
            }
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeInt(this.m_deleteType, os);
            DataOutputStream output = new DataOutputStream(os);
            this.m_ri.writeToStream(output, (short)-1);
            output.flush();
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_deleteType = StreamUtil.readInt(is);
            this.m_ri = new RouteInfo();
            DataInputStream input = new DataInputStream(is);
            this.m_ri.readFromStream(input, (short)-1);
        }

        @Override
        public int memsize() {
            return this.m_ri.length();
        }

        @Override
        public int length() {
            return this.m_ri.length();
        }

        @Override
        public byte getType() {
            return 10;
        }

        @Override
        public long getTracking() {
            return -1L;
        }

        @Override
        public boolean okToReplicate() {
            return true;
        }

        @Override
        public boolean replicatePostDoit() {
            return false;
        }
    }

    final class RouteSaveOp
    implements RouteSaverOp,
    IReplicateableSaverOp {
        private RouteInfo m_ri;

        RouteSaveOp(RouteInfo ri) {
            this.m_ri = ri;
        }

        RouteSaveOp() {
        }

        @Override
        public boolean executeOutsideRoutingDBTx() {
            return false;
        }

        @Override
        public void doit(IRoutingDBQ dbq) throws IOException {
            if (RouteSaver.this.DEBUG) {
                RouteSaver.this.debug("saving route " + this.m_ri.getNodeName() + "::" + this.m_ri.getGlobalName());
            }
            dbq.addRouteTx(this.m_ri);
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            DataOutputStream output = new DataOutputStream(os);
            this.m_ri.writeToStream(output, (short)-1);
            output.flush();
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_ri = new RouteInfo();
            DataInputStream input = new DataInputStream(is);
            this.m_ri.readFromStream(input, (short)-1);
        }

        @Override
        public int memsize() {
            return this.m_ri.length();
        }

        @Override
        public int length() {
            return this.m_ri.length();
        }

        @Override
        public byte getType() {
            return 9;
        }

        @Override
        public long getTracking() {
            return -1L;
        }

        @Override
        public boolean okToReplicate() {
            return true;
        }

        @Override
        public boolean replicatePostDoit() {
            return false;
        }
    }
}

