/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import java.io.IOException;
import java.util.Map;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentSender;
import progress.message.gr.RemoteBroker;
import progress.message.gr.RouterListener;
import progress.message.net.ISocket;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ProgressSecureRandom;

class RouterConnection
extends AgentConnection {
    RemoteBroker m_remoteBroker;

    RouterConnection(ISocket socket, RemoteBroker remote) throws IOException {
        super(socket, ProgressSecureRandom.theSecureRandom().nextLong(), false);
        this.setAgentSender(new AgentSender(this));
        this.setAgentListener(new RouterListener(this, remote));
        this.m_remoteBroker = remote;
    }

    @Override
    protected String getInstanceMetricName() {
        ClientSecurityContext.ISecurityContextDisplayInfo displayInfo;
        String instanceName = null;
        ClientSecurityContext csc = this.getSecurityContext(0);
        if (csc != null && (displayInfo = csc.getDisplayInfo()).getType() == 3) {
            instanceName = displayInfo.getName();
        }
        return instanceName;
    }

    @Override
    public void appendConnectionMemberProperties(Map properties) {
        super.appendConnectionMemberProperties(properties);
        properties.put("ConnectionType", "Routing");
        if (this.m_remoteBroker != null) {
            properties.put("RemoteNode", this.m_remoteBroker.getNodeName());
            properties.put("RemoteBroker", this.m_remoteBroker.getBrokerName());
        }
    }
}

