/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.EOFException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.client.Credentials;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.EUnknownBrokerHost;
import progress.message.gr.RouterManager;
import progress.message.interbroker.GuarAckExchanger;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.InterbrokerConnection;
import progress.message.interbroker.InterbrokerListener;
import progress.message.interbroker.Neighbor;
import progress.message.interbroker.TempMessageHandler;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.zclient.BrokerURL;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.NegotiatedConnectParms;

final class CollectiveConnect
extends Connection {
    private boolean m_activated = false;
    private GuarAckExchanger m_gax = null;
    private static Interbroker s_ib = Interbroker.getInterbroker();
    private byte m_mark;
    private Neighbor m_neighbor;

    CollectiveConnect(Neighbor n) throws EGeneralException {
        super("Broker connect", new Credentials(Config.BROKER_UID, Config.BROKER_PWD), new TempMessageHandler(n.getName()));
        this.m_neighbor = n;
        Hashtable properties = new Hashtable();
        Config.getConnectionProperties(properties);
        this.setProperties(properties);
        super.setSocketConnectTimeout(Config.CLUSTER_CONNECT_TIMEOUT);
        super.setConnectTimeout(Config.CLUSTER_CONNECT_TIMEOUT);
    }

    @Override
    public String toString() {
        return "CollectiveConnect " + this.m_neighbor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pauseListener(long token) throws ENotConnected, InterruptedException {
        if (InterbrokerConfig.DEBUG) {
            this.debug("Pause Listening...");
        }
        IMgram request = null;
        if (InterbrokerConfig.DEBUG) {
            this.debug("Token is " + token);
        }
        request = MgramFactory.getMgramFactory().buildIBConvertMgram(token, this.getChannel());
        if (InterbrokerConfig.DEBUG) {
            this.debug("Length of request is " + request.networkLength());
        }
        CollectiveConnect collectiveConnect = this;
        synchronized (collectiveConnect) {
            if (this.m_mark == -1) {
                throw new ENotConnected();
            }
            this.m_mark = 1;
            this.notifyAll();
        }
        this.getSender().send(request);
        if (InterbrokerConfig.DEBUG) {
            this.debug("Sent ib_convert mgram");
        }
        collectiveConnect = this;
        synchronized (collectiveConnect) {
            while (this.m_mark == 1) {
                this.wait();
            }
            if (this.m_mark == -1) {
                throw new ENotConnected();
            }
        }
        if (InterbrokerConfig.DEBUG) {
            this.debug("Listening should be paused.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pauseIfMark() {
        CollectiveConnect collectiveConnect = this;
        synchronized (collectiveConnect) {
            if (this.m_mark != 1) {
                return;
            }
            if (InterbrokerConfig.DEBUG) {
                this.debug("Notice to pause the listener");
            }
            this.m_mark = (byte)2;
            if (InterbrokerConfig.DEBUG) {
                this.debug("...listener paused");
            }
            this.notifyAll();
        }
        Thread.currentThread().stop();
    }

    @Override
    protected synchronized void connDroppedIBHook() {
        if (InterbrokerConfig.DEBUG) {
            this.debug("connection dropped, setting m_mark to -1");
        }
        if (this.m_gax != null) {
            this.m_gax.notifyConnDropped();
        }
        this.m_mark = (byte)-1;
        this.notifyAll();
    }

    boolean convertToCollective(String hostPort, int timeout, boolean secondaryAcceptor) throws EGeneralException {
        InterbrokerConnection new_con;
        long token;
        AgentRegistrar reg;
        block48: {
            reg = s_ib.getAgentRegistrar();
            token = 0L;
            try {
                String host = null;
                try {
                    BrokerURL brokerURL = new BrokerURL(hostPort);
                    host = brokerURL.getBrokerHostName();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (host == null || host.trim().length() == 0) {
                    throw new EUnknownBrokerHost(hostPort);
                }
                this.connect(hostPort);
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Connected to " + hostPort, 3);
                }
                Label local = new Label();
                local.setRouteLimit(1);
                Message msg = new Message(InterbrokerConfig.addPrefix("CONVERT"));
                msg.write((byte)1);
                boolean primaryBroker = !Config.REPLICATED || Config.PRIMARY;
                msg.writeBoolean(primaryBroker);
                msg.writeBoolean(secondaryAcceptor);
                msg = this.getDefaultSession().request(new Envelope(msg, local), timeout);
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Received reply from " + this.m_neighbor, 3);
                }
                try {
                    token = msg.readLong();
                    this.m_neighbor.setToken(token);
                }
                catch (EOFException e) {
                    if (InterbrokerConfig.DEBUG) {
                        BrokerComponent.getComponentContext().logMessage("Broker rejected interbroker request: " + this.m_neighbor, 2);
                    }
                    this.cleanUp();
                    return false;
                }
                catch (IOException e) {
                    if (InterbrokerConfig.DEBUG) {
                        BrokerComponent.getComponentContext().logMessage("Error reading convert reply from " + this.m_neighbor + ": " + e.getMessage(), (Throwable)e, 2);
                    }
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Token extracted: " + token, 3);
                }
                this.m_gax = new GuarAckExchanger(this.getDefaultSession(), reg.getId(), this.m_neighbor.getID(), token, true);
                this.m_gax.doExchange();
                this.pauseListener(token);
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Listener paused", 3);
                }
            }
            catch (EGeneralException e) {
                this.cleanUp();
                throw e;
            }
            catch (InterruptedException e) {
                this.cleanUp();
                throw new EInterrupted();
            }
            catch (Exception e) {
                this.cleanUp();
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            ClientSecurityContext csc = null;
            new_con = null;
            try {
                new_con = new InterbrokerConnection(this.getSocket(), this.m_neighbor);
                ((InterbrokerListener)new_con.getAgentListener()).setClientSessionVer(this.getBrokerSessionVer());
                new_con.setNegotiatedConnectParms(NegotiatedConnectParms.buildNegotiatedConnectParms(this.m_brokerConnectParms));
                new_con.setPartnerProductVersion(this.getPartnerProductVersion());
                this.getClientSender().kill(true, this.getChannel(), false);
                csc = (ClientSecurityContext)this.getSecurityContext().clone();
                String uid = this.m_neighbor.getName();
                csc.setUidAppid(uid, "Broker");
                if (Config.ENABLE_SECURITY) {
                    csc.setPrincipal(reg.getSecurityBean().getUser(uid));
                    if (csc.getPrincipal() == null) {
                        this.cleanUp();
                        return false;
                    }
                }
                new_con.connectSuccess(this.getChannel(), csc, csc.getClientId());
                new_con.checkLimits(0, csc.getAppid(), csc);
                new_con.getAgentListener().setCommonSecurityContext(csc);
                if (!Config.ENABLE_QOPSECURITY) break block48;
                byte[] sessionKey = csc.getSessionKey();
                if (sessionKey != null) {
                    new_con.getAgentSender().initMessageProtection(sessionKey);
                    break block48;
                }
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Neighbor " + hostPort + " does not have security enabled.", 3);
                }
                this.cleanUp();
                return false;
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                this.cleanUp();
                return false;
            }
        }
        this.m_state = 1;
        this.cleanUp();
        long id = this.m_neighbor.getID();
        if (InterbrokerConfig.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("Creating " + new_con.getListener() + " in thread " + Thread.currentThread() + " for " + this.m_neighbor, 3);
        }
        IClientContext cc = null;
        try {
            reg.connect(id, new_con, true);
        }
        catch (EGeneralException e) {
            CollectiveConnect.ensureConnectionClosed(reg, id, new_con, cc);
            throw new EInterrupted();
        }
        catch (InterruptedException e) {
            CollectiveConnect.ensureConnectionClosed(reg, id, new_con, cc);
            throw new EInterrupted();
        }
        this.m_activated = true;
        s_ib.activate(id);
        reg.postConnect(id, this.getChannel());
        try {
            cc = reg.getClient(id);
            cc.startDelivery(null);
        }
        catch (EClientNotRegistered e) {
            new_con.close();
            throw new ENotConnected();
        }
        RouterManager rm = reg.getRouterManager();
        rm.getRouteForwarder().onNewConnection(this.m_neighbor, false);
        reg.getGSManager().onNewConnection(this.m_neighbor, false);
        reg.getClusteredQueueManager().onNewConnection(this.m_neighbor);
        if (InterbrokerConfig.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("Starting " + new_con.getListener() + " for " + this.m_neighbor, 3);
        }
        boolean connectFailure = false;
        if (new_con.getListener().startIfNotStartedOrShutdown()) {
            if (this.DEBUG) {
                this.debug("Started Listener");
            }
            try {
                if (!new_con.getAgentListener().waitForMainLoop()) {
                    if (this.DEBUG) {
                        this.debug("Failed to reach main loop");
                    }
                    connectFailure = true;
                }
            }
            catch (InterruptedException e) {
                if (this.DEBUG) {
                    this.debug("Interrupted to reach main loop");
                }
                connectFailure = true;
            }
        } else {
            if (this.DEBUG) {
                this.debug("Failed to start listener");
            }
            connectFailure = true;
        }
        if (connectFailure) {
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)new EAssertFailure("Interbroker Listener thread didn't start"), 2);
            }
            CollectiveConnect.ensureConnectionClosed(reg, id, new_con, cc);
            throw new ENotConnected();
        }
        try {
            Message msg = new Message(InterbrokerConfig.addPrefix("CONVERT"));
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("  OOPS 1", 3);
            }
            msg.write((byte)2);
            msg.writeLong(reg.getId());
            boolean primaryBroker = !Config.REPLICATED || Config.PRIMARY;
            msg.writeBoolean(primaryBroker);
            msg.writeBoolean(secondaryAcceptor);
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("  OOPS 2", 3);
            }
            s_ib.getIBSession().publish(id, msg, 0, false);
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("  OOPS 3", 3);
            }
        }
        catch (ENetworkFailure enf) {
            if (!Broker.isInShutdown()) {
                BrokerComponent.getComponentContext().logMessage((Throwable)enf, 2);
            }
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        if (InterbrokerConfig.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("Connected!", 3);
        }
        s_ib.connectEvent(this.m_neighbor, token);
        return true;
    }

    final boolean getActivated() {
        return this.m_activated;
    }

    @Override
    public byte selectSessionVer(byte defaultSessionVer, byte ServerSessionVer) {
        return this.m_neighbor.selectSessionVer(defaultSessionVer, ServerSessionVer);
    }

    private static final void ensureConnectionClosed(AgentRegistrar reg, long id, AgentConnection new_con, IClientContext cc) {
        new_con.close();
        if (cc == null) {
            try {
                cc = reg.getClient(id);
            }
            catch (EClientNotRegistered e) {
                return;
            }
        }
        if (cc.isConnected()) {
            reg.disconnect(id, false, true, new_con);
        }
    }
}

