/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EStartupFailure;
import progress.message.client.EGeneralException;
import progress.message.client.ENotConnected;
import progress.message.client.EUnusableConnection;
import progress.message.interbroker.IBConfigBean;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.security.SecurityBean;
import progress.message.zclient.Connection;
import progress.message.zclient.Message;

public final class ConfigConnectionMgr
implements Runnable {
    private Interbroker m_ib;
    private volatile Connection m_configConnection;
    private Thread m_keepAliveThread;
    private Vector m_oldConnections = new Vector();
    private volatile boolean m_deliveryStarted;
    private IBConfigBean m_configBean;
    private SecurityBean m_securityBean;
    private Object x = new Object();

    ConfigConnectionMgr(Interbroker ib) throws EStartupFailure {
        this.m_ib = ib;
        AgentRegistrar reg = ib.getAgentRegistrar();
        this.m_configBean = IBConfigBean.createLocalBean(reg.getAdminConnection());
        if (Config.ENABLE_SECURITY) {
            this.m_securityBean = SecurityBean.createLocalBean(reg.getAdminConnection());
        }
    }

    void startEventDelivery() throws EStartupFailure {
        this.m_deliveryStarted = true;
        if (!InterbrokerConfig.CONFIG_SERVER.equals("")) {
            try {
                this.m_configConnection.startDelivery();
            }
            catch (ENotConnected e) {
            }
            catch (EUnusableConnection e) {
            }
            catch (EGeneralException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                throw new EStartupFailure("Could not start delivery of interbroker config events: " + e);
            }
        }
    }

    public IBConfigBean getConfigBean() {
        return this.m_configBean;
    }

    SecurityBean getSecurityBean() {
        return this.m_securityBean;
    }

    Connection getConnection() {
        return this.m_configConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConfigServer() {
        Object object = this.x;
        synchronized (object) {
            this.x.notifyAll();
        }
        if (this.m_configConnection != null) {
            this.m_configConnection.cleanUp();
        }
        if (this.m_keepAliveThread != null && this.m_keepAliveThread.isAlive()) {
            try {
                this.m_keepAliveThread.join(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_keepAliveThread.isAlive()) {
                this.m_keepAliveThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message m = new Message("$ISYS.null");
        do {
            Object object;
            try {
                object = this.x;
                synchronized (object) {
                    this.x.wait(30000L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.m_configConnection.getDefaultSession().publish(m, 0, false);
            }
            catch (EGeneralException eGeneralException) {
                // empty catch block
            }
            object = this.m_oldConnections;
            synchronized (object) {
                if (!this.m_oldConnections.isEmpty()) {
                    for (int i = this.m_oldConnections.size() - 1; i >= 0; --i) {
                        ((Connection)this.m_oldConnections.elementAt(i)).cleanUp();
                    }
                }
            }
        } while (!Broker.exiting);
    }
}

