/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.IClientContext;
import progress.message.gr.RouterManager;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.Neighbor;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

class Convert
extends DebugObject
implements IMessageHandler {
    public static final byte RESET = 0;
    public static final byte GET_TOKEN = 1;
    public static final byte DONE = 2;
    private Interbroker m_interbroker;

    Convert(Interbroker interbroker) {
        super(DebugState.GLOBAL_DEBUG_ON ? "Convert" : null);
        this.m_interbroker = interbroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Session session, Envelope envelope) {
        block30: {
            Message m = envelope.getMessage();
            Object array = null;
            try {
                byte i = m.readByte();
                if (InterbrokerConfig.DEBUG) {
                    System.out.println(m.getSubject() + ":" + i);
                }
                switch (i) {
                    case 1: {
                        if (!envelope.isRequest()) break;
                        Message replym = new Message();
                        Neighbor remote = null;
                        long r_id = 0L;
                        try {
                            r_id = AddrUtil.getIdFromDirectedSubject(envelope.getReplySubject());
                            remote = this.m_interbroker.getNeighborByConnectID(r_id);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (remote != null) {
                            long token;
                            boolean peerPrimaryRole = m.readBoolean();
                            boolean primaryAcceptor = true;
                            if (m.available() > 0) {
                                primaryAcceptor = m.readBoolean();
                                if (this.DEBUG) {
                                    this.debug("Convert.handleMessage(GET_TOKEN): " + remote.getName() + " primaryRole= " + peerPrimaryRole + " primaryAcceptor= " + primaryAcceptor);
                                }
                            } else {
                                byte sessver = 0;
                                if (this.DEBUG) {
                                    try {
                                        IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(r_id);
                                        sessver = cc.getClientSessionVer();
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    this.debug("Convert.handleMessage(GET_TOKEN): no more data available; " + remote.getName() + " primaryRole= " + peerPrimaryRole + " sessver of partner= " + sessver);
                                }
                            }
                            if ((token = remote.passiveConvert()) != 0L) {
                                remote.setPassiveConnectInfo(peerPrimaryRole, primaryAcceptor);
                                if (this.DEBUG) {
                                    this.debug("Convert.handleMessage(GET_TOKEN): returning token " + remote.getName() + " primaryRole= " + peerPrimaryRole + " primaryAcceptor= " + primaryAcceptor);
                                }
                                replym.write(token);
                            }
                        }
                        session.reply(replym, envelope);
                        break;
                    }
                    case 2: {
                        Neighbor n = null;
                        try {
                            AgentRegistrar reg = this.m_interbroker.getAgentRegistrar();
                            long id = m.readLong();
                            n = this.m_interbroker.getNeighborByID(id);
                            IClientContext cc = reg.lockContext(id);
                            if (cc == null) break;
                            try {
                                boolean peerPrimaryRole = m.readBoolean();
                                boolean primaryAcceptor = true;
                                if (m.available() > 0) {
                                    primaryAcceptor = m.readBoolean();
                                    if (this.DEBUG) {
                                        this.debug("Convert.handleMessage(DONE): " + n.getName() + " primaryRole= " + peerPrimaryRole + " primaryAcceptor= " + primaryAcceptor);
                                    }
                                } else if (this.DEBUG) {
                                    this.debug("Convert.handleMessage(DONE): no more data available; " + n.getName() + " primaryRole= " + peerPrimaryRole + " sessver of partner= " + cc.getClientSessionVer());
                                }
                                n.setPassiveConnectInfo(peerPrimaryRole, primaryAcceptor);
                                if (n.isActive()) {
                                    reg.postConnect(id, cc.getChannel());
                                    RouterManager rm = reg.getRouterManager();
                                    rm.getRouteForwarder().onNewConnection(n, true);
                                    reg.getGSManager().onNewConnection(n, true);
                                    reg.getClusteredQueueManager().onNewConnection(n);
                                    cc.startDelivery(null);
                                    this.m_interbroker.connectEvent(n, n.getToken());
                                    if (this.DEBUG) {
                                        this.debug("Convert.handleMessage(DONE): completed " + n.getName() + " primaryRole= " + peerPrimaryRole + " primaryAcceptor= " + primaryAcceptor);
                                    }
                                }
                            }
                            finally {
                                cc.unlock();
                            }
                            if (InterbrokerConfig.DEBUG) {
                                BrokerComponent.getComponentContext().logMessage("  Convert 1", 3);
                            }
                            break;
                        }
                        catch (Exception e) {
                            if (!InterbrokerConfig.DEBUG) break;
                            BrokerComponent.getComponentContext().logMessage("unable to start new sender: " + e.getMessage(), (Throwable)e, 2);
                        }
                    }
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block30;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

