/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ClientAckEvt;
import progress.message.broker.ClientContextMgramQueue;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.IProxyHandle;
import progress.message.broker.IProxyingHandle;
import progress.message.broker.MsgSaver;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.InterbrokerSession;
import progress.message.interbroker.Neighbor;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.util.ISizedEnumeration;
import progress.message.util.LongHashTable;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.Solicitation;

final class GuarAckExchanger
extends DebugObject {
    private static final int MAX_ACKS_PER_MSG = 2000;
    private static final String REQ_SUBJ = InterbrokerConfig.addPrefix("ACK_EXCHANGE");
    private static final int TYPE_PUBSUB = 1;
    private static final int TYPE_QUEUE = 2;
    private static final byte SUBTYPE_PUB_SUB_TARGETED = 1;
    private static final byte SUBTYPE_PUB_SUB_MIXED = 2;
    private static final byte SUBTYPE_PUB_SUB_UNTARGETED = 4;
    private long m_localId;
    private long m_remoteId;
    private long m_token;
    private Neighbor m_neighbor;
    private Connection m_con;
    private Session m_ssn;
    private MessageHandler m_reqMH;
    private MessageHandler m_repMH;
    private boolean m_isClient;
    private boolean m_localReqDone;
    private boolean m_remoteReqDone;
    private Solicitation m_localReq;
    private Envelope m_remoteReq;
    private EGeneralException m_err;
    private boolean m_repHandlerRunning;
    private boolean m_reqHandlerRunning;
    private boolean m_connDropped;
    private boolean DEBUG1;

    GuarAckExchanger(Session ssn, long localId, long remoteId, long token, boolean localIsClient) throws EGeneralException {
        super(DebugState.GLOBAL_DEBUG_ON ? "GuarAckExchanger " + Interbroker.getInterbroker().getNeighborByID(remoteId) : null);
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.DEBUG1) {
            this.debug("Constructor: localId= " + localId + " remoteId= " + remoteId + " localIsClient= " + localIsClient);
        }
        try {
            this.m_localId = localId;
            this.m_remoteId = remoteId;
            this.m_token = token;
            this.m_isClient = localIsClient;
            this.m_ssn = ssn;
            this.m_con = ssn.getConnection();
            this.m_neighbor = Interbroker.getInterbroker().getNeighborByID(this.m_remoteId);
            if (this.DEBUG) {
                this.debug("m_neighbor = " + this.m_neighbor);
            }
            this.m_reqMH = new MessageHandler(new IMessageHandler(){

                @Override
                public void handleMessage(Session s, Envelope env) {
                    try {
                        GuarAckExchanger.this.handleRequest(env);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            this.m_reqMH.setName("IB GuarAck request handler");
            this.m_reqMH.bind(REQ_SUBJ);
            this.m_con.addMessageHandler(this.m_reqMH);
            this.m_repMH = new MessageHandler(new IMessageHandler(){

                @Override
                public void handleMessage(Session s, Envelope env) {
                    try {
                        GuarAckExchanger.this.handleReply(env);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            this.m_repMH.setName("IB GuarAck reply handler");
            this.m_con.addMessageHandler(this.m_repMH);
        }
        catch (EGeneralException e) {
            this.m_remoteReqDone = true;
            this.m_localReqDone = true;
            this.m_err = e;
            throw e;
        }
        if (this.DEBUG) {
            this.debug("Created GuarAckExchanger");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void doExchange() throws EGeneralException {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            try {
                if (this.DEBUG) {
                    this.debug("doExchange: starting exchange");
                }
                if (this.m_isClient) {
                    this.sendClientSolicit();
                }
                if (this.DEBUG) {
                    this.debug("doExchange: waiting for exchange");
                }
                while (!(this.m_localReqDone && this.m_remoteReqDone || this.m_connDropped)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new EInterrupted();
                    }
                }
            }
            catch (EGeneralException e) {
                this.m_err = e;
            }
        }
        this.cleanUp();
        if (this.m_err != null) {
            throw this.m_err;
        }
    }

    void cleanUp() {
        if (this.DEBUG) {
            this.debug("cleaning up");
        }
        if (this.m_localReq != null) {
            this.m_localReq.cancel();
        }
        try {
            if (this.m_reqMH != null) {
                this.m_con.removeMessageHandler(this.m_reqMH);
            }
        }
        catch (EGeneralException e) {
            // empty catch block
        }
        try {
            if (this.m_repMH != null) {
                this.m_con.removeMessageHandler(this.m_repMH);
            }
        }
        catch (EGeneralException eGeneralException) {
            // empty catch block
        }
    }

    synchronized void notifyConnDropped() {
        this.m_connDropped = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            if (this.DEBUG) {
                this.debug("aborting");
            }
            boolean interrupted = false;
            while (this.m_reqHandlerRunning || this.m_repHandlerRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.m_remoteReqDone = true;
            this.m_localReqDone = true;
            this.notifyAll();
        }
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRequest(Envelope env) throws InterruptedException {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            this.m_reqHandlerRunning = true;
        }
        try {
            int i;
            Message rep;
            int numInMsg;
            boolean more;
            Message m = env.getMessage();
            byte[] body = m.getBody();
            long remoteId = ArrayUtil.readLong(body, 0);
            if (remoteId != this.m_remoteId || ArrayUtil.readLong(body, 8) != this.m_token) {
                if (this.DEBUG1) {
                    this.debug("handleRequest: discarding remote request for Id " + remoteId + "; Expecting " + this.m_remoteId);
                }
                return;
            }
            if (this.DEBUG) {
                this.debug("got remote request");
            }
            GuarAckExchanger guarAckExchanger2 = this;
            synchronized (guarAckExchanger2) {
                this.m_remoteReq = env;
                this.notifyAll();
            }
            if (!this.m_isClient) {
                this.sendBrokerSolicit();
            }
            AgentRegistrar.getAgentRegistrar().getLogManager().flush();
            if (this.DEBUG) {
                this.debug("sending replies");
            }
            Vector xOnceTrackNums = this.m_neighbor.getXOnceMsgTrackNums();
            int numAcks = xOnceTrackNums.size();
            ISizedEnumeration enumXOnceQMsgs = this.m_neighbor.getXOnceQMsgTrackNums();
            int numqAcks = enumXOnceQMsgs.size();
            Enumeration enu = xOnceTrackNums.elements();
            LongHashTable redirectAckTable = this.m_neighbor.getXOnceRedirectTrkNums();
            ISizedEnumeration<Long> redirectAcks = redirectAckTable.keyList();
            int numRedirectAcks = redirectAcks.size();
            if (this.DEBUG) {
                this.debug("handleRequest: sending replies: numAcks to send= " + numAcks);
            }
            if (this.DEBUG) {
                this.debug("Initiating in doubt resolution, numAcks=" + numAcks + ", redirectAcks=" + numRedirectAcks + " numQAcks=" + numqAcks);
            }
            do {
                ISizedEnumeration trackers;
                long backTracking;
                Long backTrackingLong;
                boolean bl = more = (numInMsg = Math.min(numAcks + numRedirectAcks, 2000)) < numAcks + numRedirectAcks;
                if (numqAcks > 0) {
                    more = true;
                }
                rep = new Message();
                rep.writeBoolean(false);
                rep.writeBoolean(more);
                rep.writeByte(1);
                if (numAcks >= numInMsg) {
                    rep.writeByte(4);
                    for (i = 0; i < numInMsg; ++i) {
                        rep.writeLong((Long)enu.nextElement());
                    }
                    numAcks -= numInMsg;
                    if (this.DEBUG) {
                        this.debug("handleRequest: sending replies: sent 1 pub/sub reply; acks in msg= " + numInMsg + " more= " + more);
                    }
                } else if (numAcks > 0 && numRedirectAcks > 0) {
                    rep.writeByte(2);
                    rep.writeInt(numAcks);
                    while (enu.hasMoreElements()) {
                        rep.writeLong((Long)enu.nextElement());
                    }
                    for (i = numAcks; i < numInMsg; ++i) {
                        try {
                            backTrackingLong = (Long)redirectAcks.nextElement();
                            backTracking = backTrackingLong;
                            rep.writeLong(backTracking);
                            trackers = ((LongHashTable)redirectAckTable.get(backTracking)).elementList();
                            rep.writeInt(trackers.size());
                            while (trackers.hasMoreElements()) {
                                rep.writeLong(((AgentGuarMsgTracker)trackers.nextElement()).getRedirectAckClient());
                            }
                            continue;
                        }
                        catch (NoSuchElementException nsee) {
                            BrokerComponent.getComponentContext().logMessage((Throwable)nsee, 2);
                            break;
                        }
                    }
                    if (this.DEBUG) {
                        this.debug("handleRequest: sending replies: sent 1 pub/sub reply; acks in msg= " + numAcks + ", numRedirectAcks=" + (numInMsg - numAcks) + ", more= " + more);
                    }
                    numRedirectAcks -= numInMsg - numAcks;
                    numAcks = 0;
                } else if (numRedirectAcks > 0) {
                    rep.writeByte(1);
                    for (i = 0; i < numInMsg; ++i) {
                        try {
                            backTrackingLong = (Long)redirectAcks.nextElement();
                            backTracking = backTrackingLong;
                            rep.writeLong(backTracking);
                            trackers = ((LongHashTable)redirectAckTable.get(backTracking)).elementList();
                            rep.writeInt(trackers.size());
                            while (trackers.hasMoreElements()) {
                                rep.writeLong(((AgentGuarMsgTracker)trackers.nextElement()).getRedirectAckClient());
                            }
                            continue;
                        }
                        catch (NoSuchElementException nsee) {
                            BrokerComponent.getComponentContext().logMessage((Throwable)nsee, 2);
                            break;
                        }
                    }
                    if (this.DEBUG) {
                        this.debug("handleRequest: sending replies: sent 1 pub/sub reply; numRedirectAcks=" + numInMsg + ", more= " + more);
                    }
                    numRedirectAcks -= numInMsg;
                }
                this.m_ssn.reply(rep, env);
            } while (numAcks > 0 || numRedirectAcks > 0);
            if (this.DEBUG) {
                this.debug("handleRequest: all pubsub acks sent");
            }
            if (this.DEBUG) {
                this.debug("handleRequest: sending replies: numqAcks to send= " + numqAcks);
            }
            while (numqAcks > 0) {
                numInMsg = Math.min(numqAcks, 2000);
                more = numInMsg < numqAcks;
                rep = new Message();
                rep.writeBoolean(false);
                rep.writeBoolean(more);
                rep.writeByte(2);
                for (i = 0; i < numInMsg; ++i) {
                    rep.writeLong((Long)enumXOnceQMsgs.nextElement());
                }
                this.m_ssn.reply(rep, env);
                numqAcks -= numInMsg;
                if (!this.DEBUG) continue;
                this.debug("handleRequest: sending replies: sent 1 queue reply; acks in msg= " + numInMsg + " more= " + more);
            }
            if (this.DEBUG) {
                this.debug("handleRequest: all Qacks sent");
            }
        }
        catch (IOException e) {
            if (this.DEBUG) {
                this.debug("Exception in request handler, aborting: " + e);
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            GuarAckExchanger guarAckExchanger3 = this;
            synchronized (guarAckExchanger3) {
                if (e instanceof EGeneralException) {
                    this.m_err = (EGeneralException)e;
                } else {
                    if (InterbrokerConfig.DEBUG) {
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                    this.m_err = new ENetworkFailure(151, e.toString());
                }
                this.m_reqHandlerRunning = false;
            }
            this.abort();
        }
        finally {
            GuarAckExchanger guarAckExchanger4 = this;
            synchronized (guarAckExchanger4) {
                this.m_reqHandlerRunning = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleReply(Envelope env) throws InterruptedException {
        block89: {
            GuarAckExchanger guarAckExchanger = this;
            synchronized (guarAckExchanger) {
                this.m_repHandlerRunning = true;
            }
            try {
                Message m = env.getMessage();
                if (m.readBoolean()) {
                    if (this.DEBUG) {
                        this.debug("handleReply: got final reply; remote has completed processing our acks");
                    }
                    this.m_neighbor.allXOnceAcksDone();
                    this.m_neighbor.allXOnceQAcksDone();
                    GuarAckExchanger guarAckExchanger2 = this;
                    synchronized (guarAckExchanger2) {
                        if (this.m_localReqDone) {
                            this.m_localReq.cancel();
                        }
                        this.m_remoteReqDone = true;
                        this.notifyAll();
                    }
                    if (this.DEBUG) {
                        this.debug("handleReply: done processing final reply");
                    }
                    break block89;
                }
                if (this.DEBUG) {
                    this.debug("handleReply: got reply to our request");
                }
                MsgSaver deleter = AgentRegistrar.getAgentRegistrar().getMsgSaver();
                boolean more = m.readBoolean();
                byte type = m.readByte();
                int ctp = 0;
                int ctq = 0;
                switch (type) {
                    case 1: {
                        try {
                            byte subType = m.readByte();
                            int numUntargeted = Integer.MAX_VALUE;
                            switch (subType) {
                                case 2: {
                                    numUntargeted = m.readInt();
                                }
                                case 4: {
                                    ClientAckEvt evt;
                                    IProxyingHandle proxying;
                                    IClientContext cc = null;
                                    try {
                                        cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_remoteId);
                                    }
                                    catch (EClientNotRegistered ecnr) {
                                        cc = this.m_neighbor.getClient();
                                    }
                                    for (int i = 0; i < numUntargeted; ++i) {
                                        long tracking = m.readLong();
                                        if (this.DEBUG) {
                                            this.debug("Deleting untargeted gax GUAR=" + tracking);
                                        }
                                        FastVector proxied = null;
                                        IClientContext ackClient = cc;
                                        ClientContextMgramQueue.InDoubtXOGroupSend idgs = null;
                                        if (cc != null) {
                                            proxied = cc.getProxyHandle().getProxyRecips(tracking);
                                            cc.removeLBSWrapperInfo(tracking);
                                            idgs = cc.removeInDoubtXOnceGroupSend(tracking);
                                            if (idgs != null) {
                                                tracking = idgs.gma.msgTracking;
                                            }
                                        }
                                        if (proxied != null) {
                                            for (int p = 0; p < proxied.m_count; ++p) {
                                                IClientContext proxiedCC = (IClientContext)proxied.m_data[p];
                                                if (this.DEBUG) {
                                                    this.debug("Deleting proxied gax GUAR=" + tracking + " CLIENT=" + proxiedCC.getId());
                                                }
                                                proxiedCC.getGuarDoubtManager().msgAcknowledged(tracking, true);
                                                proxying = cc.getProxyingHandle();
                                                if (proxying != null) {
                                                    proxying.removeInDoubtProxyMessage(tracking);
                                                }
                                                deleter.deleteMsgFlushPostponedSaves(proxiedCC.getId(), tracking, -1, false);
                                            }
                                        }
                                        if (cc != null) {
                                            if (idgs == null) {
                                                cc.getGuarDoubtManager().msgAcknowledged(tracking, true);
                                            } else {
                                                idgs.groupcc.getGuarDoubtManager().msgAcknowledged(tracking, true);
                                            }
                                        }
                                        evt = null;
                                        if (idgs == null) {
                                            evt = new ClientAckEvt(this.m_remoteId, tracking, null, proxied != null, true);
                                        } else {
                                            evt = new ClientAckEvt(idgs.groupcc.getId(), tracking, null, proxied != null, true);
                                            evt.setNotifyDelete(true);
                                        }
                                        AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
                                        if (idgs == null) {
                                            deleter.deleteMsgFlushPostponedSaves(this.m_remoteId, tracking, -1, true);
                                        } else {
                                            deleter.deleteMsgFlushPostponedSaves(idgs.groupcc.getId(), tracking, -1, true);
                                        }
                                        ++ctp;
                                    }
                                }
                                case 1: {
                                    ClientAckEvt evt;
                                    IProxyingHandle proxying;
                                    block52: while (true) {
                                        long tracking = m.readLong();
                                        long numClients = m.readInt();
                                        int i = 0;
                                        while (true) {
                                            if ((long)i >= numClients) continue block52;
                                            long clientID = m.readLong();
                                            if (this.DEBUG) {
                                                this.debug("Deleting targeted gax GUAR=" + tracking + " CLIENT=" + clientID);
                                            }
                                            evt = new ClientAckEvt(clientID, tracking, null, true);
                                            AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
                                            try {
                                                IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientID);
                                                cc.getGuarDoubtManager().msgAcknowledged(tracking, true);
                                                proxying = cc.getProxyingHandle();
                                                if (proxying != null) {
                                                    proxying.removeInDoubtProxyMessage(tracking);
                                                }
                                            }
                                            catch (EClientNotRegistered ecnr) {
                                                // empty catch block
                                            }
                                            deleter.deleteMsgFlushPostponedSaves(clientID, tracking, -1, true);
                                            ++ctp;
                                            ++i;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        catch (EOFException e) {}
                        break;
                    }
                    case 2: {
                        try {
                            while (true) {
                                long tracking = m.readLong();
                                this.m_neighbor.inDoubtQMsgAcknowledged(tracking);
                                ++ctq;
                            }
                        }
                        catch (EOFException e) {
                            // empty catch block
                        }
                    }
                }
                if (this.DEBUG) {
                    this.debug("handleReply: finished processing reply; " + ctp + " pubsub messages acknowledged");
                    this.debug("handleReply: finished processing reply; " + ctq + " queue messages acknowledged");
                }
                if (more) break block89;
                if (this.DEBUG) {
                    this.debug("handleReply: no more (nonfinal) replies");
                }
                if (this.DEBUG) {
                    this.debug("handleReply: GAX done, flushing deletes.");
                }
                try {
                    deleter.flush();
                }
                catch (InterruptedException e) {
                    throw new EInterrupted();
                }
                if (this.m_neighbor.getClient() != null) {
                    IProxyHandle ph = this.m_neighbor.getClient().getProxyHandle();
                    if (this.DEBUG) {
                        this.debug("handleReply: IProxyHandle ph = " + ph);
                    }
                    if (ph != null) {
                        ph.proxyDoubtResolved(false);
                    }
                }
                AgentRegistrar.getAgentRegistrar().getLogManager().flush();
                this.m_neighbor.allInDoubtQAcksReceived();
                GuarAckExchanger ph = this;
                synchronized (ph) {
                    while (this.m_remoteReq == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new EInterrupted();
                        }
                    }
                }
                if (this.DEBUG) {
                    this.debug("handleReply: sending our final reply; completed processing of acks");
                }
                Message rep = new Message();
                rep.writeBoolean(true);
                this.m_ssn.reply(rep, this.m_remoteReq);
                GuarAckExchanger guarAckExchanger3 = this;
                synchronized (guarAckExchanger3) {
                    if (this.m_remoteReqDone) {
                        this.m_localReq.cancel();
                    }
                    this.m_localReqDone = true;
                    this.notifyAll();
                }
                if (this.DEBUG) {
                    this.debug("handleReply: final reply sent");
                }
            }
            catch (IOException e) {
                if (this.DEBUG) {
                    this.debug("Exception in reply handler, aborting: " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                GuarAckExchanger guarAckExchanger4 = this;
                synchronized (guarAckExchanger4) {
                    if (e instanceof EGeneralException) {
                        this.m_err = (EGeneralException)e;
                    } else {
                        if (InterbrokerConfig.DEBUG) {
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                        this.m_err = new ENetworkFailure(151, e.toString());
                    }
                    this.m_repHandlerRunning = false;
                }
                this.abort();
            }
            finally {
                GuarAckExchanger guarAckExchanger5 = this;
                synchronized (guarAckExchanger5) {
                    this.m_repHandlerRunning = false;
                    this.notifyAll();
                }
            }
        }
    }

    private void sendClientSolicit() throws EGeneralException {
        if (this.DEBUG) {
            this.debug("sending client side solicit");
        }
        Label local = new Label();
        local.setRouteLimit(1);
        Message req = new Message(REQ_SUBJ);
        req.writeLong(this.m_localId);
        req.writeLong(this.m_token);
        this.m_localReq = this.m_ssn.solicit(new Envelope(req, local), this.m_repMH);
    }

    private void sendBrokerSolicit() throws EGeneralException {
        if (this.DEBUG) {
            this.debug("sending broker side solicit");
        }
        Message req = new Message(REQ_SUBJ);
        req.writeLong(this.m_localId);
        req.writeLong(this.m_token);
        this.m_localReq = ((InterbrokerSession)this.m_ssn).solicit(this.m_neighbor.getConnectID(), req, this.m_repMH, 0);
    }
}

