/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.EStartupFailure;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.interbroker.IBConfigBeanCache;
import progress.message.interbroker.IBConfigEvent;
import progress.message.interbroker.IBConfigListener;
import progress.message.interbroker.IBConfiguration;
import progress.message.interbroker.admin.EAlreadyInCluster;
import progress.message.interbroker.admin.EBrokerIsRunning;
import progress.message.interbroker.admin.EBrokerNotIsolated;
import progress.message.interbroker.admin.EClusterNotEmpty;
import progress.message.interbroker.admin.ECycleFormed;
import progress.message.interbroker.admin.EDuplicateClusterName;
import progress.message.interbroker.admin.ENoSuchCluster;
import progress.message.util.server.ByteBufferOutputStream;
import progress.message.zclient.Connection;

public class IBConfigBean {
    protected IBConfigBeanCache m_cache;
    protected Vector m_listeners = new Vector();

    static IBConfigBean createLocalBean(Connection serverConnection) throws EStartupFailure {
        try {
            IBConfigBean ret = new IBConfigBean();
            return ret;
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure("Error initializing interbroker config server: " + e);
        }
    }

    IBConfigBean() throws EDatabaseException {
        Hashtable h = BrokerComponent.getBrokerComponent().getPeerInfoTable();
        String clusterName = BrokerComponent.getBrokerComponent().getClusterName();
        this.m_cache = new IBConfigBeanCache(this, h, clusterName);
    }

    public synchronized void addIBConfigListener(IBConfigListener ibcl) {
        this.m_listeners.addElement(ibcl);
    }

    public synchronized void removeIBConfigListener(IBConfigListener ibcl) {
        this.m_listeners.removeElement(ibcl);
    }

    public synchronized long getStartTime() {
        return this.m_cache.getStartTime();
    }

    public synchronized IBConfiguration getConfiguration(String brokerName) {
        return this.m_cache.getConfiguration(brokerName);
    }

    public synchronized boolean existsBroker(int brokerUid) {
        return this.m_cache.existsBroker(brokerUid);
    }

    public synchronized void newCollective(String name) throws EDuplicateClusterName, IOException {
        this.newEvent(this.m_cache.prepareNewCollectiveEvent(name));
    }

    public synchronized void deleteCollective(String name) throws EClusterNotEmpty, IOException {
        this.newEvent(this.m_cache.prepareCollectiveDeletedEvent(name));
    }

    public synchronized void newBroker(String name, FTPairPeerInfoHolder info) throws EDatabaseException, IOException {
        this.newEvent(this.m_cache.prepareNewBrokerEvent(name, info));
    }

    public synchronized void deleteBroker(String name) throws EDatabaseException, EBrokerNotIsolated, EBrokerIsRunning, IOException {
        this.newEvent(this.m_cache.prepareBrokerDeletedEvent(name));
    }

    public synchronized void addBroker(String collective, String broker) throws ENoSuchCluster, EAlreadyInCluster, ECycleFormed, EDatabaseException, IOException {
        this.newEvent(this.m_cache.prepareBrokerAddedEvent(collective, broker));
    }

    public synchronized void removeBroker(String collective, String broker) throws EDatabaseException, IOException {
        this.newEvent(this.m_cache.prepareBrokerRemovedEvent(collective, broker));
    }

    public synchronized void setRouting(RoutingConnectionInfo routing, boolean setPassword) throws EDatabaseException, IOException {
        RoutingConnectionInfo old_rci = this.m_cache.getRoutingConfig().getRoutingConnection(routing.getRoutingNodeName());
        if (old_rci == null) {
            this.newEvent(this.m_cache.prepareRoutingAddedEvent(routing));
        } else {
            if (!setPassword) {
                routing.setPassword(old_rci.getPassword());
            }
            this.newEvent(this.m_cache.prepareRoutingUpdatedEvent(routing, setPassword));
        }
    }

    public synchronized void deleteRouting(String routingNodeName) throws EDatabaseException, IOException {
        this.newEvent(this.m_cache.prepareRoutingDeletedEvent(routingNodeName));
    }

    synchronized ByteBufferOutputStream getSerializedCache(ByteBufferOutputStream out) throws IOException {
        ByteBufferOutputStream bbos = null;
        bbos = out == null ? new ByteBufferOutputStream() : out;
        ObjectOutputStream oos = new ObjectOutputStream(bbos);
        oos.writeObject(this.m_cache);
        oos.flush();
        return bbos;
    }

    synchronized ByteBufferOutputStream getSerializedRoutingConfig(ByteBufferOutputStream out) throws IOException {
        ByteBufferOutputStream bbos = null;
        bbos = out == null ? new ByteBufferOutputStream() : out;
        DataOutputStream dos = new DataOutputStream(bbos);
        this.m_cache.getRoutingConfig().serialize(dos);
        dos.flush();
        return bbos;
    }

    protected void fireIBConfigEvent(IBConfigEvent evt) {
        if (evt.isRoutingConfigEvent()) {
            return;
        }
        int count = this.m_listeners.size();
        for (int i = 0; i < count; ++i) {
            ((IBConfigListener)this.m_listeners.elementAt(i)).IBConfigChanged(evt);
        }
    }

    private void newEvent(IBConfigEvent evt) throws EDatabaseException, IOException {
        if (evt != null) {
            this.m_cache.processEvent(evt);
            this.fireIBConfigEvent(evt);
        }
    }
}

