/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import progress.message.util.EAssertFailure;
import progress.message.zclient.Label;

class IBContentSubscription {
    static final int NOP = 0;
    static final int SUBSCRIBE = 1;
    static final int UNSUBSCRIBE = 2;
    static final int LABEL_CHANGE = 3;
    private String m_format;
    private short m_version;
    private String m_query;
    private int m_refcount;
    private int m_guarcount;

    IBContentSubscription(String format, short ver, String query) {
        this.m_format = format;
        this.m_version = ver;
        this.m_query = query;
    }

    int addRef(Label lab) {
        int ret = 0;
        if (this.m_refcount++ == 0) {
            ret = 1;
        }
        if (lab.isGuaranteed() && this.m_guarcount++ == 0 && ret != 1) {
            ret = 3;
        }
        if (this.m_refcount < 0 || this.m_guarcount < 0) {
            throw new EAssertFailure("Negative count in IB subscription to " + this.m_format + ": refcount " + this.m_refcount + ", guarcount " + this.m_guarcount);
        }
        return ret;
    }

    int removeRef(Label lab) {
        int ret = 0;
        if (--this.m_refcount == 0) {
            ret = 2;
        }
        if (lab.isGuaranteed() && --this.m_guarcount == 0 && ret != 2) {
            ret = 3;
        }
        if (this.m_refcount < 0 || this.m_guarcount < 0) {
            throw new EAssertFailure("Negative count in IB subscription to " + this.m_format + ": refcount " + this.m_refcount + ", guarcount " + this.m_guarcount);
        }
        return ret;
    }

    int updateRef(Label from, Label to) {
        boolean gto;
        int ret = 0;
        boolean gfrom = from.isGuaranteed();
        if (gfrom != (gto = to.isGuaranteed()) && (gfrom && --this.m_guarcount == 0 || gto && this.m_guarcount++ == 0)) {
            ret = 3;
        }
        if (this.m_refcount < 0 || this.m_guarcount < 0) {
            throw new EAssertFailure("Negative count in IB subscription to " + this.m_format + ": refcount " + this.m_refcount + ", guarcount " + this.m_guarcount);
        }
        return ret;
    }

    Label getLabel() {
        Label lab = new Label();
        lab.setGuaranteed(this.m_guarcount > 0);
        return lab;
    }

    String getFormatName() {
        return this.m_format;
    }

    short getVersion() {
        return this.m_version;
    }

    String getQuery() {
        return this.m_query;
    }
}

