/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import java.io.IOException;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentSender;
import progress.message.interbroker.Neighbor;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.ArrayUtil;

final class InterbrokerSender
extends AgentSender {
    private Neighbor m_neighbor;
    private long m_lastPingTime = -1L;

    InterbrokerSender(AgentConnection con, Neighbor n) throws IOException {
        super("InterbrokerSender of", con);
        this.m_neighbor = n;
    }

    @Override
    protected IMgram getPingMgram() {
        if (this.m_needExtendedPing) {
            byte[] payload = new byte[8];
            int totalConnections = AgentConnection.getClientConnectionCount();
            boolean hasNewConnections = AgentConnection.getMostRecentClientConnectTime() > this.m_lastPingTime;
            ArrayUtil.writeShort(payload, 0, (short)1);
            ArrayUtil.writeInt(payload, 2, totalConnections);
            ArrayUtil.writeShort(payload, 6, hasNewConnections ? (short)1 : 0);
            if (this.checkDebugFlags(16384)) {
                this.debug("publishing connection counts = " + totalConnections + " (" + (hasNewConnections ? "has" : "no") + " new connections since last ping)");
            }
            this.m_lastPingTime = System.currentTimeMillis();
            return MgramFactory.getMgramFactory().buildPingRequest(payload, 0);
        }
        return super.getPingMgram();
    }
}

