/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import progress.message.client.prAccessor;
import progress.message.jclient.Channel;
import progress.message.jclient.DeliveryMode;
import progress.message.jclient.DestinationFactory;
import progress.message.jimpl.BytesMessage;
import progress.message.jimpl.ChannelAdmin;
import progress.message.jimpl.ChannelAdminFactory;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.Destination;
import progress.message.jimpl.IXMessageFactory;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.MapMessage;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.MultiTopic;
import progress.message.jimpl.NativeMessage;
import progress.message.jimpl.ObjectMessage;
import progress.message.jimpl.Queue;
import progress.message.jimpl.QueueReceiver;
import progress.message.jimpl.QueueSender;
import progress.message.jimpl.Session;
import progress.message.jimpl.StreamMessage;
import progress.message.jimpl.TemporaryQueue;
import progress.message.jimpl.TemporaryTopic;
import progress.message.jimpl.TextMessage;
import progress.message.jimpl.Topic;
import progress.message.util.DestinationInfo;
import progress.message.util.DraDestUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.EPropertyCheckFailed;
import progress.message.util.PropertyChecker;
import progress.message.util.StringUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;

public class Message
implements progress.message.jclient.Message,
Cloneable {
    static boolean DEBUG = false;
    private static final String XMESSAGE_FACTORY_CLASS = "progress.message.jimpl.xmessage.XMessageFactory";
    private Channel m_channel = null;
    private javax.jms.Destination m_replyTo = null;
    int m_reenqueueCt = 1;
    protected Envelope m_zenvelope = null;
    boolean m_didFreeMem = false;
    boolean m_propertiesReadOnly = false;
    protected boolean m_bodyReadOnly = false;
    String m_messageID = null;
    MessageConsumer m_consumer = null;
    ConnectionConsumer m_ccConsumer = null;
    Session m_jsession = null;
    short m_replyToType = 0;
    public static final short TYPE_UNDEFINED = 0;
    public static final short TYPE_QUEUE = 1;
    public static final short TYPE_TOPIC = 2;
    public static final short NATIVE_MESSAGE_TYPE = 0;
    public static final short BASE_MESSAGE_TYPE = 1;
    public static final short BYTES_MESSAGE_TYPE = 2;
    public static final short MAP_MESSAGE_TYPE = 3;
    public static final short OBJECT_MESSAGE_TYPE = 4;
    public static final short STREAM_MESSAGE_TYPE = 5;
    public static final short TEXT_MESSAGE_TYPE = 6;
    public static final short XML_MESSAGE_TYPE = 7;

    public Message() {
        this(1);
    }

    public Message(short bodyType) {
        this.m_zenvelope = new Envelope(new progress.message.zclient.Message());
        this.m_zenvelope.setBodyType(bodyType);
    }

    public Message(Envelope envelope) {
        this.m_zenvelope = envelope;
    }

    protected Message(Message msg) {
        this.m_bodyReadOnly = msg.m_bodyReadOnly;
        this.m_ccConsumer = msg.m_ccConsumer;
        this.m_channel = msg.m_channel;
        this.m_consumer = msg.m_consumer;
        this.m_didFreeMem = msg.m_didFreeMem;
        this.m_jsession = msg.m_jsession;
        this.m_messageID = msg.m_messageID;
        this.m_propertiesReadOnly = msg.m_propertiesReadOnly;
        this.m_replyTo = msg.m_replyTo;
        this.m_replyToType = msg.m_replyToType;
        this.m_zenvelope = msg.m_zenvelope;
    }

    public static Message createMessage(Envelope envelope) throws JMSException {
        switch (envelope.getBodyType()) {
            case 0: {
                return new NativeMessage(envelope);
            }
            case 1: {
                String extType = envelope.getExtendedType();
                if (extType != null && !"".equals(extType)) {
                    return Message.createExtMessage(extType, envelope);
                }
                return new Message(envelope);
            }
            case 2: {
                return new BytesMessage(envelope);
            }
            case 3: {
                try {
                    return new MapMessage(envelope);
                }
                catch (IOException ioe) {
                    throw JMSExceptionUtil.createJMSException(ioe);
                }
            }
            case 4: {
                return new ObjectMessage(envelope);
            }
            case 5: {
                return new StreamMessage(envelope);
            }
            case 6: {
                return new TextMessage(envelope);
            }
            case 7: {
                return Message.createExtMessage("XMLMessageType", envelope);
            }
        }
        throw new MessageFormatException(prAccessor.getString("MSG_INVALID_BODY_TYPE"));
    }

    public Object clone() {
        try {
            Message msg = (Message)super.clone();
            msg.m_zenvelope = (Envelope)this.m_zenvelope.deepClone();
            return msg;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public int getBodySize() throws JMSException {
        this.marshal();
        return this.m_zenvelope.getMessage().getRawBodyLength();
    }

    public Object protectedClone() {
        try {
            Message msg = (Message)super.clone();
            msg.m_zenvelope = (Envelope)this.m_zenvelope.protectedClone();
            return msg;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    void unprotectSuccessor() {
        this.m_zenvelope.unprotectSuccessor();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            Message msg = (Message)obj;
            try {
                if (this.m_zenvelope.getOriginalMessageID().equals(msg.getEnvelope().getOriginalMessageID())) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_zenvelope.getOriginalMessageID().hashCode();
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        if (this.m_messageID == null) {
            this.m_messageID = this.m_zenvelope.getMessageID("ID:");
        }
        return this.m_messageID;
    }

    @Override
    public void setJMSMessageID(String id) throws JMSException {
        this.m_messageID = id;
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.m_zenvelope.getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.m_zenvelope.setTimestamp(timestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.m_zenvelope.getCorrelationID() == null) {
            return null;
        }
        return this.m_zenvelope.getCorrelationID().getBytes();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.m_zenvelope.setCorrelationID(new String(correlationID));
    }

    @Override
    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.m_zenvelope.setCorrelationID(correlationID);
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this.m_zenvelope.getCorrelationID();
    }

    @Override
    public javax.jms.Destination getJMSReplyTo() throws JMSException {
        return this.getReplyTo(false, false);
    }

    javax.jms.Destination getReplyTo(boolean internal, boolean saveToEnv) throws JMSException {
        String firstNodeInReplyTo;
        String currentNode;
        if (this.m_replyTo != null) {
            return this.m_replyTo;
        }
        ISubject replySubject = this.m_zenvelope.getReplySubject();
        if (replySubject != null && replySubject.isMultiSubject()) {
            throw new IllegalStateException(prAccessor.getString("MULTI_TOPIC_NOT_ALLOWED"));
        }
        String replyTo1 = this.m_zenvelope.getReplyTo();
        String replyTo2 = "";
        this.m_replyToType = Message.getDestinationType(replyTo1);
        if (this.m_replyToType == 0) {
            return null;
        }
        if (this.m_replyToType == 1) {
            replyTo1 = replyTo1.substring("$Q.".length());
        }
        Vector allRouting = this.m_zenvelope.getAllRouting();
        if (DEBUG) {
            Message.debug("getAllRouing returned nodes : " + allRouting);
        }
        replyTo2 = Message.getJMSReplyToInternal(replyTo1, this.adjustAllRouting(allRouting));
        if (DEBUG) {
            Message.debug("message.getReplyTo(), replyTo2: " + replyTo2 + " replyTo1 = " + replyTo1);
        }
        if (internal && allRouting != null && !allRouting.isEmpty() && (currentNode = (String)allRouting.firstElement()).length() > 0 && DestUtil.hasRoutingNode(replyTo2) && !currentNode.equals(firstNodeInReplyTo = replyTo2.substring(0, replyTo2.indexOf("::")))) {
            replyTo2 = currentNode + "::" + replyTo2;
            if (DEBUG) {
                Message.debug("message.getReplyTo() internal, replyTo2: " + replyTo2 + " replyTo1 = " + replyTo1);
            }
        }
        if (this.m_replyToType == 1) {
            if (saveToEnv && !replyTo2.equals(replyTo1)) {
                this.m_zenvelope.setReplyTo("$Q." + replyTo2);
                if (DEBUG) {
                    Message.debug("message.getReplyTo() save to env, : $Q." + replyTo2);
                }
            }
            Queue q = new Queue(replyTo2, true);
            return q;
        }
        if (saveToEnv && !replyTo2.equals(replyTo1)) {
            this.m_zenvelope.setReplyTo(replyTo2);
            if (DEBUG) {
                Message.debug("message.getReplyTo() save to env, : " + replyTo2);
            }
        }
        return new Topic(replyTo2, true);
    }

    private Vector adjustAllRouting(Vector allRouting) {
        if (allRouting == null || allRouting.size() <= 1) {
            return allRouting;
        }
        String localRoutingNodeName = null;
        if (this.m_jsession != null) {
            localRoutingNodeName = this.m_jsession.getJconnection().getRoutingNodeName();
        } else if (this.m_consumer != null) {
            localRoutingNodeName = this.m_consumer.getSession().getJconnection().getRoutingNodeName();
        }
        if (localRoutingNodeName != null && allRouting.contains(localRoutingNodeName) && allRouting.indexOf(localRoutingNodeName) > 0) {
            while (!((String)allRouting.firstElement()).equals(localRoutingNodeName)) {
                allRouting.removeElementAt(0);
            }
        }
        if (DEBUG) {
            Message.debug("adjustAllRouing for localRoutingNodeName: " + localRoutingNodeName + ", allRouting : " + allRouting);
        }
        return allRouting;
    }

    public static short getDestinationType(String destination) {
        if (destination == null || destination.length() == 0) {
            return 0;
        }
        if (destination.startsWith("$Q.")) {
            return 1;
        }
        return 2;
    }

    public static String getJMSReplyToInternal(String replyTo, Vector allRouting) {
        String routing;
        if (allRouting == null || allRouting.size() < 2) {
            return replyTo;
        }
        if (DEBUG) {
            Message.debug("in Message.getJMSReplyToInternal(), getallrouting v = " + allRouting + " replyTo = " + replyTo);
        }
        if ((routing = DestUtil.getRoutingName(replyTo)) != null) {
            int multihopIdx = routing.indexOf("::");
            if (multihopIdx != -1) {
                routing = routing.substring(0, multihopIdx);
                if (DEBUG) {
                    Message.debug("in Message.getJMSReplyToInternal(), multihop replyto, routing= " + routing);
                }
            }
            if (routing.equals((String)allRouting.lastElement())) {
                allRouting.removeElement(allRouting.lastElement());
                if (DEBUG) {
                    Message.debug("in Message.getJMSReplyToInternal(), after remove last allRouting = " + allRouting);
                }
                if (allRouting.size() < 2) {
                    return replyTo;
                }
            }
        }
        StringBuilder nodes = new StringBuilder();
        for (int i = 1; i < allRouting.size(); ++i) {
            nodes.append((String)allRouting.elementAt(i));
            nodes.append("::");
        }
        nodes.append(replyTo);
        if (DEBUG) {
            Message.debug("message.getJMSReplyToInternal(), adjust routing to: " + replyTo);
        }
        return nodes.toString();
    }

    @Override
    public void setJMSReplyTo(javax.jms.Destination replyTo) throws JMSException {
        String dest = null;
        if (replyTo == null) {
            this.m_zenvelope.setReplyTo(null);
            this.m_replyTo = null;
            return;
        }
        if (replyTo instanceof MultiTopic) {
            throw new InvalidDestinationException(prAccessor.getString("MULTI_TOPIC_NOT_ALLOWED"));
        }
        if (replyTo instanceof javax.jms.Topic) {
            if (!(replyTo instanceof progress.message.jclient.Topic)) {
                dest = ((javax.jms.Topic)replyTo).getTopicName();
                new Topic(dest);
            } else {
                dest = ((javax.jms.Topic)replyTo).getTopicName();
            }
            this.m_zenvelope.setReplyTo(dest);
            this.m_replyToType = (short)2;
        } else if (replyTo instanceof javax.jms.Queue) {
            dest = replyTo instanceof Queue ? ((Queue)replyTo).getFullName() : ((javax.jms.Queue)replyTo).getQueueName();
            this.m_zenvelope.setReplyTo("$Q." + dest);
            this.m_replyToType = 1;
        } else {
            throw new InvalidDestinationException(prAccessor.getString("MSG_UNKNOWN_DEST_TYPE") + replyTo.getClass().getName());
        }
        this.m_replyTo = replyTo;
    }

    void adjustJMSReplyTo(javax.jms.Destination destination, Session session, javax.jms.Destination replyTo) throws JMSException {
        javax.jms.Topic replyToTopic;
        if (replyTo == null) {
            return;
        }
        if (replyTo instanceof TemporaryQueue) {
            return;
        }
        String replyToRoutingNodeName = null;
        if (replyTo instanceof TemporaryTopic) {
            Topic replyToTopic2 = (Topic)replyTo;
            replyToRoutingNodeName = replyToTopic2.getRoutingNodeName();
            if (replyToRoutingNodeName != null) {
                this.m_zenvelope.setReplyTo(replyToRoutingNodeName + "::" + replyToTopic2.getTopicName());
                if (DEBUG) {
                    Message.debug("in Message.adjustJMSReplyTo() for tempT, setReplyTo: " + replyToRoutingNodeName + "::" + replyToTopic2.getTopicName());
                }
            }
            return;
        }
        String routingNodeName = DestUtil.getRoutingName(destination);
        String localRoutingNodeName = session.getJconnection().getRoutingNodeName();
        if (routingNodeName == null || routingNodeName.equals(localRoutingNodeName)) {
            return;
        }
        if (this.m_replyToType == 1) {
            javax.jms.Queue replyToQueue = (javax.jms.Queue)replyTo;
            if (DestUtil.getRoutingName(replyToQueue.getQueueName()) == null && localRoutingNodeName != null && (replyToRoutingNodeName = localRoutingNodeName) != null) {
                this.m_zenvelope.setReplyTo("$Q." + replyToRoutingNodeName + "::" + replyToQueue.getQueueName());
                if (DEBUG) {
                    Message.debug("in Message.adjustJMSReplyTo() for Queue, setReplyTo: $Q." + replyToRoutingNodeName + "::" + replyToQueue.getQueueName());
                }
            }
            return;
        }
        if (this.m_replyToType == 2 && DestUtil.getRoutingName((replyToTopic = (javax.jms.Topic)replyTo).getTopicName()) == null && localRoutingNodeName != null && (replyToRoutingNodeName = localRoutingNodeName) != null) {
            this.m_zenvelope.setReplyTo(replyToRoutingNodeName + "::" + replyToTopic.getTopicName());
            if (DEBUG) {
                Message.debug("in Message.adjustJMSReplyTo() for Topic, setReplyTo: " + replyToRoutingNodeName + "::" + replyToTopic.getTopicName());
            }
        }
    }

    @Override
    public javax.jms.Destination getJMSDestination() throws JMSException {
        ISubject subject = this.m_zenvelope.getMessage().getSubject();
        if (subject == null) {
            subject = this.m_zenvelope.getSubject();
        }
        if (subject != null) {
            return DestUtil.createDestination(this.m_zenvelope.getRouting(), subject);
        }
        return null;
    }

    void validateUndeliveredDestination(javax.jms.Destination dest, String localNodeName) throws JMSException {
        Destination sonicDest;
        String undelDestStr;
        try {
            undelDestStr = (String)this.m_zenvelope.getProperties().get("JMS_SonicMQ_destinationUndelivered");
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException(prAccessor.getString("MSG_INVALID_OBJ_TYPE"));
        }
        if (undelDestStr == null) {
            return;
        }
        DestinationInfo undelDest = new DestinationInfo(undelDestStr, localNodeName);
        String undelRouting = undelDest.getRouting();
        if (undelRouting == null || undelRouting.length() == 0) {
            undelRouting = localNodeName;
        }
        if (undelDest.isQueue()) {
            if (undelDest.getSubject().equals("SonicMQ.routingQueue")) {
                throw new InvalidDestinationException(prAccessor.getString("UNDEL_DEST_ROUTING_QUEUE"));
            }
            if (undelDest.getSubject().equals("SonicMQ.deadMessage") && !undelRouting.equals(localNodeName)) {
                throw new InvalidDestinationException(prAccessor.getString("UNDEL_DEST_DEAD_MESSAGE_QUEUE"));
            }
        }
        if ((sonicDest = (Destination)DestinationFactory.createSonicDestination(dest)) != null && !sonicDest.getSubject().isMultiSubject() && sonicDest.getSubject().isQueue() == undelDest.isQueue() && sonicDest.getSubject().getJMSName().equals(undelDest.getSubject())) {
            String destRouting = sonicDest.getRouting();
            if (destRouting == null || destRouting.length() == 0) {
                destRouting = localNodeName;
            }
            if (destRouting.equals(undelRouting)) {
                throw new InvalidDestinationException(prAccessor.getString("UNDEL_DEST_SAME_AS_MESSAGE_DEST"));
            }
        }
    }

    public static String createDestinationString(short type, String routing, String subject) {
        String string = routing = routing == null ? "" : routing + "::";
        if (type == 1) {
            return routing + subject.substring("$Q.".length());
        }
        return routing + subject;
    }

    @Override
    public void setJMSDestination(javax.jms.Destination destination) throws JMSException {
        if (destination instanceof Destination) {
            Destination d = (Destination)destination;
            this.m_zenvelope.setRouting(d.getRouting());
            this.m_zenvelope.getMessage().setSubject(d.getSubject().protectedClone());
            return;
        }
        String routing = DestUtil.getRoutingName(destination);
        this.m_zenvelope.setRouting(routing);
        try {
            if (destination instanceof javax.jms.Topic) {
                this.m_zenvelope.getMessage().setSubject(DestUtil.getDestinationName(destination));
            } else {
                this.m_zenvelope.getMessage().setSubject("$Q." + DestUtil.getDestinationName(destination));
            }
        }
        catch (ClassCastException cce) {
            throw new InvalidDestinationException(prAccessor.getString("MSG_DEST_NOT_Q"));
        }
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return Message.getJMSDeliveryMode(this.m_zenvelope.isPersistent(), this.m_zenvelope.isDiscardable(), this.m_zenvelope.isNonPersistentReplicated());
    }

    public static int getJMSDeliveryMode(boolean isPersistent, boolean isDiscardable, boolean isNonPersistentReplicated) {
        if (isNonPersistentReplicated) {
            return DeliveryMode.NON_PERSISTENT_REPLICATED;
        }
        if (isPersistent) {
            return 2;
        }
        if (isDiscardable) {
            return DeliveryMode.DISCARDABLE;
        }
        return 1;
    }

    @Override
    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        boolean isPersistent = deliveryMode == 2;
        boolean isDiscardable = deliveryMode == DeliveryMode.DISCARDABLE;
        boolean isNonPersistentReplicated = deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED;
        this.m_zenvelope.getLabel().setPersistent(isPersistent);
        this.m_zenvelope.setDiscardable(isDiscardable);
        this.m_zenvelope.getMgram().setNonPersistentReplicated(isNonPersistentReplicated);
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return this.m_zenvelope.isSuccessor();
    }

    @Override
    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.m_zenvelope.setSuccessor(redelivered);
    }

    public void setJMSRedelivered(boolean redelivered, boolean internalUser) throws JMSException {
        if (internalUser) {
            this.m_zenvelope.setSuccessor(redelivered);
        }
    }

    @Override
    public String getJMSType() throws JMSException {
        return this.m_zenvelope.getType();
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        this.m_zenvelope.setType(type);
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this.m_zenvelope.getExpirationTime();
    }

    @Override
    public void setJMSExpiration(long expiration) throws JMSException {
        this.m_zenvelope.getLabel().setExpirationTime(expiration);
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this.m_zenvelope.getPriority();
    }

    @Override
    public void setJMSPriority(int priority) throws JMSException {
        this.m_zenvelope.getLabel().setPriority((byte)(priority & 0xFF));
    }

    @Override
    public void clearProperties() throws JMSException {
        this.m_propertiesReadOnly = false;
        this.m_zenvelope.getProperties().clear();
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        return this.m_zenvelope.getProperty(name) != null;
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            return PropertyChecker.checkBooleanProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            return PropertyChecker.checkByteProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            return PropertyChecker.checkShortProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        if (property == null && name != null && "JMSXDeliveryCount".equals(name)) {
            return this.getJMSXDeliveryCount();
        }
        try {
            return PropertyChecker.checkIntProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            return PropertyChecker.checkLongProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            return PropertyChecker.checkFloatProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            return PropertyChecker.checkDoubleProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            return PropertyChecker.checkStringProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        return this.m_zenvelope.getProperty(name);
    }

    @Override
    public boolean isDestinationProperty(String name) {
        return name.equals("JMS_SonicMQ_destinationUndelivered") || name.equals("JMS_SonicMQ_undeliveredOriginalJMSDestination");
    }

    @Override
    public javax.jms.Destination getDestinationProperty(String name) throws JMSException {
        Object property = this.m_zenvelope.getProperty(name);
        try {
            if (!this.isDestinationProperty(name)) {
                throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
            }
            return PropertyChecker.checkDestinationProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MessageFormatException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        return this.m_zenvelope.getProperties().keys();
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (!this.isClientSettableProperty(name)) {
            return;
        }
        this.m_zenvelope.getProperties().put(name, value);
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (!this.isClientSettableProperty(name)) {
            return;
        }
        this.m_zenvelope.getProperties().put(name, value);
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (!this.isClientSettableProperty(name)) {
            return;
        }
        this.m_zenvelope.getProperties().put(name, value);
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (!this.isClientSettableProperty(name)) {
            return;
        }
        this.m_zenvelope.getProperties().put(name, value);
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (!this.isClientSettableProperty(name)) {
            return;
        }
        this.m_zenvelope.getProperties().put(name, value);
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (!this.isClientSettableProperty(name)) {
            return;
        }
        this.m_zenvelope.getProperties().put(name, Float.valueOf(value));
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (!this.isClientSettableProperty(name)) {
            return;
        }
        this.m_zenvelope.getProperties().put(name, value);
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (value == null) {
            if (this.m_zenvelope.getProperties().get(name) != null) {
                this.m_zenvelope.getProperties().remove(name);
            }
            if (name.equals("JMS_SonicMQ_destinationUndelivered")) {
                this.m_zenvelope.setUndeliveredDestination(false);
            }
        } else {
            if (!this.isClientSettableProperty(name)) {
                return;
            }
            int utfLen = StringUtil.lengthUTF(value) - 2;
            if (utfLen > 65535) {
                throw new JMSException(prAccessor.getString("STRING_PROPERTY_TOO_LARGE"), "-27");
            }
            if (name.equals("JMS_SonicMQ_destinationUndelivered")) {
                this.m_zenvelope.setUndeliveredDestination(true);
            }
            this.m_zenvelope.getProperties().put(name, value);
        }
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String) {
            int utfLen;
            if (!this.isClientSettableProperty(name)) {
                return;
            }
            if (value instanceof String && (utfLen = StringUtil.lengthUTF((String)value) - 2) > 65535) {
                throw new JMSException(prAccessor.getString("STRING_PROPERTY_TOO_LARGE"), "-27");
            }
            if (name.equals("JMS_SonicMQ_destinationUndelivered")) {
                this.m_zenvelope.setUndeliveredDestination(true);
            }
            this.m_zenvelope.getProperties().put(name, value);
        } else if (value == null) {
            if (this.m_zenvelope.getProperties().get(name) != null) {
                this.m_zenvelope.getProperties().remove(name);
            }
            if (name.equals("JMS_SonicMQ_destinationUndelivered")) {
                this.m_zenvelope.setUndeliveredDestination(false);
            }
        } else {
            throw new MessageFormatException(prAccessor.getString("MSG_INVALID_OBJ_TYPE"));
        }
    }

    @Override
    public void setDestinationProperty(String name, javax.jms.Destination value) throws JMSException {
        if (this.m_propertiesReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (value == null) {
            if (this.m_zenvelope.getProperties().get(name) != null) {
                this.m_zenvelope.getProperties().remove(name);
            }
            if (name.equals("JMS_SonicMQ_destinationUndelivered")) {
                this.m_zenvelope.setUndeliveredDestination(false);
            }
        } else {
            if (!this.isDestinationProperty(name)) {
                throw new MessageFormatException(prAccessor.getString("MSG_INVALID_OBJ_TYPE"));
            }
            if (!this.isClientSettableProperty(name)) {
                return;
            }
            if ((value = DestinationFactory.createSonicDestination(value)) instanceof MultiTopic) {
                throw new InvalidDestinationException(prAccessor.getString("MULTI_TOPIC_NOT_ALLOWED"));
            }
            String destStr = ((Destination)DestinationFactory.createSonicDestination(value)).getFullName();
            if (value instanceof Queue) {
                destStr = "$Q." + destStr;
            }
            this.m_zenvelope.getProperties().put(name, destStr);
            if (name.equals("JMS_SonicMQ_destinationUndelivered")) {
                this.m_zenvelope.setUndeliveredDestination(true);
            }
        }
    }

    private void removeProperty(String name) {
        if (this.m_zenvelope.getProperties().get(name) != null) {
            this.m_zenvelope.getProperties().remove(name);
        }
    }

    @Override
    public void acknowledgeAndForward(javax.jms.Destination destination) throws JMSException {
        this.acknowledgeAndForwardInternal(destination, this.getJMSDeliveryMode(), this.getJMSPriority(), this.getJMSExpiration());
    }

    @Override
    public void acknowledgeAndForward(javax.jms.Destination destination, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long expiration = timeToLive > 0L ? System.currentTimeMillis() + timeToLive : 0L;
        this.acknowledgeAndForwardInternal(destination, deliveryMode, priority, expiration);
    }

    private void acknowledgeAndForwardInternal(javax.jms.Destination dest, int deliveryMode, int priority, long expiration) throws JMSException {
        if (this.m_consumer == null || !(this.m_consumer instanceof javax.jms.QueueReceiver)) {
            throw new IllegalStateException(prAccessor.getString("NON_Q_RECEIVER"));
        }
        if (this.m_consumer.isClosing()) {
            throw new IllegalStateException(prAccessor.getString("Q_RECEIVER_CLOSED"));
        }
        if (this.m_consumer.getSession().getAcknowledgeMode() != 1004) {
            throw new IllegalStateException(prAccessor.getString("SINGLE_MSG_ACK_ONLY"));
        }
        if (dest == null) {
            throw new InvalidDestinationException(prAccessor.getString("DEST_Q_NULL"));
        }
        if (!(dest instanceof javax.jms.Queue)) {
            throw new InvalidDestinationException(prAccessor.getString("DEST_MUST_BE_Q"));
        }
        if (this.m_consumer.getSession().isAcknowledged(this)) {
            throw new IllegalStateException(prAccessor.getString("MESSAGE_ALREADY_ACKNOWLEDGED"));
        }
        if (this.m_consumer.getSession().getJconnection().isFaultTolerant()) {
            boolean forwardNonPersistentReplicated;
            boolean nonPersistentReplicated = this.m_zenvelope.isNonPersistentReplicated();
            boolean ackPersistent = this.m_zenvelope.getLabel().isPersistent() && !nonPersistentReplicated;
            boolean forwardPersistent = deliveryMode == 2;
            boolean bl = forwardNonPersistentReplicated = deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED;
            if (nonPersistentReplicated ^ forwardNonPersistentReplicated) {
                throw new IllegalStateException(prAccessor.getString("UNSUPPORTED_NPTF_AAF"));
            }
            if (ackPersistent ^ forwardPersistent) {
                throw new IllegalStateException(prAccessor.getString("UNSUPPORTED_AAF"));
            }
        } else if (deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED) {
            deliveryMode = 1;
        }
        this.m_zenvelope.setAcknowledgeAndForward();
        QueueSender.sendAckForward(this.m_consumer.getSession(), (javax.jms.Queue)dest, ((QueueReceiver)this.m_consumer).getClientID(), this.m_zenvelope.getGuarTracking(), this.m_zenvelope.getLabel().isPersistent() || this.m_zenvelope.isNonPersistentReplicated(), this.getReplyTo(true, false), deliveryMode, priority, expiration);
        this.m_consumer.getSession().acknowledge(this);
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this.m_consumer != null) {
            if (this.m_consumer.getSession().isClosing()) {
                throw this.m_consumer.getSession().getJMSObjectClosedException();
            }
            this.m_consumer.getSession().acknowledge(this);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.m_bodyReadOnly = false;
        this.m_zenvelope.setMessage(new progress.message.zclient.Message());
        this.m_zenvelope.getMgram().setBody(null);
        this.removeProperty("JMS_SonicMQ_CTS_Message");
    }

    @Override
    public Channel getChannel() throws JMSException {
        if (this.m_channel == null && this.hasChannel()) {
            try {
                if (!this.m_zenvelope.isUserAcked()) {
                    throw new IllegalStateException(prAccessor.getString("MESSAGE_UNACKED"));
                }
                ChannelAdmin channelAdmin = ChannelAdminFactory.getChannelAdminFactory().createChannelAdmin();
                channelAdmin.initChannelFromMessage(this, this.getConsumer().m_jconnection);
                this.m_channel = channelAdmin.getChannel();
            }
            catch (ClassNotFoundException e) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_NOT_FOUND"), "-2000", e);
            }
            catch (IllegalAccessException e) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_PERMISSION_DENIED"), "-2003", e);
            }
            catch (InstantiationException e) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_LOAD_EXCEPTION"), "-2002", e);
            }
        }
        return this.m_channel;
    }

    @Override
    public void setChannel(Channel channel) throws JMSException {
        this.m_channel = channel;
    }

    @Override
    public void setChannel(progress.message.jclient.Message message) throws JMSException {
        Message m = (Message)message;
        if (m.m_channel != null) {
            throw new IllegalStateException(prAccessor.getString("CHANNEL_IS_ACTIVE"));
        }
        if (!m.propertyExists("JMS_SonicMQ_channel")) {
            throw new IllegalStateException(prAccessor.getString("NO_CHANNEL_INFO"));
        }
        if (this.propertyExists("JMS_SonicMQ_channel") || this.m_channel != null) {
            throw new IllegalStateException(prAccessor.getString("MESSAGE_ALREADY_HAS_CHANNEL"));
        }
        this.getProperties().put("JMS_SonicMQ_channel", m.getStringProperty("JMS_SonicMQ_channel"));
    }

    @Override
    public boolean hasChannel() throws JMSException {
        if (this.m_channel == null) {
            return this.propertyExists("JMS_SonicMQ_channel");
        }
        return true;
    }

    public boolean hasChannelReference() {
        return this.m_channel != null;
    }

    void clearInternalBodyData() {
        this.m_zenvelope.clearInternalBodyData();
    }

    @Override
    public Hashtable getProperties() {
        return this.m_zenvelope.getProperties();
    }

    public void setPropertiesReadOnly(boolean readOnly) {
        this.m_propertiesReadOnly = readOnly;
    }

    public void setBodyReadOnly(boolean readOnly) {
        this.m_bodyReadOnly = readOnly;
    }

    public void marshal() throws JMSException {
    }

    public final Envelope getEnvelope() {
        return this.m_zenvelope;
    }

    void setMessageID(long brokerID, long messageID, String prefix) {
        this.m_zenvelope.setMessageID(brokerID, messageID, prefix);
    }

    void setConsumer(MessageConsumer consumer) {
        this.m_consumer = consumer;
    }

    public MessageConsumer getConsumer() {
        return this.m_consumer;
    }

    public void setConnectionConsumer(ConnectionConsumer ccConsumer, Session session, MessageConsumer consumer) {
        this.m_ccConsumer = ccConsumer;
        this.m_jsession = session;
        this.m_consumer = consumer;
    }

    public ConnectionConsumer getConnectionConsumer() {
        return this.m_ccConsumer;
    }

    public Session getSession() {
        return this.m_jsession;
    }

    private boolean isClientSettableProperty(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Property names cannot be null or empty strings");
        }
        return !name.startsWith("JMSX") || this.isClientSettableJMSXProperty(name);
    }

    private boolean isClientSettableJMSXProperty(String name) {
        if (name == null) {
            return false;
        }
        return "JMSXGroupID".equals(name) || "JMSXGroupSeq".equals(name);
    }

    public boolean isBodyReadOnly() {
        return this.m_bodyReadOnly;
    }

    private static Message createExtMessage(String extType, Envelope env) throws JMSException {
        if (extType == null) {
            return null;
        }
        if (!extType.equals("x-sonicmq-multipart") && !"XMLMessageType".equals(extType)) {
            return null;
        }
        IXMessageFactory factory = null;
        try {
            Class<?> c = Class.forName(XMESSAGE_FACTORY_CLASS);
            factory = (IXMessageFactory)c.newInstance();
        }
        catch (Exception e) {
            throw new EAssertFailure(prAccessor.getString("LOAD_CLASS_FAILED") + XMESSAGE_FACTORY_CLASS, e);
        }
        if (factory == null) {
            return null;
        }
        if (extType.equals("x-sonicmq-multipart")) {
            return (Message)((Object)factory.createMultipartMessage(env));
        }
        if ("XMLMessageType".equals(extType)) {
            return (Message)((Object)factory.createXMLMessage(env));
        }
        return null;
    }

    public String getExtendedType() throws JMSException {
        return this.m_zenvelope.getExtendedType();
    }

    public final void setExtendedType(String type) throws JMSException {
        if (type == null) {
            if (this.m_zenvelope.getExtendedType() != null) {
                this.m_zenvelope.getProperties().remove("JMS_SonicMQ_ExtendedType");
            }
        } else {
            this.m_zenvelope.setExtendedType(type);
        }
    }

    private static void debug(String s) {
        System.out.println(s);
    }

    void incrementReenqueue() {
        this.m_reenqueueCt = this.getReenqueued();
        this.setJMSXDeliveryCount(++this.m_reenqueueCt);
    }

    int getReenqueued() {
        if (this.getConnectionConsumer() != null) {
            return this.getJMSXDeliveryCount();
        }
        return this.m_reenqueueCt;
    }

    void setJMSXDeliveryCount(int count) {
        this.m_zenvelope.getProperties().put("JMSXDeliveryCount", count);
    }

    int getJMSXDeliveryCount() {
        Object count = this.m_zenvelope.getProperty("JMSXDeliveryCount");
        if (count == null) {
            return 1;
        }
        return (Integer)count;
    }

    protected void setDefaultRoutingForURLDestination(javax.jms.Destination dest) throws JMSException {
        if (DestUtil.getRoutingName(dest) == null && DraDestUtil.isHttpOrHttps(DestUtil.getDestinationName(dest))) {
            this.m_zenvelope.setRouting(DraDestUtil.SONIC_HTTP);
        }
    }
}

