/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xmessage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.Queue;
import progress.message.jimpl.Topic;
import progress.message.jimpl.xmessage.Part;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.TypedInputStream;
import progress.message.util.TypedOutputStream;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.Envelope;

class MessagePart
extends Part
implements progress.message.jclient.MessagePart {
    private Message m_message;

    MessagePart() {
    }

    MessagePart(javax.jms.Message msg, String type) throws JMSException {
        super(msg, type);
        this.m_message = (Message)msg;
    }

    void marshalMessage() throws JMSException {
        this.doMarshalIfNecessary();
        OutputStream os = this.getOutputStream();
        this.writeMgram(os);
    }

    void writeMgram(OutputStream os) throws JMSException {
        try {
            Envelope env = this.m_message.getEnvelope();
            env.setNonSecure();
            env.syncEnvelopeData();
            IMgram mgram = env.getMgram();
            mgram.sync();
            mgram.writeMgramToStream(os);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    void unpackMessage() throws JMSException {
        InputStream is = this.getInputStream();
        this.m_message = this.readMgram(is);
    }

    Message readMgram(InputStream is) throws JMSException {
        Message msg = null;
        try {
            IMgram mgram = MgramFactory.getMgramFactory().createMgram(is);
            Envelope env = new Envelope(mgram, false, null, null);
            env.setNonSecure();
            msg = Message.createMessage(env);
            msg.setPropertiesReadOnly(true);
            msg.setBodyReadOnly(true);
        }
        catch (EMgramFormatError emfe) {
            throw JMSExceptionUtil.createJMSException(emfe);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        return msg;
    }

    @Override
    public javax.jms.Message getMessage() {
        return this.m_message;
    }

    @Override
    public Object clone() {
        MessagePart part = (MessagePart)super.clone();
        part.m_message = (Message)this.m_message.protectedClone();
        return part;
    }

    private void doMarshalIfNecessary() throws JMSException {
        try {
            byte[] body = this.m_message.getEnvelope().getMessage().getBody();
            if (body == null || body.length == 0) {
                this.m_message.marshal();
            }
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    void marshalMessage(ObjectOutput out) throws JMSException {
        try {
            Hashtable properties;
            this.setReadOnly(false);
            TypedOutputStream os = new TypedOutputStream(new DataOutputStream(this.getOutputStream()));
            this.doMarshalIfNecessary();
            Envelope env = this.m_message.getEnvelope();
            os.writeShort(env.getBodyType());
            String extendedType = "";
            if (this.m_message.getExtendedType() != null) {
                extendedType = this.m_message.getExtendedType();
            }
            os.writeString(extendedType);
            byte[] body = env.getMessage().getBody();
            if (body == null) {
                os.writeInt(0);
            } else {
                os.writeInt(body.length);
                if (body.length > 0) {
                    os.writeBytes(body);
                }
            }
            Hashtable JMSHeaders = this.buildJMSHeaders(this.m_message);
            int tableSize = 0;
            if (JMSHeaders != null) {
                tableSize = JMSHeaders.size();
            }
            os.writeInt(tableSize);
            if (tableSize > 0) {
                Enumeration keys = JMSHeaders.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    os.writeString(key);
                    os.writeObject(JMSHeaders.get(key));
                }
            }
            tableSize = (properties = this.m_message.getProperties()) == null ? 0 : properties.size();
            os.writeInt(tableSize);
            if (tableSize > 0) {
                Enumeration enum2 = properties.keys();
                while (enum2.hasMoreElements()) {
                    String key = (String)enum2.nextElement();
                    os.writeString(key);
                    os.writeObject(properties.get(key));
                }
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    void unpackMessage(ObjectInput in) throws JMSException {
        try {
            int propertiesSize;
            TypedInputStream is = new TypedInputStream(new DataInputStream(this.getInputStream()));
            short JMSBodyType = is.readShort();
            String JMSExtendedType = is.readString();
            int bodySize = is.readInt();
            byte[] body = null;
            if (bodySize > 0) {
                body = new byte[bodySize];
                is.readBytes(body);
            }
            Envelope env = new Envelope(new progress.message.zclient.Message(body));
            env.setBodyType(JMSBodyType);
            if (!"".equals(JMSExtendedType)) {
                env.setExtendedType(JMSExtendedType);
            }
            this.m_message = Message.createMessage(env);
            int JMSHeadersSize = is.readInt();
            if (JMSHeadersSize > 0) {
                this.setJMSHeaders(JMSHeadersSize, is);
            }
            if ((propertiesSize = is.readInt()) > 0) {
                this.setProperties(propertiesSize, is);
            }
            this.internalSetContent(this.m_message, null);
            this.m_message.setPropertiesReadOnly(this.m_readOnly);
            this.m_message.setBodyReadOnly(this.m_readOnly);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    Hashtable buildJMSHeaders(Message message) throws JMSException {
        if (message == null) {
            return null;
        }
        Hashtable<String, Object> JMSHeaders = new Hashtable<String, Object>();
        try {
            if (message.getJMSCorrelationID() != null) {
                JMSHeaders.put("JMSCorrelationID", message.getJMSCorrelationID());
            }
            JMSHeaders.put("JMSDeliveryMode", message.getJMSDeliveryMode());
            Destination dest = message.getJMSDestination();
            if (dest != null) {
                String destString = dest.toString();
                if (dest instanceof javax.jms.Queue) {
                    destString = "$Q." + destString;
                }
                JMSHeaders.put("JMSDestination", destString);
            }
            JMSHeaders.put("JMSExpiration", message.getJMSExpiration());
            if (message.getJMSMessageID() != null) {
                JMSHeaders.put("JMSMessageID", message.getJMSMessageID());
            }
            JMSHeaders.put("JMSPriority", message.getJMSPriority());
            JMSHeaders.put("JMSRedelivered", message.getJMSRedelivered());
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo != null) {
                String replyToString = replyTo.toString();
                if (dest instanceof javax.jms.Queue) {
                    replyToString = "$Q." + replyToString;
                }
                JMSHeaders.put("JMSReplyTo", replyToString);
            }
            JMSHeaders.put("JMSTimestamp", message.getJMSTimestamp());
            if (message.getJMSType() != null) {
                JMSHeaders.put("JMSType", message.getJMSType());
            }
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        return JMSHeaders;
    }

    void setJMSHeaders(int headerSize, TypedInputStream in) throws JMSException {
        try {
            for (int i = 0; i < headerSize; ++i) {
                String key = in.readString();
                Object value = in.readObject();
                if ("JMSCorrelationID".equals(key)) {
                    this.m_message.setJMSCorrelationID((String)value);
                    continue;
                }
                if ("JMSDeliveryMode".equals(key)) {
                    this.m_message.setJMSDeliveryMode((Integer)value);
                    continue;
                }
                if ("JMSDestination".equals(key)) {
                    String JMSDestination = (String)value;
                    if (JMSDestination.startsWith("$Q.")) {
                        this.m_message.setJMSDestination(new Queue(JMSDestination.substring("$Q.".length()), true));
                        continue;
                    }
                    this.m_message.setJMSDestination(new Topic(JMSDestination, true));
                    continue;
                }
                if ("JMSExpiration".equals(key)) {
                    this.m_message.setJMSExpiration((Long)value);
                    continue;
                }
                if ("JMSMessageID".equals(key)) {
                    this.m_message.setJMSMessageID((String)value);
                    continue;
                }
                if ("JMSPriority".equals(key)) {
                    this.m_message.setJMSPriority((Integer)value);
                    continue;
                }
                if ("JMSRedelivered".equals(key)) {
                    this.m_message.setJMSRedelivered((Boolean)value, true);
                    continue;
                }
                if ("JMSReplyTo".equals(key)) {
                    String JMSReplyTo = (String)value;
                    if (JMSReplyTo.startsWith("$Q.")) {
                        this.m_message.setJMSDestination(new Queue(JMSReplyTo.substring("$Q.".length()), true));
                        continue;
                    }
                    this.m_message.setJMSDestination(new Topic(JMSReplyTo, true));
                    continue;
                }
                if ("JMSTimestamp".equals(key)) {
                    this.m_message.setJMSTimestamp((Long)value);
                    continue;
                }
                if (!"JMSType".equals(key)) continue;
                this.m_message.setJMSType((String)value);
            }
        }
        catch (IOException ie) {
            throw JMSExceptionUtil.createJMSException(ie);
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    void setProperties(int propertiesSize, TypedInputStream in) throws JMSException {
        try {
            for (int i = 0; i < propertiesSize; ++i) {
                String key = in.readString();
                Object value = in.readObject();
                this.m_message.setObjectProperty(key, value);
            }
        }
        catch (IOException ie) {
            throw JMSExceptionUtil.createJMSException(ie);
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }
}

