/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xmessage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.mail.util.ByteArrayDataSource;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.xmessage.Header;
import progress.message.jimpl.xmessage.MultipartMessage;

class Part
implements progress.message.jclient.Part,
progress.message.jclient.Header,
Cloneable {
    private static final String DEF_CHARSET;
    private static final boolean AUTO_ADD_CHARSET;
    protected Header m_header;
    protected Object m_contentObj;
    protected byte[] m_contentBytes;
    protected DataHandler m_dataHandler;
    protected boolean m_readOnly = false;
    protected ByteArrayInputStream m_bis;
    protected ByteArrayOutputStream m_bos = new ByteArrayOutputStream();
    protected int m_contentFormat;
    private static final int BYTES_CONTENT = 1;
    private static final int OBJ_CONTENT = 2;
    private static final int DH_CONTENT = 3;
    private static final String BYTES_CONTENT_TYPE = "java.lang.ByteArray";
    private static final String STRING_CONTENT_TYPE = "java.lang.String";
    private static final String FILE_CONTENT_TYPE = "java.io.File";
    private static final String USER_CONTENT_TYPE = "user_content_type";
    private MultipartMessage m_parentMM;
    private boolean MM_DEBUG = false;

    public Part() {
        this.m_header = new Header();
        this.m_header.setParentPart(this);
    }

    public Part(Object obj, String type) {
        this.createHeader(obj, type, null);
        this.m_contentFormat = 2;
        this.m_contentObj = obj;
        this.m_header.setParentPart(this);
    }

    public Part(DataHandler dataHandler) throws JMSException {
        Object contentObj = null;
        DataSource ds = dataHandler.getDataSource();
        if (ds != null && ds instanceof FileDataSource) {
            contentObj = null;
        } else {
            try {
                contentObj = dataHandler.getContent();
            }
            catch (IOException e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
        }
        this.createHeader(contentObj, dataHandler.getContentType(), dataHandler.getName());
        this.m_contentFormat = 3;
        this.m_dataHandler = dataHandler;
        this.m_header.setParentPart(this);
    }

    private void createHeader(Object obj, String type, String name) {
        if (obj == null) {
            if (name != null && !name.equals("")) {
                this.m_header = new Header(type, name, FILE_CONTENT_TYPE);
            }
        } else {
            this.m_header = obj instanceof String ? new Header(type, name, STRING_CONTENT_TYPE) : (obj instanceof byte[] ? new Header(type, name, BYTES_CONTENT_TYPE) : new Header(type, name, USER_CONTENT_TYPE));
        }
        if (this.m_header == null) {
            this.m_header = new Header();
        }
    }

    @Override
    public progress.message.jclient.Header getHeader() {
        return this.m_header;
    }

    @Override
    public DataHandler getDataHandler() throws JMSException {
        if (this.m_dataHandler != null) {
            return this.m_dataHandler;
        }
        Object obj = null;
        if (this.m_contentBytes != null) {
            obj = this.m_contentBytes;
        } else if (this.m_contentObj != null) {
            obj = this.m_contentObj;
        }
        if (obj != null) {
            return new DataHandler(obj, this.getContentType());
        }
        return null;
    }

    @Override
    public void setDataHandler(DataHandler dataHandler) throws JMSException {
        if (this.m_readOnly) {
            throw new MessageNotWriteableException("");
        }
        Object contentObj = null;
        DataSource ds = dataHandler.getDataSource();
        if (ds != null && ds instanceof FileDataSource) {
            this.m_contentObj = null;
            this.m_header.setXType(FILE_CONTENT_TYPE);
            this.m_header.setContentType(dataHandler.getContentType());
            this.m_header.setContentId(dataHandler.getName());
        } else {
            try {
                contentObj = dataHandler.getContent();
            }
            catch (IOException e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
            this.setContent(contentObj, dataHandler.getContentType());
        }
        this.m_dataHandler = dataHandler;
        this.m_contentFormat = 3;
        if (this.m_parentMM != null) {
            this.m_parentMM.setDirty(true);
        }
    }

    @Override
    public InputStream getInputStream() throws JMSException {
        if (this.m_bis != null) {
            return this.m_bis;
        }
        if (this.m_bos.size() > 0) {
            return new ByteArrayInputStream(this.m_bos.toByteArray());
        }
        try {
            switch (this.m_contentFormat) {
                case 1: {
                    return new ByteArrayInputStream(this.m_contentBytes);
                }
                case 2: {
                    this.m_dataHandler = new DataHandler(this.m_contentObj, this.getContentType());
                }
                case 3: {
                    DataSource ds = this.m_dataHandler.getDataSource();
                    Object obj = ds != null && ds instanceof FileDataSource ? null : this.m_dataHandler.getContent();
                    if (obj != null && obj instanceof String) {
                        return new ByteArrayInputStream(this.encodeStringContent((String)obj));
                    }
                    if (obj != null && obj instanceof byte[]) {
                        return new ByteArrayInputStream((byte[])obj);
                    }
                    return this.m_dataHandler.getInputStream();
                }
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws JMSException {
        if (this.m_readOnly) {
            throw new MessageNotWriteableException("");
        }
        return this.m_bos;
    }

    @Override
    public Object getContent() {
        if (this.m_contentObj != null) {
            return this.m_contentObj;
        }
        if (this.m_dataHandler != null) {
            try {
                return this.m_dataHandler.getContent();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public byte[] getContentBytes() {
        if (this.m_contentBytes != null) {
            return this.m_contentBytes;
        }
        Object obj = this.getContent();
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            try {
                return this.encodeStringContent((String)obj);
            }
            catch (UnsupportedEncodingException e) {
                return ((String)obj).getBytes();
            }
        }
        return null;
    }

    @Override
    public void setContent(Object object, String type) throws JMSException, MessageNotWriteableException {
        if (this.m_readOnly) {
            throw new MessageNotWriteableException("");
        }
        this.m_contentObj = object;
        if (object instanceof String) {
            this.m_header.setXType(STRING_CONTENT_TYPE);
        } else if (object instanceof byte[]) {
            this.m_header.setXType(BYTES_CONTENT_TYPE);
        } else {
            this.m_header.setXType(USER_CONTENT_TYPE);
        }
        this.m_header.setContentType(type);
        this.m_contentFormat = 2;
        if (this.m_parentMM != null) {
            this.m_parentMM.setDirty(true);
        }
    }

    @Override
    public void setContent(byte[] content) throws JMSException, MessageNotWriteableException {
        if (this.m_readOnly) {
            throw new MessageNotWriteableException("");
        }
        this.m_contentBytes = content;
        this.m_header.setXType(BYTES_CONTENT_TYPE);
        this.m_contentFormat = 1;
        if (this.m_parentMM != null) {
            this.m_parentMM.setDirty(true);
        }
    }

    @Override
    public String getContentId() {
        return this.m_header.getContentId();
    }

    @Override
    public void setContentId(String cid) throws JMSException, MessageNotWriteableException {
        this.m_header.setContentId(cid);
        if (this.m_parentMM != null) {
            this.m_parentMM.setDirty(true);
        }
    }

    @Override
    public void setContentType(String type) throws JMSException, MessageNotWriteableException {
        this.m_header.setContentType(type);
    }

    @Override
    public String getContentType() {
        return this.m_header.getContentType();
    }

    @Override
    public Enumeration getHeaderFieldNames() {
        return this.m_header.getHeaderFieldNames();
    }

    @Override
    public String getHeaderField(String name) {
        return this.m_header.getHeaderField(name);
    }

    @Override
    public String getHeaderField(String name, String value) {
        return this.m_header.getHeaderField(name, value);
    }

    @Override
    public void setHeaderField(String name, String value) throws JMSException, MessageNotWriteableException {
        this.m_header.setHeaderField(name, value);
        if (this.m_parentMM != null) {
            this.m_parentMM.setDirty(true);
        }
    }

    @Override
    public void removeHeaderField(String name) throws JMSException {
        this.m_header.removeHeaderField(name);
        if (this.m_parentMM != null) {
            this.m_parentMM.setDirty(true);
        }
    }

    @Override
    public void removeAllHeaders() throws JMSException {
        this.m_header.removeAllHeaders();
        if (this.m_parentMM != null) {
            this.m_parentMM.setDirty(true);
        }
    }

    void marshalHeader(ObjectOutput out) throws JMSException {
        this.addDefaultCharsetHeader();
        this.m_header.marshal(out);
    }

    void marshalPart(ObjectOutput out) throws JMSException {
        try {
            if (this.m_bos.size() > 0) {
                out.writeInt(this.m_bos.size());
                out.write(this.m_bos.toByteArray());
                return;
            }
            switch (this.m_contentFormat) {
                case 1: {
                    if (this.m_contentBytes == null) {
                        out.writeInt(0);
                    } else {
                        out.writeInt(this.m_contentBytes.length);
                        out.write(this.m_contentBytes);
                    }
                    return;
                }
                case 2: {
                    this.m_dataHandler = new DataHandler(this.m_contentObj, this.getContentType());
                }
                case 3: {
                    DataSource ds = this.m_dataHandler.getDataSource();
                    Object obj = null;
                    if (ds != null && ds instanceof FileDataSource) {
                        obj = null;
                    } else {
                        obj = this.m_dataHandler.getContent();
                        if (obj == null) {
                            out.writeInt(0);
                            return;
                        }
                    }
                    byte[] bytes = null;
                    if (obj != null && obj instanceof String) {
                        bytes = this.encodeStringContent((String)obj);
                        out.writeInt(bytes.length);
                        out.write(bytes);
                    } else if (obj != null && obj instanceof byte[]) {
                        bytes = (byte[])obj;
                        out.writeInt(bytes.length);
                        out.write(bytes);
                    } else {
                        this.m_dataHandler.writeTo((OutputStream)this.m_bos);
                        out.writeInt(this.m_bos.size());
                        out.write(this.m_bos.toByteArray());
                        if (this.MM_DEBUG) {
                            System.out.println("marshal out DH size  = " + this.m_bos.size());
                        }
                    }
                    return;
                }
            }
            if (this.m_contentBytes != null) {
                int len = this.m_contentBytes.length;
                out.writeInt(len);
                if (len > 0) {
                    out.write(this.m_contentBytes);
                }
            } else {
                out.writeInt(0);
            }
            return;
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private final void addDefaultCharsetHeader() throws JMSException {
        Object obj;
        if (AUTO_ADD_CHARSET && DEF_CHARSET != null && (obj = this.getContent()) != null && obj instanceof String && this.m_header.getHeaderField("x-sonicmq-text-charset") == null) {
            this.m_header.setHeaderField("x-sonicmq-text-charset", DEF_CHARSET);
        }
    }

    private final byte[] encodeStringContent(String content) throws UnsupportedEncodingException {
        String charset = this.m_header.getHeaderField("x-sonicmq-text-charset");
        if (charset != null) {
            return content.getBytes(charset);
        }
        if (AUTO_ADD_CHARSET && DEF_CHARSET != null) {
            return content.getBytes(DEF_CHARSET);
        }
        return content.getBytes();
    }

    private final String decodeStringContent(byte[] content) throws UnsupportedEncodingException {
        String charset = this.m_header.getHeaderField("x-sonicmq-text-charset");
        if (charset != null) {
            return new String(content, charset);
        }
        return new String(content);
    }

    void unpackHeader(ObjectInput in) throws JMSException {
        this.m_header.unpack(in);
    }

    void unpackContent(ObjectInput in) throws JMSException {
        try {
            int size = in.readInt();
            this.m_contentBytes = new byte[size];
            in.read(this.m_contentBytes);
            if (STRING_CONTENT_TYPE.equals(this.getXType())) {
                this.internalSetContent(this.decodeStringContent(this.m_contentBytes), null);
            } else if (USER_CONTENT_TYPE.equals(this.getXType())) {
                this.decodeUserContent();
            } else {
                this.internalSetContent(this.m_contentBytes, null);
            }
            this.m_bis = new ByteArrayInputStream(this.m_contentBytes);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private void decodeUserContent() {
        try {
            ByteArrayDataSource ds = new ByteArrayDataSource(this.m_contentBytes, this.getContentType());
            DataHandler dataHandler = new DataHandler((DataSource)ds);
            Object content = dataHandler.getContent();
            if (!(content instanceof InputStream)) {
                this.internalSetContent(content, dataHandler);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.internalSetContent(this.m_contentBytes, null);
    }

    void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        this.m_header.setReadOnly(readOnly);
    }

    void setHeader(Header header) {
        this.m_header = header;
    }

    @Override
    public boolean isMessagePart() {
        return this.m_header.isSonicmqMessageType();
    }

    public Object clone() {
        try {
            Part part = (Part)super.clone();
            part.m_header = (Header)this.m_header.clone();
            part.m_header.setParentPart(part);
            part.m_bos = new ByteArrayOutputStream();
            if (this.m_bos.size() > 0) {
                part.m_bos.write(this.m_bos.toByteArray());
            }
            return part;
        }
        catch (IOException e) {
            throw new InternalError(e.getMessage());
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    String getXType() {
        return this.m_header.getXType();
    }

    boolean isContentIdAlreadyExist(String contentId) {
        if (this.m_parentMM == null) {
            return false;
        }
        Part part = null;
        try {
            part = (Part)this.m_parentMM.getPart(contentId);
        }
        catch (JMSException e) {
            return false;
        }
        return part != null;
    }

    MultipartMessage getParentMM() {
        return this.m_parentMM;
    }

    void setParentMM(MultipartMessage mm) {
        this.m_parentMM = mm;
    }

    final void internalSetContent(Object object, DataHandler dataHandler) {
        this.m_contentObj = object;
        if (object instanceof byte[]) {
            this.m_contentFormat = 1;
            if (this.MM_DEBUG) {
                System.out.println("unpack get an obj of byte[] size  = " + ((byte[])object).length);
            }
        } else if (null != dataHandler) {
            this.m_dataHandler = dataHandler;
            this.m_contentFormat = 3;
        } else {
            this.m_contentFormat = 2;
        }
    }

    static {
        String defCharset = null;
        try {
            defCharset = System.getProperty("SonicMQ.DEFAULT_MULTIPART_TEXT_CHARSET");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (defCharset == null) {
            try {
                defCharset = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            }
            catch (Throwable thrown) {
                // empty catch block
            }
        }
        DEF_CHARSET = defCharset;
        boolean autoAddCharsest = true;
        try {
            autoAddCharsest = new Boolean(System.getProperty("SonicMQ.ADD_MULTIPART_CHARSET_HEADER", "false"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        AUTO_ADD_CHARSET = autoAddCharsest;
    }
}

