/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.EnhancedByteArrayOutputStream;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.util.TypedOutputStream;
import progress.message.zclient.ISidebandData;

public class SidebandData
implements Cloneable,
ISidebandData {
    static final short TYPE_FLAG = 1;
    static final short MESSAGEID_FLAG = 2;
    static final short CORRELATION_ID_FLAG = 4;
    static final short REPLY_TO_FLAG = 8;
    static final short TIMESTAMP_FLAG = 16;
    static final short ROUTING_FLAG = 32;
    static final short PROPERTIES_FLAG = 64;
    static final short GSA_PUB_FLAG = 256;
    private boolean m_sidebandDirty = true;
    private byte[] m_sidebandBuffer = null;
    short m_bodyType;
    String m_type;
    byte[] m_typeUTF = null;
    String m_correlationID;
    byte[] m_correlationIDUTF = null;
    String m_replyTo;
    byte[] m_replyToUTF = null;
    long m_timestamp;
    String m_routing;
    byte[] m_routingUTF;
    boolean m_isGSAPublication = false;
    long m_brokerID;
    long m_messageID;
    byte[] m_brokerMessageIDPrefixUTF = null;
    boolean m_hasMessageID = false;
    int m_serializedLength = 0;
    private boolean m_isReadOnly = false;
    private Hashtable m_properties;
    private static int s_sbMemLength = MemoryUtil.estimateBaseSize(SidebandData.class);

    @Override
    public Object clone() {
        try {
            SidebandData sidebandData = (SidebandData)super.clone();
            if (this.m_properties != null) {
                sidebandData.m_properties = (Hashtable)this.m_properties.clone();
            }
            if (!this.m_sidebandDirty) {
                sidebandData.m_sidebandBuffer = new byte[this.m_sidebandBuffer.length];
                System.arraycopy(this.m_sidebandBuffer, 0, sidebandData.m_sidebandBuffer, 0, this.m_sidebandBuffer.length);
            }
            return sidebandData;
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure(e.toString(), e);
        }
    }

    @Override
    public Object shallowClone() {
        try {
            SidebandData sidebandData = (SidebandData)super.clone();
            if (this.m_properties != null) {
                sidebandData.m_properties = (Hashtable)this.m_properties.clone();
            }
            return sidebandData;
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure(e.toString(), e);
        }
    }

    @Override
    public short getBodyType() {
        return this.m_bodyType;
    }

    @Override
    public void setBodyType(short bodyType) {
        this.checkReadOnly();
        this.m_bodyType = bodyType;
        this.m_sidebandDirty = true;
    }

    @Override
    public String getType() {
        if (this.m_type == null && this.m_typeUTF != null) {
            try {
                this.m_type = StringUtil.UTFToString(this.m_typeUTF, 0);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
        }
        return this.m_type;
    }

    @Override
    public void setType(String type) {
        this.checkReadOnly();
        this.m_type = type;
        if (type != null && !"".equals(type)) {
            try {
                this.m_typeUTF = StringUtil.stringToUTF(type);
            }
            catch (UTFDataFormatException uTFDataFormatException) {}
        } else {
            this.m_typeUTF = null;
        }
        this.m_sidebandDirty = true;
    }

    @Override
    public void setMessageID(long brokerID, long messageID, String prefix) {
        this.checkReadOnly();
        try {
            this.m_brokerID = brokerID;
            this.m_messageID = messageID;
            this.m_brokerMessageIDPrefixUTF = (byte[])(prefix != null ? StringUtil.stringToUTF(prefix) : null);
        }
        catch (UTFDataFormatException e) {
            // empty catch block
        }
        this.m_hasMessageID = true;
        this.m_sidebandDirty = true;
    }

    @Override
    public long getBrokerID() {
        return this.m_brokerID;
    }

    @Override
    public long getConnectionAndLocalID() {
        return this.m_messageID;
    }

    @Override
    public String getCorrelationID() {
        if (this.m_correlationID == null && this.m_correlationIDUTF != null) {
            try {
                this.m_correlationID = StringUtil.UTFToString(this.m_correlationIDUTF, 0);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
        }
        return this.m_correlationID;
    }

    @Override
    public void setCorrelationID(String correlationID) {
        this.checkReadOnly();
        this.m_correlationID = correlationID;
        if (correlationID != null && !"".equals(correlationID)) {
            try {
                this.m_correlationIDUTF = StringUtil.stringToUTF(correlationID);
            }
            catch (UTFDataFormatException uTFDataFormatException) {}
        } else {
            this.m_correlationIDUTF = null;
        }
        this.m_sidebandDirty = true;
    }

    @Override
    public String getReplyTo() {
        if (this.m_replyTo == null && this.m_replyToUTF != null) {
            try {
                this.m_replyTo = StringUtil.UTFToString(this.m_replyToUTF, 0);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
        }
        return this.m_replyTo;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.checkReadOnly();
        this.m_replyTo = replyTo;
        if (replyTo != null && !"".equals(replyTo)) {
            try {
                this.m_replyToUTF = StringUtil.stringToUTF(replyTo);
            }
            catch (UTFDataFormatException uTFDataFormatException) {}
        } else {
            this.m_replyToUTF = null;
        }
        this.m_sidebandDirty = true;
    }

    public String getRouting() {
        if (this.m_routing == null && this.m_routingUTF != null) {
            try {
                this.m_routing = StringUtil.UTFToString(this.m_routingUTF, 0);
            }
            catch (UTFDataFormatException e) {
                // empty catch block
            }
        }
        if (this.m_routing == null) {
            return null;
        }
        int pos = -1;
        pos = this.m_routing.indexOf("::");
        if (pos != -1) {
            return this.m_routing.substring(0, pos);
        }
        pos = this.m_routing.indexOf("$$");
        if (pos != -1) {
            return this.m_routing.substring(0, pos);
        }
        return this.m_routing;
    }

    public boolean isGSAPublication() {
        return this.m_isGSAPublication;
    }

    public void setGSAPublication(boolean b) {
        this.checkReadOnly();
        this.m_isGSAPublication = b;
        this.m_sidebandDirty = true;
    }

    public void setRouting(String routing) {
        this.checkReadOnly();
        this.m_routing = routing;
        if (this.m_routing != null && !"".equals(this.m_routing)) {
            try {
                this.m_routingUTF = StringUtil.stringToUTF(this.m_routing);
            }
            catch (UTFDataFormatException uTFDataFormatException) {}
        } else {
            this.m_routingUTF = null;
        }
        this.m_sidebandDirty = true;
    }

    public void addNodeToPath(String node) {
        this.checkReadOnly();
        String r = this.getRouting();
        if (r == null || "".equals(r)) {
            this.m_routing = node;
        } else if (node != null && !"".equals(node) && !node.equals(r)) {
            this.m_routing = node + "$$" + this.m_routing;
        }
        if (this.m_routing != null && !"".equals(this.m_routing)) {
            try {
                this.m_routingUTF = StringUtil.stringToUTF(this.m_routing);
            }
            catch (UTFDataFormatException uTFDataFormatException) {}
        } else {
            this.m_routingUTF = null;
        }
        this.m_sidebandDirty = true;
    }

    public Vector getAllRouting() {
        Vector<String> allNodes = new Vector<String>();
        if (this.m_routing == null && this.m_routingUTF != null) {
            try {
                this.m_routing = StringUtil.UTFToString(this.m_routingUTF, 0);
            }
            catch (UTFDataFormatException e) {
                // empty catch block
            }
        }
        if (this.m_routing != null) {
            String SEP1 = "$$";
            String SEP2 = "::";
            String separator = null;
            if (this.m_routing.indexOf("$$") != -1) {
                separator = "$$";
            } else if (this.m_routing.indexOf("::") != -1) {
                separator = "::";
            }
            if (separator == null) {
                allNodes.add(this.m_routing);
            } else {
                String routingString = this.m_routing;
                while (routingString != null && routingString.length() > 0) {
                    int i = routingString.indexOf(separator);
                    if (i != -1) {
                        allNodes.add(routingString.substring(0, i));
                        routingString = routingString.substring(i + separator.length());
                        continue;
                    }
                    allNodes.add(routingString);
                    routingString = null;
                }
            }
        }
        return allNodes;
    }

    public String getAllRoutingString() {
        this.getRouting();
        return this.m_routing;
    }

    public boolean isNodeInPath(String targetNode) {
        if (targetNode == null || "".equals(targetNode)) {
            return false;
        }
        Vector nodes = this.getAllRouting();
        return nodes != null && nodes.contains(targetNode);
    }

    public boolean isMultiHopRouting() {
        this.getRouting();
        return this.m_routing != null && this.m_routing.indexOf("::") != -1;
    }

    public void removeNextRouting(String targetNode) {
        String newRouting;
        if (targetNode == null || targetNode.length() == 0) {
            return;
        }
        String r = this.getRouting();
        if (r != null && r.length() > 0 && !r.equals(targetNode)) {
            return;
        }
        this.m_routing = newRouting = this.m_routing.substring(2 + (r != null ? r.length() : 0));
        if (this.m_routing != null && !"".equals(this.m_routing)) {
            try {
                this.m_routingUTF = StringUtil.stringToUTF(this.m_routing);
            }
            catch (UTFDataFormatException e) {}
        } else {
            this.m_routingUTF = null;
        }
        this.m_sidebandDirty = true;
    }

    public String getSourceRoutingNode() {
        if (this.m_routing == null && this.m_routingUTF != null) {
            try {
                this.m_routing = StringUtil.UTFToString(this.m_routingUTF, 0);
            }
            catch (UTFDataFormatException e) {
                // empty catch block
            }
        }
        if (this.m_routing == null) {
            return null;
        }
        int pos = this.m_routing.lastIndexOf("$$");
        if (pos == -1) {
            return null;
        }
        return this.m_routing.substring(2 + pos);
    }

    @Override
    public long getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.checkReadOnly();
        this.m_timestamp = timestamp;
        this.m_sidebandDirty = true;
    }

    @Override
    public Hashtable getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new Hashtable();
        }
        this.m_sidebandDirty = true;
        return this.m_properties;
    }

    @Override
    public Object getProperty(String property) {
        if (this.m_properties == null) {
            return null;
        }
        return this.m_properties.get(property);
    }

    @Override
    public void setProperties(Hashtable properties) {
        this.checkReadOnly();
        this.m_properties = (Hashtable)properties.clone();
        this.m_sidebandDirty = true;
    }

    @Override
    public int getSerializedLength() {
        this.sync();
        return this.m_serializedLength;
    }

    @Override
    public int memoryLength() {
        this.sync();
        return s_sbMemLength + this.m_serializedLength * 2;
    }

    @Override
    public byte[] toByteArray() {
        this.sync();
        byte[] result = new byte[this.m_serializedLength];
        System.arraycopy(this.m_sidebandBuffer, 0, result, 0, this.m_serializedLength);
        return result;
    }

    @Override
    public int fromByteArray(byte[] data, int offset) {
        this.checkReadOnly();
        int size = 0;
        int count = 0;
        try {
            int usize;
            size = ArrayUtil.readInt(data, 0);
            this.m_bodyType = ArrayUtil.readShort(data, count += 4);
            short flags = ArrayUtil.readShort(data, count += 2);
            count += 2;
            boolean bl = this.m_isGSAPublication = (flags & 0x100) != 0;
            if ((flags & 1) != 0) {
                usize = ArrayUtil.getUTFStringLength(data, count);
                this.m_typeUTF = new byte[usize];
                System.arraycopy(data, count, this.m_typeUTF, 0, usize);
                count += usize;
            }
            if ((flags & 2) != 0) {
                this.m_hasMessageID = true;
                usize = ArrayUtil.getUTFStringLength(data, count);
                this.m_brokerMessageIDPrefixUTF = new byte[usize];
                System.arraycopy(data, count, this.m_brokerMessageIDPrefixUTF, 0, usize);
                this.m_brokerID = ArrayUtil.readLong(data, count += usize);
                this.m_messageID = ArrayUtil.readLong(data, count += 8);
                count += 8;
            }
            if ((flags & 4) != 0) {
                usize = ArrayUtil.getUTFStringLength(data, count);
                this.m_correlationIDUTF = new byte[usize];
                System.arraycopy(data, count, this.m_correlationIDUTF, 0, usize);
                count += usize;
            }
            if ((flags & 8) != 0) {
                usize = ArrayUtil.getUTFStringLength(data, count);
                this.m_replyToUTF = new byte[usize];
                System.arraycopy(data, count, this.m_replyToUTF, 0, usize);
                count += usize;
            }
            if ((flags & 0x10) != 0) {
                this.m_timestamp = ArrayUtil.readLong(data, count);
                count += 8;
            }
            if ((flags & 0x20) != 0) {
                usize = ArrayUtil.getUTFStringLength(data, count);
                this.m_routingUTF = new byte[usize];
                System.arraycopy(data, count, this.m_routingUTF, 0, usize);
                count += usize;
            }
            if ((flags & 0x40) != 0) {
                int nProperties = ArrayUtil.readInt(data, count);
                count += 4;
                this.m_properties = new Hashtable(nProperties);
                for (int i = 0; i < nProperties; ++i) {
                    int stringLength = ArrayUtil.getUTFStringLength(data, count);
                    String key = ArrayUtil.getUTFString(data, count);
                    int objectLength = ArrayUtil.getObjectSize(data, count += stringLength);
                    Object object = ArrayUtil.readObject(data, count);
                    count += objectLength;
                    this.m_properties.put(key, object);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_serializedLength = size;
        this.m_sidebandBuffer = data;
        this.m_sidebandDirty = false;
        return size;
    }

    @Override
    public boolean isDirty() {
        return this.m_sidebandDirty;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        this.sync();
        os.write(this.m_sidebandBuffer, 0, this.m_serializedLength);
    }

    @Override
    public int readFromStream(InputStream is) throws IOException {
        this.checkReadOnly();
        int sidebandSize = StreamUtil.readInt(is);
        this.m_sidebandBuffer = new byte[sidebandSize];
        ArrayUtil.writeInt(this.m_sidebandBuffer, 0, sidebandSize);
        StreamUtil.readBytes(is, this.m_sidebandBuffer, 4, sidebandSize - 4);
        this.fromByteArray(this.m_sidebandBuffer, 0);
        return sidebandSize;
    }

    @Override
    public void sync() {
        if (this.isDirty() && !this.m_isReadOnly) {
            byte[] bytes = this.getNewByteArray();
            this.m_sidebandBuffer = bytes;
            this.m_serializedLength = ArrayUtil.readInt(bytes, 0);
            this.m_sidebandDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getNewByteArray() {
        EnhancedByteArrayOutputStream byteStream = new EnhancedByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeInt(0);
            dataStream.writeShort(this.m_bodyType);
            int flags = 0;
            if (this.m_type != null && !"".equals(this.m_type)) {
                flags = (short)(flags | 1);
            }
            if (this.m_hasMessageID) {
                flags = (short)(flags | 2);
            }
            if (this.m_correlationID != null && !"".equals(this.m_correlationID)) {
                flags = (short)(flags | 4);
            }
            if (this.m_replyTo != null && !"".equals(this.m_replyTo)) {
                flags = (short)(flags | 8);
            }
            if (this.m_timestamp != 0L) {
                flags = (short)(flags | 0x10);
            }
            if (this.m_routing != null) {
                flags = (short)(flags | 0x20);
            }
            if (this.m_properties != null && !this.m_properties.isEmpty()) {
                flags = (short)(flags | 0x40);
            }
            if ((flags & 1) == 0 && this.m_type == null && this.m_typeUTF != null) {
                flags = (short)(flags | 1);
            }
            if ((flags & 8) == 0 && this.m_replyTo == null && this.m_replyToUTF != null) {
                flags = (short)(flags | 8);
            }
            if ((flags & 0x20) == 0 && this.m_routing == null && this.m_routingUTF != null) {
                flags = (short)(flags | 0x20);
            }
            if ((flags & 4) == 0 && this.m_correlationID == null && this.m_correlationIDUTF != null) {
                flags = (short)(flags | 4);
            }
            if (this.m_isGSAPublication) {
                flags = (short)(flags | 0x100);
            }
            dataStream.writeShort(flags);
            if ((flags & 1) != 0) {
                if (this.m_typeUTF != null) {
                    dataStream.write(this.m_typeUTF);
                } else {
                    dataStream.writeUTF(this.m_type);
                }
            }
            if ((flags & 2) != 0) {
                dataStream.write(this.m_brokerMessageIDPrefixUTF);
                dataStream.writeLong(this.m_brokerID);
                dataStream.writeLong(this.m_messageID);
            }
            if ((flags & 4) != 0) {
                if (this.m_correlationIDUTF != null) {
                    dataStream.write(this.m_correlationIDUTF);
                } else {
                    dataStream.writeUTF(this.m_correlationID);
                }
            }
            if ((flags & 8) != 0) {
                if (this.m_replyToUTF != null) {
                    dataStream.write(this.m_replyToUTF);
                } else {
                    dataStream.writeUTF(this.m_replyTo);
                }
            }
            if ((flags & 0x10) != 0) {
                dataStream.writeLong(this.m_timestamp);
            }
            if ((flags & 0x20) != 0) {
                if (this.m_routingUTF != null) {
                    dataStream.write(this.m_routingUTF);
                } else {
                    dataStream.writeUTF(this.m_routing);
                }
            }
            if ((flags & 0x40) != 0) {
                Hashtable hashtable = this.m_properties;
                synchronized (hashtable) {
                    dataStream.writeInt(this.m_properties.size());
                    if (!this.m_properties.isEmpty()) {
                        TypedOutputStream typedStream = new TypedOutputStream(dataStream);
                        Enumeration keys = this.m_properties.keys();
                        Enumeration elements = this.m_properties.elements();
                        while (keys.hasMoreElements()) {
                            dataStream.writeUTF((String)keys.nextElement());
                            typedStream.writeObject(elements.nextElement());
                        }
                    }
                }
            }
            byteStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] bytes = byteStream.getBuffer();
        ArrayUtil.writeInt(bytes, 0, byteStream.getBufferSize());
        return bytes;
    }

    @Override
    public byte[] getRawSidebandBuffer() {
        this.sync();
        return this.m_sidebandBuffer;
    }

    @Override
    public void setSidebandBuffer(byte[] sideband) {
        this.checkReadOnly();
        this.m_sidebandBuffer = sideband;
        this.m_sidebandDirty = false;
        this.m_serializedLength = sideband.length;
    }

    @Override
    public void setReadOnly() {
        this.m_isReadOnly = true;
    }

    @Override
    public void disableReadOnly() {
        this.m_isReadOnly = false;
    }

    private void checkReadOnly() {
        if (this.m_isReadOnly) {
            throw new EAssertFailure("Sideband data is read-only");
        }
    }
}

