/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import progress.message.msg.v25.DynamicHeader;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.SecureDynamicHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.SessionConfig;

public final class DefaultDynamicHeader
extends DynamicHeader {
    static final int s_dhMemSize = MemoryUtil.estimateBaseSize(DefaultDynamicHeader.class);
    private int m_messageLen = 0;
    private static final int DEFAULT_DYNAMIC_HEADER_LEN = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.println("Message Length: " + this.getMessageLength());
        }
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        return super.clone(m);
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        return super.shallowClone(m);
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        return super.clone(m);
    }

    @Override
    public void protect() {
    }

    public DefaultDynamicHeader(Mgram m) {
        super(m);
    }

    @Override
    void initDynamicHeaderFromStream(InputStream is) throws IOException {
        this.m_messageLen = StreamUtil.readInt(is);
        this.m_mgram.setStatus(2);
    }

    @Override
    public int getMessageLength() {
        int length;
        if (this.m_mgram == null || this.m_mgram.getStatus() < 3) {
            return this.m_messageLen;
        }
        this.m_messageLen = length = this.m_mgram.getPayloadLength();
        return this.m_messageLen;
    }

    @Override
    public byte[] toByteArray() {
        byte[] result = new byte[4];
        if (this.m_mgram != null) {
            ArrayUtil.writeInt(result, 0, this.m_mgram.getPayloadLength());
        } else {
            ArrayUtil.writeInt(result, 0, this.m_messageLen);
        }
        return result;
    }

    @Override
    int length() {
        return 4;
    }

    @Override
    public void setMessageLength(int length) {
        this.m_messageLen = length;
    }

    public static void setMessageLength(int length, byte[] buffer) {
        ArrayUtil.writeInt(buffer, 0, length);
    }

    @Override
    int memoryLength() {
        return s_dhMemSize;
    }

    @Override
    void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeInt(this.getMessageLength(), os);
    }

    @Override
    void writeToStream(OutputStream os, IMessageProtection m_mp) throws IOException {
        this.writeToStream(os);
    }

    @Override
    public void writeToStream(OutputStream os, IMessageProtection mp, byte[] messageKey, byte[] digest) throws IOException {
        this.writeToStream(os);
    }

    @Override
    void sync() {
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    DynamicHeader getSecureDynamicHeader(IMessageProtection mp) {
        SecureDynamicHeader sdh = new SecureDynamicHeader(mp, this);
        return sdh;
    }

    @Override
    DynamicHeader getNonSecureDynamicHeader() {
        return this;
    }
}

