/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import java.util.LinkedList;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IDefaultPayloadHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.DefaultPayloadInputWrapper;
import progress.message.msg.v25.DefaultPayloadOutputWrapper;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.Payload;
import progress.message.msg.v25.SidebandData;
import progress.message.resources.prMessageFormat;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.CryptoInfo;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectUtil;
import progress.message.zclient.prAccessor;

public class DefaultPayload
extends Payload
implements IOperationHandle,
IDefaultPayloadHandle {
    private static final boolean DEBUG_TRACE_DATA = false;
    static final int s_dpMemSize = MemoryUtil.estimateBaseSize(DefaultPayload.class);
    private static int PAYLOAD_CHUNK_SIZE = 65536;
    private static final int RRS_SEND = 0;
    private static final int RRS_REQUEST = 2;
    private static final int RRS_REPLY = 3;
    private static final byte SUBJECT_MASK = 1;
    private static final byte BODY_MASK = 2;
    private static final byte SIDEBAND_MASK = 4;
    private byte[] m_prebodyBuffer = null;
    private int m_preBodyLength = 0;
    private boolean m_preBodyDirty = true;
    private byte[] m_bodyBuffer = null;
    private int m_bodyBufferLength = 0;
    private boolean m_hasBody = false;
    private boolean m_hasID = false;
    private long m_idHigh = 0L;
    private long m_idLow = 0L;
    private boolean m_hasSideband = false;
    private byte[] m_destinationAddress = null;
    private byte[] m_sourceAddress = null;
    private byte[] m_replyAddress = null;
    private int m_replyPrio;
    private int m_raf;
    private byte m_requestProtection;
    private String m_replyString;
    private String m_subject;
    private byte[] m_subjectUTF;
    private boolean m_hasSubject = false;
    private int m_txnId;
    private long m_trackingNum;
    private StreamUtilCounter m_utilCounter = null;
    private ISidebandData m_sidebandData;
    private byte[] m_sidebandDataCache = null;
    private boolean m_sidebandDataCacheLenDirty = false;
    private byte[] m_padArray = null;
    private boolean m_preBodyProtected = false;
    private boolean m_sidebandProtected = false;
    private boolean m_bodyProtected = false;
    private boolean m_isReadOnly = false;
    private boolean m_isEncrypted = false;
    private int m_cachedMemoryLength = -1;
    private int m_operationType = -1;
    private LinkedList m_operationMgramLinkedList = null;

    public DefaultPayload(Mgram m) {
        super(m);
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        DefaultPayload dp = (DefaultPayload)super.clone(m);
        if (!this.m_preBodyDirty) {
            dp.m_prebodyBuffer = new byte[this.m_preBodyLength];
            System.arraycopy(this.m_prebodyBuffer, 0, dp.m_prebodyBuffer, 0, this.m_preBodyLength);
        }
        if (this.m_sidebandData != null) {
            dp.m_sidebandData = (SidebandData)this.m_sidebandData.clone();
        }
        if (this.m_sidebandDataCache != null) {
            dp.m_sidebandDataCache = new byte[this.m_sidebandDataCache.length];
            System.arraycopy(this.m_sidebandDataCache, 0, dp.m_sidebandDataCache, 0, this.m_sidebandDataCache.length);
        }
        if (this.m_bodyBuffer != null) {
            dp.m_bodyBuffer = new byte[this.m_bodyBufferLength];
            System.arraycopy(this.m_bodyBuffer, 0, dp.m_bodyBuffer, 0, this.m_bodyBufferLength);
        }
        dp.m_preBodyProtected = false;
        dp.m_sidebandProtected = false;
        dp.m_bodyProtected = false;
        return dp;
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        DefaultPayload dp = (DefaultPayload)super.clone(m);
        if (this.m_sidebandData != null) {
            dp.m_sidebandData = (SidebandData)this.m_sidebandData.shallowClone();
        }
        return dp;
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        this.m_preBodyProtected = true;
        this.m_sidebandProtected = true;
        this.m_bodyProtected = true;
        DefaultPayload dp = (DefaultPayload)super.clone(m);
        return dp;
    }

    @Override
    protected boolean isDirty() {
        return this.m_preBodyDirty || this.m_sidebandData != null && this.m_sidebandData.isDirty();
    }

    @Override
    public void protect() {
        this.m_preBodyProtected = true;
        this.m_sidebandProtected = true;
        this.m_bodyProtected = true;
    }

    private void unprotectPreBody() {
        if (this.m_preBodyProtected) {
            this.checkReadOnly();
            if (this.m_prebodyBuffer != null && !this.m_preBodyDirty) {
                this.m_prebodyBuffer = this.copyByteArray(this.m_prebodyBuffer);
            }
            if (this.m_destinationAddress != null) {
                this.m_destinationAddress = this.copyByteArray(this.m_destinationAddress);
            }
            if (this.m_sourceAddress != null) {
                this.m_sourceAddress = this.copyByteArray(this.m_sourceAddress);
            }
            if (this.m_replyAddress != null) {
                this.m_replyAddress = this.copyByteArray(this.m_replyAddress);
            }
            if (this.m_subjectUTF != null) {
                this.m_subjectUTF = this.copyByteArray(this.m_subjectUTF);
            }
            this.m_preBodyProtected = false;
        }
    }

    private void unprotectSideBand() {
        if (this.m_sidebandProtected && !this.m_isReadOnly) {
            this.checkReadOnly();
            if (this.m_sidebandData != null) {
                this.m_sidebandData = (SidebandData)this.m_sidebandData.clone();
            }
            if (this.m_sidebandDataCache != null) {
                byte[] newCache = new byte[this.m_sidebandDataCache.length];
                System.arraycopy(this.m_sidebandDataCache, 0, newCache, 0, this.m_sidebandDataCache.length);
                this.m_sidebandDataCache = newCache;
            }
            this.m_sidebandProtected = false;
        }
    }

    public void checkReadOnly() {
        if (this.m_isReadOnly) {
            throw new EAssertFailure("Payload is read only");
        }
    }

    private void unprotectBody() {
        if (this.m_bodyProtected) {
            this.checkReadOnly();
            if (this.m_bodyBuffer != null) {
                this.m_bodyBuffer = this.copyByteArray(this.m_bodyBuffer);
            }
            if (this.m_padArray != null) {
                this.m_padArray = this.copyByteArray(this.m_padArray);
            }
            this.m_bodyProtected = false;
        }
    }

    private byte[] copyByteArray(byte[] src) {
        byte[] result = new byte[src.length];
        System.arraycopy(src, 0, result, 0, result.length);
        return result;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.checkReadOnly();
        this.m_utilCounter = sc;
        if (this.m_utilCounter == null) {
            this.m_utilCounter = new StreamUtilCounter(false);
        }
        this.readPreBodyFromStream(is);
        if (this.supportsSidebandSubjectBody()) {
            byte subjectBodyBits = this.m_utilCounter.readByte(is);
            this.m_preBodyLength = this.m_utilCounter.getCounter();
            if ((subjectBodyBits & 1) != 0) {
                this.m_hasSubject = true;
                this.m_subjectUTF = this.m_utilCounter.readUTFString(is);
                this.m_subject = null;
                this.m_preBodyLength = this.m_utilCounter.getCounter();
            }
            if ((subjectBodyBits & 4) != 0) {
                this.m_hasSideband = true;
                this.m_sidebandData = null;
                int sidebandLength = this.m_utilCounter.readInt(is);
                this.m_sidebandDataCache = new byte[sidebandLength];
                this.m_utilCounter.readBytes(is, this.m_sidebandDataCache, 4, sidebandLength - 4);
                ArrayUtil.writeInt(this.m_sidebandDataCache, 0, sidebandLength);
                this.m_sidebandDataCacheLenDirty = true;
            }
            if ((subjectBodyBits & 2) != 0) {
                this.m_hasBody = true;
                int length = this.m_mgram.getMessageLength() - this.m_utilCounter.getCounter();
                this.m_utilCounter.checkMessageLength(length);
                this.m_bodyBuffer = new byte[length];
                this.m_bodyBufferLength = length;
                this.m_utilCounter.readBytes(is, this.m_bodyBuffer, 0, length);
            }
        } else if (this.supportsSimpleBody()) {
            int lengthLeft = this.m_mgram.getMessageLength() - this.m_utilCounter.getCounter();
            if (lengthLeft > 0) {
                this.m_bodyBuffer = new byte[lengthLeft];
                this.m_bodyBufferLength = lengthLeft;
                this.m_utilCounter.readBytes(is, this.m_bodyBuffer, 0, lengthLeft);
                this.m_hasBody = true;
            } else {
                this.m_hasBody = false;
            }
        } else {
            throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR071"), new Object[]{Byte.toString(this.m_mgram.getType())}));
        }
        if (this.m_mgram.isSecure()) {
            this.m_utilCounter.skip(is, this.m_mgram.getMessagePad());
        }
        this.m_mgram.setStatus(3);
    }

    void setPreBodyBuffer(byte[] preBody) {
        this.checkReadOnly();
        this.m_prebodyBuffer = preBody;
        this.m_preBodyDirty = false;
        this.m_preBodyLength = preBody.length;
    }

    void setSidebandBuffer(byte[] sideband) {
        this.checkReadOnly();
        if (this.m_sidebandData != null) {
            this.m_sidebandData.setSidebandBuffer(sideband);
        } else {
            this.m_sidebandDataCache = sideband;
            this.m_sidebandDataCacheLenDirty = true;
        }
    }

    void setPadBuffer(byte[] pad) {
        this.checkReadOnly();
        this.m_padArray = pad;
    }

    @Override
    byte[] getPadBuffer() {
        return this.m_padArray;
    }

    public void readPreBodyFromStream(InputStream is) throws IOException, EMgramFormatError {
        this.m_preBodyDirty = true;
        if (this.m_mgram.hasID()) {
            this.m_idHigh = this.m_utilCounter.readLong(is);
            this.m_idLow = this.m_utilCounter.readLong(is);
            this.m_hasID = true;
        }
        this.m_destinationAddress = this.readAddress(is, this.m_mgram.getDestinationAddressFormat());
        this.m_sourceAddress = this.readAddress(is, 0);
        this.readRequestReplyBytes(is);
        if (this.m_mgram.isGuarenteed()) {
            this.m_trackingNum = this.m_utilCounter.read6ByteLong(is);
        }
        if (this.m_mgram.hasTxn()) {
            this.m_txnId = this.m_utilCounter.readInt(is);
        }
        if (this.m_mgram.getType() == 25) {
            this.m_operationType = this.m_utilCounter.readInt(is);
        }
        this.m_preBodyLength = this.m_utilCounter.getCounter();
    }

    private byte[] readAddress(InputStream is, int format) throws IOException, EMgramFormatError {
        byte[] address = null;
        switch (format) {
            case 3: {
                byte byte1 = this.m_utilCounter.readByte(is);
                byte byte2 = this.m_utilCounter.readByte(is);
                int len = (byte1 & 0xFF) << 10 | (byte2 & 0xFF) << 2;
                if (len > 0) {
                    address = new byte[len + 2];
                    this.m_utilCounter.readBytes(is, address, 2, len);
                    address[0] = byte1;
                    address[1] = byte2;
                }
                return address;
            }
            case 2: {
                address = new byte[4];
                this.m_utilCounter.readBytes(is, address, 0, 4);
                return address;
            }
            case 1: {
                address = this.m_utilCounter.readUTFString(is);
                return address;
            }
            case 0: {
                return null;
            }
        }
        throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR079"), new Object[]{Integer.toString(format)}));
    }

    private int calculateAddressLength(byte[] address, int format) {
        int addressLength = 0;
        switch (format) {
            case 3: {
                addressLength = (address[0] & 0xFF) << 10 | (address[1] & 0xFF) << 2;
                addressLength += 2;
                break;
            }
            case 1: 
            case 2: {
                addressLength += address.length;
                break;
            }
            case 0: {
                break;
            }
        }
        return addressLength;
    }

    private int writeAddressToArray(byte[] preBody, int offset, byte[] address, int format) {
        int result = offset;
        switch (format) {
            case 3: {
                int len = (address[0] & 0xFF) << 10 | (address[1] & 0xFF) << 2;
                System.arraycopy(address, 0, preBody, offset, len += 2);
                offset += len;
                break;
            }
            case 1: 
            case 2: {
                System.arraycopy(address, 0, preBody, offset, address.length);
                offset += address.length;
                break;
            }
            case 0: {
                break;
            }
        }
        return offset - result;
    }

    private void writeAddress(OutputStream os, byte[] address, int format) throws IOException {
        switch (format) {
            case 3: {
                int len = (address[0] & 0xFF) << 10 | (address[1] & 0xFF) << 2;
                os.write(address, 0, len + 2);
                break;
            }
            case 1: 
            case 2: {
                os.write(address, 0, address.length);
                break;
            }
            case 0: {
                break;
            }
        }
    }

    private void readRequestReplyBytes(InputStream is) throws IOException, EMgramFormatError {
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = this.m_utilCounter.readByte(is);
                this.m_replyPrio = requestReplyBits & 0xF;
                this.m_raf = (requestReplyBits & 0xF0) >>> 4;
                this.m_replyAddress = this.readAddress(is, (requestReplyBits & 0xF0) >>> 4);
                byte type = this.m_mgram.getType();
                if (type != 0 && type != 7 && type != 4) {
                    byte[] replyString = this.m_utilCounter.readUTFString(is);
                    this.m_replyString = StringUtil.UTFToString(replyString, 0);
                }
                if (!this.m_mgram.isSecure()) break;
                this.m_requestProtection = this.m_mgram.getSecurity();
                break;
            }
            case 3: {
                if (!this.m_mgram.isSecure()) break;
                this.m_requestProtection = this.m_mgram.getSecurity();
                break;
            }
            default: {
                throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR067"), new Object[]{Integer.toString(this.m_mgram.getRequestReplyFieldType())}));
            }
        }
    }

    private int calculateRequestReplyBytesLength() {
        int length = 0;
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = (byte)(this.m_replyPrio & 0xF);
                requestReplyBits = (byte)(requestReplyBits | (byte)(this.m_raf & 0xF) << 4);
                ++length;
                length += this.calculateAddressLength(this.m_replyAddress, this.m_raf);
                byte type = this.m_mgram.getType();
                if (type == 0 || type == 7 || type == 4) break;
                try {
                    length += StringUtil.stringToUTF(this.m_replyString).length;
                }
                catch (UTFDataFormatException e) {}
                break;
            }
            case 3: {
                break;
            }
        }
        return length;
    }

    private int writeRequestReplyBytesToArray(byte[] preBody, int offset) {
        int result = offset;
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = (byte)(this.m_replyPrio & 0xF);
                requestReplyBits = (byte)(requestReplyBits | (byte)(this.m_raf & 0xF) << 4);
                preBody[offset] = (byte)(requestReplyBits & 0xFF);
                ++offset;
                offset += this.writeAddressToArray(preBody, offset, this.m_replyAddress, this.m_raf);
                byte type = this.m_mgram.getType();
                if (type == 0 || type == 7 || type == 4) break;
                try {
                    byte[] utf = StringUtil.stringToUTF(this.m_replyString);
                    System.arraycopy(utf, 0, preBody, offset, utf.length);
                    offset += utf.length;
                }
                catch (UTFDataFormatException e) {}
                break;
            }
            case 3: {
                break;
            }
        }
        return offset - result;
    }

    private void writeRequestReplyBytes(OutputStream os) throws IOException {
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = (byte)(this.m_replyPrio & 0xF);
                requestReplyBits = (byte)(requestReplyBits | (byte)(this.m_raf & 0xF) << 4);
                os.write(requestReplyBits);
                this.writeAddress(os, this.m_replyAddress, this.m_raf);
                byte type = this.m_mgram.getType();
                if (type == 0 || type == 7 || type == 4) break;
                os.write(StringUtil.stringToUTF(this.m_replyString));
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    boolean hasID() {
        return this.m_hasID;
    }

    @Override
    byte[] getID() {
        byte[] result = new byte[16];
        ArrayUtil.writeLong(result, 0, this.m_idHigh);
        ArrayUtil.writeLong(result, 8, this.m_idLow);
        return result;
    }

    @Override
    void setID(byte[] id) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_idHigh = ArrayUtil.readLong(id, 0);
        this.m_idLow = ArrayUtil.readLong(id, 8);
    }

    @Override
    public boolean isEncrypted() {
        return this.m_isEncrypted;
    }

    void setEncrypted() {
        this.m_isReadOnly = true;
        if (this.m_sidebandData != null) {
            this.m_sidebandData.setReadOnly();
        }
        this.m_isEncrypted = true;
    }

    void setDecrypted() {
        this.m_isEncrypted = false;
    }

    void disableReadOnly() {
        this.m_isReadOnly = false;
        if (this.m_sidebandData != null) {
            this.m_sidebandData.disableReadOnly();
        }
    }

    @Override
    void setTxn(int tid) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_txnId = tid;
    }

    @Override
    void removeTxn() {
        this.setTxn(0);
    }

    @Override
    int getTxnId() {
        return this.m_txnId;
    }

    private void setPreBodyDirty() {
        this.checkReadOnly();
        this.m_preBodyDirty = true;
    }

    @Override
    void clearID() {
        this.checkReadOnly();
        if (this.m_idHigh != 0L || this.m_idLow != 0L || this.m_hasID) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
        this.m_idHigh = 0L;
        this.m_idLow = 0L;
        this.m_hasID = false;
    }

    @Override
    void clearAddresses() {
        this.checkReadOnly();
        if (this.m_raf != 0 || this.m_destinationAddress != null || this.m_replyAddress != null) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
        this.m_raf = 0;
        this.m_replyAddress = null;
        this.m_destinationAddress = null;
    }

    @Override
    byte[] getRawPreBody() {
        this.syncPreBodyBuffer();
        return this.m_prebodyBuffer;
    }

    @Override
    public void setGuarenteed(long tracking) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_trackingNum = tracking;
    }

    @Override
    void setRequest(byte[] replyToAddress, String replySubject) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_replyAddress = replyToAddress;
        this.m_replyString = replySubject;
        this.m_raf = 3;
    }

    @Override
    void setReplyToString(String value) {
        this.checkReadOnly();
        if (value != null) {
            if (!value.equals(this.m_replyString)) {
                this.setPreBodyDirty();
                this.unprotectPreBody();
            }
        } else if (this.m_replyString != null) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
        this.m_replyString = value;
    }

    @Override
    byte[] getReplyToAddress() {
        return this.m_replyAddress;
    }

    @Override
    int getReplyToAddressFormat() {
        return this.m_raf;
    }

    @Override
    public void setReplyToAddressFormat(int format) {
        this.checkReadOnly();
        if (this.m_raf != format) {
            this.m_raf = format;
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
    }

    @Override
    String getReplyToAddressString() {
        this.checkReadOnly();
        return this.m_replyString;
    }

    @Override
    void setDestinationAddress(byte[] address) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_destinationAddress = address;
    }

    @Override
    byte[] getDestinationAddress() {
        return this.m_destinationAddress;
    }

    @Override
    boolean canHaveReplyTracking() {
        return this.m_destinationAddress != null && this.m_destinationAddress.length >= 4;
    }

    @Override
    protected byte[] toByteArray() {
        byte[] bodyBuffer;
        this.sync();
        int length = 0;
        length += this.m_preBodyLength;
        if (this.m_hasSideband) {
            length = this.m_sidebandData != null ? (length += this.getSidebandData().getSerializedLength()) : (length += this.m_sidebandDataCache.length);
        }
        if ((bodyBuffer = this.getRawBodyBuffer()) != null) {
            length += this.getBodyLength();
        }
        byte[] newByteArray = new byte[length];
        int pos = 0;
        if (this.m_prebodyBuffer != null) {
            System.arraycopy(this.m_prebodyBuffer, 0, newByteArray, pos, this.m_preBodyLength);
            pos += this.m_preBodyLength;
        }
        if (this.m_hasSideband) {
            int sidebandLength;
            byte[] sidebandBuffer;
            if (this.m_sidebandData != null) {
                sidebandBuffer = this.m_sidebandData.getRawSidebandBuffer();
                sidebandLength = this.m_sidebandData.getSerializedLength();
            } else {
                sidebandBuffer = this.m_sidebandDataCache;
                sidebandLength = sidebandBuffer.length;
            }
            System.arraycopy(sidebandBuffer, 0, newByteArray, pos, sidebandLength);
            pos += sidebandLength;
        }
        if (this.m_hasBody) {
            System.arraycopy(this.m_bodyBuffer, 0, newByteArray, pos, this.m_bodyBufferLength);
            pos += this.m_bodyBufferLength;
        }
        return newByteArray;
    }

    void syncSidebandBuffer() {
        if (this.m_hasSideband && this.m_sidebandData != null && this.m_sidebandData.isDirty()) {
            if (!this.m_isReadOnly) {
                this.unprotectSideBand();
            }
            if (this.m_sidebandData != null) {
                this.m_sidebandData.sync();
            }
        }
    }

    @Override
    byte[] getRawSidebandBuffer() {
        if (this.m_sidebandData != null) {
            return this.m_sidebandData.getRawSidebandBuffer();
        }
        return this.m_sidebandDataCache;
    }

    @Override
    byte[] getRawBodyBuffer() {
        return this.m_bodyBuffer;
    }

    private void syncPreBodyBuffer() {
        if (this.m_preBodyDirty && !this.isEncrypted()) {
            this.checkReadOnly();
            this.unprotectPreBody();
            this.m_preBodyLength = this.calculatePreBodyLength();
            this.m_prebodyBuffer = new byte[this.m_preBodyLength];
            this.writePreBodyToArray(this.m_prebodyBuffer);
            this.m_preBodyDirty = false;
        }
    }

    private int calculatePreBodyLength() {
        int preBodyCounter = 0;
        if (this.m_preBodyDirty && !this.isEncrypted()) {
            if (this.m_mgram.hasID()) {
                preBodyCounter += 16;
            }
            preBodyCounter += this.calculateAddressLength(this.m_destinationAddress, this.m_mgram.getDestinationAddressFormat());
            preBodyCounter += this.calculateAddressLength(this.m_sourceAddress, 0);
            preBodyCounter += this.calculateRequestReplyBytesLength();
            if (this.m_mgram.isGuarenteed()) {
                preBodyCounter += 6;
            }
            if (this.m_mgram.hasTxn()) {
                preBodyCounter += 4;
            }
            if (this.supportsSidebandSubjectBody()) {
                ++preBodyCounter;
                if (this.hasSubject()) {
                    preBodyCounter += this.m_subjectUTF.length;
                }
            }
            if (this.m_mgram.getType() == 25) {
                preBodyCounter += 4;
            }
            return preBodyCounter;
        }
        return this.m_prebodyBuffer.length;
    }

    private void writePreBodyToArray(byte[] preBody) {
        int offset = 0;
        if (this.m_mgram.hasID()) {
            ArrayUtil.writeLong(preBody, offset, this.m_idHigh);
            ArrayUtil.writeLong(preBody, offset += 8, this.m_idLow);
            offset += 8;
        }
        offset += this.writeAddressToArray(preBody, offset, this.m_destinationAddress, this.m_mgram.getDestinationAddressFormat());
        offset += this.writeAddressToArray(preBody, offset, this.m_sourceAddress, 0);
        offset += this.writeRequestReplyBytesToArray(preBody, offset);
        if (this.m_mgram.isGuarenteed()) {
            ArrayUtil.write6ByteLong(preBody, offset, this.m_trackingNum);
            offset += 6;
        }
        if (this.m_mgram.hasTxn()) {
            ArrayUtil.writeInt(preBody, offset, this.m_txnId);
            offset += 4;
        }
        if (this.m_mgram.getType() == 25) {
            ArrayUtil.writeInt(preBody, offset, this.m_operationType);
            offset += 4;
        }
        if (this.supportsSidebandSubjectBody()) {
            byte subjectBodyBits = 0;
            if (this.hasSubject()) {
                subjectBodyBits = (byte)(subjectBodyBits | 1);
            }
            if (this.m_hasSideband) {
                subjectBodyBits = (byte)(subjectBodyBits | 4);
            }
            if (this.m_hasBody) {
                subjectBodyBits = (byte)(subjectBodyBits | 2);
            }
            preBody[offset] = subjectBodyBits;
            ++offset;
            if (this.hasSubject()) {
                System.arraycopy(this.m_subjectUTF, 0, preBody, offset, this.m_subjectUTF.length);
            }
        }
    }

    private void writePreBodyToStream(OutputStream os) throws IOException {
        if (this.m_preBodyDirty && !this.isEncrypted()) {
            if (this.m_mgram.hasID()) {
                StreamUtil.writeLong(this.m_idHigh, os);
                StreamUtil.writeLong(this.m_idLow, os);
            }
            this.writeAddress(os, this.m_destinationAddress, this.m_mgram.getDestinationAddressFormat());
            this.writeAddress(os, this.m_sourceAddress, 0);
            this.writeRequestReplyBytes(os);
            if (this.m_mgram.isGuarenteed()) {
                StreamUtil.write6ByteLong(this.m_trackingNum, os);
            }
            if (this.m_mgram.hasTxn()) {
                StreamUtil.writeInt(this.m_txnId, os);
            }
            if (this.supportsSidebandSubjectBody()) {
                int subjectBodyBits = 0;
                if (this.hasSubject()) {
                    subjectBodyBits |= 1;
                }
                if (this.m_hasSideband) {
                    subjectBodyBits |= 4;
                }
                if (this.m_hasBody) {
                    subjectBodyBits |= 2;
                }
                os.write(subjectBodyBits);
                if (this.hasSubject()) {
                    os.write(this.m_subjectUTF);
                }
            }
            if (this.m_mgram.getType() == 25) {
                StreamUtil.writeInt(this.m_operationType, os);
            }
        } else {
            os.write(this.m_prebodyBuffer, 0, this.m_preBodyLength);
        }
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        this.writePreBodyToStream(os);
        if (this.supportsSidebandSubjectBody() && this.m_hasSideband) {
            if (this.m_sidebandData != null) {
                this.m_sidebandData.writeToStream(os);
            } else {
                os.write(this.m_sidebandDataCache);
            }
        }
        if ((this.supportsSidebandSubjectBody() || this.supportsSimpleBody()) && this.m_hasBody) {
            this.chunkWrite(os, this.m_bodyBuffer, 0, this.m_bodyBufferLength, PAYLOAD_CHUNK_SIZE);
        }
        if (this.m_mgram.isSecure()) {
            if (!this.isEncrypted()) {
                boolean needPad = true;
                ISecureOutputStream sos = null;
                if (os instanceof ISecureOutputStream && !(sos = (ISecureOutputStream)((Object)os)).getMessageProtection().isSonicCipherSuite()) {
                    needPad = false;
                }
                if (needPad) {
                    int pad = this.m_mgram.getMessagePad();
                    byte[] padArray = new byte[pad];
                    os.write(padArray);
                }
                if (sos != null) {
                    sos.doFinal();
                }
            } else if (this.m_padArray != null) {
                os.write(this.m_padArray);
            }
        }
    }

    private boolean supportsSidebandSubjectBody() {
        switch (this.m_mgram.getType()) {
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 25: 
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    private boolean supportsSimpleBody() {
        switch (this.m_mgram.getType()) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    private void chunkWrite(OutputStream os, byte[] data, int offset, int dataLength, int chunkSize) throws IOException {
        int remainder = dataLength % chunkSize;
        int numChunks = dataLength / chunkSize;
        if (numChunks != 0) {
            int currentPointer = offset;
            for (int count = 0; count < numChunks; ++count) {
                os.write(data, currentPointer, chunkSize);
                currentPointer += chunkSize;
                os.flush();
            }
            if (remainder != 0) {
                os.write(data, dataLength - remainder + offset, remainder);
            }
        } else {
            os.write(data, offset, dataLength);
        }
    }

    @Override
    int getReplyPriority() {
        return this.m_replyPrio;
    }

    @Override
    void setReplyPriority(int priority) {
        this.checkReadOnly();
        if (priority != this.m_replyPrio) {
            this.m_replyPrio = priority;
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
    }

    @Override
    boolean hasSubject() {
        return this.m_hasSubject;
    }

    @Override
    ISidebandData getSidebandData() {
        this.unprotectSideBand();
        this.createSidebandDataFromCache();
        return this.m_sidebandData;
    }

    @Override
    boolean hasSidebandData() {
        return this.m_hasSideband;
    }

    @Override
    void createSidebandDataIfNeeded() {
        if (this.m_sidebandData == null && this.m_sidebandDataCache == null) {
            this.checkReadOnly();
            this.m_hasSideband = true;
            this.m_sidebandData = new SidebandData();
            this.m_sidebandProtected = false;
            this.setPreBodyDirty();
            return;
        }
        this.createSidebandDataFromCache();
    }

    private void createSidebandDataFromCache() {
        if (this.m_sidebandDataCache != null) {
            this.m_sidebandData = new SidebandData();
            this.m_sidebandData.fromByteArray(this.m_sidebandDataCache, 0);
            this.m_sidebandDataCache = null;
            this.m_sidebandDataCacheLenDirty = false;
        }
    }

    @Override
    String getSubject() {
        if (this.m_subject == null && this.m_subjectUTF != null) {
            try {
                this.m_subject = StringUtil.UTFToString(this.m_subjectUTF, 0);
            }
            catch (UTFDataFormatException e) {
                e.printStackTrace();
            }
        }
        return this.m_subject;
    }

    @Override
    void setSubject(String subject) {
        this.checkReadOnly();
        if (subject != null) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
            this.m_hasSubject = true;
            if (subject != null && subject.equals(this.m_subject)) {
                return;
            }
            this.m_subject = subject;
            try {
                this.m_subjectUTF = StringUtil.stringToUTF(subject);
            }
            catch (UTFDataFormatException e) {
                throw new EAssertFailure("UTF Format Exception in given subject");
            }
        } else {
            this.m_hasSubject = false;
        }
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_trackingNum;
    }

    @Override
    boolean hasBody() {
        return this.m_hasBody;
    }

    @Override
    void setBody(byte[] body, int length) {
        this.checkReadOnly();
        if (body != null && length > 0) {
            this.m_bodyBuffer = body;
            this.m_bodyBufferLength = length;
            this.m_hasBody = true;
            this.m_bodyProtected = false;
        } else {
            this.m_hasBody = false;
            this.m_bodyBuffer = null;
            this.m_bodyBufferLength = 0;
            this.m_bodyProtected = false;
        }
    }

    @Override
    int getBodyLength() {
        return this.m_bodyBufferLength;
    }

    @Override
    int getPreBodyLength() {
        this.syncPreBodyBuffer();
        return this.m_preBodyLength;
    }

    @Override
    void setSidebandData(ISidebandData sd) {
        this.checkReadOnly();
        if (sd != null) {
            this.m_sidebandData = sd;
            this.m_sidebandDataCache = null;
            this.m_sidebandDataCacheLenDirty = false;
            this.m_hasSideband = true;
            this.m_sidebandProtected = false;
        } else {
            this.m_hasSideband = false;
        }
    }

    @Override
    public int length() {
        this.syncSidebandBuffer();
        this.syncPreBodyBuffer();
        int length = 0;
        if (this.m_hasSideband) {
            length = this.m_sidebandData != null ? (length += this.m_sidebandData.getSerializedLength()) : (length += this.m_sidebandDataCache.length);
        }
        length += this.m_preBodyLength;
        if (this.m_hasBody) {
            length += this.m_bodyBufferLength;
        }
        return length;
    }

    @Override
    protected int memoryLength() {
        this.sync();
        return this.m_cachedMemoryLength;
    }

    @Override
    protected void sync() {
        boolean calcMemSize = this.m_cachedMemoryLength == -1 || this.m_sidebandDataCacheLenDirty || this.isDirty();
        this.syncSidebandBuffer();
        this.syncPreBodyBuffer();
        if (calcMemSize) {
            this.m_cachedMemoryLength = s_dpMemSize + (this.m_bodyBuffer == null ? 0 : this.m_bodyBuffer.length) + (this.m_prebodyBuffer == null ? 0 : this.m_prebodyBuffer.length) + (this.m_sidebandData == null ? 0 : this.m_sidebandData.memoryLength()) + (this.m_sidebandDataCache == null ? 0 : this.m_sidebandDataCache.length) + (this.m_destinationAddress == null ? 0 : this.m_destinationAddress.length) + (this.m_padArray == null ? 0 : this.m_padArray.length) + (this.m_replyAddress == null ? 0 : this.m_replyAddress.length) + (this.m_replyString == null ? 0 : this.m_replyString.length()) + (this.m_sourceAddress == null ? 0 : this.m_sourceAddress.length) + (this.m_subjectUTF == null ? 0 : this.m_subjectUTF.length);
        }
    }

    @Override
    public byte[] encryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.checkReadOnly();
        this.unprotectPreBody();
        this.unprotectSideBand();
        this.unprotectBody();
        this.sync();
        int keyLen = this.m_mgram.getMessageKey().length;
        byte[] key = new byte[keyLen];
        System.arraycopy(this.m_mgram.getMessageKey(), 0, key, 0, keyLen);
        CryptoInfoLinkedList encLinkedList = this.createEncInfoLinkedList(mp);
        this.m_padArray = mp.encrypt(key, encLinkedList);
        this.setEncrypted();
        return this.m_padArray;
    }

    @Override
    void decryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        if (!this.isEncrypted()) {
            return;
        }
        this.disableReadOnly();
        this.unprotectPreBody();
        this.unprotectSideBand();
        this.unprotectBody();
        this.sync();
        int keyLen = this.m_mgram.getMessageKey().length;
        byte[] key = new byte[keyLen];
        System.arraycopy(this.m_mgram.getMessageKey(), 0, key, 0, keyLen);
        CryptoInfoLinkedList encLinkedList = this.createEncInfoLinkedList(mp);
        mp.decrypt(key, encLinkedList);
        this.m_padArray = null;
        this.setDecrypted();
        try {
            if (this.m_utilCounter == null) {
                this.m_utilCounter = new StreamUtilCounter(false);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(this.m_prebodyBuffer);
            this.readPreBodyFromStream(bais);
            this.m_utilCounter.resetCounter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EMgramFormatError e) {
            e.printStackTrace();
        }
    }

    @Override
    CryptoInfoLinkedList createMacInfoLinkedList() {
        this.sync();
        this.createSidebandDataFromCache();
        CryptoInfoLinkedList macLinkedList = new CryptoInfoLinkedList();
        macLinkedList.addLast(new CryptoInfo(this.m_prebodyBuffer, 0, this.m_preBodyLength));
        byte[] sideBandBuffer = this.getRawSidebandBuffer();
        if (sideBandBuffer != null) {
            macLinkedList.addLast(new CryptoInfo(sideBandBuffer, 0, this.m_sidebandData.getSerializedLength()));
        }
        if (this.m_bodyBuffer != null) {
            macLinkedList.addLast(new CryptoInfo(this.m_bodyBuffer, 0, this.m_bodyBufferLength));
        }
        return macLinkedList;
    }

    CryptoInfoLinkedList createEncInfoLinkedList(IMessageProtection mp) {
        byte[] sideBandBuffer;
        this.sync();
        this.createSidebandDataFromCache();
        this.m_mgram.recalculatePad(mp);
        int pad = this.m_mgram.getMessagePad();
        CryptoInfoLinkedList encLinkedList = new CryptoInfoLinkedList();
        if (this.m_preBodyLength > 0) {
            encLinkedList.addLast(new CryptoInfo(this.m_prebodyBuffer, 0, this.m_preBodyLength));
        }
        if ((sideBandBuffer = this.getRawSidebandBuffer()) != null) {
            encLinkedList.addLast(new CryptoInfo(sideBandBuffer, 0, this.m_sidebandData.getSerializedLength()));
        }
        if (this.m_bodyBuffer != null) {
            encLinkedList.addLast(new CryptoInfo(this.m_bodyBuffer, 0, this.m_bodyBufferLength));
        }
        if (!this.isEncrypted()) {
            CryptoInfo lastElement = encLinkedList.getLast();
            lastElement.setPad(pad);
        } else {
            if (this.m_padArray != null) {
                encLinkedList.addLast(new CryptoInfo(this.m_padArray, 0, this.m_padArray.length));
            }
            CryptoInfo lastElement = encLinkedList.getLast();
            lastElement.setPad(0);
        }
        return encLinkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            this.printMgramMessageID();
            this.printMgramDestinationAddress();
            this.printMgramReplyAddressFormat();
            this.printMgramReplyPriority();
            this.printMgramReplyAddress();
            this.printMgramGuaranteedTrackingNumber();
            this.printMgramTransactionID();
            if (this.hasSubject()) {
                log.println("Subject: " + this.getSubject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramMessageID() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Message ID: ");
            if (this.hasID()) {
                byte[] id = this.getID();
                for (int p = 0; p < id.length; ++p) {
                    log.print(Integer.toHexString(id[p]));
                }
                log.println();
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramDestinationAddress() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Destination Address: ");
            this.printAddress(this.m_mgram.getDestinationAddressFormat(), this.getDestinationAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printAddress(int format, byte[] address) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            switch (format) {
                case 0: {
                    log.println("NONE");
                    break;
                }
                case 1: {
                    log.println(ArrayUtil.getString(address, 0));
                    break;
                }
                case 2: {
                    log.println(ArrayUtil.readInt(address, 0));
                    break;
                }
                case 3: {
                    log.println(SubjectUtil.crackDestAddr(address, 0));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramReplyAddressFormat() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Reply Address Format: ");
            if (this.m_mgram.isRequest()) {
                this.printAddressFormat(this.getReplyToAddressFormat());
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printAddressFormat(int format) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            switch (format) {
                case 0: {
                    log.println("NONE");
                    break;
                }
                case 1: {
                    log.println("AF_STRING");
                    break;
                }
                case 2: {
                    log.println("AF_FIXED");
                    break;
                }
                case 3: {
                    log.println("AF_VAR");
                    break;
                }
                default: {
                    log.println("UNKNOWN");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramReplyPriority() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Reply Priority: ");
            if (this.m_mgram.isRequest()) {
                log.println(this.getReplyPriority());
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramReplyAddress() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Reply Address: ");
            if (this.m_mgram.isRequest()) {
                this.printAddress(this.m_mgram.getReplyToAddressFormat(), this.getReplyToAddress());
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramGuaranteedTrackingNumber() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Guaranteed Tracking #: ");
            if (this.m_mgram.isGuarenteed()) {
                log.println(this.getGuarenteedTrackingNum());
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMgramTransactionID() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Transaction ID: ");
            if (this.m_mgram.hasTxn()) {
                log.println(this.getTxnId());
            } else {
                log.println("NONE");
            }
        }
    }

    @Override
    public ObjectInput getPayloadInputStreamHandle() {
        return new DefaultPayloadInputWrapper(this);
    }

    @Override
    public ObjectOutput getPayloadOutputStreamHandle() {
        return new DefaultPayloadOutputWrapper(this);
    }

    @Override
    final IOperationHandle getOperationHandle() {
        this.m_mgram.checkOperationType();
        return this;
    }

    @Override
    public void setOperationType(int operationType) {
        this.m_mgram.checkOperationType();
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_operationType = operationType;
    }

    @Override
    public int getOperationType() {
        this.m_mgram.checkOperationType();
        return this.m_operationType;
    }

    @Override
    public void addMgram(IMgram m) {
        this.m_mgram.checkOperationType();
        this.checkReadOnly();
        if (this.m_operationMgramLinkedList == null) {
            this.m_operationMgramLinkedList = new LinkedList();
        }
        this.m_operationMgramLinkedList.addLast(m);
    }

    @Override
    public LinkedList getMgramList() {
        this.m_mgram.checkOperationType();
        return this.m_operationMgramLinkedList;
    }

    @Override
    public int getMgramListSerializedLength() {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            result += subMgram.serializedLength();
        }
        return result;
    }

    @Override
    public int getMgramListNetworkLength() {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            result += subMgram.networkLength();
        }
        return result;
    }

    @Override
    public int getMgramListMemoryLength() {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            result += subMgram.memoryLength();
        }
        return result;
    }

    @Override
    public void macMgramListMessagesWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return;
        }
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            subMgram.getBrokerHandle().macMessageWithMessageKey(mp);
        }
    }

    @Override
    public void macMgramListHeadersWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return;
        }
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            subMgram.getBrokerHandle().macHeaderWithMessageKey(mp);
        }
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("DP_BODY_BUFFER", this.m_bodyBuffer);
        result.put("DP_BODY_BUFFER_LENGTH", new Integer(this.m_bodyBufferLength));
        result.put("DP_BODY_PROTECTED", new Boolean(this.m_bodyProtected));
        result.put("DP_CACHED_MEMORY_LENGTH", new Integer(this.m_cachedMemoryLength));
        result.put("DP_HAS_BODY", new Boolean(this.m_hasBody));
        result.put("DP_HAS_ID", new Boolean(this.m_hasID));
        result.put("DP_HAS_SIDEBAND", new Boolean(this.m_hasSideband));
        result.put("DP_ID_HIGH", new Long(this.m_idHigh));
        result.put("DP_ID_LOW", new Long(this.m_idLow));
        result.put("DP_IS_ENCRYPTED", new Boolean(this.m_isEncrypted));
        result.put("DP_IS_READ_ONLY", new Boolean(this.m_isReadOnly));
        result.put("DP_OPERATION_LINKED_LIST", this.m_operationMgramLinkedList);
        result.put("DP_OPERATION_TYPE", new Integer(this.m_operationType));
        result.put("DP_PAD_ARRAY", this.m_padArray);
        result.put("DP_RAF", new Integer(this.m_raf));
        result.put("DP_REPLY_PRIO", new Integer(this.m_replyPrio));
        result.put("DP_REQUEST_PROTECTION", new Byte(this.m_requestProtection));
        result.put("DP_SIDEBAND_DATA", this.m_sidebandData);
        result.put("DP_SIDEBAND_DATA_CACHE", this.m_sidebandDataCache);
        result.put("DP_SIDEBAND_DATA_CACHE_LEN_DIRTY", new Boolean(this.m_sidebandDataCacheLenDirty));
        result.put("DP_SIDEBAND_PROTECTED", new Boolean(this.m_sidebandProtected));
        result.put("DP_SOURCE_ADDRESS", this.m_sourceAddress);
        result.put("DP_TRACKING_NUMBER", new Long(this.m_trackingNum));
        result.put("DP_TXN_ID", new Integer(this.m_txnId));
        Subject subject = new Subject(this.m_subject);
        subject.initSubjectUTF(this.m_subjectUTF);
        boolean tracking = false;
        try {
            subject.initSubjectTracking(this.m_mgram.getReplyTracking());
            tracking = true;
        }
        catch (ENoTrackingNum ex) {
            // empty catch block
        }
        subject.initMatchVector(SubjectUtil.convertAddressToMatchVector(this.m_destinationAddress, this.m_mgram.getDestinationAddressFormat(), tracking));
        if (!this.m_hasSubject && this.m_mgram.getDestinationAddressFormat() == 1) {
            subject.initSubjectUTF(this.m_destinationAddress);
        }
        result.put("DP_SUBJECT", subject);
        tracking = false;
        Subject replySubject = new Subject(this.m_replyString);
        if (this.m_raf != 0) {
            if (this.m_mgram.getRequestReplyFieldType() == 2) {
                tracking = true;
                replySubject.initSubjectTracking(this.m_mgram.getReplyToAddressTracking());
            }
            replySubject.initMatchVector(SubjectUtil.convertAddressToMatchVector(this.m_replyAddress, this.m_raf, tracking));
        }
        result.put("DP_REPLY_SUBJECT", replySubject);
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_bodyBuffer = (byte[])map.get("DP_BODY_BUFFER");
        this.m_bodyBufferLength = (Integer)map.get("DP_BODY_BUFFER_LENGTH");
        this.m_bodyProtected = (Boolean)map.get("DP_BODY_PROTECTED");
        this.m_cachedMemoryLength = (Integer)map.get("DP_CACHED_MEMORY_LENGTH");
        this.m_hasBody = (Boolean)map.get("DP_HAS_BODY");
        this.m_hasID = (Boolean)map.get("DP_HAS_ID");
        this.m_hasSideband = (Boolean)map.get("DP_HAS_SIDEBAND");
        this.m_idHigh = (Long)map.get("DP_ID_HIGH");
        this.m_idLow = (Long)map.get("DP_ID_LOW");
        this.m_isEncrypted = (Boolean)map.get("DP_IS_ENCRYPTED");
        this.m_isReadOnly = (Boolean)map.get("DP_IS_READ_ONLY");
        this.m_operationMgramLinkedList = (LinkedList)map.get("DP_OPERATION_LINKED_LIST");
        this.m_operationType = (Integer)map.get("DP_OPERATION_TYPE");
        this.m_padArray = (byte[])map.get("DP_PAD_ARRAY");
        this.m_replyPrio = (Integer)map.get("DP_REPLY_PRIO");
        this.m_requestProtection = (Byte)map.get("DP_REQUEST_PROTECTION");
        this.m_sidebandData = (ISidebandData)map.get("DP_SIDEBAND_DATA");
        this.m_sidebandDataCache = (byte[])map.get("DP_SIDEBAND_DATA_CACHE");
        this.m_sidebandProtected = (Boolean)map.get("DP_SIDEBAND_PROTECTED");
        this.m_sourceAddress = (byte[])map.get("DP_SOURCE_ADDRESS");
        this.m_trackingNum = (Long)map.get("DP_TRACKING_NUMBER");
        this.m_txnId = (Integer)map.get("DP_TXN_ID");
        ISubject subject = (ISubject)map.get("DP_SUBJECT");
        int[] mv = null;
        if (subject != null) {
            if (subject.isSubjectSet()) {
                this.m_hasSubject = true;
                this.m_subject = subject.getSubjectString();
                this.m_subjectUTF = subject.getSubjectUTF();
            }
            if (subject.hasSubjectTracking() && this.m_mgram.isReply()) {
                int[] tempmv = subject.getMatchVector();
                mv = new int[tempmv.length + 1];
                System.arraycopy(tempmv, 0, mv, 0, tempmv.length);
                mv[mv.length - 1] = (int)subject.getSubjectTracking();
            } else {
                mv = subject.getMatchVector();
            }
            this.m_destinationAddress = SubjectUtil.convertMatchVectorToVarFmt(mv);
            this.m_mgram.setDestinationAddressFormat(3);
        } else {
            this.m_mgram.setDestinationAddressFormat(0);
        }
        ISubject replySubject = (ISubject)map.get("DP_REPLY_SUBJECT");
        if (replySubject != null && replySubject.isSubjectSet()) {
            this.m_replyString = replySubject.getSubjectString();
            mv = null;
            if (replySubject.hasSubjectTracking() && this.m_mgram.isRequest()) {
                int[] tempmv = replySubject.getMatchVector();
                mv = new int[tempmv.length + 1];
                System.arraycopy(tempmv, 0, mv, 0, tempmv.length);
                mv[mv.length - 1] = (int)replySubject.getSubjectTracking();
            } else {
                mv = replySubject.getMatchVector();
            }
            this.m_replyAddress = SubjectUtil.convertMatchVectorToVarFmt(mv);
            this.m_raf = 3;
        } else {
            this.m_raf = 0;
        }
        this.m_preBodyDirty = true;
        this.sync();
    }
}

