/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import progress.message.msg.IIDRHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.DefaultPayload;
import progress.message.msg.v25.Mgram;
import progress.message.util.EAssertFailure;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.prAccessor;

final class IDRPayload
extends DefaultPayload
implements IIDRHandle {
    private boolean m_more;
    private boolean m_senderHasDoubt;
    private boolean m_responseRequired;
    private byte m_subType;
    private List m_dnrPubSub;
    private List m_dnrPTP;
    private List m_ugaPubSub;
    private List m_ugaPTP;
    boolean m_syncd = false;

    public IDRPayload(Mgram m) {
        super(m);
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        super.initPayloadFromStream(is, sc);
        ObjectInput dis = this.getPayloadInputStreamHandle();
        this.m_more = false;
        this.m_senderHasDoubt = false;
        this.m_responseRequired = false;
        this.m_subType = dis.readByte();
        if (this.m_subType == 3) {
            return;
        }
        boolean more = dis.readBoolean();
        boolean senderDoubt = dis.readBoolean();
        boolean responseRequired = dis.readBoolean();
        this.m_dnrPubSub = new ArrayList();
        this.m_dnrPTP = new ArrayList();
        this.m_ugaPubSub = new ArrayList();
        this.m_ugaPTP = new ArrayList();
        try {
            while (true) {
                byte typ = dis.readByte();
                long tracking = dis.readLong();
                boolean domain = true;
                if ((typ & MgramConstants.MASK_CATEGORY) == MgramConstants.MASK_PTP_VAL) {
                    if ((typ & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_DNR_VAL) {
                        this.m_dnrPTP.add(new Long(tracking));
                        continue;
                    }
                    this.m_ugaPTP.add(new Long(tracking));
                    continue;
                }
                if ((typ & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_DNR_VAL) {
                    this.m_dnrPubSub.add(new Long(tracking));
                    continue;
                }
                this.m_ugaPubSub.add(new Long(tracking));
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    protected void sync() {
        if (this.m_syncd) {
            return;
        }
        ObjectOutput os = this.getPayloadOutputStreamHandle();
        Iterator it = null;
        byte mask = 0;
        long tracking = 0L;
        try {
            os.writeByte(this.m_subType);
            if (this.m_subType == 3) {
                super.sync();
                this.m_syncd = true;
                return;
            }
            os.writeBoolean(this.m_more);
            os.writeBoolean(this.m_senderHasDoubt);
            os.writeBoolean(this.m_responseRequired);
            if (this.m_dnrPubSub != null && !this.m_dnrPubSub.isEmpty()) {
                it = this.m_dnrPubSub.iterator();
                mask = (byte)(MgramConstants.MASK_PUBSUB_VAL | MgramConstants.MASK_DNR_VAL);
                while (it.hasNext()) {
                    tracking = (Long)it.next();
                    os.writeByte(mask);
                    os.writeLong(tracking);
                }
            }
            if (this.m_dnrPTP != null && !this.m_dnrPTP.isEmpty()) {
                it = this.m_dnrPTP.iterator();
                mask = (byte)(MgramConstants.MASK_PTP_VAL | MgramConstants.MASK_DNR_VAL);
                while (it.hasNext()) {
                    tracking = (Long)it.next();
                    os.writeByte(mask);
                    os.writeLong(tracking);
                }
            }
            if (this.m_ugaPubSub != null && !this.m_ugaPubSub.isEmpty()) {
                it = this.m_ugaPubSub.iterator();
                mask = (byte)(MgramConstants.MASK_PUBSUB_VAL | MgramConstants.MASK_UGA_VAL);
                while (it.hasNext()) {
                    tracking = (Long)it.next();
                    os.writeByte(mask);
                    os.writeLong(tracking);
                }
            }
            if (this.m_ugaPTP != null && !this.m_ugaPTP.isEmpty()) {
                it = this.m_ugaPTP.iterator();
                mask = (byte)(MgramConstants.MASK_PTP_VAL | MgramConstants.MASK_UGA_VAL);
                while (it.hasNext()) {
                    tracking = (Long)it.next();
                    os.writeByte(mask);
                    os.writeLong(tracking);
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.m_syncd = true;
        super.sync();
    }

    @Override
    public void setSubType(byte subType) {
        this.m_subType = subType;
    }

    @Override
    public byte getSubType() {
        return this.m_subType;
    }

    @Override
    public void setMore(boolean more) {
        this.m_more = more;
    }

    @Override
    public boolean getMore() {
        return this.m_more;
    }

    @Override
    public void setSenderHasDoubt(boolean senderHasDoubt) {
        this.m_senderHasDoubt = senderHasDoubt;
    }

    @Override
    public boolean getSenderHasDoubt() {
        return this.m_senderHasDoubt;
    }

    @Override
    public void setResponseRequired(boolean responseRequired) {
        this.m_responseRequired = responseRequired;
    }

    @Override
    public boolean getResponseRequired() {
        return this.m_responseRequired;
    }

    @Override
    public void setUGAPubSub(List l) {
        this.m_ugaPubSub = l;
    }

    @Override
    public List getUGAPubSub() {
        return this.m_ugaPubSub;
    }

    @Override
    public void setUGAPTP(List l) {
        this.m_ugaPTP = l;
    }

    @Override
    public List getUGAPTP() {
        return this.m_ugaPTP;
    }

    @Override
    public void setDNRPubSub(List l) {
        this.m_dnrPubSub = l;
    }

    @Override
    public List getDNRPubSub() {
        return this.m_dnrPubSub;
    }

    @Override
    public void setDNRPTP(List l) {
        this.m_dnrPTP = l;
    }

    @Override
    public List getDNRPTP() {
        return this.m_dnrPTP;
    }

    @Override
    public IIDRHandle getIDRHandle() {
        return this;
    }

    @Override
    public String summaryString() {
        StringBuffer sb = new StringBuffer();
        sb.append("subtype=" + this.getSubType());
        if (this.m_subType == 3) {
            return sb.toString();
        }
        sb.append(", senderDoubt=" + this.getSenderHasDoubt() + ", more=" + this.getMore() + ", resp required:" + this.getResponseRequired());
        if (this.m_dnrPubSub != null && this.m_dnrPubSub.size() != 0) {
            sb.append(", dnrPubSub=" + this.dumpList(this.m_dnrPubSub));
        }
        if (this.m_dnrPTP != null && this.m_dnrPTP.size() != 0) {
            sb.append(", dnrPTP=" + this.dumpList(this.m_dnrPTP));
        }
        if (this.m_ugaPubSub != null && this.m_ugaPubSub.size() != 0) {
            sb.append(", ugaPubSub=" + this.dumpList(this.m_ugaPubSub));
        }
        if (this.m_ugaPTP != null && this.m_ugaPTP.size() != 0) {
            sb.append(", ugaPTP=" + this.dumpList(this.m_ugaPTP));
        }
        return sb.toString();
    }

    private String dumpList(List l) {
        if (l == null || l.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap result = super.getPayloadProperties();
        result.put("IIDR_DNR_PTP", this.m_dnrPTP);
        result.put("IIDR_DNR_PUB_SUB", this.m_dnrPubSub);
        result.put("IIDR_MORE", new Boolean(this.m_more));
        result.put("IIDR_RESPONSE_REQUIRED", new Boolean(this.m_responseRequired));
        result.put("IIDR_SENDER_HAS_DOUBT", new Boolean(this.m_senderHasDoubt));
        result.put("IIDR_SUB_TYPE", new Byte(this.m_subType));
        result.put("IIDR_UGA_PTP", this.m_ugaPTP);
        result.put("IIDR_UGA_PUB_SUB", this.m_ugaPubSub);
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        super.setPayloadProperties(map);
        this.m_dnrPTP = (List)map.get("IIDR_DNR_PTP");
        this.m_dnrPubSub = (List)map.get("IIDR_DNR_PUB_SUB");
        this.m_more = (Boolean)map.get("IIDR_MORE");
        this.m_responseRequired = (Boolean)map.get("IIDR_RESPONSE_REQUIRED");
        this.m_senderHasDoubt = (Boolean)map.get("IIDR_SENDER_HAS_DOUBT");
        this.m_subType = (Byte)map.get("IIDR_SUB_TYPE");
        this.m_ugaPTP = (List)map.get("IIDR_UGA_PTP");
        this.m_ugaPubSub = (List)map.get("IIDR_UGA_PUB_SUB");
    }

    @Override
    public void setPREQ(List l) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public List getPREQ() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setPREP(List l) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public List getPREP() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }
}

