/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.IIDRHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.AckPayload;
import progress.message.msg.v25.DefaultDynamicHeader;
import progress.message.msg.v25.DefaultPayload;
import progress.message.msg.v25.DynamicHeader;
import progress.message.msg.v25.ErrorPayload;
import progress.message.msg.v25.FailoverStatusNotificationPayload;
import progress.message.msg.v25.FlowControlPayload;
import progress.message.msg.v25.IBrokerMgramCreator;
import progress.message.msg.v25.IDRPayload;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.NackPayload;
import progress.message.msg.v25.Payload;
import progress.message.msg.v25.QueueFlowControlPayload;
import progress.message.msg.v25.StaticHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.xa.XidImpl;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.SecurityLogic;

public class MgramCreator
extends DebugObject
implements IMgramConverter {
    private static Mgram m_guarAckMgram = null;
    private static byte[] m_ackStaticHeader;
    private static byte[] m_ackDynamicHeader;
    private static byte[] m_flowControlStaticHeader;
    private static byte[] m_flowControlDynamicHeader;
    private static byte[] m_flowControlPayload;
    private static Mgram m_pingRequest;
    private static Mgram m_pingReply;
    private static Mgram m_flowControl;
    private static int TXN_REQUEST_BODY_LENGTH;
    private static int TXN_REPLY_BODY_LENGTH;
    private static IBrokerMgramCreator m_brokerMgramCreator;
    private ISecureInputStream m_sis = null;
    private ISecureOutputStream m_sos = null;
    private ClientSecurityContext m_csc = null;
    private IMessageProtection m_mp = null;
    private IMgramStatusListener m_listener = null;
    private boolean m_isTTEttlConvert = false;
    private StreamUtilCounter m_counter = null;
    private byte[] m_encryptedMessageKey = null;
    private boolean m_ignoreEncryption = false;

    public MgramCreator() {
        super("MgramCreator");
    }

    @Override
    public void initializeConverter(Hashtable properties) {
        Boolean ignoreEncryption;
        this.m_csc = (ClientSecurityContext)properties.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.m_sis = (ISecureInputStream)properties.get(MgramConstants.SECURE_INPUT_STREAM);
        this.m_sos = (ISecureOutputStream)properties.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.m_mp = (IMessageProtection)properties.get(MgramConstants.MESSAGE_PROTECTION);
        this.m_listener = (IMgramStatusListener)properties.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean tteTTL = (Boolean)properties.get(MgramConstants.TTE_TTL_CONVERT);
        if (tteTTL != null) {
            this.m_isTTEttlConvert = tteTTL;
        }
        if ((ignoreEncryption = (Boolean)properties.get(MgramConstants.IGNORE_SECURITY)) != null) {
            this.m_ignoreEncryption = ignoreEncryption;
        }
        this.m_counter = new StreamUtilCounter(true);
    }

    @Override
    public IMgram createMgram(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram m;
        if (this.m_counter != null) {
            this.m_counter.resetCounter();
        }
        if ((m = Mgram.createMgram(is, this.m_sis, this.m_mp, this.m_csc, this.m_listener, this.m_counter, this.m_isTTEttlConvert)).supportsOperationHandle()) {
            int size = StreamUtil.readInt(is);
            for (int count = 0; count < size; ++count) {
                IMgram payload = this.createMgram(is);
                m.getOperationHandle().addMgram(payload);
            }
        }
        return m;
    }

    @Override
    public IMgram createMgram(byte version, InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (this.m_counter != null) {
            this.m_counter.resetCounter();
        }
        if (!this.m_ignoreEncryption) {
            return Mgram.createMgram(version, is, this.m_sis, this.m_mp, this.m_csc, this.m_listener, this.m_counter, this.m_isTTEttlConvert);
        }
        return Mgram.createMgramNonSecure(version, is, this.m_listener, this.m_counter, this.m_isTTEttlConvert);
    }

    private void writeMgramToNetworkStream(IMgram m, OutputStream os) throws IOException {
        m.writeMgramToNetworkStream(os, this.m_csc, this.m_sos, this.m_mp, null);
    }

    @Override
    public void deliver(IMgram m, OutputStream os) throws IOException {
        this.deliver(m, -1, os, null);
    }

    @Override
    public void deliver(IMgram m, int channel, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        m.writeMgramToNetworkStream(os, channel, this.m_csc, this.m_sos, this.m_mp, ctx);
        if (m.supportsOperationHandle()) {
            LinkedList ll = m.getOperationHandle().getMgramList();
            if (ll != null) {
                StreamUtil.writeInt(ll.size(), os);
                for (int count = 0; count < ll.size(); ++count) {
                    m = (IMgram)ll.get(count);
                    this.deliver(m, channel, os, null);
                }
            } else {
                StreamUtil.writeInt(0, os);
            }
        }
    }

    @Override
    public void secureDeliver(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        if (m.isSecure() && (SecurityLogic.isMKeyMacHeader(m.getSecurity()) || SecurityLogic.isMKeyDigest(m.getSecurity()))) {
            this.messageKeySlicedDelivery(m, channel, csc, os);
        } else if (m.isSecure() && (SecurityLogic.isSKeyDigest(m.getSecurity()) || SecurityLogic.isSKeyEncryption(m.getSecurity()))) {
            this.sessionKeySlicedDelivery(m, channel, csc, os);
        } else {
            m.writeMgramToNetworkStream(os, channel, csc, this.m_sos, this.m_mp, ctx);
            this.deliverSecureOperationPayloads(m, channel, csc, os);
        }
    }

    private void messageKeySlicedDelivery(IMgram m, int channel, ClientSecurityContext csc, OutputStream os) throws IOException {
        IMgramConverterHandle mch = m.getMgramConverterHandle();
        mch.recalculatePad(this.m_mp);
        if (this.m_encryptedMessageKey == null) {
            this.m_encryptedMessageKey = new byte[this.m_mp.getOutputSize(this.m_mp.getSecretKeyLength())];
        }
        m.getBrokerHandle().encryptMessageKey(this.m_encryptedMessageKey, this.m_mp);
        StaticHeader.writeToStream(os, mch.getInternalStaticHeader(), channel, true);
        mch.getInternalDynamicHeader().writeToStream(os, this.m_mp, this.m_encryptedMessageKey, null, null);
        mch.getInternalPayload().writeToStream(os);
        this.deliverSecureOperationPayloads(m, channel, csc, os);
    }

    private void deliverSecureOperationPayloads(IMgram m, int channel, ClientSecurityContext csc, OutputStream os) throws IOException {
        if (m.supportsOperationHandle()) {
            LinkedList ll = m.getOperationHandle().getMgramList();
            if (ll != null) {
                StreamUtil.writeInt(ll.size(), os);
                for (int count = 0; count < ll.size(); ++count) {
                    m = (IMgram)ll.get(count);
                    this.secureDeliver(m, channel, csc, os, null);
                }
            } else {
                StreamUtil.writeInt(0, os);
            }
        }
    }

    private void sessionKeySlicedDelivery(IMgram m, int channel, ClientSecurityContext csc, OutputStream os) throws IOException {
        IMgramConverterHandle mch = m.getMgramConverterHandle();
        mch.recalculatePad(this.m_mp);
        byte[] mac = null;
        if (SecurityLogic.isSKeyDigest(m.getSecurity())) {
            mac = mch.calculateMac(csc.getDigestKey(), this.m_mp);
        }
        StaticHeader.writeToStream(os, mch.getInternalStaticHeader(), channel, true);
        mch.getInternalDynamicHeader().writeToStream(os, this.m_mp, null, mac, null);
        m.writePayloadToStream(os, this.m_sos);
        this.deliverSecureOperationPayloads(m, channel, csc, os);
    }

    @Override
    public IMgram unserialize(InputStream os, boolean tteTTLConvert) throws IOException {
        return this.unserialize(os);
    }

    public IMgram unserialize(InputStream is) throws IOException {
        IMgram m = Mgram.unserialize(is);
        if (m.supportsOperationHandle()) {
            int size = StreamUtil.readInt(is);
            for (int count = 0; count < size; ++count) {
                byte version = StreamUtil.readByte(is);
                IMgram payload = this.unserialize(is);
                m.getOperationHandle().addMgram(payload);
            }
        }
        return m;
    }

    @Override
    public void serialize(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
        this.serialize(os, m);
    }

    public void serialize(OutputStream os, IMgram m) throws IOException {
        IOperationHandle ioh;
        LinkedList ll;
        m.getBrokerHandle().serialize(os, false);
        if (m.supportsOperationHandle() && (ll = (ioh = m.getOperationHandle()).getMgramList()) != null) {
            int size = ll.size();
            StreamUtil.writeInt(size, os);
            for (int count = 0; count < size; ++count) {
                IMgram payload = (IMgram)ll.get(count);
                this.serialize(os, payload);
            }
        }
    }

    public void writeMgramToStreamNonSecure(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
    }

    public IMgram createMgram(byte[] data) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return new Mgram(data);
    }

    public IMgram createMgram(boolean initialize) {
        return new Mgram(initialize);
    }

    public static IMgram buildAck(long tracking, long clientID, short err, int channel) {
        return MgramCreator.buildAck(tracking, clientID, err, false, 0L, false, 0, channel);
    }

    public static IMgram buildAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        Mgram ack = null;
        ack = new Mgram(false);
        byte[] staticHeader = new byte[m_ackStaticHeader.length];
        System.arraycopy(m_ackStaticHeader, 0, staticHeader, 0, m_ackStaticHeader.length);
        byte[] dynamicHeader = new byte[m_ackDynamicHeader.length];
        System.arraycopy(m_ackDynamicHeader, 0, dynamicHeader, 0, m_ackDynamicHeader.length);
        StaticHeader.setChannel(channel, staticHeader);
        ack.setStaticHeader(staticHeader);
        ack.setDynamicHeaderCache(dynamicHeader);
        byte[] payload = AckPayload.createPayload(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid);
        DefaultDynamicHeader.setMessageLength(payload.length, dynamicHeader);
        if (guaranteed) {
            StaticHeader.setGuarenteed(guaranteed, staticHeader);
        }
        if (txn) {
            StaticHeader.setTxn(txn, staticHeader);
        }
        ack.setPayloadCache(payload);
        return ack;
    }

    public IMgram buildQAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        IMgram ack = null;
        ack = MgramCreator.buildAck(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid, channel);
        ack.setType((byte)14);
        return ack;
    }

    public IMgram buildQueueGetRequestMgram(boolean secure, int channel, short receiveType, int prefetchCount, String subject) {
        Mgram qGetRequestMgram = new Mgram(true);
        qGetRequestMgram.setType((byte)13);
        qGetRequestMgram.setChannel(channel);
        qGetRequestMgram.setSubject(subject, 3);
        byte[] body = new byte[6];
        int p = 0;
        ArrayUtil.writeShort(body, p, receiveType);
        ArrayUtil.writeInt(body, p += 2, prefetchCount);
        qGetRequestMgram.setBody(body);
        if (secure) {
            qGetRequestMgram.setMgramSecure(null);
            qGetRequestMgram.setSecurityAttribute((byte)0);
        }
        qGetRequestMgram.sync();
        return qGetRequestMgram;
    }

    public IMgram buildQueueOpenRemoteReceiverMgram(boolean secure, int channel, String subject, String msgSelector) {
        Mgram qOpenRemoteReceiverMgram = new Mgram(true);
        qOpenRemoteReceiverMgram.setType((byte)30);
        qOpenRemoteReceiverMgram.setChannel(channel);
        qOpenRemoteReceiverMgram.setSubject(subject, 3);
        qOpenRemoteReceiverMgram.setRouteLimit(1);
        byte[] body = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StreamUtil.writeUTF(msgSelector == null ? "" : msgSelector, baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        body = baos.toByteArray();
        qOpenRemoteReceiverMgram.setBody(body);
        if (secure) {
            qOpenRemoteReceiverMgram.setMgramSecure(null);
            qOpenRemoteReceiverMgram.setSecurityAttribute((byte)0);
        }
        qOpenRemoteReceiverMgram.sync();
        return qOpenRemoteReceiverMgram;
    }

    public IMgram buildQueueCloseRemoteReceiverMgram(boolean secure, int channel, String subject, String msgSelector) {
        Mgram qCloseRemoteReceiverMgram = new Mgram(true);
        qCloseRemoteReceiverMgram.setType((byte)31);
        qCloseRemoteReceiverMgram.setChannel(channel);
        qCloseRemoteReceiverMgram.setSubject(subject, 3);
        qCloseRemoteReceiverMgram.setRouteLimit(1);
        byte[] body = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StreamUtil.writeUTF(msgSelector == null ? "" : msgSelector, baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        body = baos.toByteArray();
        qCloseRemoteReceiverMgram.setBody(body);
        if (secure) {
            qCloseRemoteReceiverMgram.setMgramSecure(null);
            qCloseRemoteReceiverMgram.setSecurityAttribute((byte)0);
        }
        qCloseRemoteReceiverMgram.sync();
        return qCloseRemoteReceiverMgram;
    }

    public IMgram buildPingRequest(byte[] payload, int channel) {
        IMgram ping = null;
        try {
            ping = (IMgram)m_pingRequest.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        ping.setChannel(channel);
        ping.setBody(payload);
        return ping;
    }

    public IMgram buildPingReply(IMgram m) {
        IMgram ping = null;
        try {
            ping = (IMgram)m_pingReply.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ping.setChannel(m.getChannel());
        ping.setBody(m.getRawBody());
        return ping;
    }

    public IMgram buildDisconnectRequest(int channel, boolean forceDisconnect) {
        Mgram disconnect = new Mgram(true);
        disconnect.setType((byte)7);
        disconnect.setPriority((byte)0);
        disconnect.setRequestReplyType(2);
        disconnect.setChannel(channel);
        disconnect.setReplyToAddressFormat(0);
        byte[] body = new byte[]{(byte)(forceDisconnect ? 1 : 0)};
        disconnect.setBody(body);
        return disconnect;
    }

    public IMgram buildFlowControlMgram(byte minPriority, int channel) {
        Mgram flowControl = new Mgram(false);
        byte[] flowControlPayload = new byte[m_flowControlPayload.length];
        System.arraycopy(m_flowControlPayload, 0, flowControlPayload, 0, m_flowControlPayload.length);
        byte[] flowControlDynamicHeader = new byte[m_flowControlDynamicHeader.length];
        System.arraycopy(m_flowControlDynamicHeader, 0, flowControlDynamicHeader, 0, m_flowControlDynamicHeader.length);
        byte[] flowControlStaticHeader = new byte[m_flowControlStaticHeader.length];
        System.arraycopy(m_flowControlStaticHeader, 0, flowControlStaticHeader, 0, m_flowControlStaticHeader.length);
        FlowControlPayload.setMinPriority(minPriority, flowControlPayload);
        StaticHeader.setChannel(channel, flowControlStaticHeader);
        flowControl.setStaticHeader(flowControlStaticHeader);
        flowControl.setDynamicHeaderCache(flowControlDynamicHeader);
        flowControl.setPayloadCache(flowControlPayload);
        return flowControl;
    }

    public IMgram buildVersionMgram(int channel, byte version) {
        Mgram versionMgram = new Mgram(true);
        versionMgram.setType((byte)4);
        versionMgram.setVersion(version);
        versionMgram.setChannel(channel);
        versionMgram.setPostV22();
        return versionMgram;
    }

    public IMgram buildVersionMgram(int channel, byte version, byte sessionVer) {
        Mgram versionMgram = new Mgram(true);
        versionMgram.setType((byte)4);
        versionMgram.setVersion(version);
        versionMgram.setChannel(channel);
        versionMgram.setPostV22();
        versionMgram.setSessionVer(sessionVer);
        return versionMgram;
    }

    public IMgram buildConnectMgram(byte[] payload, int channel) {
        Mgram connectMgram = new Mgram(true);
        connectMgram.setType((byte)1);
        connectMgram.setRequestReplyType(0);
        connectMgram.setChannel(channel);
        connectMgram.setBody(payload);
        return connectMgram;
    }

    public IMgram buildErrorMgram(int errcode, int errinfo, IMgram m, int channel) {
        Mgram error = new Mgram(false);
        error.setStaticHeader(StaticHeader.getDefaultByteArray());
        error.setDynamicHeader(new DefaultDynamicHeader(error));
        error.setPayload(new ErrorPayload(error));
        if (m != null && m.hasID()) {
            error.setID(m.getID());
        }
        error.setType((byte)-1);
        error.setChannel(channel);
        error.getErrorHandle().setErrCode(errcode);
        error.getErrorHandle().setErrInfo(errinfo);
        return error;
    }

    public IMgram buildTxnRequest(boolean chained, int tid, int tracking, long clientId, int channel) {
        Mgram txnRequest = new Mgram(true);
        txnRequest.setType((byte)8);
        txnRequest.setRequestReplyType(0);
        txnRequest.setPriority((byte)0);
        txnRequest.setChannel(channel);
        byte[] body = new byte[TXN_REQUEST_BODY_LENGTH];
        int p = 0;
        ArrayUtil.writeShort(body, p, (short)(chained ? 1 : 0));
        ArrayUtil.writeInt(body, p += 2, tracking);
        ArrayUtil.writeInt(body, p += 4, tid);
        ArrayUtil.writeLong(body, p += 4, clientId);
        txnRequest.setBody(body);
        return txnRequest;
    }

    public IMgram buildTxnReply(short status, int nextTid, int tracking, int channel) {
        Mgram txnReply = new Mgram(true);
        txnReply.setType((byte)8);
        txnReply.setRequestReplyType(3);
        txnReply.setPriority((byte)10);
        txnReply.setChannel(channel);
        byte[] body = new byte[TXN_REPLY_BODY_LENGTH];
        int p = 0;
        ArrayUtil.writeShort(body, p, status);
        ArrayUtil.writeInt(body, p += 2, tracking);
        ArrayUtil.writeInt(body, p += 4, nextTid);
        p += 4;
        txnReply.setBody(body);
        return txnReply;
    }

    public IMgram buildExtendedTxnRequest(boolean chained, int tid, int tracking, long clientId, int channel, XidImpl xid, int op) {
        Mgram txnRequest = new Mgram(true);
        txnRequest.setType((byte)26);
        txnRequest.setRequestReplyType(0);
        txnRequest.setPriority((byte)0);
        txnRequest.setChannel(channel);
        int EXTENDED_TXN_REQUEST_BODY_LENGTH = 22 + xid.getMemorySize();
        byte[] body = new byte[EXTENDED_TXN_REQUEST_BODY_LENGTH];
        int p = 0;
        ArrayUtil.writeInt(body, p, op);
        ArrayUtil.writeShort(body, p += 4, (short)(chained ? 1 : 0));
        ArrayUtil.writeInt(body, p += 2, tracking);
        ArrayUtil.writeInt(body, p += 4, tid);
        ArrayUtil.writeLong(body, p += 4, clientId);
        xid.writebody(body, p += 8);
        txnRequest.setBody(body);
        return txnRequest;
    }

    public IMgram buildGRConvertMgram(long code, long clientid, int channel, long token) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildGRConvertMgram(code, clientid, channel, token);
        }
        throw new EAssertFailure("Cannot create GR convert mgram without broker");
    }

    public IMgram buildFailoverStatusNotification(int state, String[] redundantURLs) {
        Mgram status = new Mgram(true);
        status.setType((byte)21);
        status.setPriority((byte)10);
        status.setChannel(0);
        status.setRouteLimit(1);
        status.setMgramNonSecure();
        status.setPayload(new FailoverStatusNotificationPayload(status));
        IFailoverStatusNotificationHandle handle = status.getFailoverStatusNotificationHandle();
        handle.setState(state);
        handle.setRedundantURLs(redundantURLs);
        status.sync();
        return status;
    }

    public IMgram buildOperationMgram(int operationType) {
        Mgram operation = new Mgram(true);
        operation.setType((byte)25);
        operation.getOperationHandle().setOperationType(operationType);
        return operation;
    }

    public IMgram buildIDRAckMgram() {
        Mgram m = new Mgram(true);
        m.setType((byte)23);
        m.setPriority((byte)10);
        m.setRouteLimit(1);
        m.setMgramNonSecure();
        m.setPayload(new IDRPayload(m));
        IIDRHandle handle = m.getIDRHandle();
        handle.setSubType((byte)3);
        m.sync();
        return m;
    }

    public List buildIDRMgramList(boolean isRequest, boolean needsResponseOnLast, boolean senderHasDoubt, List dnrPubSub, List dnrPTP, List ugaPubSub, List ugaPTP) {
        Vector<Mgram> l = new Vector<Mgram>();
        byte subType = isRequest ? (byte)1 : 2;
        Mgram m = new Mgram(true);
        m.setType((byte)23);
        m.setPriority((byte)10);
        m.setRouteLimit(1);
        m.setMgramNonSecure();
        m.setPayload(new IDRPayload(m));
        IIDRHandle handle = m.getIDRHandle();
        handle.setSubType(subType);
        handle.setMore(false);
        handle.setSenderHasDoubt(senderHasDoubt);
        handle.setResponseRequired(needsResponseOnLast);
        handle.setDNRPTP(dnrPTP);
        handle.setDNRPubSub(dnrPubSub);
        handle.setUGAPTP(ugaPTP);
        handle.setUGAPubSub(ugaPubSub);
        m.sync();
        l.add(m);
        return l;
    }

    public IMgram buildFirstMessageNotification(long clientID) {
        IMgram m = this.buildOperationMgram(1);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public IMgram buildDeliveryFinished(long clientID) {
        IMgram m = this.buildOperationMgram(21);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public IMgram buildLastMessageNotification(long clientID) {
        IMgram m = this.buildOperationMgram(2);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public IMgram buildSingleTargetMessage(long clientID, IMgram msg) {
        if (this.DEBUG) {
            this.debug("building single target op mgram");
        }
        IMgram m = this.buildOperationMgram(3);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
            m.getOperationHandle().addMgram(msg);
            m.setPriority(msg.getPriority());
            m.setDiscardable(msg.isDiscardable());
            m.setTTE(msg.getTTE());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public IMgram buildLBSTargetMessage(IMgram m, FastVector targets) {
        int hops;
        if (this.DEBUG) {
            this.debug("building LBS op mgram");
        }
        IMgram wrapper = this.buildOperationMgram((hops = ((Integer)targets.m_data[0]).intValue()) == 1 ? 13 : 14);
        ObjectOutput out = wrapper.getPayloadOutputStreamHandle();
        wrapper.setRouteLimit(m.getRouteLimit());
        wrapper.setPriority(m.getPriority());
        wrapper.setDiscardable(m.isDiscardable());
        wrapper.setTTE(m.getTTE());
        if (m.isGuarenteed()) {
            wrapper.setGuarenteed(m.getGuarenteedTrackingNum());
        }
        if (m.isSecure()) {
            wrapper.setMgramSecure(m.getMessageProtection());
            try {
                wrapper.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, SecurityLogic.getPubAttr(m.getSecurity())));
            }
            catch (ESecurityInvalidLogistics il) {
                throw new EAssertFailure(il.getMessage());
            }
        }
        try {
            out.writeInt(hops);
            for (int i = 1; i <= hops; ++i) {
                out.writeLong((Long)targets.m_data[i]);
            }
            out.writeInt(targets.m_count - ++hops);
            for (int j = hops; j < targets.m_count; ++j) {
                out.writeUTF((String)targets.m_data[j]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        wrapper.getOperationHandle().addMgram(m);
        return wrapper;
    }

    public IMgram buildDisconnectReply(int channel, boolean reject) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildDisconnectReply(channel, reject);
        }
        throw new EAssertFailure("Cannot create DisconnectReply without broker");
    }

    public IMgram buildTxnEOFMarker() {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildTxnEOFMarker();
        }
        throw new EAssertFailure("Cannot create TxnEOFMarker without broker");
    }

    public IMgram buildRemoteRestorePhasesDoneMgram(long clientID) {
        IMgram m = this.buildOperationMgram(20);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public IMgram buildResumeMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildResumeMgram(channel, utfDestination, utfLength, routing);
        }
        throw new EAssertFailure("Cannot create Resume without broker");
    }

    public IMgram buildBlockMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildBlockMgram(channel, utfDestination, utfLength, routing);
        }
        throw new EAssertFailure("Cannot create Block without broker");
    }

    public IMgram buildNack(long tracking, int channel) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildNack(tracking, channel);
        }
        throw new EAssertFailure("Cannot create Nack without broker");
    }

    public IMgram buildRouteRequest(int channel, int requestType, long requestTime, int infoCount, byte[] routeInfo) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildRouteRequest(channel, requestType, requestTime, infoCount, routeInfo);
        }
        throw new EAssertFailure("Cannot create Route Request without broker");
    }

    public IMgram buildIBConvertMgram(long token, int channel) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildIBConvertMgram(token, channel);
        }
        throw new EAssertFailure("Cannot create IB Convert without broker");
    }

    public IMgram buildStateEventMgram(IStateEvent event, boolean tteTTLConvert) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildStateEventMgram(event, tteTTLConvert);
        }
        throw new EAssertFailure("Cannot create StateEvent without broker");
    }

    public static Payload getPayloadObject(byte type, Mgram m) {
        Payload result;
        switch (type) {
            case 4: {
                return null;
            }
            case 18: 
            case 19: {
                result = new QueueFlowControlPayload(m);
                break;
            }
            case 6: {
                result = new FlowControlPayload(m);
                break;
            }
            case 3: 
            case 14: {
                result = new AckPayload(m);
                break;
            }
            case 20: {
                result = new NackPayload(m);
                break;
            }
            case -1: {
                result = new ErrorPayload(m);
                break;
            }
            case 21: {
                result = new FailoverStatusNotificationPayload(m);
                break;
            }
            case 23: {
                result = new IDRPayload(m);
                break;
            }
            default: {
                result = null;
            }
        }
        if (result == null && m_brokerMgramCreator != null) {
            result = m_brokerMgramCreator.getPayloadObject(type, m);
        }
        if (result == null) {
            result = new DefaultPayload(m);
        }
        return result;
    }

    @Override
    public byte getVersion() {
        return 25;
    }

    static {
        TXN_REQUEST_BODY_LENGTH = 18;
        TXN_REPLY_BODY_LENGTH = 10;
        m_brokerMgramCreator = null;
        m_ackStaticHeader = StaticHeader.getDefaultByteArray();
        DefaultDynamicHeader dh = new DefaultDynamicHeader(null);
        ((DynamicHeader)dh).setMessageLength(16);
        m_ackDynamicHeader = ((DynamicHeader)dh).toByteArray();
        StaticHeader.setType((byte)3, m_ackStaticHeader);
        StaticHeader.setPriority((byte)11, m_ackStaticHeader);
        m_guarAckMgram = new Mgram(false);
        m_guarAckMgram.setStaticHeader(StaticHeader.getDefaultByteArray());
        m_guarAckMgram.setDynamicHeader(new DefaultDynamicHeader(m_guarAckMgram));
        m_guarAckMgram.setPayload(new AckPayload(m_guarAckMgram));
        m_guarAckMgram.setGuarenteed(0L);
        m_guarAckMgram.setType((byte)3);
        m_guarAckMgram.setPriority((byte)11);
        m_guarAckMgram.sync();
        m_pingRequest = new Mgram(false);
        m_pingRequest.setStaticHeader(StaticHeader.getDefaultByteArray());
        dh = new DefaultDynamicHeader(m_pingRequest);
        m_pingRequest.setDynamicHeader(dh);
        DefaultPayload payload = new DefaultPayload(m_pingRequest);
        payload.setReplyToAddressFormat(0);
        m_pingRequest.setPayload(payload);
        m_pingRequest.setType((byte)0);
        m_pingRequest.setPriority((byte)12);
        m_pingRequest.setRequestReplyType(2);
        m_pingRequest.sync();
        m_pingReply = new Mgram(false);
        m_pingReply.setStaticHeader(StaticHeader.getDefaultByteArray());
        m_pingReply.setDynamicHeader(new DefaultDynamicHeader(m_pingReply));
        DefaultPayload payload2 = new DefaultPayload(m_pingReply);
        payload2.setReplyToAddressFormat(0);
        m_pingReply.setPayload(payload2);
        m_pingReply.setType((byte)0);
        m_pingReply.setPriority((byte)12);
        m_pingReply.setRequestReplyType(3);
        m_pingReply.sync();
        m_flowControl = new Mgram(false);
        m_flowControlStaticHeader = StaticHeader.getDefaultByteArray();
        dh = new DefaultDynamicHeader(null);
        ((DynamicHeader)dh).setMessageLength(1);
        m_flowControlDynamicHeader = ((DynamicHeader)dh).toByteArray();
        StaticHeader.setType((byte)6, m_flowControlStaticHeader);
        StaticHeader.setPriority((byte)12, m_flowControlStaticHeader);
        StaticHeader.setRequestReplyType(0, m_flowControlStaticHeader);
        m_flowControlPayload = new FlowControlPayload(null).toByteArray();
        try {
            Class<?> brokerCreator = Class.forName("progress.message.msg.v25.broker.MgramCreator");
            m_brokerMgramCreator = (IBrokerMgramCreator)brokerCreator.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

