/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import progress.message.msg.IAckListHandle;
import progress.message.msg.IMgram;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.MgramCreator;
import progress.message.msg.v26.Payload;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

public class AckListPayload
extends Payload
implements IAckListHandle {
    static final int s_ackListMemSize = MemoryUtil.estimateBaseSize(AckListPayload.class);
    static final int DEFAULT_SIZE = 50;
    private ArrayList m_pubSubList;
    private int m_pubSubSerializedSize;
    private int m_pubSubMemorySize;
    private ArrayList m_ptpList;
    private int m_ptpSerializedSize;
    private int m_ptpMemorySize;
    private long m_guarTracking = -1L;
    private int m_txnId;
    private static final byte HAS_CLIENTID_MASK = 1;
    private static final byte HAS_IS_GUAR_MASK = 2;
    private static final byte HAS_IS_TXN_MASK = 4;
    private static final byte HAS_SUBJECT_TRACKING_MASK = 8;

    public AckListPayload(Mgram m) {
        super(m);
    }

    @Override
    public void setPayloadProperties(HashMap map) {
    }

    @Override
    public HashMap getPayloadProperties() {
        return new HashMap();
    }

    @Override
    protected void dump() {
    }

    @Override
    protected int memoryLength() {
        return s_ackListMemSize + this.m_ptpMemorySize + this.m_pubSubMemorySize;
    }

    @Override
    public int length() {
        return this.m_pubSubSerializedSize + this.m_ptpSerializedSize;
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeToStream(baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    @Override
    protected boolean isDirty() {
        return false;
    }

    @Override
    protected void syncPayload() {
    }

    @Override
    public String summaryString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_mgram.isGuarenteed()) {
            sb.append("GUAR=" + this.m_mgram.getGuarenteedTrackingNum());
        }
        if (this.m_mgram.hasTxn()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("TX=" + this.m_mgram.getTxnId());
        }
        if (this.m_ptpList != null) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("ptp:");
            this.writeListToStringBuffer(this.m_ptpList, sb);
        }
        if (this.m_pubSubList != null) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("pub/sub:");
            this.writeListToStringBuffer(this.m_pubSubList, sb);
        }
        return sb.toString();
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        if (this.m_mgram.isGuarenteed()) {
            StreamUtil.write6ByteLong(this.m_guarTracking, os);
        }
        if (this.m_mgram.hasTxn()) {
            StreamUtil.writeInt(this.m_txnId, os);
        }
        this.writeListToStream(this.m_ptpList, os);
        this.writeListToStream(this.m_pubSubList, os);
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        if (this.m_mgram.isGuarenteed()) {
            this.m_guarTracking = StreamUtil.read6ByteLong(is);
        }
        if (this.m_mgram.hasTxn()) {
            this.m_txnId = StreamUtil.readInt(is);
        }
        this.m_ptpList = this.readListFromStream(is);
        this.m_pubSubList = this.readListFromStream(is);
    }

    private void writeListToStream(ArrayList list, OutputStream os) throws IOException {
        if (list != null) {
            int size = list.size();
            StreamUtil.writeInt(size, os);
            for (int count = 0; count < size; ++count) {
                Ack ack = (Ack)list.get(count);
                StreamUtil.writeByte(ack.m_bitField, os);
                StreamUtil.write6ByteLong(ack.m_msgTracking, os);
                StreamUtil.writeInt(ack.m_channel, os);
                if (ack.isGuaranteed()) {
                    StreamUtil.write6ByteLong(ack.m_ackTracking, os);
                }
                if (ack.isTxn()) {
                    StreamUtil.writeInt(ack.m_tid, os);
                }
                if (ack.hasClientID()) {
                    StreamUtil.writeLong(ack.m_clientID, os);
                }
                if (!ack.hasSubjectTracking()) continue;
                StreamUtil.writeShort(ack.m_subjectTracking, os);
            }
        } else {
            StreamUtil.writeInt(0, os);
        }
    }

    private void writeListToStringBuffer(ArrayList list, StringBuffer sb) {
        int size = list.size();
        for (int count = 0; count < size; ++count) {
            Ack ack = (Ack)list.get(count);
            if (count != 0) {
                sb.append(";");
            }
            sb.append(ack.summaryString());
        }
    }

    private ArrayList readListFromStream(InputStream is) throws IOException {
        int size = StreamUtil.readInt(is);
        ArrayList<Ack> list = null;
        if (size > 0) {
            list = new ArrayList<Ack>();
            for (int count = 0; count < size; ++count) {
                Ack ack = new Ack();
                ack.m_bitField = StreamUtil.readByte(is);
                ack.m_msgTracking = StreamUtil.read6ByteLong(is);
                ack.m_channel = StreamUtil.readInt(is);
                if ((ack.m_bitField & 2) > 0) {
                    ack.m_ackTracking = StreamUtil.read6ByteLong(is);
                }
                if ((ack.m_bitField & 4) > 0) {
                    ack.m_tid = StreamUtil.readInt(is);
                }
                ack.m_clientID = (ack.m_bitField & 1) > 0 ? StreamUtil.readLong(is) : -1L;
                ack.m_subjectTracking = (ack.m_bitField & 8) > 0 ? StreamUtil.readShort(is) : (short)-1;
                list.add(ack);
            }
        }
        return list;
    }

    @Override
    public void setGuarenteed(long tracking) {
        this.m_guarTracking = tracking;
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_guarTracking;
    }

    @Override
    public int getTxnId() {
        return this.m_txnId;
    }

    @Override
    public void removeTxn() {
    }

    @Override
    public void setTxn(int tid) {
        this.m_txnId = tid;
    }

    @Override
    public void addAck(long tracking, int channel) {
        this.addAck(tracking, -1L, false, 0L, false, 0, channel);
    }

    @Override
    public void addSplitDeliveryAck(long tracking, int channel, short subjectTracking) {
        this.addAckToList(true, tracking, -1L, false, -1L, false, 0, channel, subjectTracking);
    }

    @Override
    public void addSplitDeliveryAck(long msgTracking, long clientID, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel, short subjectTracking) {
        this.addAckToList(true, msgTracking, clientID, guaranteed, ackTracking, txn, tid, channel, subjectTracking);
    }

    @Override
    public void addAck(long msgTracking, long clientID, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        this.addAckToList(true, msgTracking, clientID, guaranteed, ackTracking, txn, tid, channel, (short)-1);
    }

    @Override
    public void addQAck(long msgTracking, int channel) {
        this.addQAck(msgTracking, -1L, false, 0L, false, 0, channel);
    }

    @Override
    public void addQAck(long msgTracking, long clientID, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        this.addAckToList(false, msgTracking, clientID, guaranteed, ackTracking, txn, tid, channel, (short)-1);
    }

    @Override
    public Collection getPubSubList() {
        ArrayList<IMgram> result = null;
        if (this.m_pubSubList != null && !this.m_pubSubList.isEmpty()) {
            result = new ArrayList<IMgram>(this.m_pubSubList.size());
            for (int count = 0; count < this.m_pubSubList.size(); ++count) {
                Ack ack = (Ack)this.m_pubSubList.get(count);
                if (!ack.hasSubjectTracking()) {
                    result.add(MgramCreator.buildAck(ack.m_msgTracking, ack.m_clientID, (short)0, ack.isGuaranteed(), ack.m_ackTracking, ack.isTxn(), ack.m_tid, ack.m_channel));
                    continue;
                }
                result.add(MgramCreator.buildSplitDeliveryAck(ack.m_msgTracking, ack.m_clientID, (short)0, ack.isGuaranteed(), ack.m_ackTracking, ack.isTxn(), ack.m_tid, ack.m_channel, ack.m_subjectTracking));
            }
        }
        return result;
    }

    @Override
    public Collection getPtpList() {
        ArrayList<IMgram> result = null;
        if (this.m_ptpList != null && !this.m_ptpList.isEmpty()) {
            result = new ArrayList<IMgram>(this.m_ptpList.size());
            for (int count = 0; count < this.m_ptpList.size(); ++count) {
                Ack ack = (Ack)this.m_ptpList.get(count);
                result.add(MgramCreator.buildQAck(ack.m_msgTracking, ack.m_clientID, (short)0, ack.isGuaranteed(), ack.m_ackTracking, ack.isTxn(), ack.m_tid, ack.m_channel));
            }
        }
        return result;
    }

    @Override
    IAckListHandle getAckListHandle() {
        return this;
    }

    private void addAckToList(boolean isPubSub, long msgTracking, long clientID, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel, short subjectTracking) {
        ArrayList list = null;
        if (isPubSub) {
            if (this.m_pubSubList == null) {
                this.m_pubSubList = new ArrayList(50);
            }
            list = this.m_pubSubList;
        } else {
            if (this.m_ptpList == null) {
                this.m_ptpList = new ArrayList(50);
            }
            list = this.m_ptpList;
        }
        Ack ack = new Ack();
        ack.m_msgTracking = msgTracking;
        ack.m_clientID = clientID;
        ack.m_ackTracking = ackTracking;
        ack.m_tid = tid;
        ack.m_channel = channel;
        ack.m_subjectTracking = subjectTracking;
        if (guaranteed) {
            ack.m_bitField = (byte)(ack.m_bitField | 2);
        }
        if (txn) {
            ack.m_bitField = (byte)(ack.m_bitField | 4);
        }
        if (clientID != -1L) {
            ack.m_bitField = (byte)(ack.m_bitField | 1);
        }
        if (ack.m_subjectTracking != -1) {
            ack.m_bitField = (byte)(ack.m_bitField | 8);
        }
        list.add(ack);
        if (isPubSub) {
            this.m_pubSubSerializedSize += ack.serializedSize();
            this.m_pubSubMemorySize += ack.memoryLength();
        } else {
            this.m_ptpSerializedSize += ack.serializedSize();
            this.m_ptpMemorySize += ack.memoryLength();
        }
    }

    static class Ack {
        static final int s_ackMemSize = MemoryUtil.estimateBaseSize(Ack.class);
        byte m_bitField;
        long m_msgTracking;
        long m_clientID;
        long m_ackTracking;
        int m_tid;
        int m_channel;
        short m_subjectTracking = (short)-1;

        Ack() {
        }

        public int serializedSize() {
            int result = 11 + (this.hasClientID() ? 8 : 0) + (this.isGuaranteed() ? 6 : 0) + (this.isTxn() ? 4 : 0) + (this.hasSubjectTracking() ? 2 : 0);
            return result;
        }

        public int memoryLength() {
            return s_ackMemSize;
        }

        public boolean hasClientID() {
            return (this.m_bitField & 1) > 0;
        }

        public boolean isGuaranteed() {
            return (this.m_bitField & 2) > 0;
        }

        public boolean isTxn() {
            return (this.m_bitField & 4) > 0;
        }

        public boolean hasSubjectTracking() {
            return (this.m_bitField & 8) > 0;
        }

        public String summaryString() {
            StringBuffer sb = new StringBuffer();
            sb.append("acked=" + this.m_msgTracking);
            if (this.isTxn()) {
                sb.append(",tid=" + this.m_tid);
            }
            if (this.hasClientID()) {
                sb.append(",cid=" + this.m_clientID);
            }
            if (this.isGuaranteed()) {
                sb.append(",guar=" + this.m_ackTracking);
            }
            if (this.hasSubjectTracking()) {
                sb.append(",subject trk=" + this.m_ackTracking);
            }
            return sb.toString();
        }
    }
}

