/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.Payload;
import progress.message.util.EnhancedByteArrayOutputStream;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public final class PTPFlowControlPayload
extends Payload
implements IPTPFlowControlHandle {
    private static final int s_qfcMemSize = MemoryUtil.estimateBaseSize(PTPFlowControlPayload.class);
    private static final byte HAS_ROUTING_MASK = 1;
    private static final byte IS_PUBSUB_MASK = 2;
    private byte[] m_bodyBuffer = null;
    private boolean m_isDirty = true;
    private byte m_subType = (byte)-1;
    private byte[] m_routingUTF = null;
    private String m_routing = null;
    private boolean m_isPubSub = false;
    private ISubject m_flowSubject = null;

    public PTPFlowControlPayload(Mgram m) {
        super(m);
    }

    public static byte[] createPayload(ISubject flowSubject, String routing, boolean pubSub, byte operation) {
        int length = 2;
        byte[] routingUTF = null;
        if (routing != null) {
            try {
                routingUTF = StringUtil.stringToUTF(routing);
                length += routingUTF.length;
            }
            catch (UTFDataFormatException ex) {
                SessionConfig.logMessage("Invalid routing: " + routing, ex, SessionConfig.SEVERE);
            }
        }
        EnhancedByteArrayOutputStream baos = new EnhancedByteArrayOutputStream(length += flowSubject.getSerializedLength());
        try {
            byte flags = 0;
            if (routing != null) {
                flags = (byte)(flags | 1);
            }
            if (pubSub) {
                flags = (byte)(flags | 2);
            }
            baos.write(flags);
            baos.write(operation);
            if (routingUTF != null) {
                baos.write(routingUTF);
            }
            flowSubject.writeToStream(baos);
        }
        catch (IOException ioe) {
            SessionConfig.logMessage("Error creating flow control payload.", ioe, SessionConfig.SEVERE);
        }
        return baos.getBuffer();
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        byte flags = StreamUtil.readByte(is);
        this.m_subType = StreamUtil.readByte(is);
        if ((flags & 1) > 0) {
            this.m_routingUTF = StreamUtil.readUTFString(is);
        }
        if ((flags & 2) > 0) {
            this.m_isPubSub = true;
        }
        this.m_flowSubject = Subject.createFromStream(is);
        this.m_isDirty = true;
    }

    @Override
    protected boolean isDirty() {
        return this.m_isDirty || this.m_bodyBuffer == null;
    }

    @Override
    protected byte[] toByteArray() {
        this.syncPayload();
        return this.m_bodyBuffer;
    }

    @Override
    protected void syncPayload() {
        if (this.m_isDirty || this.m_bodyBuffer == null) {
            EnhancedByteArrayOutputStream baos = new EnhancedByteArrayOutputStream(this.length());
            try {
                this.writeToStream(baos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_bodyBuffer = baos.getBuffer();
            this.m_isDirty = false;
        }
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        if (this.isDirty()) {
            byte flags = 0;
            if (this.hasRouting()) {
                flags = (byte)(flags | 1);
            }
            if (this.m_isPubSub) {
                flags = (byte)(flags | 2);
            }
            os.write(flags);
            os.write(this.m_subType);
            if (this.hasRouting()) {
                os.write(this.getRoutingUTF());
            }
            this.m_flowSubject.writeToStream(os);
        } else {
            os.write(this.m_bodyBuffer);
        }
    }

    @Override
    public int length() {
        if (this.isDirty()) {
            byte[] routingUTF;
            int length = 2;
            if (this.hasRouting() && (routingUTF = this.getRoutingUTF()) != null) {
                length += routingUTF.length;
            }
            return length += this.m_flowSubject.getSerializedLength();
        }
        return this.m_bodyBuffer.length;
    }

    @Override
    protected int memoryLength() {
        this.sync();
        return s_qfcMemSize + 1 + this.m_flowSubject.memoryLength() + (this.hasRouting() ? this.getRoutingUTF().length : 0);
    }

    private final byte[] getRoutingUTF() {
        if (this.m_routingUTF != null) {
            return this.m_routingUTF;
        }
        if (this.m_routing != null) {
            try {
                this.m_routingUTF = StringUtil.stringToUTF(this.m_routing);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
            return this.m_routingUTF;
        }
        return null;
    }

    @Override
    public ISubject getFlowSubject() {
        return this.m_flowSubject;
    }

    @Override
    public final boolean hasRouting() {
        return this.m_routing != null || this.m_routingUTF != null;
    }

    @Override
    public String getRouting() {
        if (this.m_routing == null && this.m_routingUTF != null) {
            try {
                this.m_routing = StringUtil.UTFToString(this.m_routingUTF, 0);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
        }
        return this.m_routing;
    }

    @Override
    public boolean isPubSub() {
        return this.m_isPubSub;
    }

    @Override
    public byte getSubType() {
        return this.m_subType;
    }

    @Override
    public void setSubType(byte subType) {
        this.m_subType = subType;
        if (this.m_bodyBuffer != null) {
            this.m_bodyBuffer[1] = subType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Flow Subject: " + this.m_flowSubject);
            log.print(", Routing: " + this.m_routing);
        }
    }

    @Override
    public IPTPFlowControlHandle getPTPFlowControlHandle() {
        return this;
    }

    @Override
    public HashMap getPayloadProperties() {
        return new HashMap();
    }

    @Override
    public void setPayloadProperties(HashMap map) {
    }
}

