/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26.broker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.msg.ISaverOpHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.Payload;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.ISaverOp;
import progress.message.zclient.SessionConfig;

public class SaverOpPayload
extends Payload
implements ISaverOpHandle {
    private static int s_saveOpPayloadMemSize = MemoryUtil.estimateBaseSize(SaverOpPayload.class);
    private IReplicateableSaverOp m_saverOp;
    private long m_trackingNum;
    private byte m_type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            if (this.m_saverOp != null) {
                log.print(this.m_saverOp.toString());
                if (this.m_mgram.isGuarenteed()) {
                    log.print("Tracking Num: " + this.m_trackingNum);
                }
            }
        }
    }

    public SaverOpPayload(Mgram m) {
        super(m);
    }

    @Override
    public void setGuarenteed(long tracking) {
        this.m_trackingNum = tracking;
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_trackingNum;
    }

    @Override
    protected void syncPayload() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public int length() {
        int result = this.m_mgram.isGuarenteedInternal() ? 8 : 0;
        return result += this.m_saverOp.length();
    }

    @Override
    public int memoryLength() {
        int result = s_saveOpPayloadMemSize + this.m_saverOp.memsize();
        return result;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.m_type = StreamUtil.readByte(is);
        if (this.m_mgram.isGuarenteedInternal()) {
            this.m_trackingNum = StreamUtil.read6ByteLong(is);
        }
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        switch (this.m_type) {
            case 0: 
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                this.m_saverOp = (IReplicateableSaverOp)((Object)reg.getQueueMsgSaver().buildQMsgSaverOp(this.m_type, is));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                this.m_saverOp = (IReplicateableSaverOp)((Object)reg.getMsgSaver().buildMsgSaverOp(this.m_type, is));
                break;
            }
            case 9: 
            case 10: {
                this.m_saverOp = (IReplicateableSaverOp)((Object)reg.getRouterManager().getRouteForwarder().getRouteSaver().buildRouteSaverOp(this.m_type, is));
            }
        }
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeByte(this.m_saverOp.getType(), os);
        if (this.m_mgram.isGuarenteedInternal()) {
            StreamUtil.write6ByteLong(this.m_trackingNum, os);
        }
        this.m_saverOp.writeToStream(os);
    }

    @Override
    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeToStream(baos);
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public byte getType() {
        return this.m_type;
    }

    @Override
    public ISaverOp getSaverOp() {
        return this.m_saverOp;
    }

    @Override
    public void setSaverOp(ISaverOp op) {
        this.m_saverOp = (IReplicateableSaverOp)op;
    }

    @Override
    public ISaverOpHandle getSaverOpHandle() {
        return this;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
    }

    @Override
    public HashMap getPayloadProperties() {
        return new HashMap();
    }
}

