/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.evs;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.util.SelectableNetworkLinkResult;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.evs.ProgressEvsSocket;

public class ProgressEvsServerSocket
extends ProgressServerSocket {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_UNEXPECTED = false;
    IEvsNetworkLink m_link = null;
    INetworkLinkConfig m_config = null;
    private Selector m_selector = null;
    private final SelectableNetworkLinkResult m_netResult = new SelectableNetworkLinkResult();

    public ProgressEvsServerSocket(IEvsNetworkLink link, INetworkLinkConfig config) throws IOException {
        this.m_link = link;
        this.m_config = config;
        if (!this.m_config.getBlockingIO()) {
            this.m_selector = Selector.open();
        }
    }

    @Override
    public ProgressSocket accept() throws IOException {
        try {
            IEvsNetworkLink link = this.m_link.accept(this.m_netResult);
            while (link == null) {
                try {
                    this.m_netResult.select(this.m_selector, false);
                }
                catch (ClosedSelectorException cse) {
                    IOException ioe = new IOException(cse.getMessage());
                    ioe.initCause(cse);
                    throw ioe;
                }
                finally {
                    link = this.m_link.accept(this.m_netResult);
                    if (link != null) break;
                }
            }
            return new ProgressEvsSocket(link, this.m_config);
        }
        catch (EEvsIOException eeioe) {
            Exception e = eeioe.getExtendedException();
            if (e != null && e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ioe = new IOException(eeioe.getMessage());
            ioe.initCause(eeioe);
            throw ioe;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        Selector selector = null;
        SelectableNetworkLinkResult result = new SelectableNetworkLinkResult();
        try {
            while (!this.m_link.close(result, false)) {
                if (selector == null) {
                    selector = Selector.open();
                }
                try {
                    result.select(selector, false);
                }
                catch (ClosedSelectorException cse) {
                    IOException ioe = new IOException(cse.getMessage());
                    ioe.initCause(cse);
                    throw ioe;
                    return;
                }
            }
        }
        catch (Throwable thrown) {
            Exception e;
            result.blockingOps = 0;
            try {
                this.m_link.close(result, true);
            }
            catch (EEvsIOException eeioe) {
                Exception e2 = eeioe.getExtendedException();
                if (e2 != null && e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                IOException ioe = new IOException(eeioe.getMessage());
                ioe.initCause(eeioe);
                throw ioe;
            }
            if (thrown != null && thrown instanceof IOException) {
                throw (IOException)thrown;
            }
            if (thrown instanceof EEvsIOException && (e = ((EEvsIOException)thrown).getExtendedException()) != null && e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ioe = new IOException(thrown.getMessage());
            ioe.initCause(thrown);
            throw ioe;
        }
        finally {
            if (selector != null) {
                try {
                    selector.close();
                }
                catch (IOException ioe) {}
            }
            if (this.m_selector != null) {
                try {
                    this.m_selector.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private final void debug(String string) {
        this.debug(string, null);
    }

    private final void debug(String string, Throwable thrown) {
        if (thrown != null) {
            System.out.println(this.m_link + ": " + string + " Related Exception: " + thrown.getMessage());
            thrown.printStackTrace();
        } else {
            System.out.println(this.m_link + ": " + string);
        }
    }
}

