/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.client.tunnel;

import progress.message.net.http.client.tunnel.QueueElement;

public class SafeQueue {
    private QueueElement in = null;
    private QueueElement out = null;
    private int nElements = 0;

    public boolean isEmpty() {
        return this.out == null;
    }

    public synchronized int getNElements() {
        return this.nElements;
    }

    public synchronized void add(Object o) {
        QueueElement element = new QueueElement();
        element.object = o;
        element.next = null;
        ++this.nElements;
        if (this.in != null) {
            this.in.next = element;
            this.in = element;
        } else {
            this.in = element;
            this.out = element;
        }
        this.notifyAll();
    }

    public synchronized Object removeNonBlocking() {
        if (this.getNElements() == 0) {
            return null;
        }
        try {
            return this.remove();
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    public synchronized Object remove() throws InterruptedException {
        try {
            while (this.out == null) {
                this.wait();
            }
            QueueElement element = this.out;
            this.out = element.next;
            --this.nElements;
            if (this.out == null) {
                this.in = null;
            }
            return element.object;
        }
        catch (InterruptedException e) {
            this.notifyAll();
            return null;
        }
    }
}

