/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.server;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.util.ThreadedServer;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.Config;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundHolder;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.client.tunnel.SafeQueue;
import progress.message.net.http.server.HttpConnectionHandler;
import progress.message.net.http.server.SonicHttpConnection;
import progress.message.net.http.server.tunnel.HttpConnectionSocket;

public class SonicHttpServer
extends ThreadedServer
implements HttpListener {
    protected static boolean DEBUG = Config.HTTP_DEBUG_DEFAULT;
    protected static int HTTP_MAX_THREADS = 512;
    protected static int HTTP_MIN_THREADS = 2;
    protected static int HTTP_THREAD_IDLE_TIMEOUT = 60000;
    protected static int HTTP_BROKER_READ_TIMEOUT = 20000;
    protected static boolean TCP_NODELAY = true;
    protected transient HttpServer m_server;
    protected int m_lowResources;
    protected transient boolean m_isLow;
    protected transient boolean m_isOut;
    protected transient long m_warned;
    protected SafeQueue m_connectionQueue = new SafeQueue();
    protected Hashtable m_props = null;
    protected HttpConnectionHandler m_httpConnectionHandler;
    private static final long serialVersionUID = 3258135764704571445L;
    private boolean m_isSonicHttpServer;

    public SonicHttpServer(ProgressInetAddress bindAddr, int port, Properties properties) throws IOException {
        this(bindAddr, port, properties, true);
    }

    public SonicHttpServer(ProgressInetAddress bindAddr, int port, Properties properties, boolean isSonicHttpsServer) throws IOException {
        super(bindAddr == null ? null : bindAddr.getDelegateInetAddress(), port);
        this.m_isSonicHttpServer = isSonicHttpsServer;
        if (Config.DS_DEBUG) {
            if (this.m_isSonicHttpServer) {
                System.out.println("SonicHttpServer.ctor: properties = " + properties);
            } else {
                System.out.println("SonicHttpsServer.ctor: properties = " + properties);
            }
        }
        int maxThreads = HTTP_MAX_THREADS;
        int minThreads = HTTP_MIN_THREADS;
        int idleTimeout = HTTP_THREAD_IDLE_TIMEOUT;
        String[] httpXProtocols = null;
        String[] httpXFactories = null;
        String[] httpXPropfiles = null;
        HTTPDirectInboundHolder holder = null;
        if (properties != null) {
            Boolean B;
            int v;
            this.m_props = properties;
            Object value = this.m_props.get("HTTP_DEBUG");
            if (value != null && ((String)value).equalsIgnoreCase("TRUE")) {
                DEBUG = true;
                HttpConnectionHandler.DEBUG = true;
            }
            if ((value = this.m_props.get("HTTP_MIN_THREADS")) != null && (v = ((Integer)value).intValue()) > 0) {
                minThreads = v;
            }
            if ((value = this.m_props.get("HTTP_MAX_THREADS")) != null && (v = ((Integer)value).intValue()) > 0) {
                int n = maxThreads = v < minThreads ? minThreads + 1 : v;
            }
            if ((value = this.m_props.get("HTTP_THREAD_IDLE_TIMEOUT")) != null && (v = ((Long)value).intValue()) >= 0) {
                idleTimeout = v;
            }
            if ((value = this.m_props.get("HTTP_CLIENT_IDLE_TIMEOUT")) != null && (v = ((Long)value).intValue()) > 0) {
                if (DEBUG) {
                    System.out.println("HTTP_CLIENT_IDLE_TIMEOUT = " + v);
                }
                HttpConnectionSocket.setClientIdleTimeout(v);
            }
            if ((value = this.m_props.get("HTTP_CLIENT_READ_TIMEOUT")) != null && (v = ((Long)value).intValue()) > 0) {
                if (DEBUG) {
                    System.out.println("HTTP_CLIENT_READ_TIMEOUT = " + v);
                }
                HttpConnectionSocket.setClientReadTimeout(v);
            }
            if ((value = this.m_props.get("HTTP_BROKER_READ_TIMEOUT")) != null && (v = ((Long)value).intValue()) > 0) {
                if (DEBUG) {
                    System.out.println("HTTP_BROKER_READ_TIMEOUT = " + v);
                }
                HTTP_BROKER_READ_TIMEOUT = v;
            }
            TCP_NODELAY = (B = (Boolean)this.m_props.get("TCP_NODELAY")) != null ? B : true;
            holder = (HTTPDirectInboundHolder)this.m_props.get("HTTP_DIRECT_INBOUND_HOLDER");
            if (Config.DS_DEBUG) {
                if (this.m_isSonicHttpServer) {
                    System.out.println("SonicHttpServer.ctor: HTTP Direct Inbound holder = " + holder);
                } else {
                    System.out.println("SonicHttpsServer.ctor: HTTP Direct Inbound holder = " + holder);
                }
            }
            if (holder == null) {
                httpXProtocols = (String[])this.m_props.get("HTTP_X_PROTOCOLS");
                httpXFactories = (String[])this.m_props.get("HTTP_X_FACTORIES");
                httpXPropfiles = (String[])this.m_props.get("HTTP_X_PROPFILES");
            }
        }
        this.m_httpConnectionHandler = new HttpConnectionHandler(holder);
        HTTPAcceptor acceptor = AcceptorHolder.getAcceptorHolder().findHttpAcceptor(port);
        if (acceptor != null) {
            acceptor.registerConnectionHandler(this.m_httpConnectionHandler);
        }
        this.initThreadProperty(maxThreads, minThreads, idleTimeout);
        if (DEBUG) {
            System.out.println("HTTP_MAX_THREADS = " + maxThreads);
            System.out.println("HTTP_MIN_THREADS = " + minThreads);
            System.out.println("HTTP_THREAD_IDLE_TIMEOUT = " + idleTimeout);
            System.out.println("TCP_NODELAY = " + maxThreads);
            System.out.println("setDaemon() = true");
        }
        if (this.m_isSonicHttpServer) {
            this.m_server = new HttpServer();
            if (bindAddr != null) {
                this.initHost(bindAddr);
            }
            this.m_server.addListener((HttpListener)this);
        }
    }

    private void initThreadProperty(int maxThreads, int minThreads, int idleTimeout) {
        this.setMaxThreads(maxThreads);
        this.setMinThreads(minThreads);
        this.setMaxIdleTimeMs(idleTimeout);
        this.setTcpNoDelay(TCP_NODELAY);
        this.setDaemon(true);
    }

    private void initHost(ProgressInetAddress bindAddr) throws UnknownHostException {
        this.setHost(bindAddr.getHostAddress(false));
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    public void customizeRequest(HttpConnection connection, HttpRequest request) {
    }

    public void setHttpServer(HttpServer server) {
        if (server != null && this.m_server != null && this.m_server != server) {
            throw new IllegalStateException("Cannot share listeners");
        }
        this.m_server = server;
    }

    public HttpServer getHttpServer() {
        return this.m_server;
    }

    public String getDefaultScheme() {
        if (!this.m_isSonicHttpServer) {
            return "https";
        }
        return "http";
    }

    public void addHttpConnection(HttpConnectionSocket socket) {
        if (this.m_connectionQueue != null) {
            this.m_connectionQueue.add(socket);
        }
    }

    public HttpConnectionSocket acceptHttpConnection() {
        try {
            HttpConnectionSocket socket = (HttpConnectionSocket)this.m_connectionQueue.remove();
            return socket;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    protected void handleConnection(Socket connection) throws IOException {
        try {
            SonicHttpConnection httpConnection = new SonicHttpConnection(this, connection, this.m_httpConnectionHandler, TCP_NODELAY);
            httpConnection.handle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBufferSize() {
        return 8192;
    }

    public int getBufferReserve() {
        return 512;
    }

    public void persistConnection(HttpConnection connection) {
    }

    public boolean isLowOnResources() {
        boolean low;
        int spare = this.getMaxThreads() - this.getThreads();
        int lr = this.m_lowResources > 0 ? this.m_lowResources : this.getMinThreads();
        boolean bl = low = spare + this.getIdleThreads() < lr;
        if (low && !this.m_isLow) {
            try {
                String message = "LOW ON THREADS ((" + this.getMaxThreads() + "-" + this.getThreads() + "+" + this.getIdleThreads() + ")<" + this.getMinThreads() + ") on " + (Object)((Object)this);
                BrokerComponent.getComponentContext().logMessage(message, 2);
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.m_warned = System.currentTimeMillis();
            this.m_isLow = true;
        } else if (!low && this.m_isLow && System.currentTimeMillis() - this.m_warned > 1000L) {
            this.m_isOut = false;
            this.m_isLow = false;
        }
        return low;
    }

    public boolean isOutOfResources() {
        boolean out;
        boolean bl = out = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (out && !this.m_isOut) {
            try {
                String message = "OUT OF THREADS: " + (Object)((Object)this);
                BrokerComponent.getComponentContext().logMessage(message, 2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_warned = System.currentTimeMillis();
            this.m_isLow = true;
            this.m_isOut = true;
        }
        return out;
    }

    public boolean isIntegral(HttpConnection connection) {
        return !this.m_isSonicHttpServer;
    }

    public String getIntegralScheme() {
        return "https";
    }

    public int getIntegralPort() {
        if (!this.m_isSonicHttpServer) {
            return this.getPort();
        }
        return 0;
    }

    public boolean isConfidential(HttpConnection connection) {
        return !this.m_isSonicHttpServer;
    }

    public String getConfidentialScheme() {
        return "https";
    }

    public int getConfidentialPort() {
        if (!this.m_isSonicHttpServer) {
            return this.getPort();
        }
        return 0;
    }

    public HttpHandler getHttpHandler() {
        return null;
    }
}

