/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.server;

import java.io.IOException;
import java.net.Socket;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import progress.message.net.ProgressInetAddress;
import progress.message.net.https.server.SSLSocketImpl;
import progress.message.net.https.server.SonicHttpsServer;
import progress.message.net.ssl.ISSLSocket;
import progress.message.security.cert.X509Certificate;

public class SonicHttpsConnection
extends HttpConnection {
    SonicHttpsServer m_server = null;
    ProgressInetAddress m_addr = null;
    X509Certificate m_cert = null;
    Socket m_socket = null;
    X509Certificate[] m_certs;

    public SonicHttpsConnection(SonicHttpsServer listener, ISSLSocket socket) throws IOException {
        super((HttpListener)listener, socket.getImpl().getInetAddress(), socket.getImpl().getInputStream(), socket.getImpl().getOutputStream(), (Object)socket.getImpl());
        this.m_server = listener;
        this.m_addr = new ProgressInetAddress(socket.getImpl().getInetAddress());
        this.m_cert = socket.getPeerCertificate();
        this.m_certs = socket.getPeerCertificateChain();
        this.m_socket = socket.getImpl();
    }

    public SonicHttpsConnection(SonicHttpsServer listener, Socket socket) throws IOException {
        super((HttpListener)listener, socket.getInetAddress(), socket.getInputStream(), socket.getOutputStream(), (Object)socket);
        this.m_server = listener;
        this.m_addr = new ProgressInetAddress(socket.getInetAddress());
        this.m_socket = socket;
        if (socket instanceof SSLSocketImpl) {
            this.m_cert = ((SSLSocketImpl)socket).getPeerCertificate();
            this.m_certs = ((SSLSocketImpl)socket).getPeerCertificateChain();
        }
    }

    public SonicHttpsServer getServer() {
        return this.m_server;
    }

    public ProgressInetAddress getInetAddress() {
        return this.m_addr;
    }

    public X509Certificate getPeerCertificate() {
        return this.m_cert;
    }

    public X509Certificate[] getPeerCertificateChain() {
        return this.m_certs;
    }

    public Socket getSocket() {
        return this.m_socket;
    }

    protected HttpContext service(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        this.m_server.getHandler().handle(null, request, response, this.m_socket);
        return null;
    }

    public String getCipherSuite() {
        String cipherSuite = ((SSLSocketImpl)this.m_socket).getCipherSuite();
        return cipherSuite;
    }
}

