/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.server;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.ssl.SSLUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.util.InetAddrPort;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.server.HttpConnectionHandler;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.https.ProgressHttpsSocketFactory;
import progress.message.net.https.server.SSLSocketImpl;
import progress.message.net.https.server.SonicHttpsConnection;
import progress.message.net.https.server.tunnel.HttpsConnectionSocket;
import progress.message.net.https.server.tunnel.HttpsTunnelHandlerFactory;
import progress.message.net.prAccessor;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.ISSLImpl;
import progress.message.net.ssl.ISSLServerSocket;
import progress.message.net.ssl.ISSLSocket;

public class SonicHttpsServer
extends SonicHttpServer {
    private static final long serialVersionUID = 3256438088602695733L;
    private ISSLServerSocket m_serverSocket = null;
    private int m_acceptTimeout = -1;
    private boolean m_stopped = false;
    private static int _connectionCount = 0;
    private static Object _mutex = new Object();

    public SonicHttpsServer(ProgressInetAddress bindAddr, int port, int backlog) throws IOException {
        this(bindAddr, port, backlog, null);
    }

    public SonicHttpsServer(ProgressInetAddress bindAddr, int port, int backlog, Properties properties) throws IOException {
        super(bindAddr, port, properties, false);
        HttpsTunnelHandlerFactory https = new HttpsTunnelHandlerFactory(null, null);
        this.m_httpConnectionHandler.insertProtocolFactory(https, 0);
        ISSLImpl sslFactory = ProgressHttpsSocketFactory.getSSLFactory();
        ISSLControl control = sslFactory.createSSLServerControl();
        String pwd = SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_PASSWORD", null);
        if (!control.configureKeyAndCertificate(SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN", null), SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN_FORM", "LIST"), SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY", null), SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_FORM", "PKCS8"), pwd)) {
            throw new ESocketConfigException(prAccessor.getString("CertLoadFailure"));
        }
        String cipherSuites = SSLUtil.getProperty(this.m_props, "SSL_CIPHER_SUITES", null);
        Vector cs = SSLUtil.getCipherSuites(cipherSuites, DEBUG);
        if (!control.configureCipherSuites(cs)) {
            throw new ESocketConfigException(prAccessor.getString("CipherSuiteConfig") + cipherSuites);
        }
        if (SSLUtil.getProperty(this.m_props, "SSL_CLIENT_AUTHENTICATION", "false").equalsIgnoreCase("true")) {
            String caCertsDir = SSLUtil.getProperty(this.m_props, "SSL_CA_CERTIFICATES_DIR", null);
            try {
                if (caCertsDir != null && !control.configureTrustDecider(caCertsDir, null)) {
                    throw new ESocketConfigException(prAccessor.getString("CACertLoadFailure"));
                }
            }
            catch (Exception ex) {
                throw new ESocketConfigException(ex.getMessage());
            }
        }
        this.m_serverSocket = sslFactory.createSSLServerSocket(bindAddr, port, backlog, control, (Object)this.m_props);
        this.setAcceptTimeout();
        this.m_server = new HttpServer();
        this.initHost(bindAddr);
        this.m_server.addListener((HttpListener)this);
    }

    private void setAcceptTimeout() throws IOException {
        this.m_acceptTimeout = this.getMaxIdleTimeMs();
        if (this.m_acceptTimeout > 0) {
            this.m_serverSocket.setSoTimeout(this.m_acceptTimeout);
        }
    }

    private void initHost(ProgressInetAddress bindAddr) throws UnknownHostException {
        if (bindAddr != null) {
            this.setHost(bindAddr.getHostAddress(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        if (this.m_stopped) {
            return;
        }
        this.m_stopped = true;
        super.stop();
        if (this.m_serverSocket != null) {
            try {
                this.m_serverSocket.getImpl().close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.m_serverSocket = null;
            }
        }
    }

    HttpConnectionHandler getHandler() {
        return this.m_httpConnectionHandler;
    }

    public void addHttpsConnection(HttpsConnectionSocket socket) {
        this.m_connectionQueue.add(socket);
    }

    protected Socket acceptSocket(ServerSocket serverSocket, int timeout) {
        if (this.m_serverSocket == null) {
            return null;
        }
        try {
            if (this.m_acceptTimeout != timeout) {
                this.m_acceptTimeout = timeout;
                this.m_serverSocket.setSoTimeout(this.m_acceptTimeout);
            }
            ISSLSocket socket = this.m_serverSocket.accept();
            socket.setSoTimeout(HTTP_BROKER_READ_TIMEOUT);
            SSLSocketImpl sslSocket = new SSLSocketImpl(socket);
            return sslSocket;
        }
        catch (ESocketConfigException scex) {
            try {
                this.stop();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            return null;
        }
        catch (IOException ex) {
            String s = ex.getMessage();
            String jettyMessage = "Accept timed out";
            if (s != null && s.length() >= jettyMessage.length() && jettyMessage.equalsIgnoreCase(s.substring(0, jettyMessage.length()))) {
                return null;
            }
            jettyMessage = "socket closed";
            if (s != null && s.length() >= jettyMessage.length() && jettyMessage.equalsIgnoreCase(s.substring(0, jettyMessage.length()))) {
                return null;
            }
            if (DEBUG) {
                if (ex instanceof InterruptedIOException) {
                    System.out.print(Thread.currentThread() + " idle (accept) timeout expired.");
                } else {
                    ex.printStackTrace();
                }
            }
            return null;
        }
    }

    public HttpsConnectionSocket acceptHttpsConnection() throws IOException {
        if (this.m_stopped) {
            throw new ESocketConfigException("SonicHttpsServer no longer accepting connection.");
        }
        try {
            HttpsConnectionSocket socket = (HttpsConnectionSocket)this.m_connectionQueue.remove();
            return socket;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    protected ServerSocket newServerSocket(InetAddrPort address, int acceptQueueSize) throws IOException {
        ServerSocket socket = this.m_serverSocket.getImpl();
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle(Object job) {
        Socket socket = (Socket)job;
        if (socket == null || socket.isClosed()) {
            return;
        }
        try {
            socket.setTcpNoDelay(TCP_NODELAY);
            this.handleConnection(socket);
        }
        catch (SocketException e) {
        }
        catch (Exception e) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleConnection(Socket socket) {
        SonicHttpsConnection connection = null;
        try {
            if (DEBUG) {
                Object object = _mutex;
                synchronized (object) {
                    ++_connectionCount;
                    if (DEBUG) {
                        System.out.println(Thread.currentThread() + " handling new connection " + _connectionCount + " from " + socket.getInetAddress() + ":" + socket.getPort());
                    }
                }
            }
            connection = new SonicHttpsConnection(this, socket);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer("Https connection error occurred..");
            sb.append(" ").append("Reason=").append(e.getMessage());
            sb.append(", ").append("Client IP=").append(socket.getInetAddress().getHostAddress());
            BrokerComponent.getComponentContext().logMessage(sb.toString(), 2);
        }
        if (connection != null) {
            try {
                connection.handle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

