/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import progress.message.net.ssl.CRLCache;
import progress.message.net.ssl.CRLCachePolicy;
import progress.message.net.ssl.CRLCacheUpdateException;
import progress.message.net.ssl.CRLStore;
import progress.message.net.ssl.FSCRLStoreParameters;
import progress.message.net.ssl.InvalidCRLStoreParametersException;

public class FSCRLStore
extends CRLStore {
    private static boolean DEBUG = true;
    private String m_crlDir = null;
    private Hashtable m_crlByFile = null;
    private Hashtable m_fileByDn = null;
    private Hashtable m_dnByFile = null;
    private FSCRLStoreParameters m_params = null;
    CRLCache m_cache = null;
    Vector m_policies = null;
    boolean m_init = false;

    public static void setDebug(boolean on) {
        DEBUG = on;
    }

    public FSCRLStore(FSCRLStoreParameters params) {
        this.m_params = params;
    }

    @Override
    public void init() throws InvalidCRLStoreParametersException {
        this.m_init = true;
        this.m_crlDir = this.m_params.getCRLDir();
        this.m_crlByFile = new Hashtable();
        this.m_fileByDn = new Hashtable();
        this.m_dnByFile = new Hashtable();
        if (DEBUG) {
            System.out.println("Loading CRL(s) from " + this.m_crlDir);
        }
        Object[] crls = null;
        File crlDir = new File(this.m_crlDir);
        if (crlDir.isDirectory()) {
            crls = crlDir.list();
        } else {
            StringTokenizer st = new StringTokenizer(this.m_crlDir, ",");
            Vector<String> tmp = new Vector<String>();
            while (st.hasMoreTokens()) {
                tmp.add(st.nextToken());
            }
            crls = new String[tmp.size()];
            tmp.copyInto(crls);
        }
        for (int i = 0; i < crls.length; ++i) {
            byte[] crlData;
            File crl = new File(crls[i]);
            if (crl.isDirectory() || (crlData = this.loadCRL(crl)) == null) continue;
            this.m_crlByFile.put(crls[i], crlData);
        }
        if (DEBUG) {
            System.out.println(this.m_crlByFile.size() + " CRL(s) loaded in total.");
        }
        if (this.m_cache != null) {
            this.m_cache.reset();
            this.populateCache();
        }
    }

    @Override
    public synchronized void cleanup() {
        if (this.m_cache == null) {
            return;
        }
        this.m_cache.reset();
    }

    public void addCachePolicy(CRLCachePolicy policy) {
        if (this.m_policies == null) {
            this.m_policies = new Vector();
        }
        this.m_policies.add(policy);
        if (this.getCache() != null) {
            try {
                this.getCache().addPolicy(policy);
            }
            catch (CRLCacheUpdateException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void bind(CRLCache cache) {
        this.m_cache = cache;
        this.populateCache();
    }

    private void populateCache() {
        if (this.m_policies != null) {
            try {
                this.m_cache.init((CRLCachePolicy[])this.m_policies.toArray());
            }
            catch (CRLCacheUpdateException ex) {
                ex.printStackTrace();
            }
        }
        for (String crl : this.m_crlByFile.keySet()) {
            String issuerName = this.m_cache.populate((byte[])this.m_crlByFile.get(crl));
            if (issuerName == null) continue;
            if (DEBUG) {
                System.out.println("CRL from " + issuerName + " is added to cache.");
            }
            this.m_fileByDn.put(issuerName, crl);
            this.m_dnByFile.put(crl, issuerName);
        }
    }

    public CRLCache getCache() {
        return this.m_cache;
    }

    @Override
    public byte[] getCRLByIssuer(String issuerName) {
        String crl;
        if (DEBUG) {
            System.out.println("Retrieving CRL issued by " + issuerName);
        }
        if ((crl = (String)this.m_fileByDn.get(issuerName)) != null) {
            return this.loadCRL(new File(crl));
        }
        String[] crlFiles = new File(this.m_crlDir).list();
        for (int i = 0; i < crlFiles.length; ++i) {
            byte[] crlData;
            if (this.m_dnByFile.containsKey(crlFiles[i]) || (crlData = this.loadCRL(new File(crlFiles[i]))) == null) continue;
            String testName = this.getCache().getIssuerName(crlData);
            if (DEBUG && testName != null) {
                System.out.println("Found CRL issued by " + testName);
            }
            if (testName == null || !testName.equals(issuerName)) continue;
            if (DEBUG) {
                System.out.println("Returning CRL issued by " + testName);
            }
            return crlData;
        }
        if (DEBUG) {
            System.out.println("Failed to locate CRL issued by " + issuerName);
        }
        return null;
    }

    @Override
    public byte[] getCRLByDP(String distributionPoint) {
        return this.getCRLByIssuer(distributionPoint);
    }

    private byte[] loadCRL(File crlFile) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.m_crlDir + File.separator + crlFile);
            byte[] crlData = new byte[inputStream.available()];
            inputStream.read(crlData, 0, crlData.length);
            inputStream.close();
            return crlData;
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

