/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsafe;

import com.rsa.certj.CertJ;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.PKCS10CertRequest;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.pkcs12.PKCS12;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.ssl.SSLUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Vector;
import progress.message.net.ssl.jsafe.jsafeX509Certificate;
import progress.message.security.cert.X500Name;
import progress.message.security.keystore.EKeyStoreException;
import progress.message.security.keystore.KeyStore;

public class jsafeKeyStore
extends KeyStore {
    private static final String s_csrHeader = "-----BEGIN CERTIFICATE REQUEST-----";
    private static final String s_csrTrailer = "-----END CERTIFICATE REQUEST-----";
    private static final String s_certificateHeader = "-----BEGIN CERTIFICATE-----";
    private static final String s_certificateTrailer = "-----END CERTIFICATE-----";
    private static final boolean DEBUG = false;
    private static byte[] s_salt = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, 17, 17, 17, 17, 17, 17, 17, 17};
    private static JSAFE_SecureRandom random = null;
    static final long serialVersionUID = 4529319232503159154L;

    public static boolean verifyKeyPair(JSAFE_PublicKey publicKey, JSAFE_PrivateKey privateKey) {
        boolean ret = false;
        try {
            String keyType = privateKey.getAlgorithm().indexOf("RSA") != -1 ? "RSA" : "DSA";
            String algorithm = "SHA1/" + keyType + "/PKCS1Block01Pad";
            JSAFE_Signature signer = JSAFE_Signature.getInstance((String)algorithm, (String)"Java");
            signer.signInit(privateKey, null);
            signer.signUpdate(s_salt, 0, s_salt.length);
            byte[] signature = signer.signFinal();
            signer.clearSensitiveData();
            JSAFE_Signature verifier = JSAFE_Signature.getInstance((String)algorithm, (String)"Java");
            verifier.verifyInit(publicKey, null);
            verifier.verifyUpdate(s_salt, 0, s_salt.length);
            ret = verifier.verifyFinal(signature, 0, signature.length);
            verifier.clearSensitiveData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public byte[] keygen(String alias, int keySize, int keyType, X500Name subjectDN) throws EKeyStoreException, IOException {
        RDN rdn;
        byte[] csrBytes = null;
        byte[] keyBytes = null;
        if (random == null) {
            throw new EKeyStoreException("JSAFE_SecureRandom not available");
        }
        com.rsa.certj.cert.X500Name subject = new com.rsa.certj.cert.X500Name();
        String value = null;
        try {
            value = subjectDN.getRDN(1);
            if (value != null && value.length() > 0) {
                rdn = new RDN();
                rdn.addNameAVA(new AttributeValueAssertion(0, AttributeValueAssertion.COMMON_NAME_OID, 4864, value));
                value = null;
                subject.addRDN(rdn);
            }
        }
        catch (NameException ne) {
            EKeyStoreException kse = new EKeyStoreException("Unable to set Common Name: " + ne.getMessage(), ne);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            value = subjectDN.getRDN(2);
            if (value != null && value.length() > 0) {
                rdn = new RDN();
                rdn.addNameAVA(new AttributeValueAssertion(5, AttributeValueAssertion.ORGANIZATIONAL_UNIT_NAME_OID, 4864, value));
                value = null;
                subject.addRDN(rdn);
            }
        }
        catch (NameException ne) {
            EKeyStoreException kse = new EKeyStoreException("Unable to set Organization Unit Name: " + ne.getMessage(), ne);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            value = subjectDN.getRDN(3);
            if (value != null && value.length() > 0) {
                rdn = new RDN();
                rdn.addNameAVA(new AttributeValueAssertion(4, AttributeValueAssertion.ORGANIZATION_NAME_OID, 4864, value));
                value = null;
                subject.addRDN(rdn);
            }
        }
        catch (NameException ne) {
            EKeyStoreException kse = new EKeyStoreException("Unable to set Organization Name: " + ne.getMessage(), ne);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            value = subjectDN.getRDN(4);
            if (value != null && value.length() > 0) {
                rdn = new RDN();
                rdn.addNameAVA(new AttributeValueAssertion(2, AttributeValueAssertion.LOCALITY_NAME_OID, 4864, value));
                value = null;
                subject.addRDN(rdn);
            }
        }
        catch (NameException ne) {
            EKeyStoreException kse = new EKeyStoreException("Unable to set Locality Name: " + ne.getMessage(), ne);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            value = subjectDN.getRDN(5);
            if (value != null && value.length() > 0) {
                rdn = new RDN();
                rdn.addNameAVA(new AttributeValueAssertion(3, AttributeValueAssertion.STATE_NAME_OID, 4864, value));
                value = null;
                subject.addRDN(rdn);
            }
        }
        catch (NameException ne) {
            EKeyStoreException kse = new EKeyStoreException("Unable to set State/Province Name: " + ne.getMessage(), ne);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            value = subjectDN.getRDN(6);
            if (value != null && value.length() > 0) {
                rdn = new RDN();
                rdn.addNameAVA(new AttributeValueAssertion(1, AttributeValueAssertion.COUNTRY_NAME_OID, 4864, value));
                value = null;
                subject.addRDN(rdn);
            }
        }
        catch (NameException ne) {
            EKeyStoreException kse = new EKeyStoreException("Unable to set Country Name: " + ne.getMessage(), ne);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            value = subjectDN.getRDN(7);
            if (value != null && value.length() > 0) {
                rdn = new RDN();
                rdn.addNameAVA(new AttributeValueAssertion(7, AttributeValueAssertion.EMAIL_ADDRESS_OID, 5632, value));
                value = null;
                subject.addRDN(rdn);
            }
        }
        catch (NameException ne) {
            EKeyStoreException kse = new EKeyStoreException("Unable to set email address: " + ne.getMessage(), ne);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            JSAFE_KeyPair keyPair = null;
            JSAFE_Parameters keyPairGenParams = null;
            JSAFE_PrivateKey privateKey = null;
            JSAFE_PublicKey publicKey = null;
            int[] keyPairSharedParams = null;
            try {
                if (keyType == 1) {
                    keyPair = JSAFE_KeyPair.getInstance((String)"RSA", (String)"Java");
                    keyPairSharedParams = new int[]{keySize, 65537};
                } else if (keyType == 2) {
                    keyPairGenParams = JSAFE_Parameters.getInstance((String)"DSA", (String)"Java");
                    int[] paramGenParams = new int[]{keySize};
                    keyPairGenParams.generateInit(paramGenParams, (SecureRandom)random);
                    keyPairGenParams.generate();
                    keyPair = JSAFE_KeyPair.getInstance((String)"DSA", (String)"Java");
                } else {
                    throw new EKeyStoreException("Invalid key type specified");
                }
                keyPair.generateInit(keyPairGenParams, keyPairSharedParams, (SecureRandom)random);
                keyPair.generate();
                privateKey = keyPair.getPrivateKey();
                publicKey = keyPair.getPublicKey();
            }
            catch (JSAFE_InvalidUseException iue) {
                EKeyStoreException kse = new EKeyStoreException(iue.getMessage(), iue);
                kse.fillInStackTrace();
                throw kse;
            }
            catch (JSAFE_UnimplementedException uie) {
                EKeyStoreException kse = new EKeyStoreException(uie.getMessage(), uie);
                kse.fillInStackTrace();
                throw kse;
            }
            catch (JSAFE_InvalidParameterException ipe) {
                EKeyStoreException kse = new EKeyStoreException(ipe.getMessage(), ipe);
                kse.fillInStackTrace();
                throw kse;
            }
            finally {
                if (keyPair != null) {
                    keyPair.clearSensitiveData();
                }
                keyPair = null;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(privateKey);
            keyBytes = bos.toByteArray();
            oos.close();
            bos.close();
            PKCS10CertRequest csr = new PKCS10CertRequest();
            csr.setSubjectName(subject);
            csr.setSubjectPublicKey(publicKey);
            try {
                if (keyType == 2) {
                    csr.signCertRequest("SHA1/DSA", "Java", privateKey, (SecureRandom)random);
                } else {
                    csr.signCertRequest("SHA1/RSA/PKCS1Block01Pad", "Java", privateKey, (SecureRandom)random);
                }
            }
            catch (CertificateException ce) {
                EKeyStoreException kse = new EKeyStoreException(ce.getMessage(), ce);
                kse.fillInStackTrace();
                throw kse;
            }
            byte[] csrDER = new byte[csr.getDERLen(0)];
            csr.getDEREncoding(csrDER, 0, 0);
            csrBytes = jsafeKeyStore.doWritePEM(csrDER, s_csrHeader, s_csrTrailer);
        }
        catch (CertificateException ce) {
            EKeyStoreException kse = new EKeyStoreException(ce.getMessage(), ce);
            kse.fillInStackTrace();
            throw kse;
        }
        if (keyBytes != null && csrBytes != null) {
            this.add(alias);
            this.setCSR(alias, csrBytes);
            this.setKey(alias, keyBytes);
        }
        return csrBytes;
    }

    private void println(String msg) {
    }

    private void println() {
    }

    @Override
    public void exportKeyAndCertificate(String alias, char[] password, OutputStream os) throws EKeyStoreException, IOException {
        this.println("Starting ExportPKCS12 sample program.");
        try {
            int i;
            this.println("Loading the certificate and key ...");
            if (!this.hasCert(alias) || !this.hasKey(alias)) {
                throw new EKeyStoreException("Not enough information exists in the Certificate Store to generate PKCS12 file for this alias");
            }
            KeyStore.KeyEntry entry = null;
            byte[][] chain = null;
            byte[] key = null;
            entry = this.get(alias);
            if (entry == null || (chain = entry.getCertificate()) == null || (key = entry.getKey()) == null) {
                return;
            }
            Certificate[] certs = new Certificate[1];
            try {
                int idx = 0;
                certs[idx] = new X509Certificate(chain[idx], 0, 0);
            }
            catch (CertificateException ce) {
                EKeyStoreException kse = new EKeyStoreException("exportKeyAndCertificate() method failed to load certificate. " + ce.getMessage(), ce);
                kse.fillInStackTrace();
                throw kse;
            }
            JSAFE_PrivateKey[] keys = new JSAFE_PrivateKey[1];
            ByteArrayInputStream bis = new ByteArrayInputStream(key);
            ObjectInputStream ois = new ObjectInputStream(bis);
            keys[0] = (JSAFE_PrivateKey)ois.readObject();
            ois.close();
            bis.close();
            this.println("Creating PKCS #12 object...");
            PKCS12 p12Obj = new PKCS12(new CertJ(), certs, null, keys, null, null, null);
            this.println("Done.");
            this.println("The PKCS 12 object contains " + p12Obj.getKeys().length + " private key(s).");
            this.println("The PKCS 12 object contains " + p12Obj.getCertificates().length + " certificate(s).");
            this.println("The PKCS 12 object contains " + p12Obj.getCrls().length + " CRL(s).");
            this.println("Allowed encryption algorithms:");
            for (i = 0; i < PKCS12.POSSIBLE_ENCRYPTION_ALGORITHMS.length; ++i) {
                this.println(". " + PKCS12.POSSIBLE_ENCRYPTION_ALGORITHMS[i]);
            }
            this.println();
            this.println("Allowed digest algorithms:");
            for (i = 0; i < PKCS12.POSSIBLE_DIGEST_ALGORITHMS.length; ++i) {
                this.println(". " + PKCS12.POSSIBLE_DIGEST_ALGORITHMS[i]);
            }
            String encAlg = PKCS12.POSSIBLE_ENCRYPTION_ALGORITHMS[0];
            String digAlg = PKCS12.POSSIBLE_DIGEST_ALGORITHMS[0];
            int iterations = 1;
            int format = 1;
            this.println("Encryption algorithm used:  " + encAlg);
            this.println("Digest algorithm used:  " + digAlg);
            this.println("Digest iterations:  " + iterations);
            this.println("Output format:  " + (format == 1 ? "Microsoft" : "Netscape"));
            this.println("Encoding the PKCS 12 object.");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            p12Obj.export((OutputStream)bos, password, encAlg, digAlg, iterations, format);
            this.println("Encoded " + bos.size() + " bytes of data.");
            os.write(bos.toByteArray());
            os.close();
        }
        catch (Exception anyException) {
            anyException.printStackTrace();
            EKeyStoreException kse = new EKeyStoreException("exportKeyAndCertificate() method failed - " + anyException.getMessage(), anyException);
            kse.fillInStackTrace();
            throw kse;
        }
    }

    @Override
    public void importCertificate(String alias, InputStream cert, int form) throws EKeyStoreException, IOException {
        KeyStore.KeyEntry entry = null;
        entry = this.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unknown alias used for importCertificate call");
        }
        Object chain = null;
        try {
            byte[] x509DataBuf = form == 1 || form == 3 ? jsafeKeyStore.doReadBytes(cert) : jsafeKeyStore.doReadPEM(cert);
            X509Certificate x509Cert = new X509Certificate(x509DataBuf, 0, x509DataBuf.length);
            if (form == 4 || form == 3) {
                byte[][] existingChain = entry.getCertificate();
                int size = existingChain.length;
                if (size <= 0) {
                    throw new EKeyStoreException("Signer certificates may only be appended to an existing certificate chain.");
                }
                X509Certificate existingCert = new X509Certificate(existingChain[size - 1], 0, existingChain[size - 1].length);
                if (!existingCert.verifyCertificateSignature("Java", (Certificate)x509Cert, (SecureRandom)random)) {
                    throw new EKeyStoreException("This signer certificate was not the one used to issue the existing certificate(s)");
                }
                chain = new byte[size + 1][];
                for (int cnt = 0; cnt < size; ++cnt) {
                    chain[cnt] = existingChain[cnt];
                    existingChain[cnt] = null;
                }
                byte[] newcert = new byte[x509Cert.getDERLen(0)];
                x509Cert.getDEREncoding(newcert, 0, 0);
                chain[size] = newcert;
            } else {
                chain = new byte[1][x509Cert.getDERLen(0)];
                x509Cert.getDEREncoding(chain[0], 0, 0);
            }
            entry.setCertificate((byte[][])chain);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            EKeyStoreException kse = new EKeyStoreException("Unable to import Certificate: " + e.getMessage(), e);
            kse.fillInStackTrace();
            throw kse;
        }
    }

    @Override
    public void exportCertificate(String alias, OutputStream os) throws EKeyStoreException, IOException {
        KeyStore.KeyEntry entry = null;
        byte[][] chain = null;
        entry = this.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unable to locate KeyStore entry for alias: " + alias);
        }
        if (!this.hasCert(alias) || (chain = entry.getCertificate()) == null) {
            throw new EKeyStoreException("No Certificate information exists in the Certificate Store for this alias:" + alias);
        }
        os.write(chain[0]);
    }

    @Override
    public progress.message.security.cert.X509Certificate[] getCertificate(String alias) throws EKeyStoreException {
        KeyStore.KeyEntry entry = null;
        byte[][] chain = null;
        entry = this.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unable to locate KeyStore entry for alias: " + alias);
        }
        if (!this.hasCert(alias) || (chain = entry.getCertificate()) == null) {
            throw new EKeyStoreException("No Certificate information exists in the Certificate Store for this alias:" + alias);
        }
        progress.message.security.cert.X509Certificate[] x509chain = new progress.message.security.cert.X509Certificate[chain.length];
        try {
            for (int idx = 0; idx < chain.length; ++idx) {
                x509chain[idx] = new jsafeX509Certificate(new X509Certificate(chain[idx], 0, 0));
            }
        }
        catch (CertificateException ce) {
            EKeyStoreException kse = new EKeyStoreException("getCertificate() method failed to load certificate. " + ce.getMessage(), ce);
            kse.fillInStackTrace();
            throw kse;
        }
        return x509chain;
    }

    @Override
    public void importPrivateKey(String alias, char[] password, File certFile, int form) throws EKeyStoreException, IOException {
        KeyStore.KeyEntry entry = null;
        entry = this.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unknown alias used for importPrivateKey call");
        }
        FileInputStream inputStream = null;
        JSAFE_SymmetricCipher decrypter = null;
        JSAFE_SecretKey key = null;
        JSAFE_PrivateKey privateKey = null;
        try {
            JSAFE_PublicKey publicKey;
            inputStream = new FileInputStream(certFile);
            byte[] keyData = new byte[inputStream.available()];
            inputStream.read(keyData, 0, keyData.length);
            inputStream.close();
            decrypter = JSAFE_SymmetricCipher.getInstance((byte[])keyData, (int)0, (String)"Java");
            key = decrypter.getBlankKey();
            key.setPassword(password, 0, password.length);
            decrypter.decryptInit(key, null);
            privateKey = decrypter.unwrapPrivateKey(keyData, 0, keyData.length, true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(privateKey);
            byte[] keyBytes = bos.toByteArray();
            oos.close();
            bos.close();
            byte[][] certChain = null;
            certChain = entry.getCertificate();
            if (certChain != null && !jsafeKeyStore.verifyKeyPair(publicKey = new X509Certificate(certChain[0], 0, 0).getSubjectPublicKey("Java"), privateKey)) {
                throw new InvalidKeyException("The private key and the public key don't match.");
            }
            entry.setKey(keyBytes);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            EKeyStoreException kse = new EKeyStoreException("Unable to import Certificate: " + e.getMessage(), e);
            kse.fillInStackTrace();
            throw kse;
        }
    }

    @Override
    public void exportPrivateKey(String alias, char[] password, File certFile) throws EKeyStoreException, IOException {
        KeyStore.KeyEntry entry = null;
        entry = this.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unknown alias used for exportPrivateKey call");
        }
        try {
            byte[] key = entry.getKey();
            ByteArrayInputStream bis = new ByteArrayInputStream(key);
            ObjectInputStream ois = new ObjectInputStream(bis);
            JSAFE_PrivateKey privateKey = (JSAFE_PrivateKey)ois.readObject();
            ois.close();
            bis.close();
            SSLUtils.saveKey((JSAFE_PrivateKey)privateKey, (File)certFile, (char[])password, (JSAFE_SecureRandom)random, (String)"Java");
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            EKeyStoreException kse = new EKeyStoreException("Unable to import Certificate: " + e.getMessage(), e);
            kse.fillInStackTrace();
            throw kse;
        }
    }

    @Override
    public void importCertificateChain(String alias, InputStream certs, int form) throws EKeyStoreException, IOException {
        KeyStore.KeyEntry entry = null;
        entry = this.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unknown alias used for importCertificateChain call");
        }
        Vector certVector = null;
        try {
            certVector = jsafeX509Certificate.loadCertificateChain(certs);
        }
        catch (PKCS7Exception p7e) {
            EKeyStoreException kse = new EKeyStoreException("Unable to import Certificate Chain: " + p7e.getMessage(), p7e);
            kse.fillInStackTrace();
            throw kse;
        }
        try {
            int numcerts = 0;
            if (certVector != null) {
                numcerts = certVector.size();
            }
            byte[][] chain = new byte[numcerts][];
            for (int idx = 0; idx < numcerts; ++idx) {
                X509Certificate x509Cert = (X509Certificate)certVector.elementAt(idx);
                byte[] certDER = new byte[x509Cert.getDERLen(0)];
                x509Cert.getDEREncoding(certDER, 0, 0);
                chain[idx] = certDER;
            }
            byte[] key = null;
            key = entry.getKey();
            if (key != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(key);
                ObjectInputStream ois = new ObjectInputStream(bis);
                JSAFE_PrivateKey privateKey = (JSAFE_PrivateKey)ois.readObject();
                ois.close();
                bis.close();
                JSAFE_PublicKey publicKey = ((X509Certificate)certVector.elementAt(0)).getSubjectPublicKey("Java");
                if (!jsafeKeyStore.verifyKeyPair(publicKey, privateKey)) {
                    throw new InvalidKeyException("The private key and the public key don't match.");
                }
            }
            entry.setCertificate(chain);
        }
        catch (Exception ce) {
            EKeyStoreException kse = new EKeyStoreException("Unable to import Certificate Chain: " + ce.getMessage(), ce);
            kse.fillInStackTrace();
            throw kse;
        }
    }

    @Override
    public void exportCertificateChain(String alias, OutputStream os) throws EKeyStoreException, IOException {
        KeyStore.KeyEntry entry = null;
        entry = this.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unknown alias used for exportCertificateChain call");
        }
        SignedData pkcs7data = null;
        try {
            pkcs7data = (SignedData)ContentInfo.getInstance((int)2, null, null);
            String contentstr = "No content.";
            ContentInfo content = ContentInfo.getInstance((int)1, null, null);
            ((Data)content).setContent(contentstr.getBytes(), 0, contentstr.length());
            pkcs7data.setContentInfo(content);
            byte[][] chain = entry.getCertificate();
            for (int idx = 0; idx < chain.length; ++idx) {
                X509Certificate x509Cert = new X509Certificate(chain[idx], 0, 0);
                pkcs7data.addCertificate(x509Cert);
            }
            int contentInfoEncodingLen = pkcs7data.getContentInfoDERLen();
            byte[] contentInfoEncoding = new byte[contentInfoEncodingLen];
            pkcs7data.writeMessage(contentInfoEncoding, 0);
            os.write(contentInfoEncoding);
        }
        catch (PKCS7Exception p7e) {
            EKeyStoreException kse = new EKeyStoreException("Unable to import Certificate Chain: " + p7e.getMessage(), p7e);
            kse.fillInStackTrace();
            throw kse;
        }
        catch (CertificateException ce) {
            EKeyStoreException kse = new EKeyStoreException("Unable to import Certificate Chain: " + ce.getMessage(), ce);
            kse.fillInStackTrace();
            throw kse;
        }
    }

    @Override
    public long getKeyStoreVersion() {
        return 4529319232503159154L;
    }

    @Override
    protected byte[] encrypt(byte[] clearStore, String pwd) throws Exception {
        JSAFE_SymmetricCipher encryptor = null;
        JSAFE_SecretKey secretKey = null;
        try {
            encryptor = JSAFE_SymmetricCipher.getInstance((String)"PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-10-3", (String)"Java");
            encryptor.setSalt(s_salt, 0, s_salt.length);
            secretKey = encryptor.getBlankKey();
            secretKey.setPassword(pwd.toCharArray(), 0, pwd.length());
            encryptor.encryptInit(secretKey);
            byte[] cipherText = new byte[encryptor.getOutputBufferSize(clearStore.length)];
            int partOut = encryptor.encryptUpdate(clearStore, 0, clearStore.length, cipherText, 0);
            int finalOut = encryptor.encryptFinal(cipherText, partOut);
            byte[] byArray = cipherText;
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            encryptor.clearSensitiveData();
            secretKey.clearSensitiveData();
        }
    }

    @Override
    protected byte[] decrypt(byte[] cipherStore, String pwd) throws Exception {
        JSAFE_SymmetricCipher decryptor = null;
        JSAFE_SecretKey secretKey = null;
        try {
            decryptor = JSAFE_SymmetricCipher.getInstance((String)"PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-10-3", (String)"Java");
            decryptor.setSalt(s_salt, 0, s_salt.length);
            secretKey = decryptor.getBlankKey();
            secretKey.setPassword(pwd.toCharArray(), 0, pwd.length());
            decryptor.decryptInit(secretKey);
            byte[] clearText = new byte[cipherStore.length];
            int partOut = decryptor.decryptUpdate(cipherStore, 0, cipherStore.length, clearText, 0);
            int finalOut = decryptor.decryptFinal(clearText, partOut);
            byte[] returnText = new byte[partOut + finalOut];
            System.arraycopy(clearText, 0, returnText, 0, returnText.length);
            byte[] byArray = returnText;
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            decryptor.clearSensitiveData();
            secretKey.clearSensitiveData();
        }
    }

    static byte[] doReadBytes(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = is.read(buf)) >= 0) {
                bos.write(buf, 0, len);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        buf = bos.toByteArray();
        bos.close();
        bos = null;
        try {
            ByteArrayInputStream bufis = new ByteArrayInputStream(buf);
            byte[] pembuf = jsafeKeyStore.doReadPEM(bufis);
            return pembuf;
        }
        catch (IOException iOException) {
            return buf;
        }
    }

    static byte[] doReadPEM(InputStream is) throws IOException {
        String dataLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer base64data = new StringBuffer();
        JSAFE_Recode decoder = null;
        while ((dataLine = reader.readLine()) != null && !dataLine.startsWith(s_certificateHeader)) {
        }
        if (dataLine == null) {
            throw new IOException("BEGIN CERTIFICATE header not found");
        }
        try {
            decoder = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            decoder.decodeInit();
        }
        catch (JSAFE_UnimplementedException jie) {
            throw new IOException("JSAFE_Recode - Base64 decoder not implemented in this version of JSAFE: " + jie.getMessage(), jie);
        }
        catch (JSAFE_InvalidParameterException jipe) {
            throw new IOException("JSAFE_Recode - Base64 decoder could not be instantiated: " + jipe.getMessage(), jipe);
        }
        catch (JSAFE_InvalidUseException jiue) {
            throw new IOException("JSAFE_Recode - Base64 decoder could not be instantiated: " + jiue.getMessage(), jiue);
        }
        while ((dataLine = reader.readLine()) != null && !dataLine.startsWith(s_certificateTrailer)) {
            base64data = base64data.append(dataLine);
        }
        if (dataLine == null) {
            throw new IOException("END CERTIFICATE trailer not found");
        }
        byte[] encodedData = base64data.toString().getBytes();
        int outputSize = decoder.getOutputBufferSize(encodedData.length);
        byte[] decodedData = new byte[outputSize];
        try {
            int outputLenUpdate = decoder.decodeUpdate(encodedData, 0, encodedData.length, decodedData, 0);
            int outputLenFinal = decoder.decodeFinal(decodedData, outputLenUpdate);
        }
        catch (JSAFE_InputException jie) {
            throw new IOException("JSAFE_Recode could not decode base64 data: " + jie.getMessage(), jie);
        }
        catch (JSAFE_InvalidUseException jiue) {
            throw new IOException("JSAFE_Recode could not decode base64 data: " + jiue.getMessage(), jiue);
        }
        finally {
            decoder.clearSensitiveData();
        }
        return decodedData;
    }

    static byte[] doWritePEM(byte[] derData, String header, String trailer) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bos));
        JSAFE_Recode encoder = null;
        try {
            encoder = JSAFE_Recode.getInstance((String)"Base64-76", (String)"Java");
            encoder.encodeInit();
        }
        catch (JSAFE_UnimplementedException jie) {
            throw new IOException("JSAFE_Recode - Base64 encoder not implemented in this version of JSAFE: " + jie.getMessage(), jie);
        }
        catch (JSAFE_InvalidParameterException jipe) {
            throw new IOException("JSAFE_Recode - Base64 encoder could not be instantiated: " + jipe.getMessage(), jipe);
        }
        catch (JSAFE_InvalidUseException jiue) {
            throw new IOException("JSAFE_Recode - Base64 encoder could not be instantiated: " + jiue.getMessage(), jiue);
        }
        int outputSize = encoder.getOutputBufferSize(derData.length);
        byte[] pemData = new byte[outputSize];
        int outputLenUpdate = 0;
        int outputLenFinal = 0;
        try {
            outputLenUpdate = encoder.encodeUpdate(derData, 0, derData.length, pemData, 0);
            outputLenFinal = encoder.encodeFinal(pemData, outputLenUpdate);
        }
        catch (JSAFE_InvalidUseException jiue) {
            throw new IOException("JSAFE_Recode could not encode data in base64 format: " + jiue.getMessage(), jiue);
        }
        finally {
            encoder.clearSensitiveData();
        }
        writer.write(header);
        writer.newLine();
        writer.write(new String(pemData, 0, outputLenUpdate + outputLenFinal));
        if (pemData[outputLenUpdate + outputLenFinal - 1] != 10) {
            writer.newLine();
        }
        writer.write(trailer);
        writer.flush();
        writer.close();
        return bos.toByteArray();
    }

    static {
        try {
            random = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"SHA1Random", (String)"Java");
            random.seed(new Date().toString().getBytes());
            random.seed(random.generateRandomBytes(64));
        }
        catch (NoSuchAlgorithmException e) {
            random = null;
        }
    }
}

