/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsafe;

import com.rsa.certj.cert.X509Certificate;
import com.rsa.ssl.CompressionMethod;
import com.rsa.ssl.SSLException;
import com.rsa.ssl.SSLParams;
import com.rsa.ssl.SSLServerSocket;
import com.rsa.ssl.SSLSocket;
import com.sonicsw.security.ssl.SSLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.TCPProxy;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.ISSLImpl;
import progress.message.net.ssl.ISSLServerSocket;
import progress.message.net.ssl.ISSLSocket;
import progress.message.net.ssl.jsafe.jsafeSSLClientControl;
import progress.message.net.ssl.jsafe.jsafeSSLServerControl;
import progress.message.net.ssl.jsafe.jsafeX509Certificate;

public class jsafeSSLImpl
implements ISSLImpl {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLIENT_CIPHER = false;

    @Override
    public ISSLControl createSSLClientControl() throws ESocketConfigException {
        jsafeSSLClientControl control = new jsafeSSLClientControl();
        if (DEBUG) {
            control.setDebug(true);
        }
        return control;
    }

    @Override
    public ISSLControl createSSLServerControl() throws ESocketConfigException {
        jsafeSSLServerControl control = new jsafeSSLServerControl();
        if (DEBUG) {
            control.setDebug(true);
        }
        return control;
    }

    @Override
    public ISSLSocket createSSLSocket(String host, int port, ISSLControl control, Object properties) throws UnknownHostException, IOException {
        return this.createSSLSocket(host, port, control, null, -1, properties, null);
    }

    @Override
    public ISSLSocket createSSLSocket(String host, int port, ISSLControl control, String proxyHost, int proxyPort, Object properties, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        SSLSocket socket = null;
        ((jsafeSSLClientControl)control).setProtocolVersions(properties);
        try {
            Socket tunnelingSocket;
            if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0 && pConfig.getPort() != -1) {
                tunnelingSocket = TCPProxy.connectProxy(host, port, proxyHost, proxyPort, pConfig);
                socket = new SSLSocket(tunnelingSocket, (SSLParams)control.getContext());
            } else if (proxyHost != null && proxyPort != -1) {
                tunnelingSocket = TCPProxy.connectProxy(host, port, proxyHost, proxyPort, null);
                socket = new SSLSocket(tunnelingSocket, (SSLParams)control.getContext());
            } else {
                socket = new SSLSocket(host, port, (SSLParams)control.getContext());
            }
        }
        catch (SSLException ex) {
            throw new SocketException("An error occured during SSL handshake: " + ex.getMessage());
        }
        InputStream is = socket.getInputStream();
        OutputStream os = socket.getOutputStream();
        if (DEBUG_CLIENT_CIPHER && socket != null) {
            System.out.println("Cipher suite: " + socket.getCipherSuite().getCipherSuiteName());
        }
        if (DEBUG && socket != null) {
            System.out.println("Connection info:");
            System.out.println("Cipher suite:  " + socket.getCipherSuite().getCipherSuiteName());
            CompressionMethod compMethod = socket.getCompression();
            if (compMethod != null) {
                System.out.println("Compression method:  " + compMethod.getCompressionMethodName());
            } else {
                System.out.println("Compression method:  NONE");
            }
            System.out.println();
            System.out.println("Peer information:");
            X509Certificate[] clientChain = socket.getPeerCertificateChain();
            if (clientChain != null) {
                System.out.println("Subject name:");
                System.out.println(clientChain[0].getSubjectName().toString());
                System.out.println("Issuer name:");
                System.out.println(clientChain[0].getIssuerName().toString());
                System.out.println();
            } else {
                System.out.println(" No peer information available.");
            }
            System.out.println();
        }
        return new jsafeSSLSocket(socket, true);
    }

    @Override
    public ISSLServerSocket createSSLServerSocket(InetAddress bindAddr, int port, int backlog, ISSLControl serverControl, Object properties) throws IOException {
        ISSLServerSocket ssocket = this.createSSLServerSocket(bindAddr == null ? null : new ProgressInetAddress(bindAddr), port, backlog, serverControl, properties);
        return ssocket;
    }

    @Override
    public ISSLServerSocket createSSLServerSocket(ProgressInetAddress bindAddr, int port, int backlog, ISSLControl control, Object properties) throws IOException {
        ((jsafeSSLServerControl)control).setProtocolVersions(properties);
        SSLServerSocket serverSocket = new SSLServerSocket(port, backlog, bindAddr == null ? null : bindAddr.getDelegateInetAddress(), (SSLParams)control.getContext());
        class JsafeSSLServerSocket
        implements ISSLServerSocket {
            SSLServerSocket m_impl = null;

            JsafeSSLServerSocket(SSLServerSocket s) {
                this.m_impl = s;
            }

            @Override
            public ServerSocket getImpl() {
                return this.m_impl;
            }

            @Override
            public ISSLSocket accept() throws IOException {
                String errorMessage = null;
                SSLSocket s = null;
                try {
                    s = (SSLSocket)this.m_impl.accept();
                }
                catch (Exception e) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    errorMessage = e.getMessage();
                }
                if (s == null) {
                    throw new IOException(errorMessage + ". accept() returned null.");
                }
                return new jsafeSSLSocket(s, false);
            }

            @Override
            public void setSoTimeout(int timeout) throws IOException {
                this.m_impl.setSoTimeout(timeout);
            }
        }
        return new JsafeSSLServerSocket(serverSocket);
    }

    @Override
    public progress.message.security.cert.X509Certificate loadCertificate(File file) {
        return jsafeX509Certificate.loadX509Certificate(file);
    }

    @Override
    public progress.message.security.cert.X509Certificate loadCertificate(String file) {
        return jsafeX509Certificate.loadX509Certificate(file);
    }

    @Override
    public void setDebug(boolean on) {
        DEBUG = on;
    }

    static {
        Boolean b = SSLUtil.getBooleanProperty(null, "SSL_DEBUG.CLIENT_CIPHER", Boolean.FALSE);
        if (b != null && b.booleanValue()) {
            DEBUG_CLIENT_CIPHER = true;
        }
    }

    class jsafeSSLSocket
    implements ISSLSocket {
        SSLSocket m_impl = null;
        boolean m_handshakeDone = false;

        jsafeSSLSocket(SSLSocket s, boolean handshakeDone) {
            this.m_impl = s;
            this.m_handshakeDone = handshakeDone;
        }

        @Override
        public Socket getImpl() {
            return this.m_impl;
        }

        @Override
        public progress.message.security.cert.X509Certificate getPeerCertificate() {
            if (!this.m_handshakeDone) {
                try {
                    this.startHandshake();
                }
                catch (IOException ex) {
                    return null;
                }
            }
            try {
                X509Certificate[] certChain = this.m_impl.getPeerCertificateChain();
                return certChain != null ? new jsafeX509Certificate(certChain[0]) : null;
            }
            catch (Exception ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
                return null;
            }
        }

        @Override
        public progress.message.security.cert.X509Certificate[] getPeerCertificateChain() {
            X509Certificate[] certs;
            if (!this.m_handshakeDone) {
                try {
                    this.startHandshake();
                }
                catch (IOException ex) {
                    return null;
                }
            }
            if ((certs = this.m_impl.getPeerCertificateChain()) != null && certs.length != 0) {
                progress.message.security.cert.X509Certificate[] x509certs = new progress.message.security.cert.X509Certificate[certs.length];
                for (int i = 0; i < certs.length; ++i) {
                    x509certs[i] = new jsafeX509Certificate(certs[i]);
                }
                return x509certs;
            }
            return null;
        }

        @Override
        public InetAddress getInetAddress() {
            if (this.m_impl.parentSocket == null || this.m_impl.parentSocket.getInetAddress() == null) {
                return null;
            }
            return this.m_impl.parentSocket.getInetAddress();
        }

        @Override
        public String getCipherSuite() {
            return this.m_impl.getCipherSuite().getCipherSuiteName();
        }

        @Override
        public void startHandshake() throws IOException {
            if (DEBUG) {
                System.out.println(Thread.currentThread() + " starting ssl handshake ...");
            }
            this.m_handshakeDone = true;
            try {
                this.m_impl.getInputStream();
                this.m_impl.getOutputStream();
            }
            catch (IOException ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
                this.m_impl.parentSocket.close();
                this.m_impl.close();
                throw ex;
            }
            if (DEBUG_CLIENT_CIPHER && this.m_impl != null) {
                System.out.println("Cipher suite: " + this.m_impl.getCipherSuite().getCipherSuiteName());
            }
            if (DEBUG && this.m_impl != null) {
                System.out.println("Connection info:");
                System.out.println("Cipher suite:  " + this.m_impl.getCipherSuite().getCipherSuiteName());
                CompressionMethod compMethod = this.m_impl.getCompression();
                if (compMethod != null) {
                    System.out.println("Compression method:  " + compMethod.getCompressionMethodName());
                } else {
                    System.out.println("Compression method:  NONE");
                }
                System.out.println();
                System.out.println("Peer information:");
                X509Certificate[] clientChain = this.m_impl.getPeerCertificateChain();
                if (clientChain != null) {
                    System.out.println("Subject name:");
                    System.out.println(clientChain[0].getSubjectName().toString());
                    System.out.println("Issuer name:");
                    System.out.println(clientChain[0].getIssuerName().toString());
                    System.out.println();
                } else {
                    System.out.println(" No peer information available.");
                }
                System.out.println();
            }
        }

        @Override
        public void setSoTimeout(int timeout) throws IOException {
            this.m_impl.setSoTimeout(timeout);
        }
    }
}

