/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EStartupFailure;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.broker.SubjectAclEntry;
import progress.message.client.EGeneralException;
import progress.message.client.EUnknownPrincipal;
import progress.message.db.EDatabaseException;
import progress.message.security.EPrincipalConflict;
import progress.message.security.EPrincipalExists;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.security.SecurityListener;
import progress.message.security.prAccessor;
import progress.message.util.DraDestUtil;
import progress.message.zclient.Connection;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.QOP;

public class SecurityBean {
    public static final String PUBLIC_GROUP = "PUBLIC";
    public static final String ADMIN_GROUP = "Administrators";
    public static final String TXN_ADMIN_GROUP = "TxnAdministrators";
    public static final String BROKER_GROUP = "$ISYS-BROKERS";
    protected SecurityCache m_cache;
    protected Vector m_listeners = new Vector();

    public static SecurityBean createLocalBean(Connection serverConnection) throws EStartupFailure {
        try {
            SecurityBean ret = SecurityBean.createLocalBean();
            return ret;
        }
        catch (EGeneralException e) {
            String mf41 = prAccessor.getString("STR096");
            Object[] ob41 = new Object[]{e};
            throw new EStartupFailure(MessageFormat.format(mf41, ob41));
        }
    }

    public static SecurityBean createLocalBean() throws EStartupFailure {
        try {
            return new SecurityBean();
        }
        catch (EGeneralException e) {
            String mf58 = prAccessor.getString("STR097");
            Object[] ob58 = new Object[]{e};
            throw new EStartupFailure(MessageFormat.format(mf58, ob58));
        }
    }

    private SecurityBean() throws EGeneralException {
        this.m_cache = Broker.getBroker().getSecurityCache();
        this.m_cache.setParent(this);
        this.m_cache.setStartTime(AgentRegistrar.getAgentRegistrar().getBrokerDatabase().getLogTime());
    }

    public void startServer() throws EGeneralException {
    }

    public synchronized void addSecurityListener(SecurityListener listener) {
        this.m_listeners.addElement(listener);
    }

    public synchronized void removeSecurityListener(SecurityListener listener) {
        this.m_listeners.removeElement(listener);
    }

    public synchronized long getStartTime() {
        return this.m_cache.getStartTime();
    }

    public synchronized Vector getSecureSubjects() {
        return this.m_cache.getSecureSubjects();
    }

    public synchronized QOP getQOP(String subject) {
        return this.m_cache.getQOP(subject);
    }

    public synchronized Vector getAclEntries(String subject) {
        return this.m_cache.getAclEntries(subject);
    }

    public Vector getRoutingUserACLs(String node) {
        return this.m_cache.getRoutingUserACLs(node);
    }

    public synchronized boolean isRoutingUserAuthorized(String node, Principal principal) {
        return this.m_cache.isRoutingUserAuthorized(node, principal);
    }

    public synchronized SubjectAclEntry getAclEntry(String subject, Principal prin) {
        Vector<SubjectAclEntry> acls = this.m_cache.getAclEntries(subject);
        for (int i = acls.size(); i >= 0; --i) {
            SubjectAclEntry sae = acls.elementAt(i);
            if (!sae.getPrincipal().equals(prin)) continue;
            return sae;
        }
        return null;
    }

    public synchronized Vector getUserNames(String prefix) {
        boolean getAll = prefix.length() == 0;
        Vector<String> ret = new Vector<String>();
        Enumeration<ProgressPrincipal> prins = this.m_cache.getPrincipals();
        while (prins.hasMoreElements()) {
            String routingNodeName;
            ProgressPrincipal p = prins.nextElement();
            if (!(p instanceof ProgressPasswordUser) || (routingNodeName = ((ProgressPasswordUser)p).getRoutingNodeName()) != null) continue;
            String userName = ((ProgressPasswordUser)p).getName();
            if (!getAll && !userName.startsWith(prefix)) continue;
            ret.addElement(userName);
        }
        return ret;
    }

    public synchronized Vector getRoutingUserNames(String prefix) {
        Vector<String[]> ret = new Vector<String[]>();
        boolean getAll = prefix.length() == 0;
        Enumeration<ProgressPrincipal> prins = this.m_cache.getPrincipals();
        while (prins.hasMoreElements()) {
            String routingNodeName;
            ProgressPrincipal p = prins.nextElement();
            if (!(p instanceof ProgressPasswordUser) || (routingNodeName = ((ProgressPasswordUser)p).getRoutingNodeName()) == null) continue;
            String userName = ((ProgressPasswordUser)p).getName();
            if (!getAll && !userName.startsWith(prefix)) continue;
            String[] routingUserInfo = new String[]{userName, routingNodeName};
            ret.addElement(routingUserInfo);
        }
        return ret;
    }

    public synchronized ProgressPasswordUser getUser(String name) {
        ProgressPrincipal p = this.m_cache.getPrincipal(name);
        if (p instanceof ProgressPasswordUser) {
            return (ProgressPasswordUser)p;
        }
        return null;
    }

    public synchronized Vector getGroupNames() {
        return this.getGroupNames("");
    }

    public synchronized Vector getGroupNames(String prefix) {
        Vector<String> ret = new Vector<String>();
        boolean getAll = prefix.length() == 0;
        Enumeration<ProgressPrincipal> prins = this.m_cache.getPrincipals();
        while (prins.hasMoreElements()) {
            ProgressPrincipal p = prins.nextElement();
            if (!(p instanceof ProgressGroup)) continue;
            String name = ((ProgressGroup)p).getName();
            if (!getAll && !name.startsWith(prefix)) continue;
            ret.addElement(name);
        }
        return ret;
    }

    public synchronized Vector getExternalGroupNames() {
        return this.getExternalGroupNames("");
    }

    private synchronized Vector getExternalGroupNames(String prefix) {
        Vector<String> ret = new Vector<String>();
        boolean getAll = prefix.length() == 0;
        Enumeration<ProgressPrincipal> prins = this.m_cache.getPrincipals();
        while (prins.hasMoreElements()) {
            ProgressPrincipal p = prins.nextElement();
            if (!(p instanceof ProgressGroup) || ((ProgressGroup)p).isInternalPrincipal()) continue;
            String name = ((ProgressGroup)p).getName();
            if (!getAll && !name.startsWith(prefix)) continue;
            ret.addElement(name);
        }
        return ret;
    }

    public synchronized ProgressGroup getGroup(String name) {
        ProgressPrincipal p = this.m_cache.getPrincipal(name);
        if (p instanceof ProgressGroup) {
            return (ProgressGroup)p;
        }
        return null;
    }

    public synchronized void setQOP(String subject, QOP qop) throws IOException {
        this.newEvent(this.m_cache.prepareSetQOPEvent(subject, qop));
    }

    public synchronized void delQOP(String subject_name) throws IOException {
        this.newEvent(this.m_cache.prepareDelQOPEvent(subject_name));
    }

    public synchronized void setRoutingUserAclEntry(String nodeName, RoutingUserAclEntry aclEntry) throws EUnknownPrincipal, IOException {
        this.newEvent(this.m_cache.prepareSetRoutingUserAclEntryEvent(nodeName, aclEntry));
    }

    public synchronized void setAclEntry(String subject, SubjectAclEntry aclEntry) throws EUnknownPrincipal, IOException {
        if (subject != null && subject.equals(DraDestUtil.SUBJECT_SONIC_URL_ALL)) {
            this.newEvent(this.m_cache.prepareSetAclEntryEvent(DraDestUtil.SUBJECT_RNN_ALL_HTTP_ALL, aclEntry));
            this.newEvent(this.m_cache.prepareSetAclEntryEvent(DraDestUtil.SUBJECT_RNN_ALL_HTTPS_ALL, aclEntry));
        } else {
            this.newEvent(this.m_cache.prepareSetAclEntryEvent(subject, aclEntry));
        }
        if (subject != null && subject.equals("#")) {
            this.newEvent(this.m_cache.prepareSetAclEntryEvent("$SonicMQ-Root-Subject", aclEntry));
        }
    }

    public synchronized void delAclEntry(String subject, SubjectAclEntry aclEntry) throws IOException {
        if (subject != null && subject.equals(DraDestUtil.SUBJECT_SONIC_URL_ALL)) {
            this.newEvent(this.m_cache.prepareDelAclEntryEvent(DraDestUtil.SUBJECT_RNN_ALL_HTTP_ALL, aclEntry));
            this.newEvent(this.m_cache.prepareDelAclEntryEvent(DraDestUtil.SUBJECT_RNN_ALL_HTTPS_ALL, aclEntry));
        } else {
            this.newEvent(this.m_cache.prepareDelAclEntryEvent(subject, aclEntry));
        }
        if (subject != null && subject.equals("#")) {
            this.newEvent(this.m_cache.prepareDelAclEntryEvent("$SonicMQ-Root-Subject", aclEntry));
        }
    }

    public synchronized void delRoutingUserAclEntry(String nodeName, Principal principal) throws IOException {
        this.newEvent(this.m_cache.prepareDelRoutingUserAclEntryEvent(nodeName, principal));
    }

    public synchronized void setUser(ProgressPasswordUser user) throws EPrincipalExists, EPrincipalConflict, IOException {
        this.newEvent(this.m_cache.prepareSetUserEvent(user));
    }

    public synchronized void delUser(String name) throws IOException {
        if (this.getUser(name) != null) {
            this.newEvent(this.m_cache.prepareDelPrincipalEvent(name));
        }
    }

    public synchronized void newGroup(String name) throws EPrincipalExists, IOException {
        this.newEvent(this.m_cache.prepareNewGroupEvent(name));
    }

    public synchronized void delGroup(String name) throws IOException {
        if (this.getGroup(name) != null) {
            this.newEvent(this.m_cache.prepareDelPrincipalEvent(name));
        }
    }

    public synchronized void addGroupMember(String groupname, String username) throws EUnknownPrincipal, IOException {
        this.newEvent(this.m_cache.prepareAddGroupMemberEvent(groupname, username));
    }

    public synchronized void removeGroupMember(String groupname, String username) throws EUnknownPrincipal, IOException {
        this.newEvent(this.m_cache.prepareRemoveGroupMemberEvent(groupname, username));
    }

    public synchronized void setStartTime(long starttime) throws EDatabaseException, EGeneralException {
    }

    synchronized boolean wasEventCommitted(long starttime, int vtime) throws EDatabaseException {
        return true;
    }

    boolean isUserConflict(String name) throws EDatabaseException {
        return this.m_cache.getPrincipal(name) != null;
    }

    protected void fireSecurityEvent(SecurityEvent evt) {
        int size = this.m_listeners.size();
        for (int i = 0; i < size; ++i) {
            ((SecurityListener)this.m_listeners.elementAt(i)).securityUpdate(evt);
        }
    }

    private void newEvent(SecurityEvent evt) throws IOException {
        if (evt != null) {
            this.m_cache.processEvent(evt);
            this.fireSecurityEvent(evt);
        }
    }
}

