/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.crypto.DES;
import progress.message.crypto.MessageDigest;
import progress.message.crypto.SHA;
import progress.message.security.cert.X500Name;
import progress.message.security.cert.X509Certificate;
import progress.message.security.keystore.EKeyStoreException;
import progress.message.zclient.SessionConfig;

public abstract class KeyStore
implements Serializable {
    private static String keyStoreImpl = SessionConfig.KEY_STORE_CLASS;
    private static final KeyStore s_impl;
    protected transient Hashtable m_store = null;
    public static final int RSA = 1;
    public static final int DSA = 2;
    public static final int BINARY = 1;
    public static final int BASE64 = 2;
    public static final int BINARY_APPEND = 3;
    public static final int BASE64_APPEND = 4;
    static final long serialVersionUID = -178364121845629025L;

    public static final KeyStore newStore() throws EKeyStoreException {
        KeyStore store = null;
        try {
            Class<?> keyClass = Class.forName(keyStoreImpl);
            store = (KeyStore)keyClass.newInstance();
        }
        catch (Throwable iaike) {
            throw new EKeyStoreException("Unable to locate the KeyStore implementation class " + keyStoreImpl);
        }
        store.m_store = new Hashtable();
        return store;
    }

    public static final KeyStore load(InputStream in, String password) throws EKeyStoreException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int count = -1;
        try {
            while ((count = in.read(buf)) != -1) {
                bos.write(buf, 0, count);
            }
            in.close();
            byte[] storeData = bos.toByteArray();
            bos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(s_impl.decrypt(storeData, password));
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (KeyStore)ois.readObject();
        }
        catch (EKeyStoreException kse) {
            throw kse;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            EKeyStoreException kse = new EKeyStoreException("Unable to load KeyStore: " + ex.getMessage());
            kse.fillInStackTrace();
            throw kse;
        }
    }

    public final void save(OutputStream os, String password) throws EKeyStoreException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            if (this.m_store == null) {
                this.m_store = new Hashtable();
            }
            oos.writeObject(this);
            oos.flush();
            oos.close();
            byte[] storeData = bos.toByteArray();
            bos.close();
            os.write(s_impl.encrypt(storeData, password));
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            EKeyStoreException kse = new EKeyStoreException("Unable to save KeyStore: " + ex.getMessage());
            kse.fillInStackTrace();
            throw kse;
        }
    }

    public Enumeration aliases() throws EKeyStoreException {
        return this.m_store.keys();
    }

    public boolean hasKey(String alias) throws EKeyStoreException {
        KeyEntry entry = (KeyEntry)this.m_store.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("No entry exists with the alias: " + alias);
        }
        return entry.privateKey != null;
    }

    public boolean hasCert(String alias) throws EKeyStoreException {
        KeyEntry entry = (KeyEntry)this.m_store.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("No entry exists with the alias: " + alias);
        }
        return entry.certChain != null;
    }

    public boolean hasCSR(String alias) throws EKeyStoreException {
        KeyEntry entry = (KeyEntry)this.m_store.get(alias);
        if (entry == null) {
            throw new EKeyStoreException("No entry exists with the alias: " + alias);
        }
        return entry.CSR != null;
    }

    public void add(String alias) throws EKeyStoreException {
        KeyEntry entry = this.m_store.put(alias, new KeyEntry());
        if (entry != null) {
            throw new EKeyStoreException("Entry already exists in KeyStore with alias: " + alias);
        }
    }

    public void remove(String alias) throws EKeyStoreException {
        KeyEntry entry = (KeyEntry)this.m_store.remove(alias);
        if (entry == null) {
            throw new EKeyStoreException("Unable to remove entry from KeyStore");
        }
    }

    public abstract byte[] keygen(String var1, int var2, int var3, X500Name var4) throws EKeyStoreException, IOException;

    public abstract void exportKeyAndCertificate(String var1, char[] var2, OutputStream var3) throws EKeyStoreException, IOException;

    public abstract void importCertificate(String var1, InputStream var2, int var3) throws EKeyStoreException, IOException;

    public abstract void exportCertificate(String var1, OutputStream var2) throws EKeyStoreException, IOException;

    public abstract X509Certificate[] getCertificate(String var1) throws EKeyStoreException;

    public abstract void importPrivateKey(String var1, char[] var2, File var3, int var4) throws EKeyStoreException, IOException;

    public abstract void exportPrivateKey(String var1, char[] var2, File var3) throws EKeyStoreException, IOException;

    public abstract void importCertificateChain(String var1, InputStream var2, int var3) throws EKeyStoreException, IOException;

    public abstract void exportCertificateChain(String var1, OutputStream var2) throws EKeyStoreException, IOException;

    public abstract long getKeyStoreVersion();

    protected final KeyEntry get(String alias) {
        return (KeyEntry)this.m_store.get(alias);
    }

    protected final void put(String alias, KeyEntry entry) {
        this.m_store.put(alias, entry);
    }

    protected final void setCSR(String alias, byte[] CSR) {
        KeyEntry entry = this.entry(alias);
        entry.setCSR(CSR);
    }

    protected final void setKey(String alias, byte[] key) {
        KeyEntry entry = this.entry(alias);
        entry.setKey(key);
    }

    protected final void setCertificate(String alias, byte[][] chain) {
        KeyEntry entry = this.entry(alias);
        entry.setCertificate(chain);
    }

    private KeyEntry entry(String alias) {
        KeyEntry entry = (KeyEntry)this.m_store.get(alias);
        this.m_store.put(alias, entry);
        return entry == null ? new KeyEntry() : entry;
    }

    protected byte[] encrypt(byte[] clearStore, String pwd) throws Exception {
        byte[] cipherStore = null;
        int pad = DES.computePad(clearStore.length);
        byte[] input = new byte[clearStore.length + pad];
        System.arraycopy(clearStore, 0, input, 0, clearStore.length);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        SHA sha = new SHA();
        sha.add(input);
        dos.write(sha.digest());
        dos.writeInt(pad);
        byte[] key = KeyStore.makeDESKey(pwd);
        dos.write(KeyStore.doDES(1, key, input));
        dos.flush();
        dos.close();
        cipherStore = bos.toByteArray();
        bos.close();
        return cipherStore;
    }

    protected byte[] decrypt(byte[] cipherStore, String pwd) throws Exception {
        byte[] clearStore = null;
        int paddedDataSize = cipherStore.length - 20 - 4;
        ByteArrayInputStream bis = new ByteArrayInputStream(cipherStore);
        DataInputStream dis = new DataInputStream(bis);
        byte[] mac = new byte[20];
        dis.read(mac);
        int pad = dis.readInt();
        byte[] opaqueData = new byte[paddedDataSize];
        dis.read(opaqueData);
        dis.close();
        bis.close();
        byte[] key = KeyStore.makeDESKey(pwd);
        byte[] clearData = KeyStore.doDES(2, key, opaqueData);
        clearStore = new byte[paddedDataSize - pad];
        System.arraycopy(clearData, 0, clearStore, 0, clearStore.length);
        SHA sha = new SHA();
        sha.add(clearData);
        byte[] computedMac = sha.digest();
        for (int i = 0; i < 20; ++i) {
            if (mac[i] == computedMac[i]) continue;
            throw new Exception("The computed mac is different from the embeded one");
        }
        return clearStore;
    }

    private static byte[] makeDESKey(String pwd) throws Exception {
        SHA md = new SHA();
        byte[] hash = MessageDigest.hash(pwd, (MessageDigest)md);
        byte[] key = new byte[8];
        System.arraycopy(hash, 6, key, 0, 8);
        return key;
    }

    private static byte[] doDES(int mode, byte[] key, byte[] input) {
        DES des = new DES();
        des.init(mode, key);
        byte[] output = new byte[input.length];
        des.doFinal(input, 0, input.length, output, 0);
        return output;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.m_store != null) {
            Enumeration aliases = this.m_store.keys();
            int i = 1;
            while (aliases.hasMoreElements()) {
                stream.writeObject(new Integer(i++));
                String alias = (String)aliases.nextElement();
                stream.writeUTF(alias);
                KeyEntry entry = null;
                entry = (KeyEntry)this.m_store.get(alias);
                stream.writeObject(entry.getCSR());
                stream.writeObject(entry.getKey());
                byte[][] certs = entry.getCertificate();
                if (certs != null) {
                    stream.writeInt(certs.length);
                    for (int idx = 0; idx < certs.length; ++idx) {
                        stream.writeObject(certs[idx]);
                    }
                    continue;
                }
                stream.writeInt(0);
            }
        }
        stream.writeObject(null);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.m_store = new Hashtable();
        Object nullOrInteger = null;
        while (null != (nullOrInteger = stream.readObject())) {
            String alias = stream.readUTF();
            KeyEntry entry = new KeyEntry();
            entry.setCSR((byte[])stream.readObject());
            entry.setKey((byte[])stream.readObject());
            int len = stream.readInt();
            if (len > 0) {
                byte[][] certs = new byte[len][];
                for (int idx = 0; idx < len; ++idx) {
                    certs[idx] = (byte[])stream.readObject();
                }
                entry.setCertificate(certs);
            }
            this.m_store.put(alias, entry);
        }
    }

    static {
        KeyStore impl = null;
        try {
            impl = KeyStore.newStore();
        }
        catch (EKeyStoreException ex) {
            System.out.println(ex.getMessage());
        }
        s_impl = impl;
    }

    protected final class KeyEntry
    implements Serializable {
        protected byte[] CSR = null;
        protected byte[] privateKey = null;
        protected byte[][] certChain = null;

        protected KeyEntry() {
        }

        protected KeyEntry(byte[] csr, byte[] key, byte[][] chain) {
            this.CSR = csr;
            this.privateKey = key;
            this.certChain = chain;
        }

        public void setCSR(byte[] csr) {
            this.CSR = csr;
        }

        public byte[] getCSR() {
            return this.CSR;
        }

        public void setKey(byte[] key) {
            this.privateKey = key;
        }

        public byte[] getKey() {
            return this.privateKey;
        }

        public void setCertificate(byte[][] chain) {
            this.certChain = chain;
        }

        public byte[][] getCertificate() {
            return this.certChain;
        }
    }
}

