/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import progress.message.util.DebugState;
import progress.message.util.IMetricsListener;
import progress.message.zclient.DebugObject;

public class CompressedBlockOutputStream
extends FilterOutputStream {
    private byte[] m_inBuf = null;
    private byte[] m_outBuf = null;
    private int m_len = 0;
    private Deflater m_deflater = null;
    private IMetricsListener m_metricListener = null;
    private boolean DEBUG;
    private DebugObject m_debugObj;

    public CompressedBlockOutputStream(OutputStream os, int size, IMetricsListener listener) throws IOException {
        this(os, size, -1, 0, listener);
    }

    public CompressedBlockOutputStream(OutputStream os, int size, int level, int strategy, IMetricsListener listener) throws IOException {
        super(os);
        this.m_inBuf = new byte[size];
        this.m_outBuf = new byte[size + 64];
        this.m_deflater = new Deflater(level);
        this.m_deflater.setStrategy(strategy);
        this.m_metricListener = listener;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.m_debugObj = new DebugObject("CompressedBlockOutputStream");
            this.DEBUG = this.m_debugObj.getDebug();
        }
    }

    protected void compressAndSend() throws IOException {
        if (this.m_len > 0) {
            this.m_deflater.setInput(this.m_inBuf, 0, this.m_len);
            this.m_deflater.finish();
            int size = this.m_deflater.deflate(this.m_outBuf);
            if (this.m_metricListener != null) {
                this.m_metricListener.updateBytesDelvdStats(size);
            }
            if (this.DEBUG) {
                this.debug("Total bytes written to the network = " + size + ", bytes prior to compression = " + this.m_len);
            }
            this.out.write(size >> 24 & 0xFF);
            this.out.write(size >> 16 & 0xFF);
            this.out.write(size >> 8 & 0xFF);
            this.out.write(size >> 0 & 0xFF);
            this.out.write(this.m_len >> 24 & 0xFF);
            this.out.write(this.m_len >> 16 & 0xFF);
            this.out.write(this.m_len >> 8 & 0xFF);
            this.out.write(this.m_len >> 0 & 0xFF);
            this.out.write(this.m_outBuf, 0, size);
            this.m_len = 0;
            this.m_deflater.reset();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.m_inBuf[this.m_len++] = (byte)b;
        if (this.m_len == this.m_inBuf.length) {
            this.compressAndSend();
        }
    }

    @Override
    public void write(byte[] b, int boff, int blen) throws IOException {
        while (this.m_len + blen > this.m_inBuf.length) {
            int toCopy = this.m_inBuf.length - this.m_len;
            System.arraycopy(b, boff, this.m_inBuf, this.m_len, toCopy);
            this.m_len += toCopy;
            this.compressAndSend();
            boff += toCopy;
            blen -= toCopy;
        }
        System.arraycopy(b, boff, this.m_inBuf, this.m_len, blen);
        this.m_len += blen;
        if (this.m_len == this.m_inBuf.length) {
            this.compressAndSend();
        }
    }

    @Override
    public void flush() throws IOException {
        this.compressAndSend();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.compressAndSend();
        this.out.flush();
        this.out.close();
    }

    private void debug(String s) {
        this.m_debugObj.debug(s);
    }
}

