/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import progress.message.jimpl.DestUtil;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;

public class DestinationInfo {
    private String m_routing = null;
    private String m_queuePrefix = "";
    private String m_subject;
    private boolean m_isRemoteTopic = false;

    public DestinationInfo(String destString, String localRoutingNodeName) {
        if (destString.startsWith("$Q.")) {
            this.m_queuePrefix = "$Q.";
            destString = destString.substring("$Q.".length());
        }
        this.m_routing = DestUtil.getRoutingName(destString);
        this.m_subject = DestUtil.getDestinationName(destString);
        if (this.m_queuePrefix.length() == 0 && this.m_routing != null && this.m_routing.length() > 0 && !this.m_routing.equals(localRoutingNodeName)) {
            this.m_isRemoteTopic = true;
        }
    }

    public String getFullSubject() {
        return this.m_queuePrefix + this.m_subject;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public ISubject getISubject() {
        return new Subject(this.m_queuePrefix + this.m_subject);
    }

    public String getRouting() {
        return this.m_routing;
    }

    public boolean isRemoteTopic() {
        return this.m_isRemoteTopic;
    }

    public boolean isQueue() {
        return this.m_queuePrefix.length() > 0;
    }
}

