/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.UTFDataFormatException;

public class StringUtil {
    private static byte[] EMPTY_UTF;

    public static byte[] JToCStr(String s) {
        int clen = s.length();
        byte[] cstr = new byte[clen + 1];
        (s + "\u0000").getBytes(0, clen, cstr, 0);
        cstr[clen] = 0;
        return cstr;
    }

    public static byte[] StrToArray(String s) {
        int len = s.length();
        byte[] b = new byte[len];
        s.getBytes(0, s.length(), b, 0);
        return b;
    }

    public static String UTFToString(byte[] utf, int off) throws UTFDataFormatException {
        try {
            int utflen = (utf[off++] & 0xFF) << 8 | utf[off++] & 0xFF;
            char[] str = new char[utflen];
            int count = 0;
            int strlen = 0;
            block7: while (count < utflen) {
                byte c = utf[off++];
                switch (c >>> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        str[strlen++] = (char)c;
                        continue block7;
                    }
                    case 12: 
                    case 13: {
                        byte char2;
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        if (((char2 = utf[off++]) & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block7;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = utf[off++];
                        byte char3 = utf[off++];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block7;
                    }
                }
                throw new UTFDataFormatException();
            }
            return new String(str, 0, strlen);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UTFDataFormatException();
        }
    }

    public static byte[] stringToUTF(String str) throws UTFDataFormatException {
        char[] cc;
        int utflen = 0;
        for (char c : cc = str.toCharArray()) {
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("String too long: " + str);
        }
        byte[] utf = new byte[utflen + 2];
        int p = 0;
        utf[p++] = (byte)(utflen >>> 8 & 0xFF);
        utf[p++] = (byte)(utflen >>> 0 & 0xFF);
        for (char c : cc) {
            if (c >= '\u0001' && c <= '\u007f') {
                utf[p++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                utf[p++] = (byte)(0xE0 | c >> 12 & 0xF);
                utf[p++] = (byte)(0x80 | c >> 6 & 0x3F);
                utf[p++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            utf[p++] = (byte)(0xC0 | c >> 6 & 0x1F);
            utf[p++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return utf;
    }

    public static byte[] getEmptyUTF() {
        return EMPTY_UTF;
    }

    public static int lengthUTF(String str) {
        char[] cc;
        int utflen = 0;
        for (char c : cc = str.toCharArray()) {
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen + 2;
    }

    public static String truncateUTF(String input, int length) {
        StringBuilder result = new StringBuilder(length);
        int resultlen = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int charlen = 0;
            charlen = c <= '\u007f' ? 1 : (c <= '\u07ff' ? 2 : (c <= '\ud7ff' ? 3 : (c <= '\udbff' ? 4 : (c <= '\udfff' ? 0 : 3))));
            if (resultlen + charlen > length) break;
            result.append(c);
            resultlen += charlen;
        }
        return result.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    static {
        try {
            EMPTY_UTF = StringUtil.stringToUTF("");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }
}

