/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.net.MalformedURLException;
import java.net.URL;
import progress.message.net.ProgressInetAddress;
import progress.message.util.URLUtil;
import progress.message.zclient.SessionConfig;

public final class BrokerURL {
    public static final String TCP = "tcp";
    public static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final String SSL = "ssl";
    private static final String SSL_IAIK = "ssl.iaik";
    private String m_brokerURL;
    private String m_brokerHostName = ProgressInetAddress.getLocalHostName();
    private String m_brokerProtocol = "tcp";
    private int m_brokerPort;
    private boolean m_allowsEmptyHostname = false;

    public BrokerURL(String brokerURL) throws MalformedURLException {
        this.parseURL(brokerURL);
    }

    public BrokerURL(String brokerURL, boolean allowsEmptyHostname) throws MalformedURLException {
        this.m_allowsEmptyHostname = allowsEmptyHostname;
        this.parseURL(brokerURL);
    }

    public BrokerURL(String brokerHostName, int brokerPort, String brokerProtocol) throws MalformedURLException {
        String URL2 = this.constructBrokerURL(brokerHostName, brokerPort, brokerProtocol);
        this.parseURL(URL2);
    }

    public String getBrokerURL() {
        return this.m_brokerURL;
    }

    public String getBrokerHostName() {
        return this.m_brokerHostName;
    }

    public String getBrokerProtocol() {
        return this.m_brokerProtocol;
    }

    public int getBrokerPort() {
        return this.m_brokerPort;
    }

    private String constructBrokerURL(String brokerHostName, int brokerPort, String brokerProtocol) {
        if (brokerProtocol != null && !"".equals(brokerProtocol) && brokerProtocol.equalsIgnoreCase(TCP)) {
            brokerProtocol = "";
        }
        if (brokerHostName == null || "".equals(brokerHostName)) {
            brokerHostName = ProgressInetAddress.getLocalHostName();
        }
        return URLUtil.buildUrlString(brokerProtocol, brokerHostName, brokerPort);
    }

    private void parseURL(String brokerURL) throws MalformedURLException {
        String host;
        if (brokerURL == null || "".equals(brokerURL)) {
            if (this.m_allowsEmptyHostname) {
                this.m_brokerHostName = null;
            }
            return;
        }
        this.m_brokerURL = brokerURL = brokerURL.trim();
        if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase("tcp://")) {
            this.m_brokerProtocol = TCP;
            host = brokerURL.substring(6);
        } else if (brokerURL.length() >= 7 && brokerURL.substring(0, 7).equalsIgnoreCase("http://")) {
            this.m_brokerProtocol = HTTP;
            host = brokerURL.substring(7);
        } else if (brokerURL.length() >= 8 && brokerURL.substring(0, 8).equalsIgnoreCase("https://")) {
            this.m_brokerProtocol = HTTPS;
            host = brokerURL.substring(8);
        } else if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase("ssl://")) {
            this.m_brokerProtocol = SSL;
            host = brokerURL.substring(6);
        } else if (brokerURL.length() >= 11 && brokerURL.substring(0, 11).equalsIgnoreCase("ssl.iaik://")) {
            this.m_brokerProtocol = SSL;
            host = brokerURL.substring(11);
        } else {
            host = brokerURL;
        }
        try {
            URL url = new URL("http://" + host);
            this.m_brokerHostName = url.getHost();
            this.m_brokerPort = url.getPort();
            if (!(this.m_brokerHostName != null && this.m_brokerHostName.length() != 0 || this.m_allowsEmptyHostname)) {
                throw new MalformedURLException("Missing hostname");
            }
            if (this.m_brokerPort == -1) {
                this.m_brokerPort = SessionConfig.PORT;
            }
        }
        catch (MalformedURLException e) {
            MalformedURLException ex = new MalformedURLException(SessionConfig.BAD_HOST_FORMAT + ": " + host + " (broker url: " + brokerURL + ")");
            ex.initCause(e);
            throw ex;
        }
    }
}

