/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Enumeration;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EDuplicateKey;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.util.PriorityQueue;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IFlowControllableOutputQueue;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.IQuencher;
import progress.message.zclient.ISubject;
import progress.message.zclient.PayloadWrapper;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.xonce.IOutboundContext;

public class ClientSenderQueue
extends DebugObject
implements IFlowControllableOutputQueue {
    private IPTPFlowControlHandler m_fc;
    private final PriorityQueue m_outQueue;
    private final PrioQueueLimiter m_outLimiter;
    private IndexedList m_pendingMsgs;
    private PrioQueueLimiter m_pendingMsgsLimiter;
    private final String m_localNodeName;
    private final IOutboundContext m_outboundContext;
    private final Object m_syncObj;

    public ClientSenderQueue(IOutboundContext oc, IQuencher outQuencher, IQuencher pendingQuencher, String localNodeName) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ClientSenderQueue" : null);
        this.m_outboundContext = oc;
        this.m_syncObj = this.m_outboundContext.getSyncObj();
        this.m_outQueue = new PriorityQueue(13);
        PrioQueueLimiter.Builder builder = new PrioQueueLimiter.Builder();
        builder.normLimit(250000).reserved(5000).highLimit(50000).restartThreshold(1000);
        this.m_outLimiter = builder.build(outQuencher);
        this.m_pendingMsgs = new IndexedList();
        this.m_pendingMsgsLimiter = builder.build(pendingQuencher);
        this.m_localNodeName = localNodeName;
    }

    public final void setFlowControlHandler(IPTPFlowControlHandler fch) {
        this.m_fc = fch;
    }

    final int getEnqueuedBelow(int prio) {
        return this.m_outQueue.getEnqueuedBelow(prio);
    }

    final int getMaxNonEmptyPriorityBelow(int prio) {
        return this.m_outQueue.getMaxNonEmptyPriorityBelow(prio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpOutQueue() {
        this.m_fc.dropBlocked();
        Object object = this.m_outQueue;
        synchronized (object) {
            while (!this.m_outQueue.isEmpty()) {
                this.m_outQueue.dequeue();
            }
        }
        this.m_outLimiter.reset();
        object = this.m_syncObj;
        synchronized (object) {
            this.m_syncObj.notifyAll();
        }
    }

    final boolean hasOutgoingMsgs() {
        return !this.m_outQueue.isEmpty();
    }

    final boolean hasPendingMsgs() {
        return this.m_pendingMsgs.count() > 0;
    }

    final PayloadWrapper getPendingMsg(long trkNum) {
        return (PayloadWrapper)this.m_pendingMsgs.get(trkNum);
    }

    public final Enumeration getPendingMsgs() {
        return this.m_pendingMsgs.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PayloadWrapper removePendingMsg(long trkNum) {
        ListNode node = this.m_pendingMsgs.remove(trkNum);
        if (node != null) {
            PayloadWrapper pw = (PayloadWrapper)node.obj;
            if (!pw.isTransacted()) {
                this.m_pendingMsgsLimiter.add(-pw.getLength(), pw.getPriority());
            }
            Object object = this.m_syncObj;
            synchronized (object) {
                this.m_syncObj.notifyAll();
            }
            return pw;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearPendingMsgs() {
        this.m_pendingMsgs.clearList();
        this.m_pendingMsgsLimiter.reset();
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_syncObj.notifyAll();
        }
    }

    public final void enqueue(IMgram m, int prio) throws Exception {
        this.enqueue(m, prio, 0L, 0L, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enqueue(IMgram m, int prio, long tracking, long expTm, String routing, ISubject subject, boolean asyncDelivery) {
        block19: {
            PayloadWrapper pw = new PayloadWrapper(m, prio, tracking, expTm, routing, subject, asyncDelivery, this.m_localNodeName);
            if (!this.m_fc.interceptBlocked(pw)) {
                this.m_outQueue.enqueue(pw, pw.getPriority());
            } else if (m.isDiscardable()) {
                return;
            }
            this.m_outLimiter.add(pw.getLength(), pw.getPriority());
            if (pw.isNackable()) {
                try {
                    this.m_pendingMsgs.append(pw.getGuarenteedTrackingNum(), pw);
                    if (!pw.isTransacted()) {
                        this.m_pendingMsgsLimiter.add(pw.getLength(), pw.getPriority());
                    } else if (this.DEBUG) {
                        this.debug(pw.getLength() + " bytes of txn msg " + pw.getGuarenteedTrackingNum() + " NOT accounted for pending msg limiter");
                    }
                    break block19;
                }
                catch (EDuplicateKey ex) {
                    if (this.checkDebugFlags(64)) {
                        this.debug("ClientSenderQueue.enqueue; subj= " + pw.getSubject().getSubjectString() + " pendingCount= " + this.m_pendingMsgs.count() + " pendingSize= " + this.m_pendingMsgsLimiter.size());
                    }
                    break block19;
                }
            }
            if (this.m_outboundContext.isXOnce() && (pw.isPersistent() || pw.isTransacted()) && !pw.isDiscardable() && !pw.isAsyncDelivery()) {
                try {
                    this.m_pendingMsgs.append(pw.getGuarenteedTrackingNum(), pw);
                    if (!pw.isTransacted()) {
                        this.m_pendingMsgsLimiter.add(pw.getLength(), pw.getPriority());
                    } else if (this.DEBUG) {
                        this.debug(pw.getLength() + " bytes of txn msg " + pw.getGuarenteedTrackingNum() + " NOT accounted for pending msg limiter");
                    }
                }
                catch (EDuplicateKey ex) {
                    if (!this.checkDebugFlags(64)) break block19;
                    this.debug("ClientSenderQueue.enqueue (xonce); subj= " + pw.getSubject().getSubjectString() + " pendingCount= " + this.m_pendingMsgs.count() + " pendingSize= " + this.m_pendingMsgsLimiter.size());
                }
            }
        }
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_syncObj.notifyAll();
        }
    }

    final void enqueueDirect(PayloadWrapper pw) {
        this.m_outQueue.enqueue(pw, pw.getPriority());
        this.m_outLimiter.add(pw.getLength(), pw.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IMgram dequeueAtOrAbove(int prio) {
        PayloadWrapper pw = (PayloadWrapper)this.m_outQueue.dequeueAtOrAbove(prio);
        if (pw == null) {
            return null;
        }
        IMgram payload = pw.getPayload();
        if (payload == null) {
            return null;
        }
        this.m_outLimiter.add(-pw.getLength(), pw.getPriority());
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_syncObj.notifyAll();
        }
        return payload;
    }

    public final boolean isAsyncDelivery(long trkNum) {
        boolean async = false;
        PayloadWrapper pw = (PayloadWrapper)this.m_pendingMsgs.get(trkNum);
        if (pw != null) {
            async = pw.isAsyncDelivery();
        }
        return async;
    }

    @Override
    public final PriorityQueue getOutputQueue() {
        return this.m_outQueue;
    }

    @Override
    public final PrioQueueLimiter getOutputQueueLimiter() {
        return this.m_outLimiter;
    }

    @Override
    public final IndexedList getQueueMsgPendingQueue() {
        return this.m_pendingMsgs;
    }

    @Override
    public final String getFlowControlName() {
        return "ClientOutQueue for: " + this.m_outboundContext;
    }

    public final String getPendingDebugInfo() {
        return " pendingCt= " + this.m_pendingMsgs.count() + " pendingSize= " + this.m_pendingMsgsLimiter.size();
    }
}

