/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Vector;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EParameterIsNull;
import progress.message.client.EUnusableConnection;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.HandlerBinding;
import progress.message.zclient.HandlerIHandlerContainer;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.MessageHandlerQueue;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SessionMessageProcessor;
import progress.message.zclient.Subject;

public class MessageHandler
implements IMessageHandler {
    private IMessageHandler m_handler;
    private Vector m_bindings;
    private Vector m_handlerContainers;
    private HandlerIHandlerContainer m_defHandlerContainer;
    private boolean m_guaranteed;
    private MessageHandlerQueue m_queue;
    private boolean m_internalsys;
    private boolean m_jms = false;
    private boolean m_noThread = false;
    private int m_numSMPThreads = 1;
    private Session[] m_SMPSessions;
    private SessionMessageProcessor[] m_threads;
    private Connection m_conn;
    private String m_name;
    private boolean m_okToInterrupt = true;
    private boolean m_interrupted = false;

    public String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public boolean isOkToInterrupt() {
        return this.m_okToInterrupt;
    }

    public void setOkToInterrupt(boolean okToInterrupt) {
        this.m_okToInterrupt = okToInterrupt;
    }

    public boolean wasInterrupted() {
        return this.m_interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.m_interrupted = interrupted;
    }

    public MessageHandler(IMessageHandler mh, boolean jms, boolean noThread) {
        this(mh);
        this.m_jms = jms;
        this.m_noThread = noThread;
        if (noThread) {
            this.m_numSMPThreads = 0;
        }
    }

    public MessageHandler(IMessageHandler mh, boolean jms) {
        this(mh);
        this.m_jms = jms;
    }

    public MessageHandler(IMessageHandler mh) {
        this.m_handler = mh;
        this.m_bindings = new Vector();
        this.m_handlerContainers = new Vector();
        this.m_guaranteed = false;
        this.m_queue = new MessageHandlerQueue();
        this.m_internalsys = false;
        this.m_conn = null;
        this.m_defHandlerContainer = new HandlerIHandlerContainer(this, this);
        this.m_defHandlerContainer.incBindCount();
        this.m_handlerContainers.addElement(this.m_defHandlerContainer);
        this.filterInternal(this.m_internalsys);
    }

    public MessageHandler() {
        this(null);
    }

    public void setNumSMPThreads(int num) {
        this.m_numSMPThreads = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNextWorkItem(int threadid) throws InterruptedException {
        IMessageHandler tempImh;
        Envelope tempEnv;
        MessageHandlerQueue messageHandlerQueue = this.m_queue;
        synchronized (messageHandlerQueue) {
            tempEnv = this.m_queue.nextEnvelope();
            tempImh = this.m_queue.nextIHandler();
        }
        try {
            tempImh.handleMessage(this.m_SMPSessions[threadid - 1], tempEnv);
        }
        catch (RuntimeException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        if (!this.m_jms && !Thread.currentThread().isInterrupted()) {
            tempEnv.handlerDone(this.m_guaranteed);
        }
        tempEnv = null;
        tempImh = null;
    }

    public void deliverToClient(Envelope env, IMessageHandler imh) {
        try {
            imh.handleMessage(this.m_SMPSessions[0], env);
        }
        catch (RuntimeException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        if (!this.m_jms) {
            env.handlerDone(this.m_guaranteed);
        }
    }

    public final void bind(String subject) throws EGeneralException, EInvalidSubjectSyntax {
        this.bind(subject, (IMessageHandler)this);
    }

    public final void bind(ISubject subject) throws EGeneralException, EInvalidSubjectSyntax {
        this.bind(subject, (IMessageHandler)this);
    }

    public final void bind(String subject, IMessageHandler ihandler) throws EGeneralException, EInvalidSubjectSyntax {
        this.bind(new Subject(subject), ihandler);
    }

    public final synchronized void bind(ISubject subject, IMessageHandler ihandler) throws EGeneralException, EInvalidSubjectSyntax {
        HandlerBinding hb;
        HandlerIHandlerContainer hih;
        int i;
        if (subject == null) {
            return;
        }
        if (ihandler == null) {
            ihandler = this;
        }
        if ((i = this.m_handlerContainers.indexOf(hih = new HandlerIHandlerContainer(this, ihandler))) > -1) {
            hih = (HandlerIHandlerContainer)this.m_handlerContainers.elementAt(i);
        }
        if (!this.m_bindings.contains(hb = new HandlerBinding(subject, hih))) {
            if (this.m_conn != null) {
                this.m_conn.addSubject(subject, hih);
            }
            this.m_bindings.addElement(hb);
            if (hih.incBindCount() == 1) {
                this.m_handlerContainers.addElement(hih);
            }
        }
    }

    public final void unbind(String subjectExp) {
        this.unbind(new Subject(subjectExp));
    }

    public final synchronized void unbind(ISubject subject) {
        for (int i = this.m_bindings.size() - 1; i >= 0; --i) {
            HandlerBinding hb = (HandlerBinding)this.m_bindings.elementAt(i);
            if (!hb.getSubject().equals(subject)) continue;
            this.m_bindings.removeElementAt(i);
            HandlerIHandlerContainer hih = hb.getHandlerIHandler();
            if (hih.decBindCount() == 0) {
                this.m_handlerContainers.removeElement(hih);
            }
            if (this.m_conn == null) continue;
            this.m_conn.removeSubject(subject, hih);
        }
    }

    public final void unbind(String subject, IMessageHandler ihandler) {
        this.unbind(new Subject(subject), ihandler);
    }

    public final synchronized void unbind(ISubject subject, IMessageHandler ihandler) {
        int i = this.m_bindings.indexOf(new HandlerBinding(subject, new HandlerIHandlerContainer(this, ihandler)));
        if (i > -1) {
            HandlerBinding hb = (HandlerBinding)this.m_bindings.elementAt(i);
            HandlerIHandlerContainer hih = hb.getHandlerIHandler();
            this.m_bindings.removeElementAt(i);
            if (hih.decBindCount() == 0) {
                this.m_handlerContainers.removeElement(hih);
            }
            if (this.m_conn != null) {
                this.m_conn.removeSubject(subject, hih);
            }
        }
    }

    public final synchronized void setGuaranteed(boolean on) {
        this.m_guaranteed = on;
    }

    public final synchronized boolean isGuaranteed() {
        return this.m_guaranteed;
    }

    public final synchronized IMessageHandler replaceHandler(IMessageHandler mh) throws EParameterIsNull, EGeneralException {
        if (mh == null) {
            throw new EParameterIsNull("userMessageHandler");
        }
        IMessageHandler oldHandler = this.m_handler;
        this.m_handler = mh;
        return oldHandler;
    }

    public IMessageHandler getHandler() {
        return this.m_handler;
    }

    public final synchronized void filterInternal(boolean applyfilter) {
        this.m_internalsys = applyfilter;
    }

    public boolean getFilterStatus() {
        return this.m_internalsys;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        if (this.m_handler != null) {
            this.m_handler.handleMessage(s, env);
        }
    }

    void newMessage(Envelope env, int msgno) {
        this.m_defHandlerContainer.newMessage(env, msgno);
    }

    void newMessage(Envelope env) {
        this.m_defHandlerContainer.newMessage(env);
    }

    synchronized void assignConnection(Connection c) throws EUnusableConnection, EGeneralException {
        HandlerBinding hb;
        int i;
        if (this.m_conn != null) {
            this.m_conn.removeMessageHandler(this);
        }
        this.m_conn = c;
        if (this.m_numSMPThreads == 0) {
            this.m_SMPSessions = new Session[1];
            this.m_SMPSessions[0] = new Session(c);
        } else {
            this.m_threads = new SessionMessageProcessor[this.m_numSMPThreads];
            this.m_SMPSessions = new Session[this.m_numSMPThreads];
            for (int i2 = 0; i2 < this.m_numSMPThreads; ++i2) {
                this.m_threads[i2] = new SessionMessageProcessor(this, i2 + 1, this.m_conn.getSecurityContext() != null ? this.m_conn.getSecurityContext().getUid() + ":" + this.m_conn.getApplicationId() : this.m_conn.getApplicationId());
                this.m_SMPSessions[i2] = new Session(c);
                this.m_threads[i2].start();
            }
        }
        FastVector badBindings = null;
        for (i = this.m_bindings.size() - 1; i >= 0; --i) {
            hb = (HandlerBinding)this.m_bindings.elementAt(i);
            try {
                c.addSubject(hb.getSubject(), hb.getHandlerIHandler());
                continue;
            }
            catch (EInvalidSubjectSyntax e) {
                if (badBindings == null) {
                    badBindings = new FastVector();
                }
                badBindings.addElement(hb);
            }
        }
        if (badBindings != null) {
            for (i = 0; i < badBindings.m_count; ++i) {
                hb = (HandlerBinding)badBindings.m_data[i];
                this.unbind(hb.getSubject(), hb.getHandlerIHandler().getIHandler());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deassignConnection() {
        int i;
        if (this.m_conn == null) {
            return;
        }
        for (i = this.m_bindings.size() - 1; i >= 0; --i) {
            HandlerBinding hb = (HandlerBinding)this.m_bindings.elementAt(i);
            this.m_conn.removeSubject(hb.getSubject(), hb.getHandlerIHandler());
        }
        if (this.m_numSMPThreads == 0) {
            this.m_SMPSessions[0] = null;
        } else {
            for (i = 0; i < this.m_numSMPThreads; ++i) {
                if (this.isOkToInterrupt()) {
                    this.m_threads[i].shutdown();
                } else {
                    this.setInterrupted(true);
                }
                this.m_SMPSessions[i] = null;
            }
        }
        if (this.m_queue != null) {
            MessageHandlerQueue messageHandlerQueue = this.m_queue;
            synchronized (messageHandlerQueue) {
                this.m_queue.notifyAll();
            }
        }
        this.m_conn = null;
        this.m_numSMPThreads = 0;
        this.m_threads = null;
    }

    public MessageHandlerQueue getMessageQueue() {
        return this.m_queue;
    }

    public int getQueueSize() {
        return this.m_queue.getQueueSize();
    }

    public synchronized Session getSession() {
        if (this.m_numSMPThreads <= 1) {
            return this.m_SMPSessions[0];
        }
        Thread.dumpStack();
        return null;
    }

    boolean isVisible() {
        return true;
    }

    boolean isNoThread() {
        return this.m_noThread;
    }

    boolean isJMS() {
        return this.m_jms;
    }

    boolean checkSubjectIntegrity(Envelope env) {
        return env.m_subject_ok;
    }
}

