/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.msg.IMgram;
import progress.message.zclient.INackable;
import progress.message.zclient.ISubject;

public class PayloadWrapper
implements INackable {
    public IMgram m_payload = null;
    public boolean m_isNackable;
    public byte m_priority;
    public long m_trackingNum;
    public int m_length;
    public long m_expTm;
    public ISubject m_subject;
    public boolean m_asyncDelivery;
    public boolean m_isQueueMessage;
    public boolean m_isDiscardable;
    public boolean m_isPersistent;
    public boolean m_isTransacted;
    public byte m_type;
    public String m_routing;

    public PayloadWrapper(IMgram m, int priority, long trackingNum, long expTm, String routing, ISubject subject, boolean asyncDelivery, String localNodeName) {
        this.m_payload = m;
        this.m_isPersistent = m.isJMSPersistent();
        this.m_isTransacted = m.hasTxn();
        this.m_type = m.getType();
        ISubject msgSubject = null;
        if (m.isPTP() || m.getType() == 11) {
            this.m_isNackable = true;
            this.m_isQueueMessage = true;
            msgSubject = m.getSubject();
        } else if (m.isPubSub()) {
            this.m_isNackable = true;
            this.m_isQueueMessage = false;
            msgSubject = m.getSubject();
        } else {
            this.m_isQueueMessage = false;
        }
        if (m.isDiscardable() || !m.isGuarenteed()) {
            this.m_isNackable = false;
        }
        this.m_priority = m.getPriority();
        this.m_isDiscardable = m.isDiscardable();
        if (msgSubject == null || !msgSubject.isSubjectSet()) {
            this.m_subject = subject;
            this.m_routing = routing;
        } else {
            this.m_routing = m.getRoutingHandle().getRouting();
            this.m_subject = msgSubject;
        }
        this.m_trackingNum = m.isGuarenteed() ? m.getGuarenteedTrackingNum() : trackingNum;
        this.m_expTm = m.isTTE() ? m.getTTE() : expTm;
        this.m_asyncDelivery = asyncDelivery;
        this.m_length = m.memoryLength();
    }

    public IMgram getPayload() {
        return this.m_payload;
    }

    @Override
    public byte getPriority() {
        return this.m_priority;
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_trackingNum;
    }

    public short getType() {
        return this.m_type;
    }

    @Override
    public boolean isQueueMessage() {
        return this.m_isQueueMessage;
    }

    @Override
    public boolean isPubSub() {
        return this.m_payload.isPubSub();
    }

    @Override
    public boolean isDiscardable() {
        return this.m_isDiscardable;
    }

    public boolean isPersistent() {
        return this.m_isPersistent;
    }

    public boolean isTransacted() {
        return this.m_isTransacted;
    }

    public boolean isNackable() {
        return this.m_isNackable;
    }

    public long getExpirationTime() {
        return this.m_expTm;
    }

    @Override
    public String getRouting() {
        return this.m_routing;
    }

    public int getLength() {
        return this.m_length;
    }

    public boolean isAsyncDelivery() {
        return this.m_asyncDelivery;
    }

    @Override
    public ISubject getSubject() {
        return this.m_subject;
    }

    @Override
    public int getLimiterSize() {
        return this.m_length;
    }
}

