/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.client.EConnectionNotResumable;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENoSubscribersFound;
import progress.message.client.ENotConnected;
import progress.message.client.ENotImplemented;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETimeout;
import progress.message.client.ETransactionFailure;
import progress.message.client.ETransactionRollbackByBroker;
import progress.message.client.EUnauthorizedClient;
import progress.message.client.EUnauthorizedHttpNode;
import progress.message.client.EUnauthorizedOverrideDestination;
import progress.message.client.EUnauthorizedUndeliveredDestination;
import progress.message.zclient.Connection;
import progress.message.zclient.EConnectionClosing;
import progress.message.zclient.EFlowControlException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.ISubject;
import progress.message.zclient.Job;
import progress.message.zclient.RejectionTracker;
import progress.message.zclient.SecurityConfig;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public class Publication
extends Job {
    private Connection m_connection;
    private Envelope m_envelope;
    private ISubject m_subject = null;
    private IJobResolver m_resolver;
    static Class s_class = new Publication(null, null).getClass();

    public Publication(Connection connection, ISubject subject) {
        this(connection, subject, null);
    }

    public Publication(Connection connection, ISubject subject, IJobResolver resolver) {
        this.debugName("Publication");
        this.m_resolver = resolver;
        this.m_status = 1;
        this.m_connection = connection;
        this.m_subject = subject;
    }

    public final void setEnvelope(Envelope env) {
        this.m_envelope = env;
    }

    @Override
    public void resolve() {
        if (this.m_resolver != null && this.m_status == 1) {
            this.m_resolver.resolveJob(this);
            if (this.DEBUG) {
                this.debug("Resolving Publication: " + this);
            }
        } else if (this.DEBUG) {
            this.debug("Not resolving Publication: " + this);
        }
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public String getSubject() {
        return this.m_subject == null ? null : this.m_subject.getSubjectString();
    }

    @Override
    public synchronized void cancel() {
        throw new ENotImplemented("Publication.cancel()");
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public synchronized void join() throws EInterrupted, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        super.join();
        this.checkStatus();
    }

    @Override
    public void join(int seconds) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.joinMillis(seconds * 1000);
    }

    @Override
    synchronized void joinMillis(long millis) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        super.joinMillis(millis);
        this.checkStatus();
    }

    private void checkStatus() throws ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (this.m_status == 0) {
            return;
        }
        EGeneralException ege = Publication.buildException(this.m_status, this.m_subject, this.m_message);
        throw ege;
    }

    public static final EGeneralException buildException(int status, ISubject subject, String message) {
        switch (status) {
            case 0: {
                return null;
            }
            case -5: {
                return new ENotConnected();
            }
            case -17: {
                return new EConnectionClosing();
            }
            case -6: {
                return new EUnauthorizedClient(SecurityConfig.ERRMSG_NO_PUBLISH_PERM + ": " + subject != null ? subject.getJMSName() : "");
            }
            case -29: {
                return new EUnauthorizedOverrideDestination(SecurityConfig.ERRMSG_NO_PUBLISH_PERM + ": " + subject != null ? subject.getJMSName() : "");
            }
            case -30: {
                return new EUnauthorizedHttpNode(SecurityConfig.ERRMSG_NO_PUBLISH_PERM + ": " + subject != null ? subject.getJMSName() : "");
            }
            case -26: {
                return new EUnauthorizedUndeliveredDestination(SecurityConfig.ERRMSG_NO_PUBLISH_PERM + prAccessor.getString("UNDELIVERED_DESTINATION"));
            }
            case -10: {
                return new ESecurityGeneralException(prAccessor.getString("STR082"));
            }
            case -11: {
                return new ETransactionRollbackByBroker("");
            }
            case -12: {
                return new ETransactionFailure(168, SessionConfig.ERRMSG_TXN_ACC_VIOL);
            }
            case -13: {
                return new ETransactionFailure(168, SessionConfig.ERRMSG_TXN_SEQ_ERR);
            }
            case -14: {
                return new ENoSubscribersFound("");
            }
            case -3: {
                return new EIntegrityCompromised();
            }
            case -15: {
                String errMsg = SessionConfig.ERRMSG_QUEUE_NOT_FOUND;
                if (subject != null && subject.isQueue()) {
                    errMsg = errMsg + ": " + subject.getJMSName();
                }
                return new EGeneralException(3005, errMsg);
            }
            case -16: {
                return new EGeneralException(3004, SessionConfig.MSG_TOO_LARGE);
            }
            case -42: {
                return new EGeneralException(202, message);
            }
            case -18: {
                return new EFlowControlException(311, prAccessor.getString("QUEUE_DEST_BLOCKED"));
            }
            case -19: {
                return new EGeneralException(2500, message);
            }
            case -21: {
                return new EGeneralException(2501, message);
            }
            case -20: {
                return new EGeneralException(2502, message);
            }
            case -23: {
                return new EFlowControlException(311, prAccessor.getString("TOPIC_DEST_BLOCKED"));
            }
            case -39: {
                return new EConnectionNotResumable(prAccessor.getString("CONNECTION_UNRESUMABLE"), null);
            }
            case -27: {
                String errMsg = prAccessor.getString("INVALID_URL_NODE");
                if (subject != null) {
                    errMsg = errMsg + ": " + subject.getJMSName();
                }
                return new EGeneralException(2505, errMsg);
            }
            case -28: {
                String errMsg = prAccessor.getString("INVALID_URL_NODE");
                errMsg = errMsg + "in the " + prAccessor.getString("UNDELIVERED_DESTINATION");
                return new EGeneralException(2505, errMsg);
            }
            case -43: {
                return new EGeneralException(3006, prAccessor.getString("NO_ROOM_IN_DB"));
            }
        }
        return new ENetworkFailure(166, SessionConfig.UNKNOWN_CODE + ": " + status);
    }

    @Override
    public final void setStatus(int status, String message) {
        RejectionTracker rt;
        super.setStatus(status, message);
        if (status < 0 && this.m_envelope != null && (rt = this.m_envelope.getRejectionTracker()) != null) {
            try {
                this.checkStatus();
            }
            catch (EGeneralException ege) {
                rt.processRejection(ege);
            }
        }
    }

    @Override
    protected String getDiagnosticThreadInfo() {
        StringBuilder sb = new StringBuilder("Publication: dest ");
        try {
            this.m_subject.appendSubjectString(sb, 2);
        }
        catch (Throwable t) {
            sb.append("<unknown>");
        }
        sb.append(", conn ");
        sb.append(this.m_connection != null ? this.m_connection.getApplicationId() : "<unknown>");
        return sb.toString();
    }
}

