/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.Serializable;
import java.util.Vector;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.SearchResults;

public class SubjectLevel
implements Serializable {
    private Vector m_subLevels = new Vector();
    private int m_insertBefore = -1;
    private int m_key;
    private String m_keyRep;
    private Vector m_localValues;
    private Vector m_globalValues;
    private SubjectLevel m_singleChild;
    private SubjectLevel m_multiChild;
    private short m_special;
    private SubjectLevel m_parent;
    public static final short NORMAL = 0;
    public static final short LIMITWILD = 1;
    public static final short WILD = -1;
    private boolean m_hasCollided;
    private Vector m_collisions = null;
    private SubjectLevel m_collisionHead = null;

    public SubjectLevel(int key, String rep, boolean hasCollided) {
        this.m_key = key;
        this.m_keyRep = rep;
        this.m_localValues = new Vector();
        this.m_globalValues = new Vector();
        this.m_singleChild = null;
        this.m_multiChild = null;
        this.m_special = 0;
        this.m_parent = null;
        this.m_hasCollided = hasCollided;
    }

    public SubjectLevel(int key, String rep) {
        this(key, rep, false);
    }

    public SubjectLevel(int key, String rep, ISubjectMatchObject value, boolean hasCollided) {
        this(key, rep, hasCollided);
        if (value != null) {
            if (value.localEffect()) {
                this.m_localValues.addElement(value);
            } else {
                this.m_globalValues.addElement(value);
            }
        }
    }

    public SubjectLevel(int key, String rep, short wildcard) {
        this(key, rep, false);
        this.m_special = wildcard;
    }

    public SubjectLevel(int key, String rep, ISubjectMatchObject value, short wildcard) {
        this(key, rep, value, false);
        this.m_special = wildcard;
    }

    public final void addValue(ISubjectMatchObject value) {
        if (value.localEffect()) {
            if (!this.m_localValues.contains(value)) {
                this.m_localValues.addElement(value);
            }
        } else if (!this.m_globalValues.contains(value)) {
            this.m_globalValues.addElement(value);
        }
    }

    public final void removeValue(ISubjectMatchObject value) {
        if (value.localEffect()) {
            this.m_localValues.removeElement(value);
        } else {
            this.m_globalValues.removeElement(value);
        }
    }

    public final Vector getLocalValues() {
        return this.m_localValues;
    }

    public final Vector getGlobalValues() {
        return this.m_globalValues;
    }

    public final void addSubLevel(SubjectLevel subLevel) {
        subLevel.m_parent = this;
        switch (subLevel.m_special) {
            case 1: {
                this.m_singleChild = subLevel;
                break;
            }
            case -1: {
                this.m_multiChild = subLevel;
                break;
            }
            default: {
                this.insertByOrder(subLevel);
            }
        }
    }

    public final void remove(String identifier) {
        Object obj = null;
        if (this.hasCollided() && this.removeCollidedNode(identifier)) {
            return;
        }
        if (this.m_parent == null) {
            return;
        }
        if (this.m_parent.m_singleChild == this) {
            this.m_parent.m_singleChild = null;
        } else if (this.m_parent.m_multiChild == this) {
            this.m_parent.m_multiChild = null;
        } else if (this.hasCollided() && this.m_collisionHead != this) {
            this.m_collisionHead.removeCollidedNode(identifier);
        } else {
            this.m_parent.m_subLevels.removeElement(this);
        }
        if (!this.m_parent.hasChildren() && this.m_parent.m_localValues.isEmpty() && this.m_parent.m_globalValues.isEmpty()) {
            this.m_parent.remove(this.m_parent.getIdentifier());
        }
    }

    private boolean removeCollidedNode(String identifier) {
        SubjectLevel obj = null;
        if (identifier.equals(this.getIdentifier())) {
            if (this.m_collisions != null && !this.m_collisions.isEmpty()) {
                obj = (SubjectLevel)this.m_collisions.elementAt(0);
                this.m_collisions.removeElementAt(0);
                this.m_keyRep = obj.m_keyRep;
                this.m_globalValues = obj.m_globalValues;
                this.m_localValues = obj.m_localValues;
                this.m_multiChild = obj.m_multiChild;
                this.m_singleChild = obj.m_singleChild;
                this.m_special = obj.m_special;
                this.m_subLevels = obj.m_subLevels;
                if (this.m_collisions.isEmpty()) {
                    this.m_collisions = null;
                    this.m_hasCollided = false;
                }
                return true;
            }
        } else {
            for (int count = 0; count < this.m_collisions.size(); ++count) {
                obj = (SubjectLevel)this.m_collisions.elementAt(count);
                if (!obj.getIdentifier().equals(identifier)) continue;
                this.m_collisions.removeElementAt(count);
                if (this.m_collisions.isEmpty()) {
                    this.m_collisions = null;
                    this.m_hasCollided = false;
                }
                return true;
            }
        }
        return false;
    }

    private void insertByOrder(SubjectLevel subLevel) {
        if (this.m_insertBefore == -1) {
            this.findExactChild(subLevel.m_key, subLevel.getIdentifier(), 0);
        }
        if (this.m_insertBefore < this.m_subLevels.size()) {
            SubjectLevel oldLevel = (SubjectLevel)this.m_subLevels.elementAt(this.m_insertBefore);
            if (subLevel.m_key == oldLevel.m_key) {
                if (subLevel.getIdentifier().equals(oldLevel.getIdentifier())) {
                    this.m_subLevels.removeElementAt(this.m_insertBefore);
                    this.m_subLevels.insertElementAt(subLevel, this.m_insertBefore);
                } else {
                    oldLevel.addSubjectLevel(subLevel);
                }
            } else {
                this.m_subLevels.insertElementAt(subLevel, this.m_insertBefore);
            }
        } else {
            this.m_subLevels.addElement(subLevel);
        }
        this.m_insertBefore = -1;
    }

    public final void matchChildren(ISubject subject, int depth, SearchResults results) {
        int[] scode = subject.getMatchVector();
        boolean lastNodeInPath = true;
        this.preprocessObjects(subject, results);
        if (depth == scode.length) {
            this.processNodeObjects(subject, results, true);
            return;
        }
        if (this.m_multiChild != null) {
            if (!this.m_multiChild.hasChildren()) {
                this.m_multiChild.preprocessObjects(subject, results);
                this.m_multiChild.processNodeObjects(subject, results, true);
            } else {
                lastNodeInPath = false;
                this.m_multiChild.matchWildParents(subject, depth, results);
            }
        }
        if (this.m_singleChild != null) {
            lastNodeInPath = false;
            this.m_singleChild.matchChildren(subject, depth + 1, results);
        }
        int high = this.m_subLevels.size();
        int low = 0;
        while (low < high) {
            int mid = (high - low) / 2 + low;
            SubjectLevel s = (SubjectLevel)this.m_subLevels.elementAt(mid);
            if (s.m_key > scode[depth]) {
                high = mid;
                continue;
            }
            if (s.m_key < scode[depth]) {
                low = mid + 1;
                continue;
            }
            if (s.m_key != scode[depth]) continue;
            if ((s = s.getCollidedSubjectLevel(subject, depth)) == null) break;
            lastNodeInPath = false;
            s.matchChildren(subject, depth + 1, results);
            break;
        }
        if (lastNodeInPath) {
            this.processNodeObjects(subject, results, false);
        }
    }

    private void matchWildParents(ISubject subject, int depth, SearchResults results) {
        if (depth == subject.getMatchVector().length) {
            this.processNodeObjects(subject, results, true);
            return;
        }
        this.processNodeObjects(subject, results, true);
        if (this.m_singleChild != null) {
            this.levelScan(subject, depth, results, this.m_singleChild);
        }
        for (int i = 0; i < this.m_subLevels.size(); ++i) {
            this.levelScan(subject, depth, results, (SubjectLevel)this.m_subLevels.elementAt(i));
        }
    }

    private void levelScan(ISubject subject, int depth, SearchResults results, SubjectLevel s) {
        int[] scode = subject.getMatchVector();
        for (int j = ++depth; j < scode.length; ++j) {
            SubjectLevel level;
            if (s.m_special != 1 && s.m_key != scode[j] || (level = s.getCollidedSubjectLevel(subject, j)) == null) continue;
            level.matchChildren(subject, j + 1, results);
        }
    }

    private void processNodeObjects(ISubject subject, SearchResults results, boolean exact) {
        if (exact) {
            results.addLocalObjects(subject, this.m_localValues);
        }
    }

    private void preprocessObjects(ISubject subject, SearchResults results) {
        for (int i = 0; i < this.m_globalValues.size(); ++i) {
            ISubjectMatchObject matchObject = (ISubjectMatchObject)this.m_globalValues.elementAt(i);
            matchObject.prefixMatch(subject, results);
        }
    }

    public final SubjectLevel findExactChild(int scode, String identifier, int special) {
        SubjectLevel result = null;
        block0 : switch (special) {
            case 1: {
                result = this.m_singleChild;
                break;
            }
            case -1: {
                result = this.m_multiChild;
                break;
            }
            default: {
                int high = this.m_subLevels.size();
                int low = 0;
                SubjectLevel s = null;
                this.m_insertBefore = 0;
                while (low < high) {
                    int mid = (high - low) / 2 + low;
                    s = (SubjectLevel)this.m_subLevels.elementAt(mid);
                    if (s.m_key > scode) {
                        high = mid;
                        this.m_insertBefore = mid;
                        continue;
                    }
                    if (s.m_key < scode) {
                        low = mid + 1;
                        this.m_insertBefore = mid + 1;
                        continue;
                    }
                    if (s.m_key != scode) continue;
                    this.m_insertBefore = mid;
                    result = s.getCollidedSubjectLevel(identifier);
                    break block0;
                }
                break block0;
            }
        }
        return result;
    }

    public final boolean hasChildren() {
        return !this.m_subLevels.isEmpty() || this.m_singleChild != null || this.m_multiChild != null;
    }

    private void addSubjectLevel(SubjectLevel new_sl) {
        new_sl.m_collisionHead = this;
        if (!this.getIdentifier().equals(new_sl.getIdentifier())) {
            if (this.m_collisions == null) {
                this.m_collisions = new Vector();
            }
            for (int count = 0; count < this.m_collisions.size(); ++count) {
                SubjectLevel level = (SubjectLevel)this.m_collisions.elementAt(count);
                if (!level.getIdentifier().equals(new_sl.getIdentifier())) continue;
                this.m_collisions.removeElementAt(count);
                this.m_collisions.setElementAt(new_sl, count);
                return;
            }
            this.m_hasCollided = true;
            new_sl.setCollided(true);
            this.m_collisions.addElement(new_sl);
        }
    }

    private SubjectLevel getCollidedSubjectLevel(String identifier) {
        if (this.getIdentifier().equals(identifier)) {
            return this;
        }
        if (this.m_collisions != null) {
            int size = this.m_collisions.size();
            for (int count = 0; count < size; ++count) {
                SubjectLevel child = (SubjectLevel)this.m_collisions.elementAt(count);
                if (!child.getIdentifier().equals(identifier)) continue;
                return child;
            }
        }
        return null;
    }

    private SubjectLevel getCollidedSubjectLevel(ISubject subject, int pos) {
        return this.getCollidedSubjectLevel(subject.extractSubjectLevel(pos));
    }

    private String getIdentifier() {
        return this.m_keyRep;
    }

    private boolean hasCollided() {
        return this.m_hasCollided;
    }

    private void setCollided(boolean collided) {
        this.m_hasCollided = collided;
    }
}

