/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.SearchResults;
import progress.message.zclient.SubjectLevel;
import progress.message.zclient.SubjectUtil;
import progress.message.zclient.prAccessor;

public class SubjectTable
extends DebugObject
implements Serializable {
    protected SubjectLevel m_root = new SubjectLevel(0, "$SonicMQ-Root-Subject", null, false);
    public Hashtable m_expressions = new Hashtable();
    private boolean m_newLevelCreated = false;

    public SubjectTable() {
        super(DebugState.GLOBAL_DEBUG_ON ? "SubjectTable" : null);
        this.m_expressions.put("$SonicMQ-Root-Subject", this.m_root);
    }

    public final synchronized boolean put(ISubject subject, ISubjectMatchObject object) throws EInvalidSubjectSyntax {
        if (subject.isMultiSubject()) {
            throw new EAssertFailure("Illegal to use multisubject in SubjectTable");
        }
        if (subject.getLookupName().equals("$SonicMQ-Root-Subject")) {
            this.m_root.addValue(object);
            return false;
        }
        this.m_newLevelCreated = false;
        SubjectLevel newLevel = this.insertSubject(subject, object);
        SubjectLevel oldLevel = this.m_expressions.put(subject.getLookupName(), newLevel);
        if (oldLevel != null && oldLevel != newLevel) {
            this.append(newLevel.getLocalValues(), oldLevel.getLocalValues());
            this.append(newLevel.getGlobalValues(), oldLevel.getGlobalValues());
            oldLevel = null;
        }
        return this.m_newLevelCreated;
    }

    public final synchronized void get(ISubject subject, SearchResults results) {
        this.m_root.matchChildren(subject, 0, results);
    }

    private final SubjectLevel insertSubject(ISubject subject, ISubjectMatchObject value) throws EInvalidSubjectSyntax {
        String pattern = subject.getLookupName();
        SubjectLevel thisLevel = this.m_root;
        SubjectLevel newRoot = null;
        SubjectLevel bottomLevel = thisLevel;
        int level = 0;
        int multiLevel = -1;
        boolean sawMulti = false;
        int tokStartPos = 0;
        boolean endLevel = false;
        while (tokStartPos < pattern.length()) {
            int sharpWild;
            int delimPos = pattern.indexOf(46, tokStartPos);
            if (endLevel) {
                tokStartPos = delimPos = pattern.length();
            } else if (delimPos == -1) {
                delimPos = pattern.length();
            }
            int starWild = this.findChar(pattern, 42, tokStartPos, delimPos);
            if (starWild > delimPos) {
                starWild = -1;
            }
            if ((sharpWild = this.findChar(pattern, 35, tokStartPos, delimPos)) > delimPos) {
                sharpWild = -1;
            }
            int tokLength = delimPos - tokStartPos;
            boolean singleWild = false;
            if (starWild >= tokStartPos && tokLength > 1) {
                throw new EInvalidSubjectSyntax(prAccessor.getString("STR170"));
            }
            if (starWild == tokStartPos) {
                singleWild = true;
            }
            if (sharpWild >= tokStartPos) {
                if (tokLength > 1) {
                    throw new EInvalidSubjectSyntax(prAccessor.getString("STR171"));
                }
                if (sawMulti) {
                    throw new EInvalidSubjectSyntax(prAccessor.getString("STR172"));
                }
                sawMulti = true;
                multiLevel = level;
            }
            SubjectLevel nextLevel = null;
            if (singleWild) {
                if (newRoot == null) {
                    nextLevel = thisLevel.findExactChild(0, "*", 1);
                }
                if (nextLevel == null) {
                    nextLevel = new SubjectLevel(0, "*", 1);
                    this.m_newLevelCreated = true;
                    if (newRoot == null) {
                        newRoot = nextLevel;
                        bottomLevel = thisLevel;
                    } else {
                        thisLevel.addSubLevel(nextLevel);
                    }
                }
            } else if (sawMulti && multiLevel == level) {
                if (newRoot == null) {
                    nextLevel = thisLevel.findExactChild(0, "#", -1);
                }
                if (nextLevel == null) {
                    nextLevel = new SubjectLevel(0, "#", -1);
                    this.m_newLevelCreated = true;
                    if (newRoot == null) {
                        newRoot = nextLevel;
                        bottomLevel = thisLevel;
                    } else {
                        thisLevel.addSubLevel(nextLevel);
                    }
                }
            } else {
                String token = pattern.substring(tokStartPos, tokStartPos + tokLength);
                int scode = SubjectUtil.computeSCode(token, 0, token.length());
                if (newRoot == null) {
                    nextLevel = thisLevel.findExactChild(scode, token, 0);
                }
                if (nextLevel == null) {
                    nextLevel = new SubjectLevel(scode, token);
                    this.m_newLevelCreated = true;
                    if (newRoot == null) {
                        newRoot = nextLevel;
                        bottomLevel = thisLevel;
                    } else {
                        thisLevel.addSubLevel(nextLevel);
                    }
                }
            }
            thisLevel = nextLevel;
            ++level;
            tokStartPos = delimPos + 1;
            if (endLevel || tokStartPos != pattern.length()) continue;
            endLevel = true;
            --tokStartPos;
        }
        if (sawMulti && multiLevel != level - 1 && multiLevel != 0) {
            throw new EInvalidSubjectSyntax(prAccessor.getString("STR173"));
        }
        thisLevel.addValue(value);
        if (newRoot != null) {
            bottomLevel.addSubLevel(newRoot);
        }
        return thisLevel;
    }

    public final synchronized void removeSubject(ISubject sub) {
        if (sub.isMultiSubject()) {
            throw new EAssertFailure("Illegal to use multisubject in SubjectTable");
        }
        String subject = sub.getLookupName();
        this.m_expressions.remove(subject);
        SubjectLevel thisLevel = this.m_root;
        int level = 0;
        int multiLevel = -1;
        boolean sawMulti = false;
        int tokStartPos = 0;
        String nextIdentifier = null;
        while (tokStartPos < subject.length()) {
            int sharpWild;
            int starWild;
            int delimPos = subject.indexOf(46, tokStartPos);
            if (delimPos == -1) {
                delimPos = subject.length();
            }
            if ((starWild = this.findChar(subject, 42, tokStartPos, delimPos)) > delimPos) {
                starWild = -1;
            }
            if ((sharpWild = this.findChar(subject, 35, tokStartPos, delimPos)) > delimPos) {
                sharpWild = -1;
            }
            int tokLength = delimPos - tokStartPos;
            boolean singleWild = false;
            if (starWild >= tokStartPos && tokLength > 1) {
                return;
            }
            if (starWild == tokStartPos) {
                singleWild = true;
            }
            if (sharpWild >= tokStartPos) {
                if (tokLength > 1 || sawMulti) {
                    return;
                }
                sawMulti = true;
                multiLevel = level;
            }
            SubjectLevel nextLevel = null;
            if (singleWild) {
                nextIdentifier = "*";
                nextLevel = thisLevel.findExactChild(0, nextIdentifier, 1);
            } else if (sawMulti && multiLevel == level) {
                nextIdentifier = "#";
                nextLevel = thisLevel.findExactChild(0, "#", -1);
            } else {
                nextIdentifier = subject.substring(tokStartPos, tokLength + tokStartPos);
                int scode = SubjectUtil.computeSCode(nextIdentifier, 0, nextIdentifier.length());
                nextLevel = thisLevel.findExactChild(scode, nextIdentifier, 0);
            }
            if (nextLevel == null) {
                return;
            }
            thisLevel = nextLevel;
            ++level;
            tokStartPos = delimPos + 1;
        }
        if (!thisLevel.hasChildren()) {
            thisLevel.remove(nextIdentifier);
        }
    }

    public synchronized boolean removeSubjectObject(ISubject subject, ISubjectMatchObject value) {
        boolean removed;
        if (subject.isMultiSubject()) {
            throw new EAssertFailure("Illegal to use multisubject in SubjectTable");
        }
        SubjectLevel objects = (SubjectLevel)this.m_expressions.get(subject.getLookupName());
        Vector lv = null;
        Vector gv = null;
        if (objects != null) {
            lv = objects.getLocalValues();
            gv = objects.getGlobalValues();
        }
        if (lv == null && gv == null) {
            removed = true;
        } else {
            if (value.localEffect()) {
                if (lv != null) {
                    lv.removeElement(value);
                }
            } else if (gv != null) {
                gv.removeElement(value);
            }
            boolean bl = removed = !(lv != null && !lv.isEmpty() || gv != null && !gv.isEmpty());
        }
        if (removed) {
            this.removeSubject(subject);
        }
        return removed;
    }

    private final void append(Vector to, Vector from) {
        for (int i = 0; i < from.size(); ++i) {
            to.addElement(from.elementAt(i));
        }
    }

    private final int findChar(String pattern, int ch, int start, int end) {
        while (start < end) {
            if (pattern.charAt(start) == ch) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public final Enumeration getLocalObjects() throws NoSuchElementException {
        class LocalValueEnum
        implements Enumeration {
            private Enumeration m_levels;
            private Vector m_localVals;
            private int m_numLocalVals;
            private int m_next;

            LocalValueEnum() {
                this.m_levels = SubjectTable.this.m_expressions.elements();
                this.m_next = -1;
                this.findNextElement();
            }

            @Override
            public boolean hasMoreElements() {
                return this.m_next < this.m_numLocalVals;
            }

            public Object nextElement() {
                if (this.m_next == this.m_numLocalVals) {
                    throw new NoSuchElementException();
                }
                Object ret = this.m_localVals.elementAt(this.m_next);
                this.findNextElement();
                return ret;
            }

            private void findNextElement() {
                ++this.m_next;
                while (this.m_next == this.m_numLocalVals && this.m_levels.hasMoreElements()) {
                    this.m_localVals = ((SubjectLevel)this.m_levels.nextElement()).getLocalValues();
                    this.m_numLocalVals = this.m_localVals.size();
                    this.m_next = 0;
                }
            }
        }
        return new LocalValueEnum();
    }

    public final synchronized Enumeration elements() throws NoSuchElementException {
        throw new EAssertFailure(prAccessor.getString("STR174"));
    }
}

